/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowOps {
    private static final Logger log = LoggerFactory.getLogger(SlowOps.class);
    private static final long SLOW_SCAN_SLEEP_MS = 250L;
    private static final int NUM_DATA_ROWS = 1000;
    private final AccumuloClient client;
    private final String tableName;
    private final long maxWaitMillis;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private Future<?> compactTask = null;

    public SlowOps(AccumuloClient client, String tableName, long maxWaitMillis) {
        this.client = client;
        this.tableName = tableName;
        this.maxWaitMillis = maxWaitMillis;
        this.createData();
    }

    public static void setExpectedCompactions(AccumuloClient client, int numParallelExpected) {
        int target = numParallelExpected + 1;
        try {
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_DEFAULT_EXECUTORS.getKey(), "[{'name':'any','numThreads':" + target + "}]".replaceAll("'", "\""));
            UtilWaitThread.sleep((long)3000L);
        }
        catch (NumberFormatException | AccumuloException | AccumuloSecurityException ex) {
            throw new IllegalStateException("Could not set parallel compaction limit to " + target, ex);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    private void createData() {
        try {
            this.client.tableOperations().create(this.tableName);
            log.info("Created table id: {}, name '{}'", this.client.tableOperations().tableIdMap().get(this.tableName), (Object)this.tableName);
            try (BatchWriter bw = this.client.createBatchWriter(this.tableName);){
                for (int i = 0; i < 1000; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%05d", i)));
                    m.put((CharSequence)("col" + (i % 3 + 1)), (CharSequence)"qual", (CharSequence)"junk");
                    bw.addMutation(m);
                }
            }
            this.verifyRows();
        }
        catch (AccumuloException | AccumuloSecurityException | TableExistsException | TableNotFoundException ex) {
            throw new IllegalStateException("Create data failed with exception", ex);
        }
    }

    private void verifyRows() {
        long startTimestamp = System.nanoTime();
        int count = this.scanCount();
        log.trace("Scan time for {} rows {} ms", (Object)1000, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimestamp));
        if (count != 1000) {
            throw new IllegalStateException(String.format("Number of rows %1$d does not match expected %2$d", count, 1000));
        }
    }

    private int scanCount() {
        int n;
        block10: {
            Scanner scanner = this.client.createScanner(this.tableName, Authorizations.EMPTY);
            try {
                int count = 0;
                for (Map.Entry elt : scanner) {
                    String expected = String.format("%05d", count);
                    assert (((Key)elt.getKey()).getRow().toString().equals(expected));
                    ++count;
                }
                n = count;
                if (scanner == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scanner != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TableNotFoundException ex) {
                    log.debug("cannot verify row count, table '{}' does not exist", (Object)this.tableName);
                    throw new IllegalStateException(ex);
                }
            }
            scanner.close();
        }
        return n;
    }

    public void startCompactTask() {
        this.compactTask = pool.submit(new SlowCompactionRunner());
        if (!this.blockUntilCompactionRunning()) {
            throw new IllegalStateException("Compaction could not be started for " + this.tableName);
        }
    }

    private boolean blockUntilCompactionRunning() {
        long startWaitNanos = System.nanoTime();
        long maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(this.maxWaitMillis);
        do {
            List tservers = this.client.instanceOperations().getTabletServers();
            boolean tableFound = tservers.stream().flatMap(tserver -> {
                try {
                    List ac = this.client.instanceOperations().getActiveCompactions(tserver);
                    log.trace("tserver {}, running compactions {}", tserver, (Object)ac.size());
                    return ac.stream();
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    throw new IllegalStateException("failed to get active compactions, test fails.", e);
                }
            }).map(activeCompaction -> {
                try {
                    String compactionTable = activeCompaction.getTable();
                    log.debug("Compaction running for {}", (Object)compactionTable);
                    return compactionTable;
                }
                catch (TableNotFoundException ex) {
                    log.trace("Compaction found for unknown table {}", activeCompaction);
                    return null;
                }
            }).anyMatch(this.tableName::equals);
            if (tableFound) {
                return true;
            }
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        } while (System.nanoTime() - startWaitNanos < maxWaitNanos);
        log.debug("Could not find compaction for {} after {} seconds", (Object)this.tableName, (Object)TimeUnit.MILLISECONDS.toSeconds(this.maxWaitMillis));
        return false;
    }

    public boolean blockWhileCompactionRunning() {
        try {
            if (this.compactTask == null) {
                throw new IllegalStateException("Compaction task has not been started - call startCompactionTask() before blocking");
            }
            this.compactTask.get();
            return true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException ex) {
            return false;
        }
    }

    private class SlowCompactionRunner
    implements Runnable {
        private SlowCompactionRunner() {
        }

        @Override
        public void run() {
            long startTimestamp = System.nanoTime();
            IteratorSetting slow = new IteratorSetting(30, "slow", SlowIterator.class);
            SlowIterator.setSleepTime(slow, 250L);
            ArrayList<IteratorSetting> compactIterators = new ArrayList<IteratorSetting>();
            compactIterators.add(slow);
            log.trace("Starting slow operation using iterator: {}", (Object)slow);
            int retry = 0;
            boolean completed = false;
            while (!completed && retry++ < 5) {
                try {
                    log.info("Starting compaction.  Attempt {}", (Object)retry);
                    SlowOps.this.client.tableOperations().compact(SlowOps.this.tableName, null, null, compactIterators, true, true);
                    completed = true;
                }
                catch (Throwable ex) {
                    if (ex.getMessage().contains("Compaction canceled")) {
                        return;
                    }
                    log.info("Exception thrown while waiting for compaction - will retry", ex);
                    try {
                        Thread.sleep(10000 * retry);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            log.debug("Compaction wait is complete");
            log.trace("Slow compaction of {} rows took {} ms", (Object)1000, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimestamp));
            startTimestamp = System.nanoTime();
            int count = SlowOps.this.scanCount();
            log.trace("After compaction, scan time for {} rows {} ms", (Object)1000, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimestamp));
            if (count != 1000) {
                throw new IllegalStateException(String.format("After compaction, number of rows %1$d does not match expected %2$d", count, 1000));
            }
        }
    }
}

