/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.util;

import java.util.concurrent.TimeUnit;
import java.util.function.ToIntFunction;

public class Wait {
    public static final long MAX_WAIT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    public static final long SLEEP_MILLIS = 1000L;

    public static int getTimeoutFactor(ToIntFunction<NumberFormatException> onError) {
        String timeoutString = System.getProperty("timeout.factor", "1");
        try {
            int factor = Integer.parseInt(timeoutString);
            if (factor < 1) {
                throw new NumberFormatException("timeout.factor must be at least 1");
            }
            return factor;
        }
        catch (NumberFormatException e) {
            return onError.applyAsInt(e);
        }
    }

    public static void waitFor(Condition condition) {
        Wait.waitFor(condition, MAX_WAIT_MILLIS);
    }

    public static void waitFor(Condition condition, long duration) {
        Wait.waitFor(condition, duration, 1000L);
    }

    public static void waitFor(Condition condition, long duration, long sleepMillis) {
        Wait.waitFor(condition, duration, sleepMillis, "");
    }

    public static void waitFor(Condition condition, long duration, long sleepMillis, String failMessage) {
        boolean success;
        int timeoutFactor = Wait.getTimeoutFactor(e -> 1);
        long scaledDurationNanos = TimeUnit.MILLISECONDS.toNanos(duration) * (long)timeoutFactor;
        long scaledSleepMillis = sleepMillis * (long)timeoutFactor;
        long startNanos = System.nanoTime();
        try {
            success = condition.isSatisfied();
            while (!success && System.nanoTime() - startNanos < scaledDurationNanos) {
                TimeUnit.MILLISECONDS.sleep(scaledSleepMillis);
                success = condition.isSatisfied();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted during wait");
        }
        catch (Exception ex) {
            throw new IllegalStateException(failMessage + ". Failed because of exception in condition", ex);
        }
        if (!success) {
            throw new IllegalStateException(failMessage + ". Timeout exceeded");
        }
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

