/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.zookeeper;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.curator.test.TestingServer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperTestingServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperTestingServer.class);
    public static final String SECRET = "secret";
    private TestingServer zkServer;
    private final ZooKeeper zoo;

    public ZooKeeperTestingServer(File tmpDir) {
        this(tmpDir, PortUtils.getRandomFreePort());
    }

    private ZooKeeperTestingServer(File tmpDir, int port) {
        Preconditions.checkArgument((boolean)tmpDir.isDirectory());
        try {
            CountDownLatch connectionLatch = new CountDownLatch(1);
            boolean started = false;
            int retry = 0;
            while (!started && retry++ < 3) {
                try {
                    this.zkServer = new TestingServer(port, tmpDir);
                    this.zkServer.start();
                    started = true;
                }
                catch (Exception ex) {
                    log.trace("zookeeper test server start failed attempt {}", (Object)retry);
                }
            }
            log.info("zookeeper connection string:'{}'", (Object)this.zkServer.getConnectString());
            this.zoo = new ZooKeeper(this.zkServer.getConnectString(), 5000, watchedEvent -> {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    connectionLatch.countDown();
                }
            });
            connectionLatch.await();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to start testing zookeeper", ex);
        }
    }

    public ZooKeeper getZooKeeper() {
        return this.zoo;
    }

    public ZooReaderWriter getZooReaderWriter() {
        return new ZooReader(this.getConn(), 30000).asWriter(SECRET);
    }

    public String getConn() {
        return this.zkServer.getConnectString();
    }

    public void initPaths(String s) {
        try {
            String[] paths = s.split("/");
            String slash = "/";
            Object path = "";
            for (String p : paths) {
                if (p.isEmpty()) continue;
                path = (String)path + slash + p;
                log.debug("building default paths, creating node {}", path);
                this.zoo.create((String)path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create accumulo initial paths: " + s, ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.zkServer != null) {
            this.zkServer.stop();
        }
    }
}

