/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tracer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.AgeOffFilter;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.tracer.TraceFormatter;
import org.apache.accumulo.tracer.thrift.RemoteSpan;
import org.apache.accumulo.tracer.thrift.SpanReceiver;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceServer
implements Watcher {
    private static final Logger log = LoggerFactory.getLogger(TraceServer.class);
    private final ServerConfigurationFactory serverConfiguration;
    private final TServer server;
    private final AtomicReference<BatchWriter> writer;
    private final Connector connector;
    final String tableName;
    private static final int BATCH_WRITER_MAX_LATENCY = 5;
    private static final long SCHEDULE_PERIOD = 1000L;
    private static final long SCHEDULE_DELAY = 1000L;

    private static void put(Mutation m, String cf, String cq, byte[] bytes, int len) {
        m.put(new Text(cf), new Text(cq), new Value(bytes, 0, len));
    }

    public TraceServer(ServerConfigurationFactory serverConfiguration, String hostname) throws Exception {
        this.serverConfiguration = serverConfiguration;
        log.info("Version 1.9.0");
        log.info("Instance " + serverConfiguration.getInstance().getInstanceID());
        AccumuloConfiguration conf = serverConfiguration.getConfiguration();
        this.tableName = conf.get(Property.TRACE_TABLE);
        this.connector = this.ensureTraceTableExists(conf);
        int[] ports = conf.getPort(Property.TRACE_PORT);
        ServerSocket sock = null;
        for (int port : ports) {
            ServerSocket s = ServerSocketChannel.open().socket();
            s.setReuseAddress(true);
            try {
                s.bind(new InetSocketAddress(hostname, port));
                sock = s;
                break;
            }
            catch (Exception e) {
                log.warn("Unable to start trace server on port {}", (Object)port);
            }
        }
        if (null == sock) {
            throw new RuntimeException("Unable to start trace server on configured ports: " + Arrays.toString(ports));
        }
        TServerSocket transport = new TServerSocket(sock);
        TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)transport);
        options.processor(new SpanReceiver.Processor<Receiver>(new Receiver()));
        this.server = new TThreadPoolServer(options);
        this.registerInZooKeeper(sock.getInetAddress().getHostAddress() + ":" + sock.getLocalPort(), conf.get(Property.TRACE_ZK_PATH));
        this.writer = new AtomicReference<BatchWriter>(this.connector.createBatchWriter(this.tableName, new BatchWriterConfig().setMaxLatency(5L, TimeUnit.SECONDS)));
    }

    private Connector ensureTraceTableExists(AccumuloConfiguration conf) throws AccumuloSecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Connector connector = null;
        while (true) {
            try {
                PasswordToken at;
                Map loginMap;
                boolean isDefaultTokenType = conf.get(Property.TRACE_TOKEN_TYPE).equals(Property.TRACE_TOKEN_TYPE.getDefaultValue());
                String principal = conf.get(Property.TRACE_USER);
                if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
                    principal = SecurityUtil.getServerPrincipal((String)principal);
                }
                if ((loginMap = conf.getAllPropertiesWithPrefix(Property.TRACE_TOKEN_PROPERTY_PREFIX)).isEmpty() && isDefaultTokenType) {
                    Property p = Property.TRACE_PASSWORD;
                    at = new PasswordToken(conf.get(p).getBytes(StandardCharsets.UTF_8));
                } else {
                    AuthenticationToken.Properties props = new AuthenticationToken.Properties();
                    AuthenticationToken token = AccumuloVFSClassLoader.getClassLoader().loadClass(conf.get(Property.TRACE_TOKEN_TYPE)).asSubclass(AuthenticationToken.class).newInstance();
                    int prefixLength = Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey().length();
                    for (Map.Entry entry : loginMap.entrySet()) {
                        props.put(((String)entry.getKey()).substring(prefixLength), (CharSequence)entry.getValue());
                    }
                    token.init(props);
                    at = token;
                }
                connector = this.serverConfiguration.getInstance().getConnector(principal, (AuthenticationToken)at);
                if (!connector.tableOperations().exists(this.tableName)) {
                    connector.tableOperations().create(this.tableName);
                    IteratorSetting setting = new IteratorSetting(10, "ageoff", AgeOffFilter.class.getName());
                    AgeOffFilter.setTTL((IteratorSetting)setting, (Long)604800000L);
                    connector.tableOperations().attachIterator(this.tableName, setting);
                }
                connector.tableOperations().setProperty(this.tableName, Property.TABLE_FORMATTER_CLASS.getKey(), TraceFormatter.class.getName());
            }
            catch (IOException | RuntimeException | AccumuloException | TableExistsException | TableNotFoundException ex) {
                log.info("Waiting to checking/create the trace table.", ex);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
        return connector;
    }

    public void run() throws Exception {
        SimpleTimer.getInstance((AccumuloConfiguration)this.serverConfiguration.getConfiguration()).schedule(new Runnable(){

            @Override
            public void run() {
                TraceServer.this.flush();
            }
        }, 1000L, 1000L);
        this.server.serve();
    }

    private void flush() {
        try {
            BatchWriter writer = this.writer.get();
            if (null != writer) {
                writer.flush();
            } else if (this.connector.tableOperations().exists(this.tableName)) {
                this.resetWriter();
            }
        }
        catch (MutationsRejectedException exception) {
            log.warn("Problem flushing traces, resetting writer. Set log level to DEBUG to see stacktrace. cause: " + (Object)((Object)exception));
            log.debug("flushing traces failed due to exception", (Throwable)exception);
            this.resetWriter();
        }
        catch (RuntimeException exception) {
            log.warn("Problem flushing traces, resetting writer. Set log level to DEBUG to see stacktrace. cause: " + exception);
            log.debug("flushing traces failed due to exception", (Throwable)exception);
            this.resetWriter();
        }
    }

    /*
     * Loose catch block
     */
    private void resetWriter() {
        block13: {
            BatchWriter writer = null;
            writer = this.connector.createBatchWriter(this.tableName, new BatchWriterConfig().setMaxLatency(5L, TimeUnit.SECONDS));
            writer = this.writer.getAndSet(writer);
            try {
                if (null != writer) {
                    writer.close();
                }
                break block13;
            }
            catch (Exception ex) {
                log.warn("Problem closing batch writer. Set log level to DEBUG to see stacktrace. cause: " + ex);
                log.debug("batch writer close failed with exception", (Throwable)ex);
            }
            break block13;
            catch (Exception ex) {
                try {
                    log.warn("Unable to create a batch writer, will retry. Set log level to DEBUG to see stacktrace. cause: " + ex);
                    log.debug("batch writer creation failed with exception.", (Throwable)ex);
                    writer = this.writer.getAndSet(writer);
                }
                catch (Throwable throwable) {
                    writer = this.writer.getAndSet(writer);
                    try {
                        if (null != writer) {
                            writer.close();
                        }
                    }
                    catch (Exception ex2) {
                        log.warn("Problem closing batch writer. Set log level to DEBUG to see stacktrace. cause: " + ex2);
                        log.debug("batch writer close failed with exception", (Throwable)ex2);
                    }
                    throw throwable;
                }
                try {
                    if (null != writer) {
                        writer.close();
                    }
                }
                catch (Exception ex3) {
                    log.warn("Problem closing batch writer. Set log level to DEBUG to see stacktrace. cause: " + ex3);
                    log.debug("batch writer close failed with exception", (Throwable)ex3);
                }
            }
        }
    }

    private void registerInZooKeeper(String name, String root) throws Exception {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        zoo.putPersistentData(root, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        log.info("Registering tracer " + name + " at " + root);
        String path = zoo.putEphemeralSequential(root + "/trace-", name.getBytes(StandardCharsets.UTF_8));
        zoo.exists(path, (Watcher)this);
    }

    private static void loginTracer(AccumuloConfiguration acuConf) {
        try {
            Class<AuthenticationToken> traceTokenType = AccumuloVFSClassLoader.getClassLoader().loadClass(acuConf.get(Property.TRACE_TOKEN_TYPE)).asSubclass(AuthenticationToken.class);
            if (!KerberosToken.class.isAssignableFrom(traceTokenType)) {
                log.info("Handling login under the assumption that Accumulo users are not using Kerberos.");
                SecurityUtil.serverLogin((AccumuloConfiguration)acuConf);
            } else {
                log.info("Handling login under the assumption that Accumulo users are using Kerberos.");
                Map loginMap = acuConf.getAllPropertiesWithPrefix(Property.TRACE_TOKEN_PROPERTY_PREFIX);
                String keyTab = (String)loginMap.get(Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey() + "keytab");
                if (keyTab == null || keyTab.length() == 0) {
                    keyTab = acuConf.getPath(Property.GENERAL_KERBEROS_KEYTAB);
                }
                if (keyTab == null || keyTab.length() == 0) {
                    return;
                }
                String principalConfig = acuConf.get(Property.TRACE_USER);
                if (principalConfig == null || principalConfig.length() == 0) {
                    return;
                }
                log.info("Attempting to login as {} with {}", (Object)principalConfig, (Object)keyTab);
                SecurityUtil.serverLogin((AccumuloConfiguration)acuConf, (String)keyTab, (String)principalConfig);
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            String msg = String.format("Failed to retrieve trace user token information based on property %1s.", Property.TRACE_TOKEN_TYPE);
            log.error(msg, (Throwable)exception);
            throw new RuntimeException(msg, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String app = "tracer";
        Accumulo.setupLogging((String)"tracer");
        TraceServer.loginTracer((AccumuloConfiguration)SiteConfiguration.getInstance());
        ServerOpts opts = new ServerOpts();
        opts.parseArgs("tracer", args, new Object[0]);
        Instance instance = HdfsZooInstance.getInstance();
        ServerConfigurationFactory conf = new ServerConfigurationFactory(instance);
        VolumeManager fs = VolumeManagerImpl.get();
        MetricsSystemHelper.configure((String)TraceServer.class.getSimpleName());
        Accumulo.init((VolumeManager)fs, (ServerConfigurationFactory)conf, (String)"tracer");
        String hostname = opts.getAddress();
        TraceServer server = new TraceServer(conf, hostname);
        try {
            server.run();
        }
        finally {
            log.info("tracer stopping");
            ZooReaderWriter.getInstance().getZooKeeper().close();
        }
    }

    public void process(WatchedEvent event) {
        log.debug("event " + event.getPath() + " " + event.getType() + " " + event.getState());
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            log.warn("Trace server lost zookeeper registration at " + event.getPath());
            this.server.stop();
        } else if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
            log.warn("Trace server zookeeper entry lost " + event.getPath());
            this.server.stop();
        }
        if (event.getPath() != null) {
            try {
                if (ZooReaderWriter.getInstance().exists(event.getPath(), (Watcher)this)) {
                    return;
                }
            }
            catch (Exception ex) {
                log.error("{}", (Object)ex.getMessage(), (Object)ex);
            }
            log.warn("Trace server unable to reset watch on zookeeper registration");
            this.server.stop();
        }
    }

    class Receiver
    implements SpanReceiver.Iface {
        Receiver() {
        }

        @Override
        public void span(RemoteSpan s) throws TException {
            String idString = Long.toHexString(s.traceId);
            String startString = Long.toHexString(s.start);
            Mutation spanMutation = new Mutation(new Text(idString));
            Mutation indexMutation = new Mutation(new Text("idx:" + s.svc + ":" + startString));
            long diff = s.stop - s.start;
            indexMutation.put(new Text(s.description), new Text(s.sender), new Value((idString + ":" + Long.toHexString(diff)).getBytes(StandardCharsets.UTF_8)));
            ByteArrayTransport transport = new ByteArrayTransport();
            TCompactProtocol protocol = new TCompactProtocol((TTransport)transport);
            s.write((TProtocol)protocol);
            String parentString = Long.toHexString(s.parentId);
            if (s.parentId == 477902L) {
                parentString = "";
            }
            TraceServer.put(spanMutation, "span", parentString + ":" + Long.toHexString(s.spanId), transport.get(), transport.len());
            Mutation timeMutation = null;
            if (s.parentId == 477902L) {
                timeMutation = new Mutation(new Text("start:" + startString));
                TraceServer.put(timeMutation, "id", idString, transport.get(), transport.len());
            }
            try {
                BatchWriter writer = (BatchWriter)TraceServer.this.writer.get();
                if (null == writer) {
                    log.warn("writer is not ready; discarding span.");
                    return;
                }
                writer.addMutation(spanMutation);
                writer.addMutation(indexMutation);
                if (timeMutation != null) {
                    writer.addMutation(timeMutation);
                }
            }
            catch (MutationsRejectedException exception) {
                log.warn("Unable to write mutation to table; discarding span. set log level to DEBUG for span information and stacktrace. cause: " + (Object)((Object)exception));
                if (log.isDebugEnabled()) {
                    log.debug("discarded span due to rejection of mutation: " + spanMutation, (Throwable)exception);
                }
            }
            catch (RuntimeException exception) {
                log.warn("Unable to write mutation to table; discarding span. set log level to DEBUG for stacktrace. cause: " + exception);
                log.debug("unable to write mutation to table due to exception.", (Throwable)exception);
            }
        }
    }

    static class ByteArrayTransport
    extends TTransport {
        TByteArrayOutputStream out = new TByteArrayOutputStream();

        ByteArrayTransport() {
        }

        public boolean isOpen() {
            return true;
        }

        public void open() throws TTransportException {
        }

        public void close() {
        }

        public int read(byte[] buf, int off, int len) {
            return 0;
        }

        public void write(byte[] buf, int off, int len) throws TTransportException {
            this.out.write(buf, off, len);
        }

        public byte[] get() {
            return this.out.get();
        }

        public int len() {
            return this.out.len();
        }
    }
}

