/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tracer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.apache.accumulo.tracer.AsyncSpanReceiver;
import org.apache.accumulo.tracer.thrift.RemoteSpan;
import org.apache.accumulo.tracer.thrift.SpanReceiver;
import org.apache.htrace.HTraceConfiguration;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSpansViaThrift
extends AsyncSpanReceiver<String, SpanReceiver.Client> {
    private static final Logger log = LoggerFactory.getLogger(SendSpansViaThrift.class);
    private static final String THRIFT = "thrift://";
    private static final String DEST = "dest";

    SendSpansViaThrift() {
    }

    public SendSpansViaThrift(HTraceConfiguration conf) {
        super(conf);
    }

    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="insecure, known risk; this is user-configurable to avoid insecure transfer")
    protected SpanReceiver.Client createDestination(String destination) {
        if (destination == null) {
            return null;
        }
        try {
            int portSeparatorIndex = destination.lastIndexOf(58);
            String host = destination.substring(0, portSeparatorIndex);
            int port = Integer.parseInt(destination.substring(portSeparatorIndex + 1));
            log.debug("Connecting to {}:{}", (Object)host, (Object)port);
            InetSocketAddress addr = new InetSocketAddress(host, port);
            Socket sock = new Socket();
            sock.connect(addr);
            TSocket transport = new TSocket(sock);
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)transport);
            return new SpanReceiver.Client((TProtocol)prot);
        }
        catch (IOException ex) {
            log.trace("{}", (Object)ex, (Object)ex);
            return null;
        }
        catch (Exception ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    @Override
    protected void send(SpanReceiver.Client client, RemoteSpan s) throws Exception {
        if (client != null) {
            try {
                client.span(s);
            }
            catch (Exception ex) {
                client.getInputProtocol().getTransport().close();
                throw ex;
            }
        }
    }

    @Override
    protected String getSpanKey(Map<String, String> data) {
        String hostAddress;
        String[] hostAddr;
        String dest = data.get(DEST);
        if (dest != null && dest.startsWith(THRIFT) && (hostAddr = (hostAddress = dest.substring(THRIFT.length())).split(":", 2)).length == 2) {
            return hostAddress;
        }
        return null;
    }
}

