/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.Objects;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.tablet.CompactionStats;
import org.apache.accumulo.tserver.tablet.Tablet;

final class CompactionRunner
implements Runnable,
Comparable<CompactionRunner> {
    private final Tablet tablet;
    private final MajorCompactionReason reason;
    private final long queued;

    public CompactionRunner(Tablet tablet, MajorCompactionReason reason) {
        this.tablet = tablet;
        this.queued = System.currentTimeMillis();
        this.reason = reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CompactionStats stats = this.tablet.majorCompact(this.reason, this.queued);
        if (stats != null && stats.getEntriesRead() > 0L) {
            Tablet tablet = this.tablet;
            synchronized (tablet) {
                if (this.reason == MajorCompactionReason.NORMAL && this.tablet.needsMajorCompaction(this.reason)) {
                    this.tablet.initiateMajorCompaction(this.reason);
                }
            }
        }
    }

    private int getNumFiles() {
        return this.tablet.getDatafileManager().getNumFiles();
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.reason) + Objects.hashCode(this.queued) + this.getNumFiles();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof CompactionRunner && 0 == this.compareTo((CompactionRunner)obj);
    }

    @Override
    public int compareTo(CompactionRunner o) {
        int cmp = this.reason.compareTo(o.reason);
        if (cmp != 0) {
            return cmp;
        }
        if ((this.reason == MajorCompactionReason.USER || this.reason == MajorCompactionReason.CHOP) && (cmp = (int)(this.queued - o.queued)) != 0) {
            return cmp;
        }
        return o.getNumFiles() - this.getNumFiles();
    }
}

