/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class CompactionQueue
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    private List<Comparable> task = new LinkedList<Comparable>();

    @Override
    public synchronized Runnable poll() {
        if (this.task.size() == 0) {
            return null;
        }
        Comparable min = Collections.min(this.task);
        this.task.remove(min);
        return (Runnable)((Object)min);
    }

    @Override
    public synchronized Runnable peek() {
        if (this.task.size() == 0) {
            return null;
        }
        Comparable min = Collections.min(this.task);
        return (Runnable)((Object)min);
    }

    @Override
    public synchronized boolean offer(Runnable e) {
        this.task.add((Comparable)((Object)e));
        this.notify();
        return true;
    }

    @Override
    public synchronized void put(Runnable e) throws InterruptedException {
        this.task.add((Comparable)((Object)e));
        this.notify();
    }

    @Override
    public synchronized boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
        this.task.add((Comparable)((Object)e));
        this.notify();
        return true;
    }

    @Override
    public synchronized Runnable take() throws InterruptedException {
        while (this.task.size() == 0) {
            this.wait();
        }
        return this.poll();
    }

    @Override
    public synchronized Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.task.size() == 0) {
            this.wait(unit.toMillis(timeout));
        }
        if (this.task.size() == 0) {
            return null;
        }
        return this.poll();
    }

    @Override
    public synchronized int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized int drainTo(Collection<? super Runnable> c) {
        return this.drainTo(c, this.task.size());
    }

    @Override
    public synchronized int drainTo(Collection<? super Runnable> c, int maxElements) {
        Collections.sort(this.task);
        int num = Math.min(this.task.size(), maxElements);
        Iterator<Comparable> iter = this.task.iterator();
        for (int i = 0; i < num; ++i) {
            c.add((Runnable)((Object)iter.next()));
            iter.remove();
        }
        return num;
    }

    @Override
    public synchronized Iterator<Runnable> iterator() {
        Collections.sort(this.task);
        final Iterator<Comparable> iter = this.task.iterator();
        return new Iterator<Runnable>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Runnable next() {
                return (Runnable)iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public synchronized int size() {
        return this.task.size();
    }
}

