/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.TimeSettingIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.CompactionReason;
import org.apache.accumulo.core.tabletserver.thrift.CompactionType;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReportingIterator;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.tserver.CompactionStats;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.Tablet;
import org.apache.accumulo.tserver.TabletIteratorEnvironment;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;

public class Compactor
implements Callable<CompactionStats> {
    private static final Logger log = Logger.getLogger(Compactor.class);
    private Map<FileRef, DataFileValue> filesToCompact;
    private InMemoryMap imm;
    private FileRef outputFile;
    private boolean propogateDeletes;
    private AccumuloConfiguration acuTableConf;
    private CompactionEnv env;
    private Configuration conf;
    private VolumeManager fs;
    protected KeyExtent extent;
    private List<IteratorSetting> iterators;
    private String currentLocalityGroup = "";
    private long startTime;
    private MajorCompactionReason reason;
    protected Tablet.MinorCompactionReason mincReason;
    private AtomicLong entriesRead = new AtomicLong(0L);
    private AtomicLong entriesWritten = new AtomicLong(0L);
    private DateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static AtomicLong nextCompactorID = new AtomicLong(0L);
    private long compactorID = nextCompactorID.getAndIncrement();
    protected volatile Thread thread;
    protected static final Set<Compactor> runningCompactions = Collections.synchronizedSet(new HashSet());

    private synchronized void setLocalityGroup(String name) {
        this.currentLocalityGroup = name;
    }

    private void clearStats() {
        this.entriesRead.set(0L);
        this.entriesWritten.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompactionInfo> getRunningCompactions() {
        ArrayList<CompactionInfo> compactions = new ArrayList<CompactionInfo>();
        Set<Compactor> set = runningCompactions;
        synchronized (set) {
            for (Compactor compactor : runningCompactions) {
                compactions.add(new CompactionInfo(compactor));
            }
        }
        return compactions;
    }

    Compactor(Configuration conf, VolumeManager fs, Map<FileRef, DataFileValue> files, InMemoryMap imm, FileRef outputFile, boolean propogateDeletes, AccumuloConfiguration acuTableConf, KeyExtent extent, CompactionEnv env, List<IteratorSetting> iterators, MajorCompactionReason reason) {
        this.extent = extent;
        this.conf = conf;
        this.fs = fs;
        this.filesToCompact = files;
        this.imm = imm;
        this.outputFile = outputFile;
        this.propogateDeletes = propogateDeletes;
        this.acuTableConf = acuTableConf;
        this.env = env;
        this.iterators = iterators;
        this.reason = reason;
        this.startTime = System.currentTimeMillis();
    }

    Compactor(Configuration conf, VolumeManager fs, Map<FileRef, DataFileValue> files, InMemoryMap imm, FileRef outputFile, boolean propogateDeletes, AccumuloConfiguration acuTableConf, KeyExtent extent, CompactionEnv env) {
        this(conf, fs, files, imm, outputFile, propogateDeletes, acuTableConf, extent, env, new ArrayList<IteratorSetting>(), null);
    }

    public VolumeManager getFileSystem() {
        return this.fs;
    }

    KeyExtent getExtent() {
        return this.extent;
    }

    String getOutputFile() {
        return this.outputFile.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionStats call() throws IOException, CompactionCanceledException {
        FileSKVWriter mfw = null;
        CompactionStats majCStats = new CompactionStats();
        boolean remove = runningCompactions.add(this);
        this.clearStats();
        String oldThreadName = Thread.currentThread().getName();
        String newThreadName = "MajC compacting " + this.extent.toString() + " started " + this.dateFormatter.format(new Date()) + " file: " + this.outputFile;
        Thread.currentThread().setName(newThreadName);
        this.thread = Thread.currentThread();
        try {
            Map lGroups;
            FileOperations fileFactory = FileOperations.getInstance();
            FileSystem ns = this.fs.getVolumeByPath(this.outputFile.path()).getFileSystem();
            mfw = fileFactory.openWriter(this.outputFile.path().toString(), ns, ns.getConf(), this.acuTableConf);
            try {
                lGroups = LocalityGroupUtil.getLocalityGroups((AccumuloConfiguration)this.acuTableConf);
            }
            catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
                throw new IOException(e);
            }
            long t1 = System.currentTimeMillis();
            HashSet<ByteSequence> allColumnFamilies = new HashSet<ByteSequence>();
            if (mfw.supportsLocalityGroups()) {
                for (Map.Entry entry : lGroups.entrySet()) {
                    this.setLocalityGroup((String)entry.getKey());
                    this.compactLocalityGroup((String)entry.getKey(), (Set)entry.getValue(), true, mfw, majCStats);
                    allColumnFamilies.addAll((Collection)entry.getValue());
                }
            }
            this.setLocalityGroup("");
            this.compactLocalityGroup(null, allColumnFamilies, false, mfw, majCStats);
            long t2 = System.currentTimeMillis();
            FileSKVWriter mfwTmp = mfw;
            mfw = null;
            mfwTmp.close();
            try {
                FileSKVIterator openReader = fileFactory.openReader(this.outputFile.path().toString(), false, ns, ns.getConf(), this.acuTableConf);
                openReader.close();
            }
            catch (IOException ex) {
                log.error((Object)("Verification of successful compaction fails!!! " + this.extent + " " + this.outputFile), (Throwable)ex);
                throw ex;
            }
            log.debug((Object)String.format("Compaction %s %,d read | %,d written | %,6d entries/sec | %6.3f secs", this.extent, majCStats.getEntriesRead(), majCStats.getEntriesWritten(), (int)((double)majCStats.getEntriesRead() / ((double)(t2 - t1) / 1000.0)), (double)(t2 - t1) / 1000.0));
            majCStats.setFileSize(fileFactory.getFileSize(this.outputFile.path().toString(), ns, ns.getConf(), this.acuTableConf));
            CompactionStats compactionStats = majCStats;
            return compactionStats;
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            block25: {
                Thread.currentThread().setName(oldThreadName);
                if (remove) {
                    this.thread = null;
                    runningCompactions.remove(this);
                }
                try {
                    if (mfw == null) break block25;
                    try {
                        mfw.close();
                    }
                    finally {
                        if (!this.fs.deleteRecursively(this.outputFile.path()) && this.fs.exists(this.outputFile.path())) {
                            log.error((Object)("Unable to delete " + this.outputFile));
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                }
                catch (RuntimeException exception) {
                    log.warn((Object)exception, (Throwable)exception);
                }
            }
        }
    }

    private List<SortedKeyValueIterator<Key, Value>> openMapDataFiles(String lgName, ArrayList<FileSKVIterator> readers) throws IOException {
        ArrayList<SortedKeyValueIterator<Key, Value>> iters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.filesToCompact.size());
        for (FileRef mapFile : this.filesToCompact.keySet()) {
            try {
                FileOperations fileFactory = FileOperations.getInstance();
                FileSystem fs = this.fs.getVolumeByPath(mapFile.path()).getFileSystem();
                FileSKVIterator reader = fileFactory.openReader(mapFile.path().toString(), false, fs, this.conf, this.acuTableConf);
                readers.add(reader);
                ProblemReportingIterator iter = new ProblemReportingIterator(this.extent.getTableId().toString(), mapFile.path().toString(), false, (SortedKeyValueIterator)reader);
                if (this.filesToCompact.get(mapFile).isTimeSet()) {
                    iter = new TimeSettingIterator((SortedKeyValueIterator)iter, this.filesToCompact.get(mapFile).getTime());
                }
                iters.add((SortedKeyValueIterator<Key, Value>)iter);
            }
            catch (Throwable e) {
                ProblemReports.getInstance().report(new ProblemReport(this.extent.getTableId().toString(), ProblemType.FILE_READ, mapFile.path().toString(), e));
                log.warn((Object)("Some problem opening map file " + mapFile + " " + e.getMessage()), e);
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e2) {
                        log.warn((Object)"Failed to close map file", e2);
                    }
                }
                readers.clear();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("Failed to open map data files", e);
            }
        }
        return iters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactLocalityGroup(String lgName, Set<ByteSequence> columnFamilies, boolean inclusive, FileSKVWriter mfw, CompactionStats majCStats) throws IOException, CompactionCanceledException {
        Span span;
        ArrayList<FileSKVIterator> readers;
        block23: {
            readers = new ArrayList<FileSKVIterator>(this.filesToCompact.size());
            span = Trace.start((String)"compact");
            try {
                TabletIteratorEnvironment iterEnv;
                long entriesCompacted = 0L;
                List<SortedKeyValueIterator<Key, Value>> iters = this.openMapDataFiles(lgName, readers);
                if (this.imm != null) {
                    iters.add(this.imm.compactionIterator());
                }
                CountingIterator citr = new CountingIterator((SortedKeyValueIterator<Key, Value>)new MultiIterator(iters, this.extent.toDataRange()), this.entriesRead);
                DeletingIterator delIter = new DeletingIterator((SortedKeyValueIterator)citr, this.propogateDeletes);
                ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator((SortedKeyValueIterator)delIter);
                if (this.env.getIteratorScope() == IteratorUtil.IteratorScope.majc) {
                    iterEnv = new TabletIteratorEnvironment(IteratorUtil.IteratorScope.majc, !this.propogateDeletes, this.acuTableConf);
                } else if (this.env.getIteratorScope() == IteratorUtil.IteratorScope.minc) {
                    iterEnv = new TabletIteratorEnvironment(IteratorUtil.IteratorScope.minc, this.acuTableConf);
                } else {
                    throw new IllegalArgumentException();
                }
                SortedKeyValueIterator<Key, Value> itr = iterEnv.getTopLevelIterator((SortedKeyValueIterator<Key, Value>)IteratorUtil.loadIterators((IteratorUtil.IteratorScope)this.env.getIteratorScope(), (SortedKeyValueIterator)cfsi, (KeyExtent)this.extent, (AccumuloConfiguration)this.acuTableConf, this.iterators, (IteratorEnvironment)iterEnv));
                itr.seek(this.extent.toDataRange(), columnFamilies, inclusive);
                if (!inclusive) {
                    mfw.startDefaultLocalityGroup();
                } else {
                    mfw.startNewLocalityGroup(lgName, columnFamilies);
                }
                Span write = Trace.start((String)"write");
                try {
                    while (itr.hasTop() && this.env.isCompactionEnabled()) {
                        mfw.append((Key)itr.getTopKey(), (Value)itr.getTopValue());
                        itr.next();
                        if (++entriesCompacted % 1024L != 0L) continue;
                        this.entriesWritten.addAndGet(1024L);
                    }
                    if (!itr.hasTop() || this.env.isCompactionEnabled()) break block23;
                    try {
                        try {
                            mfw.close();
                        }
                        catch (IOException e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        this.fs.deleteRecursively(this.outputFile.path());
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to delete Canceled compaction output file " + this.outputFile), (Throwable)e);
                    }
                    throw new CompactionCanceledException();
                }
                finally {
                    CompactionStats lgMajcStats = new CompactionStats(citr.getCount(), entriesCompacted);
                    majCStats.add(lgMajcStats);
                    write.stop();
                }
            }
            catch (Throwable throwable) {
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e) {
                        log.warn((Object)"Failed to close map file", e);
                    }
                }
                span.stop();
                throw throwable;
            }
        }
        for (FileSKVIterator reader : readers) {
            try {
                reader.close();
            }
            catch (Throwable e) {
                log.warn((Object)"Failed to close map file", e);
            }
        }
        span.stop();
    }

    public static class CompactionInfo {
        private Compactor compactor;
        private String localityGroup;
        private long entriesRead;
        private long entriesWritten;

        CompactionInfo(Compactor compactor) {
            this.localityGroup = compactor.currentLocalityGroup;
            this.entriesRead = compactor.entriesRead.get();
            this.entriesWritten = compactor.entriesWritten.get();
            this.compactor = compactor;
        }

        public long getID() {
            return this.compactor.compactorID;
        }

        public KeyExtent getExtent() {
            return this.compactor.getExtent();
        }

        public long getEntriesRead() {
            return this.entriesRead;
        }

        public long getEntriesWritten() {
            return this.entriesWritten;
        }

        public Thread getThread() {
            return this.compactor.thread;
        }

        public String getOutputFile() {
            return this.compactor.getOutputFile();
        }

        public ActiveCompaction toThrift() {
            CompactionReason reason;
            CompactionType type = this.compactor.imm != null ? (this.compactor.filesToCompact.size() > 0 ? CompactionType.MERGE : CompactionType.MINOR) : (!this.compactor.propogateDeletes ? CompactionType.FULL : CompactionType.MAJOR);
            if (this.compactor.imm != null) {
                switch (this.compactor.mincReason) {
                    case USER: {
                        reason = CompactionReason.USER;
                        break;
                    }
                    case CLOSE: {
                        reason = CompactionReason.CLOSE;
                        break;
                    }
                    default: {
                        reason = CompactionReason.SYSTEM;
                        break;
                    }
                }
            } else {
                switch (this.compactor.reason) {
                    case USER: {
                        reason = CompactionReason.USER;
                        break;
                    }
                    case CHOP: {
                        reason = CompactionReason.CHOP;
                        break;
                    }
                    case IDLE: {
                        reason = CompactionReason.IDLE;
                        break;
                    }
                    default: {
                        reason = CompactionReason.SYSTEM;
                    }
                }
            }
            ArrayList<IterInfo> iiList = new ArrayList<IterInfo>();
            HashMap<String, Map> iterOptions = new HashMap<String, Map>();
            for (IteratorSetting iterSetting : this.compactor.iterators) {
                iiList.add(new IterInfo(iterSetting.getPriority(), iterSetting.getIteratorClass(), iterSetting.getName()));
                iterOptions.put(iterSetting.getName(), iterSetting.getOptions());
            }
            ArrayList<String> filesToCompact = new ArrayList<String>();
            for (FileRef ref : this.compactor.filesToCompact.keySet()) {
                filesToCompact.add(ref.toString());
            }
            return new ActiveCompaction(this.compactor.extent.toThrift(), System.currentTimeMillis() - this.compactor.startTime, filesToCompact, this.compactor.outputFile.toString(), type, reason, this.localityGroup, this.entriesRead, this.entriesWritten, iiList, iterOptions);
        }
    }

    static interface CompactionEnv {
        public boolean isCompactionEnabled();

        public IteratorUtil.IteratorScope getIteratorScope();
    }

    static class CompactionCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CompactionCanceledException() {
        }
    }

    public static class CountingIterator
    extends WrappingIterator {
        private long count;
        private ArrayList<CountingIterator> deepCopies;
        private AtomicLong entriesRead;

        public CountingIterator deepCopy(IteratorEnvironment env) {
            return new CountingIterator(this, env);
        }

        private CountingIterator(CountingIterator other, IteratorEnvironment env) {
            this.setSource(other.getSource().deepCopy(env));
            this.count = 0L;
            this.deepCopies = other.deepCopies;
            this.entriesRead = other.entriesRead;
            this.deepCopies.add(this);
        }

        public CountingIterator(SortedKeyValueIterator<Key, Value> source, AtomicLong entriesRead) {
            this.deepCopies = new ArrayList();
            this.setSource(source);
            this.count = 0L;
            this.entriesRead = entriesRead;
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }

        public void next() throws IOException {
            super.next();
            ++this.count;
            if (this.count % 1024L == 0L) {
                this.entriesRead.addAndGet(1024L);
            }
        }

        public long getCount() {
            long sum = 0L;
            for (CountingIterator dc : this.deepCopies) {
                sum += dc.count;
            }
            return this.count + sum;
        }
    }
}

