/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.SortedMapIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.iterators.system.LocalityGroupIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.tserver.MemKey;
import org.apache.accumulo.tserver.MemKeyComparator;
import org.apache.accumulo.tserver.MemKeyConversionIterator;
import org.apache.accumulo.tserver.MemValue;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.accumulo.tserver.PartialMutationSkippingIterator;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class InMemoryMap {
    private SimpleMap map = null;
    private static final Logger log = Logger.getLogger(InMemoryMap.class);
    private volatile String memDumpFile = null;
    private final String memDumpDir;
    private Map<String, Set<ByteSequence>> lggroups;
    private AtomicInteger nextKVCount = new AtomicInteger(1);
    private AtomicInteger kvCount = new AtomicInteger(0);
    private Object writeSerializer = new Object();
    private final Set<MemoryIterator> activeIters = Collections.synchronizedSet(new HashSet());
    private boolean deleted = false;

    public InMemoryMap(boolean useNativeMap, String memDumpDir) {
        this(new HashMap<String, Set<ByteSequence>>(), useNativeMap, memDumpDir);
    }

    public InMemoryMap(Map<String, Set<ByteSequence>> lggroups, boolean useNativeMap, String memDumpDir) {
        this.memDumpDir = memDumpDir;
        this.lggroups = lggroups;
        this.map = lggroups.size() == 0 ? InMemoryMap.newMap(useNativeMap) : new LocalityGroupMap(lggroups, useNativeMap);
    }

    public InMemoryMap(AccumuloConfiguration config) throws LocalityGroupUtil.LocalityGroupConfigurationError {
        this(LocalityGroupUtil.getLocalityGroups((AccumuloConfiguration)config), config.getBoolean(Property.TSERV_NATIVEMAP_ENABLED), config.get(Property.TSERV_MEMDUMP_DIR));
    }

    private static SimpleMap newMap(boolean useNativeMap) {
        if (useNativeMap && NativeMap.isLoaded()) {
            try {
                return new NativeMapWrapper();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to create native map", t);
            }
        }
        return new DefaultMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(List<Mutation> mutations) {
        int numKVs = 0;
        for (int i = 0; i < mutations.size(); ++i) {
            numKVs += mutations.get(i).size();
        }
        Object object = this.writeSerializer;
        synchronized (object) {
            int kv = this.nextKVCount.getAndAdd(numKVs);
            try {
                this.map.mutate(mutations, kv);
            }
            finally {
                this.kvCount.set(kv + numKVs - 1);
            }
        }
    }

    public synchronized long estimatedSizeInBytes() {
        if (this.map == null) {
            return 0L;
        }
        return this.map.getMemoryUsed();
    }

    Iterator<Map.Entry<Key, Value>> iterator(Key startKey) {
        return this.map.iterator(startKey);
    }

    public long getNumEntries() {
        return this.map.size();
    }

    public synchronized MemoryIterator skvIterator() {
        if (this.map == null) {
            throw new NullPointerException();
        }
        if (this.deleted) {
            throw new IllegalStateException("Can not obtain iterator after map deleted");
        }
        int mc = this.kvCount.get();
        MemoryDataSource mds = new MemoryDataSource();
        SourceSwitchingIterator ssi = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)new MemoryDataSource());
        MemoryIterator mi = new MemoryIterator(new PartialMutationSkippingIterator((SortedKeyValueIterator<Key, Value>)ssi, mc));
        mi.setSSI(ssi);
        mi.setMDS(mds);
        this.activeIters.add(mi);
        return mi;
    }

    public SortedKeyValueIterator<Key, Value> compactionIterator() {
        if (this.nextKVCount.get() - 1 != this.kvCount.get()) {
            throw new IllegalStateException("Memory map in unexpected state : nextKVCount = " + this.nextKVCount.get() + " kvCount = " + this.kvCount.get());
        }
        return this.map.skvIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long waitTime) {
        InMemoryMap inMemoryMap = this;
        synchronized (inMemoryMap) {
            if (this.deleted) {
                throw new IllegalStateException("Double delete");
            }
            this.deleted = true;
        }
        long t1 = System.currentTimeMillis();
        while (this.activeIters.size() > 0 && System.currentTimeMillis() - t1 < waitTime) {
            UtilWaitThread.sleep((long)50L);
        }
        if (this.activeIters.size() > 0) {
            try {
                Configuration conf = CachedConfiguration.getInstance();
                FileSystem fs = TraceFileSystem.wrap((FileSystem)FileSystem.getLocal((Configuration)conf));
                String tmpFile = this.memDumpDir + "/memDump" + UUID.randomUUID() + "." + "rf";
                Configuration newConf = new Configuration(conf);
                newConf.setInt("io.seqfile.compress.blocksize", 100000);
                FileSKVWriter out = new RFileOperations().openWriter(tmpFile, fs, newConf, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
                InterruptibleIterator iter = this.map.skvIterator();
                HashSet allfams = new HashSet();
                for (Map.Entry<String, Set<ByteSequence>> entry : this.lggroups.entrySet()) {
                    allfams.addAll(entry.getValue());
                    out.startNewLocalityGroup(entry.getKey(), entry.getValue());
                    iter.seek(new Range(), (Collection)entry.getValue(), true);
                    this.dumpLocalityGroup(out, iter);
                }
                out.startDefaultLocalityGroup();
                iter.seek(new Range(), allfams, false);
                this.dumpLocalityGroup(out, iter);
                out.close();
                log.debug((Object)("Created mem dump file " + tmpFile));
                this.memDumpFile = tmpFile;
                Set<MemoryIterator> set = this.activeIters;
                synchronized (set) {
                    for (MemoryIterator mi : this.activeIters) {
                        mi.switchNow();
                    }
                }
                fs.delete(new Path(this.memDumpFile), true);
            }
            catch (IOException ioe) {
                log.error((Object)"Failed to create mem dump file ", (Throwable)ioe);
                while (this.activeIters.size() > 0) {
                    UtilWaitThread.sleep((long)100L);
                }
            }
        }
        SimpleMap tmpMap = this.map;
        InMemoryMap inMemoryMap2 = this;
        synchronized (inMemoryMap2) {
            this.map = null;
        }
        tmpMap.delete();
    }

    private void dumpLocalityGroup(FileSKVWriter out, InterruptibleIterator iter) throws IOException {
        while (iter.hasTop() && this.activeIters.size() > 0) {
            MemValue newValue = new MemValue((Value)iter.getTopValue(), ((MemKey)iter.getTopKey()).kvCount);
            out.append((Key)iter.getTopKey(), (Value)newValue);
            iter.next();
        }
    }

    class MemoryIterator
    extends WrappingIterator
    implements InterruptibleIterator {
        private AtomicBoolean closed;
        private SourceSwitchingIterator ssi;
        private MemoryDataSource mds;

        protected SortedKeyValueIterator<Key, Value> getSource() {
            if (this.closed.get()) {
                throw new IllegalStateException("Memory iterator is closed");
            }
            return super.getSource();
        }

        private MemoryIterator(InterruptibleIterator source) {
            this((SortedKeyValueIterator<Key, Value>)source, new AtomicBoolean(false));
        }

        private MemoryIterator(SortedKeyValueIterator<Key, Value> source, AtomicBoolean closed) {
            this.setSource(source);
            this.closed = closed;
        }

        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            return new MemoryIterator((SortedKeyValueIterator<Key, Value>)this.getSource().deepCopy(env), this.closed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            MemoryIterator memoryIterator = this;
            synchronized (memoryIterator) {
                if (this.closed.compareAndSet(false, true)) {
                    for (FileSKVIterator reader : this.mds.readers) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            log.warn((Object)e, (Throwable)e);
                        }
                    }
                }
            }
            InMemoryMap.this.activeIters.remove((Object)this);
        }

        private synchronized boolean switchNow() throws IOException {
            if (this.closed.get()) {
                return false;
            }
            this.ssi.switchNow();
            return true;
        }

        public void setInterruptFlag(AtomicBoolean flag) {
            ((InterruptibleIterator)this.getSource()).setInterruptFlag(flag);
        }

        private void setSSI(SourceSwitchingIterator ssi) {
            this.ssi = ssi;
        }

        public void setMDS(MemoryDataSource mds) {
            this.mds = mds;
        }
    }

    class MemoryDataSource
    implements SourceSwitchingIterator.DataSource {
        boolean switched = false;
        private InterruptibleIterator iter;
        private List<FileSKVIterator> readers;

        MemoryDataSource() {
            this(new ArrayList<FileSKVIterator>());
        }

        public MemoryDataSource(List<FileSKVIterator> readers) {
            this.readers = readers;
        }

        public boolean isCurrent() {
            if (this.switched) {
                return true;
            }
            return InMemoryMap.this.memDumpFile == null;
        }

        public SourceSwitchingIterator.DataSource getNewDataSource() {
            if (this.switched) {
                throw new IllegalStateException();
            }
            if (!this.isCurrent()) {
                this.switched = true;
                this.iter = null;
            }
            return this;
        }

        public SortedKeyValueIterator<Key, Value> iterator() throws IOException {
            if (this.iter == null) {
                if (!this.switched) {
                    this.iter = InMemoryMap.this.map.skvIterator();
                } else {
                    Configuration conf = CachedConfiguration.getInstance();
                    FileSystem fs = TraceFileSystem.wrap((FileSystem)FileSystem.getLocal((Configuration)conf));
                    FileSKVIterator reader = new RFileOperations().openReader(InMemoryMap.this.memDumpFile, true, fs, conf, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
                    this.readers.add(reader);
                    this.iter = new MemKeyConversionIterator((SortedKeyValueIterator<Key, Value>)reader);
                }
            }
            return this.iter;
        }

        public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
            return new MemoryDataSource(this.readers);
        }
    }

    private static class NativeMapWrapper
    implements SimpleMap {
        private NativeMap nativeMap = new NativeMap();

        NativeMapWrapper() {
        }

        @Override
        public Value get(Key key) {
            return this.nativeMap.get(key);
        }

        @Override
        public Iterator<Map.Entry<Key, Value>> iterator(Key startKey) {
            return this.nativeMap.iterator(startKey);
        }

        @Override
        public int size() {
            return this.nativeMap.size();
        }

        @Override
        public InterruptibleIterator skvIterator() {
            return (InterruptibleIterator)this.nativeMap.skvIterator();
        }

        @Override
        public void delete() {
            this.nativeMap.delete();
        }

        @Override
        public long getMemoryUsed() {
            return this.nativeMap.getMemoryUsed();
        }

        @Override
        public void mutate(List<Mutation> mutations, int kvCount) {
            this.nativeMap.mutate(mutations, kvCount);
        }
    }

    private static class DefaultMap
    implements SimpleMap {
        private ConcurrentSkipListMap<Key, Value> map = new ConcurrentSkipListMap(new MemKeyComparator());
        private AtomicLong bytesInMemory = new AtomicLong();
        private AtomicInteger size = new AtomicInteger();

        private DefaultMap() {
        }

        public void put(Key key, Value value) {
            this.bytesInMemory.addAndGet(key.getLength() + 4);
            this.bytesInMemory.addAndGet(value.getSize());
            if (this.map.put(key, value) == null) {
                this.size.incrementAndGet();
            }
        }

        @Override
        public Value get(Key key) {
            return this.map.get(key);
        }

        @Override
        public Iterator<Map.Entry<Key, Value>> iterator(Key startKey) {
            Key lk = new Key(startKey);
            SortedMap tm = this.map.tailMap((Object)lk);
            return tm.entrySet().iterator();
        }

        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        public synchronized InterruptibleIterator skvIterator() {
            if (this.map == null) {
                throw new IllegalStateException();
            }
            return new SortedMapIterator(this.map);
        }

        @Override
        public synchronized void delete() {
            this.map = null;
        }

        public long getOverheadPerEntry() {
            return 200L;
        }

        @Override
        public void mutate(List<Mutation> mutations, int kvCount) {
            for (Mutation m : mutations) {
                for (ColumnUpdate cvp : m.getUpdates()) {
                    MemKey newKey = new MemKey(m.getRow(), cvp.getColumnFamily(), cvp.getColumnQualifier(), cvp.getColumnVisibility(), cvp.getTimestamp(), cvp.isDeleted(), false, kvCount++);
                    Value value = new Value(cvp.getValue());
                    this.put(newKey, value);
                }
            }
        }

        @Override
        public long getMemoryUsed() {
            return this.bytesInMemory.get() + (long)this.size() * this.getOverheadPerEntry();
        }
    }

    private static class LocalityGroupMap
    implements SimpleMap {
        private Map<ByteSequence, MutableLong>[] groupFams;
        private SimpleMap[] maps;
        private LocalityGroupUtil.Partitioner partitioner;
        private List<Mutation>[] partitioned;
        private Set<ByteSequence> nonDefaultColumnFamilies;

        LocalityGroupMap(Map<String, Set<ByteSequence>> groups, boolean useNativeMap) {
            this.groupFams = new Map[groups.size()];
            this.maps = new SimpleMap[groups.size() + 1];
            this.partitioned = new List[groups.size() + 1];
            this.nonDefaultColumnFamilies = new HashSet<ByteSequence>();
            for (int i = 0; i < this.maps.length; ++i) {
                this.maps[i] = InMemoryMap.newMap(useNativeMap);
            }
            int count = 0;
            for (Set<ByteSequence> cfset : groups.values()) {
                HashMap<ByteSequence, MutableLong> map = new HashMap<ByteSequence, MutableLong>();
                for (ByteSequence bs : cfset) {
                    map.put(bs, new MutableLong(1L));
                }
                this.groupFams[count++] = map;
                this.nonDefaultColumnFamilies.addAll(cfset);
            }
            this.partitioner = new LocalityGroupUtil.Partitioner((Map[])this.groupFams);
            for (int i = 0; i < this.partitioned.length; ++i) {
                this.partitioned[i] = new ArrayList<Mutation>();
            }
        }

        @Override
        public Value get(Key key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<Key, Value>> iterator(Key startKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            int sum = 0;
            for (SimpleMap map : this.maps) {
                sum += map.size();
            }
            return sum;
        }

        @Override
        public InterruptibleIterator skvIterator() {
            LocalityGroupIterator.LocalityGroup[] groups = new LocalityGroupIterator.LocalityGroup[this.maps.length];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = i < this.groupFams.length ? new LocalityGroupIterator.LocalityGroup(this.maps[i].skvIterator(), this.groupFams[i], false) : new LocalityGroupIterator.LocalityGroup(this.maps[i].skvIterator(), null, true);
            }
            return new LocalityGroupIterator(groups, this.nonDefaultColumnFamilies);
        }

        @Override
        public void delete() {
            for (SimpleMap map : this.maps) {
                map.delete();
            }
        }

        @Override
        public long getMemoryUsed() {
            long sum = 0L;
            for (SimpleMap map : this.maps) {
                sum += map.getMemoryUsed();
            }
            return sum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void mutate(List<Mutation> mutations, int kvCount) {
            try {
                this.partitioner.partition(mutations, (List[])this.partitioned);
                for (int i = 0; i < this.partitioned.length; ++i) {
                    if (this.partitioned[i].size() <= 0) continue;
                    this.maps[i].mutate(this.partitioned[i], kvCount);
                    for (Mutation m : this.partitioned[i]) {
                        kvCount += m.getUpdates().size();
                    }
                }
            }
            finally {
                for (List<Mutation> list : this.partitioned) {
                    list.clear();
                }
            }
        }
    }

    private static interface SimpleMap {
        public Value get(Key var1);

        public Iterator<Map.Entry<Key, Value>> iterator(Key var1);

        public int size();

        public InterruptibleIterator skvIterator();

        public void delete();

        public long getMemoryUsed();

        public void mutate(List<Mutation> var1, int var2);
    }
}

