/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.data.Key;

class MemKey
extends Key {
    int kvCount;

    public MemKey(byte[] row, byte[] cf, byte[] cq, byte[] cv, long ts, boolean del, boolean copy, int mc) {
        super(row, cf, cq, cv, ts, del, copy);
        this.kvCount = mc;
    }

    public MemKey() {
        this.kvCount = Integer.MAX_VALUE;
    }

    public MemKey(Key key, int mc) {
        super(key);
        this.kvCount = mc;
    }

    public String toString() {
        return super.toString() + " mc=" + this.kvCount;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.kvCount);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.kvCount = in.readInt();
    }

    public int compareTo(Key k) {
        int cmp = super.compareTo(k);
        if (cmp == 0 && k instanceof MemKey) {
            cmp = ((MemKey)k).kvCount - this.kvCount;
        }
        return cmp;
    }
}

