/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.tserver.MemKey;
import org.apache.accumulo.tserver.MemValue;

class MemKeyConversionIterator
extends WrappingIterator
implements InterruptibleIterator {
    MemKey currKey = null;
    Value currVal = null;

    public MemKeyConversionIterator(SortedKeyValueIterator<Key, Value> source) {
        this.setSource(source);
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new MemKeyConversionIterator((SortedKeyValueIterator<Key, Value>)this.getSource().deepCopy(env));
    }

    public Key getTopKey() {
        return this.currKey;
    }

    public Value getTopValue() {
        return this.currVal;
    }

    private void getTopKeyVal() {
        Key k = super.getTopKey();
        Value v = super.getTopValue();
        if (k instanceof MemKey || k == null) {
            this.currKey = (MemKey)k;
            this.currVal = v;
            return;
        }
        this.currVal = new Value(v);
        int mc = MemValue.splitKVCount(this.currVal);
        this.currKey = new MemKey(k, mc);
    }

    public void next() throws IOException {
        super.next();
        if (this.hasTop()) {
            this.getTopKeyVal();
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Key k;
        super.seek(range, columnFamilies, inclusive);
        if (this.hasTop()) {
            this.getTopKeyVal();
        }
        if ((k = range.getStartKey()) instanceof MemKey && this.hasTop()) {
            while (this.hasTop() && this.currKey.compareTo(k) < 0) {
                this.next();
            }
        }
    }

    public void setInterruptFlag(AtomicBoolean flag) {
        ((InterruptibleIterator)this.getSource()).setInterruptFlag(flag);
    }
}

