/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.tserver.CompactionStats;
import org.apache.accumulo.tserver.Compactor;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.Tablet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class MinorCompactor
extends Compactor {
    private static final Logger log = Logger.getLogger(MinorCompactor.class);
    private static final Map<FileRef, DataFileValue> EMPTY_MAP = Collections.emptyMap();

    private static Map<FileRef, DataFileValue> toFileMap(FileRef mergeFile, DataFileValue dfv) {
        if (mergeFile == null) {
            return EMPTY_MAP;
        }
        return Collections.singletonMap(mergeFile, dfv);
    }

    MinorCompactor(Configuration conf, VolumeManager fs, InMemoryMap imm, FileRef mergeFile, DataFileValue dfv, FileRef outputFile, TableConfiguration acuTableConf, KeyExtent extent, Tablet.MinorCompactionReason mincReason) {
        super(conf, fs, MinorCompactor.toFileMap(mergeFile, dfv), imm, outputFile, true, (AccumuloConfiguration)acuTableConf, extent, new Compactor.CompactionEnv(){

            @Override
            public boolean isCompactionEnabled() {
                return true;
            }

            @Override
            public IteratorUtil.IteratorScope getIteratorScope() {
                return IteratorUtil.IteratorScope.minc;
            }
        });
        this.mincReason = mincReason;
    }

    private boolean isTableDeleting() {
        try {
            return Tables.getTableState((Instance)HdfsZooInstance.getInstance(), (String)this.extent.getTableId().toString()) == TableState.DELETING;
        }
        catch (Exception e) {
            log.warn((Object)("Failed to determine if table " + this.extent.getTableId() + " was deleting "), (Throwable)e);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompactionStats call() {
        MinorCompactor.log.debug((Object)("Begin minor compaction " + this.getOutputFile() + " " + this.getExtent()));
        sleepTime = 100;
        growthFactor = 4.0;
        maxSleepTime = 180000;
        reportedProblem = false;
        MinorCompactor.runningCompactions.add(this);
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                ret = super.call();
                if (reportedProblem) {
                    ProblemReports.getInstance().deleteProblemReport(this.getExtent().getTableId().toString(), ProblemType.FILE_WRITE, this.getOutputFile());
                }
                var7_10 = ret;
                return var7_10;
            }
        }
        catch (IOException e) {
            MinorCompactor.log.warn((Object)("MinC failed (" + e.getMessage() + ") to create " + this.getOutputFile() + " retrying ..."));
            ProblemReports.getInstance().report(new ProblemReport(this.getExtent().getTableId().toString(), ProblemType.FILE_WRITE, this.getOutputFile(), (Throwable)e));
            reportedProblem = true;
        }
        catch (RuntimeException e) {
            MinorCompactor.log.warn((Object)("MinC failed (" + e.getMessage() + ") to create " + this.getOutputFile() + " retrying ..."), (Throwable)e);
            ProblemReports.getInstance().report(new ProblemReport(this.getExtent().getTableId().toString(), ProblemType.FILE_WRITE, this.getOutputFile(), (Throwable)e));
            reportedProblem = true;
        }
        catch (Compactor.CompactionCanceledException e) {
            throw new IllegalStateException(e);
        }
        {
            random = new Random();
            sleep = sleepTime + random.nextInt(sleepTime);
            MinorCompactor.log.debug((Object)("MinC failed sleeping " + sleep + " ms before retrying"));
            UtilWaitThread.sleep((long)sleep);
            sleepTime = (int)Math.round(Math.min((double)maxSleepTime, (double)sleepTime * growthFactor));
            try {
                if (this.getFileSystem().exists(new Path(this.getOutputFile()))) {
                    this.getFileSystem().deleteRecursively(new Path(this.getOutputFile()));
                }
            }
            catch (IOException e) {
                MinorCompactor.log.warn((Object)("Failed to delete failed MinC file " + this.getOutputFile() + " " + e.getMessage()));
            }
            if (!this.isTableDeleting()) ** GOTO lbl-1000
            var8_12 = new CompactionStats(0L, 0L);
        }
        return var8_12;
lbl-1000:
        // 1 sources

        {
            ** continue;
        }
        finally {
            this.thread = null;
            MinorCompactor.runningCompactions.remove(this);
        }
    }
}

