/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

public class Rate {
    private long lastCounter = -1L;
    private long lastTime = -1L;
    private double current = 0.0;
    final double ratio;

    public Rate(double ratio) {
        if (ratio <= 0.0 || ratio >= 1.0) {
            throw new IllegalArgumentException("ratio must be > 0. and < 1.0");
        }
        this.ratio = ratio;
    }

    public double update(long counter) {
        return this.update(System.currentTimeMillis(), counter);
    }

    public synchronized double update(long when, long counter) {
        if (this.lastCounter < 0L) {
            this.lastTime = when;
            this.lastCounter = counter;
            return this.current;
        }
        if (this.lastTime == when) {
            throw new IllegalArgumentException("update time < last value");
        }
        double keep = 1.0 - this.ratio;
        this.current = keep * this.current + this.ratio * (double)(counter - this.lastCounter) * 1000.0 / (double)(when - this.lastTime);
        this.lastTime = when;
        this.lastCounter = counter;
        return this.current;
    }

    public synchronized double rate() {
        return this.current;
    }
}

