/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.Tablet;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class RootFiles {
    private static Logger log = Logger.getLogger(RootFiles.class);

    static void prepareReplacement(VolumeManager fs, Path location, Set<FileRef> oldDatafiles, String compactName) throws IOException {
        for (FileRef ref : oldDatafiles) {
            Path path = ref.path();
            Tablet.rename(fs, path, new Path(location + "/delete+" + compactName + "+" + path.getName()));
        }
    }

    static void renameReplacement(VolumeManager fs, FileRef tmpDatafile, FileRef newDatafile) throws IOException {
        if (fs.exists(newDatafile.path())) {
            log.error((Object)("Target map file already exist " + newDatafile), (Throwable)new Exception());
            throw new IllegalStateException("Target map file already exist " + newDatafile);
        }
        Tablet.rename(fs, tmpDatafile.path(), newDatafile.path());
    }

    static void finishReplacement(AccumuloConfiguration acuTableConf, VolumeManager fs, Path location, Set<FileRef> oldDatafiles, String compactName) throws IOException {
        for (FileRef ref : oldDatafiles) {
            Path path = ref.path();
            Path deleteFile = new Path(location + "/delete+" + compactName + "+" + path.getName());
            if (!acuTableConf.getBoolean(Property.GC_TRASH_IGNORE) && fs.moveToTrash(deleteFile)) continue;
            fs.deleteRecursively(deleteFile);
        }
    }

    public static void replaceFiles(AccumuloConfiguration acuTableConf, VolumeManager fs, Path location, Set<FileRef> oldDatafiles, FileRef tmpDatafile, FileRef newDatafile) throws IOException {
        String compactName = newDatafile.path().getName();
        RootFiles.prepareReplacement(fs, location, oldDatafiles, compactName);
        RootFiles.renameReplacement(fs, tmpDatafile, newDatafile);
        RootFiles.finishReplacement(acuTableConf, fs, location, oldDatafiles, compactName);
    }

    public static Collection<String> cleanupReplacement(VolumeManager fs, FileStatus[] files, boolean deleteTmp) throws IOException {
        ArrayList<String> goodFiles = new ArrayList<String>(files.length);
        for (FileStatus file : files) {
            String path = file.getPath().toString();
            if (file.getPath().toUri().getScheme() == null) {
                throw new IllegalArgumentException("Require fully qualified paths " + file.getPath());
            }
            String filename = file.getPath().getName();
            if (filename.startsWith("delete+")) {
                String expectedCompactedFile = path.substring(0, path.lastIndexOf("/delete+")) + "/" + filename.split("\\+")[1];
                if (fs.exists(new Path(expectedCompactedFile))) {
                    if (fs.deleteRecursively(file.getPath())) continue;
                    log.warn((Object)("Delete of file: " + file.getPath().toString() + " return false"));
                    continue;
                }
                filename = filename.split("\\+", 3)[2];
                path = path.substring(0, path.lastIndexOf("/delete+")) + "/" + filename;
                Tablet.rename(fs, file.getPath(), new Path(path));
            }
            if (filename.endsWith("_tmp")) {
                if (!deleteTmp) continue;
                log.warn((Object)("cleaning up old tmp file: " + path));
                if (fs.deleteRecursively(file.getPath())) continue;
                log.warn((Object)("Delete of tmp file: " + file.getPath().toString() + " return false"));
                continue;
            }
            if (!filename.startsWith("map_") && !FileOperations.getValidExtensions().contains(filename.split("\\.")[1])) {
                log.error((Object)("unknown file in tablet" + path));
                continue;
            }
            goodFiles.add(path);
        }
        return goodFiles;
    }
}

