/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.tserver.ConditionalMutationSet;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;

class RowLocks {
    private Map<ByteSequence, RowLock> rowLocks = new HashMap<ByteSequence, RowLock>();

    RowLocks() {
    }

    private RowLock getRowLock(ArrayByteSequence rowSeq) {
        RowLock lock = this.rowLocks.get(rowSeq);
        if (lock == null) {
            lock = new RowLock(new ReentrantLock(), (ByteSequence)rowSeq);
            this.rowLocks.put((ByteSequence)rowSeq, lock);
        }
        ++lock.count;
        return lock;
    }

    private void returnRowLock(RowLock lock) {
        if (lock.count == 0) {
            throw new IllegalStateException();
        }
        --lock.count;
        if (lock.count == 0) {
            this.rowLocks.remove(lock.rowSeq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RowLock> acquireRowlocks(Map<KeyExtent, List<ServerConditionalMutation>> updates, Map<KeyExtent, List<ServerConditionalMutation>> deferred) {
        ArrayList<RowLock> locks = new ArrayList<RowLock>();
        Map<ByteSequence, RowLock> map = this.rowLocks;
        synchronized (map) {
            for (List<ServerConditionalMutation> scml : updates.values()) {
                for (ServerConditionalMutation scm : scml) {
                    locks.add(this.getRowLock(new ArrayByteSequence(scm.getRow())));
                }
            }
        }
        HashSet<ByteSequence> rowsNotLocked = null;
        if (locks.size() > 1) {
            for (RowLock rowLock : locks) {
                if (rowLock.tryLock()) continue;
                if (rowsNotLocked == null) {
                    rowsNotLocked = new HashSet<ByteSequence>();
                }
                rowsNotLocked.add(rowLock.rowSeq);
            }
        } else {
            ((RowLock)locks.get(0)).lock();
        }
        if (rowsNotLocked != null) {
            final HashSet<ByteSequence> rnlf = rowsNotLocked;
            ConditionalMutationSet.defer(updates, deferred, new ConditionalMutationSet.DeferFilter(){

                @Override
                public void defer(List<ServerConditionalMutation> scml, List<ServerConditionalMutation> okMutations, List<ServerConditionalMutation> deferred) {
                    for (ServerConditionalMutation scm : scml) {
                        if (rnlf.contains(new ArrayByteSequence(scm.getRow()))) {
                            deferred.add(scm);
                            continue;
                        }
                        okMutations.add(scm);
                    }
                }
            });
            ArrayList<RowLock> filteredLocks = new ArrayList<RowLock>();
            ArrayList<RowLock> locksToReturn = new ArrayList<RowLock>();
            for (RowLock rowLock : locks) {
                if (rowsNotLocked.contains(rowLock.rowSeq)) {
                    locksToReturn.add(rowLock);
                    continue;
                }
                filteredLocks.add(rowLock);
            }
            Map<ByteSequence, RowLock> map2 = this.rowLocks;
            synchronized (map2) {
                for (RowLock rowLock : locksToReturn) {
                    this.returnRowLock(rowLock);
                }
            }
            locks = filteredLocks;
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRowLocks(List<RowLock> locks) {
        for (RowLock rowLock : locks) {
            rowLock.unlock();
        }
        Map<ByteSequence, RowLock> map = this.rowLocks;
        synchronized (map) {
            for (RowLock rowLock : locks) {
                this.returnRowLock(rowLock);
            }
        }
    }

    static class RowLock {
        ReentrantLock rlock;
        int count;
        ByteSequence rowSeq;

        RowLock(ReentrantLock rlock, ByteSequence rowSeq) {
            this.rlock = rlock;
            this.count = 0;
            this.rowSeq = rowSeq;
        }

        public boolean tryLock() {
            return this.rlock.tryLock();
        }

        public void lock() {
            this.rlock.lock();
        }

        public void unlock() {
            this.rlock.unlock();
        }
    }
}

