/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.ColumnQualifierFilter;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.iterators.system.StatsIterator;
import org.apache.accumulo.core.iterators.system.VisibilityFilter;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.tableOps.CompactionIterators;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.tablets.TabletTime;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.TabletOperations;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.tserver.CompactionStats;
import org.apache.accumulo.tserver.Compactor;
import org.apache.accumulo.tserver.FileManager;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MinorCompactor;
import org.apache.accumulo.tserver.Rate;
import org.apache.accumulo.tserver.RootFiles;
import org.apache.accumulo.tserver.TLevel;
import org.apache.accumulo.tserver.TabletIteratorEnvironment;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.apache.accumulo.tserver.constraints.ConstraintChecker;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.mastermessage.TabletStatusMessage;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.zookeeper.KeeperException;

public class Tablet {
    private TabletMemory tabletMemory;
    private final TabletTime tabletTime;
    private long persistedTime;
    private final Object timeLock = new Object();
    private final Path location;
    private TServerInstance lastLocation;
    private Configuration conf;
    private VolumeManager fs;
    private TableConfiguration acuTableConf;
    private volatile boolean tableDirChecked = false;
    private AtomicLong dataSourceDeletions = new AtomicLong(0L);
    private Set<ScanDataSource> activeScans = new HashSet<ScanDataSource>();
    private volatile boolean closing = false;
    private boolean closed = false;
    private boolean closeComplete = false;
    private long lastFlushID = -1L;
    private long lastCompactID = -1L;
    private KeyExtent extent;
    private TabletServerResourceManager.TabletResourceManager tabletResources;
    private final DatafileManager datafileManager;
    private volatile boolean majorCompactionInProgress = false;
    private volatile boolean majorCompactionWaitingToStart = false;
    private Set<MajorCompactionReason> majorCompactionQueued = Collections.synchronizedSet(EnumSet.noneOf(MajorCompactionReason.class));
    private volatile boolean minorCompactionInProgress = false;
    private volatile boolean minorCompactionWaitingToStart = false;
    private boolean updatingFlushID = false;
    private AtomicReference<ConstraintChecker> constraintChecker = new AtomicReference();
    private final String tabletDirectory;
    private int writesInProgress = 0;
    private static final Logger log = Logger.getLogger(Tablet.class);
    public TabletStatsKeeper timer;
    private Rate queryRate = new Rate(0.2);
    private long queryCount = 0L;
    private Rate queryByteRate = new Rate(0.2);
    private long queryBytes = 0L;
    private Rate ingestRate = new Rate(0.2);
    private long ingestCount = 0L;
    private Rate ingestByteRate = new Rate(0.2);
    private long ingestBytes = 0L;
    private byte[] defaultSecurityLabel = new byte[0];
    private long lastMinorCompactionFinishTime;
    private long lastMapFileImportTime;
    private volatile long numEntries;
    private volatile long numEntriesInMemory;
    private AtomicLong scannedCount = new AtomicLong(0L);
    private Rate scannedRate = new Rate(0.2);
    private ConfigurationObserver configObserver;
    private TabletServer tabletServer;
    private final int logId;
    public final Object bulkFileImportLock = new Object();
    private static final List<LogEntry> EMPTY = Collections.emptyList();
    private boolean closeCompleting = false;
    private boolean sawBigRow = false;
    private long timeOfLastMinCWhenBigFreakinRowWasSeen = 0L;
    private long timeOfLastImportWhenBigFreakinRowWasSeen = 0L;
    private long splitCreationTime;
    private Set<DfsLogger> currentLogs = new HashSet<DfsLogger>();
    private Set<DfsLogger> otherLogs = Collections.emptySet();
    private boolean removingLogs = false;
    private final ReentrantLock logLock = new ReentrantLock();

    public int getLogId() {
        return this.logId;
    }

    FileRef getNextMapFilename(String prefix) throws IOException {
        String extension = FileOperations.getNewFileExtension((AccumuloConfiguration)this.tabletServer.getTableConfiguration(this.extent));
        this.checkTabletDir();
        return new FileRef(this.location.toString() + "/" + prefix + UniqueNameAllocator.getInstance().getNextName() + "." + extension);
    }

    private void checkTabletDir() throws IOException {
        if (!this.tableDirChecked) {
            this.checkTabletDir(this.location);
            this.tableDirChecked = true;
        }
    }

    private void checkTabletDir(Path tabletDir) throws IOException {
        FileStatus[] files = null;
        try {
            files = this.fs.listStatus(tabletDir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (files == null) {
            if (tabletDir.getName().startsWith("c-")) {
                log.debug((Object)("Tablet " + this.extent + " had no dir, creating " + tabletDir));
            } else {
                log.warn((Object)("Tablet " + this.extent + " had no dir, creating " + tabletDir));
            }
            this.fs.mkdirs(tabletDir);
        }
    }

    public Tablet(TabletServer tabletServer, Text location, KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, SortedMap<Key, Value> tabletsKeyValues) throws IOException {
        this(tabletServer, location, extent, trm, CachedConfiguration.getInstance(), tabletsKeyValues);
        this.splitCreationTime = 0L;
    }

    public Tablet(KeyExtent extent, TabletServer tabletServer, TabletServerResourceManager.TabletResourceManager trm, SplitInfo info) throws IOException {
        this(tabletServer, new Text(info.dir), extent, trm, CachedConfiguration.getInstance(), info.datafiles, info.time, info.initFlushID, info.initCompactID, info.lastLocation);
        this.splitCreationTime = System.currentTimeMillis();
    }

    private Tablet(TabletServer tabletServer, Text location, KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, Configuration conf, SortedMap<Key, Value> tabletsKeyValues) throws IOException {
        this(tabletServer, location, extent, trm, conf, VolumeManagerImpl.get(), tabletsKeyValues);
    }

    private Tablet(TabletServer tabletServer, Text location, KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, Configuration conf, SortedMap<FileRef, DataFileValue> datafiles, String time, long initFlushID, long initCompactID, TServerInstance last) throws IOException {
        this(tabletServer, location, extent, trm, conf, VolumeManagerImpl.get(), EMPTY, datafiles, time, last, new HashSet<FileRef>(), initFlushID, initCompactID);
    }

    private static String lookupTime(AccumuloConfiguration conf, KeyExtent extent, SortedMap<Key, Value> tabletsKeyValues) {
        if (extent.isRootTablet()) {
            return null;
        }
        TreeMap<Key, Value> entries = new TreeMap<Key, Value>();
        Text rowName = extent.getMetadataEntry();
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            if (entry.getKey().compareRow(rowName) != 0 || !MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(entry.getKey())) continue;
            entries.put(new Key(entry.getKey()), new Value(entry.getValue()));
        }
        if (entries.size() == 1) {
            return ((Value)entries.values().iterator().next()).toString();
        }
        return null;
    }

    private static SortedMap<FileRef, DataFileValue> lookupDatafiles(AccumuloConfiguration conf, VolumeManager fs, KeyExtent extent, SortedMap<Key, Value> tabletsKeyValues) throws IOException {
        TreeMap<FileRef, DataFileValue> datafiles = new TreeMap<FileRef, DataFileValue>();
        if (extent.isRootTablet()) {
            Path location = new Path(MetadataTableUtil.getRootTabletDir());
            FileStatus[] files = fs.listStatus(location);
            Collection<String> goodPaths = RootFiles.cleanupReplacement(fs, files, true);
            for (String good : goodPaths) {
                Path path = new Path(good);
                String filename = path.getName();
                FileRef ref = new FileRef(location.toString() + "/" + filename, path);
                DataFileValue dfv = new DataFileValue(0L, 0L);
                datafiles.put(ref, dfv);
            }
        } else {
            Map.Entry entry;
            Text rowName = extent.getMetadataEntry();
            String tableId = extent.isMeta() ? "+r" : "!0";
            ScannerImpl mdScanner = new ScannerImpl(HdfsZooInstance.getInstance(), (Credentials)SystemCredentials.get(), tableId, Authorizations.EMPTY);
            mdScanner.setBatchSize(1000);
            mdScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            mdScanner.setRange(new Range(rowName));
            Iterator i$ = mdScanner.iterator();
            while (i$.hasNext() && ((Key)(entry = (Map.Entry)i$.next()).getKey()).compareRow(rowName) == 0) {
                FileRef ref = new FileRef(fs, (Key)entry.getKey());
                datafiles.put(ref, new DataFileValue(((Value)entry.getValue()).get()));
            }
        }
        return datafiles;
    }

    private static List<LogEntry> lookupLogEntries(KeyExtent ke, SortedMap<Key, Value> tabletsKeyValues) {
        ArrayList<LogEntry> logEntries = new ArrayList();
        if (ke.isMeta()) {
            try {
                logEntries = MetadataTableUtil.getLogEntries((Credentials)SystemCredentials.get(), (KeyExtent)ke);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to read tablet log entries", ex);
            }
        } else {
            log.debug((Object)("Looking at metadata " + tabletsKeyValues));
            Text row = ke.getMetadataEntry();
            for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
                Key key = entry.getKey();
                if (!key.getRow().equals((Object)row) || !key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LogColumnFamily.NAME)) continue;
                logEntries.add(LogEntry.fromKeyValue((Key)key, (Value)entry.getValue()));
            }
        }
        log.debug((Object)("got " + logEntries + " for logs for " + ke));
        return logEntries;
    }

    private static Set<FileRef> lookupScanFiles(KeyExtent extent, SortedMap<Key, Value> tabletsKeyValues, VolumeManager fs) throws IOException {
        HashSet<FileRef> scanFiles = new HashSet<FileRef>();
        Text row = extent.getMetadataEntry();
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            Key key = entry.getKey();
            if (!key.getRow().equals((Object)row) || !key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME)) continue;
            scanFiles.add(new FileRef(fs, key));
        }
        return scanFiles;
    }

    private static long lookupFlushID(KeyExtent extent, SortedMap<Key, Value> tabletsKeyValues) {
        Text row = extent.getMetadataEntry();
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            Key key = entry.getKey();
            if (!key.getRow().equals((Object)row) || !MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.equals(key.getColumnFamily(), key.getColumnQualifier())) continue;
            return Long.parseLong(entry.getValue().toString());
        }
        return -1L;
    }

    private static long lookupCompactID(KeyExtent extent, SortedMap<Key, Value> tabletsKeyValues) {
        Text row = extent.getMetadataEntry();
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            Key key = entry.getKey();
            if (!key.getRow().equals((Object)row) || !MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.equals(key.getColumnFamily(), key.getColumnQualifier())) continue;
            return Long.parseLong(entry.getValue().toString());
        }
        return -1L;
    }

    private Tablet(TabletServer tabletServer, Text location, KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, Configuration conf, VolumeManager fs, SortedMap<Key, Value> tabletsKeyValues) throws IOException {
        this(tabletServer, location, extent, trm, conf, fs, Tablet.lookupLogEntries(extent, tabletsKeyValues), Tablet.lookupDatafiles(tabletServer.getSystemConfiguration(), fs, extent, tabletsKeyValues), Tablet.lookupTime(tabletServer.getSystemConfiguration(), extent, tabletsKeyValues), Tablet.lookupLastServer(extent, tabletsKeyValues), Tablet.lookupScanFiles(extent, tabletsKeyValues, fs), Tablet.lookupFlushID(extent, tabletsKeyValues), Tablet.lookupCompactID(extent, tabletsKeyValues));
    }

    private static TServerInstance lookupLastServer(KeyExtent extent, SortedMap<Key, Value> tabletsKeyValues) {
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            if (entry.getKey().getColumnFamily().compareTo((BinaryComparable)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME) != 0) continue;
            return new TServerInstance(entry.getValue(), entry.getKey().getColumnQualifier());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tablet(TabletServer tabletServer, Text location, final KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, Configuration conf, VolumeManager fs, List<LogEntry> rawLogEntries, SortedMap<FileRef, DataFileValue> rawDatafiles, String time, TServerInstance lastLocation, Set<FileRef> scanFiles, long initFlushID, long initCompactID) throws IOException {
        String contextName;
        VolumeUtil.TabletFiles tabletPaths = VolumeUtil.updateTabletVolumes((ZooLock)tabletServer.getLock(), (VolumeManager)fs, (KeyExtent)extent, (VolumeUtil.TabletFiles)new VolumeUtil.TabletFiles(location.toString(), rawLogEntries, rawDatafiles));
        Path locationPath = tabletPaths.dir.contains(":") ? new Path(tabletPaths.dir.toString()) : fs.getFullPath(VolumeManager.FileType.TABLE, extent.getTableId().toString() + tabletPaths.dir.toString());
        List logEntries = tabletPaths.logEntries;
        SortedMap datafiles = tabletPaths.datafiles;
        this.location = locationPath;
        this.lastLocation = lastLocation;
        this.tabletDirectory = tabletPaths.dir;
        this.conf = conf;
        this.acuTableConf = tabletServer.getTableConfiguration(extent);
        this.fs = fs;
        this.extent = extent;
        this.tabletResources = trm;
        this.lastFlushID = initFlushID;
        this.lastCompactID = initCompactID;
        if (extent.isRootTablet()) {
            long rtime = Long.MIN_VALUE;
            for (FileRef ref : datafiles.keySet()) {
                Path path = ref.path();
                FileSystem ns = fs.getVolumeByPath(path).getFileSystem();
                FileSKVIterator reader = FileOperations.getInstance().openReader(path.toString(), true, ns, ns.getConf(), (AccumuloConfiguration)tabletServer.getTableConfiguration(extent));
                long maxTime = -1L;
                try {
                    while (reader.hasTop()) {
                        maxTime = Math.max(maxTime, ((Key)reader.getTopKey()).getTimestamp());
                        reader.next();
                    }
                }
                finally {
                    reader.close();
                }
                if (maxTime <= rtime) continue;
                time = "L" + maxTime;
                rtime = maxTime;
            }
        }
        if (time == null && datafiles.isEmpty() && extent.equals((Object)RootTable.OLD_EXTENT)) {
            time = "L-9223372036854775808";
        }
        this.tabletServer = tabletServer;
        this.logId = tabletServer.createLogId(extent);
        this.timer = new TabletStatsKeeper();
        this.setupDefaultSecurityLabels(extent);
        this.tabletMemory = new TabletMemory();
        this.tabletTime = TabletTime.getInstance((String)time);
        this.persistedTime = this.tabletTime.getTime();
        this.configObserver = new ConfigurationObserver(){

            private void reloadConstraints() {
                Tablet.this.constraintChecker.set(new ConstraintChecker(Tablet.this.acuTableConf));
            }

            public void propertiesChanged() {
                this.reloadConstraints();
                try {
                    Tablet.this.setupDefaultSecurityLabels(extent);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to reload default security labels for extent: " + extent.toString()));
                }
            }

            public void propertyChanged(String prop) {
                if (prop.startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey())) {
                    this.reloadConstraints();
                } else if (prop.equals(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey())) {
                    try {
                        log.info((Object)("Default security labels changed for extent: " + extent.toString()));
                        Tablet.this.setupDefaultSecurityLabels(extent);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to reload default security labels for extent: " + extent.toString()));
                    }
                }
            }

            public void sessionExpired() {
                log.debug((Object)"Session expired, no longer updating per table props...");
            }
        };
        this.acuTableConf.addObserver(this.configObserver);
        this.acuTableConf.getNamespaceConfiguration().addObserver(this.configObserver);
        this.configObserver.propertiesChanged();
        this.tabletResources.setTablet(this, (AccumuloConfiguration)this.acuTableConf);
        if (!logEntries.isEmpty()) {
            log.info((Object)("Starting Write-Ahead Log recovery for " + this.extent));
            final long[] count = new long[2];
            final CommitSession commitSession = this.tabletMemory.getCommitSession();
            count[1] = Long.MIN_VALUE;
            try {
                HashSet<String> absPaths = new HashSet<String>();
                for (FileRef ref : datafiles.keySet()) {
                    absPaths.add(ref.path().toString());
                }
                tabletServer.recover(this.tabletServer.getFileSystem(), this, logEntries, absPaths, new MutationReceiver(){

                    @Override
                    public void receive(Mutation m) {
                        List muts = m.getUpdates();
                        for (ColumnUpdate columnUpdate : muts) {
                            if (columnUpdate.hasTimestamp()) continue;
                            count[1] = Math.max(count[1], columnUpdate.getTimestamp());
                        }
                        Tablet.this.tabletMemory.mutate(commitSession, Collections.singletonList(m));
                        count[0] = count[0] + 1L;
                    }
                });
                if (count[1] != Long.MIN_VALUE) {
                    this.tabletTime.useMaxTimeFromWALog(count[1]);
                }
                commitSession.updateMaxCommittedTime(this.tabletTime.getTime());
                if (count[0] == 0L) {
                    MetadataTableUtil.removeUnusedWALEntries((KeyExtent)extent, (List)logEntries, (ZooLock)tabletServer.getLock());
                    logEntries.clear();
                }
            }
            catch (Throwable t) {
                if (this.acuTableConf.getBoolean(Property.TABLE_FAILURES_IGNORE)) {
                    log.warn((Object)"Error recovering from log files: ", t);
                }
                throw new RuntimeException(t);
            }
            this.currentLogs = new HashSet<DfsLogger>();
            for (LogEntry logEntry : logEntries) {
                for (String log : logEntry.logSet) {
                    this.currentLogs.add(new DfsLogger(tabletServer.getServerConfig(), log));
                }
            }
            log.info((Object)("Write-Ahead Log recovery complete for " + this.extent + " (" + count[0] + " mutations applied, " + this.tabletMemory.getNumEntries() + " entries created)"));
        }
        if ((contextName = this.acuTableConf.get(Property.TABLE_CLASSPATH)) != null && !contextName.equals("")) {
            AccumuloVFSClassLoader.getContextManager().getClassLoader(contextName);
        }
        this.datafileManager = new DatafileManager(datafiles);
        this.computeNumEntries();
        this.datafileManager.removeFilesAfterScan(scanFiles);
        if (!logEntries.isEmpty() || this.needsMajorCompaction(MajorCompactionReason.NORMAL)) {
            this.removeOldTemporaryFiles();
        }
        log.log((Priority)TLevel.TABLET_HIST, (Object)(extent + " opened"));
    }

    private void removeOldTemporaryFiles() {
        try {
            for (FileStatus tmp : this.fs.globStatus(new Path(this.location, "*_tmp"))) {
                try {
                    log.debug((Object)("Removing old temp file " + tmp.getPath()));
                    this.fs.delete(tmp.getPath());
                }
                catch (IOException ex) {
                    log.error((Object)("Unable to remove old temp file " + tmp.getPath() + ": " + ex));
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error scanning for old temp files in " + this.location));
        }
    }

    private void setupDefaultSecurityLabels(KeyExtent extent) {
        if (extent.isMeta()) {
            this.defaultSecurityLabel = new byte[0];
        } else {
            try {
                ColumnVisibility cv = new ColumnVisibility(this.acuTableConf.get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY));
                this.defaultSecurityLabel = cv.getExpression();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.defaultSecurityLabel = new byte[0];
            }
        }
    }

    private LookupResult lookup(SortedKeyValueIterator<Key, Value> mmfi, List<Range> ranges, HashSet<Column> columnSet, ArrayList<KVEntry> results, long maxResultsSize) throws IOException {
        LookupResult lookupResult = new LookupResult();
        boolean exceededMemoryUsage = false;
        boolean tabletClosed = false;
        Set cfset = null;
        if (columnSet.size() > 0) {
            cfset = LocalityGroupUtil.families(columnSet);
        }
        block5: for (Range range : ranges) {
            if (exceededMemoryUsage || tabletClosed) {
                lookupResult.unfinishedRanges.add(range);
                continue;
            }
            int entriesAdded = 0;
            try {
                if (cfset != null) {
                    mmfi.seek(range, (Collection)cfset, true);
                } else {
                    mmfi.seek(range, (Collection)LocalityGroupUtil.EMPTY_CF_SET, false);
                }
                while (mmfi.hasTop()) {
                    Key key = (Key)mmfi.getTopKey();
                    KVEntry kve = new KVEntry(key, (Value)mmfi.getTopValue());
                    results.add(kve);
                    ++entriesAdded;
                    lookupResult.bytesAdded += (long)kve.estimateMemoryUsed();
                    lookupResult.dataSize += (long)kve.numBytes();
                    boolean bl = exceededMemoryUsage = lookupResult.bytesAdded > maxResultsSize;
                    if (exceededMemoryUsage) {
                        this.addUnfinishedRange(lookupResult, range, key, false);
                        continue block5;
                    }
                    mmfi.next();
                }
            }
            catch (TooManyFilesException tmfe) {
                log.warn((Object)("Tablet " + this.getExtent() + " has too many files, batch lookup can not run"));
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
            catch (IOException ioe) {
                if (this.shutdownInProgress()) {
                    log.debug((Object)"IOException while shutdown in progress ", (Throwable)ioe);
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw ioe;
            }
            catch (IterationInterruptedException iie) {
                if (this.isClosed()) {
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw iie;
            }
            catch (TabletClosedException tce) {
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
        }
        return lookupResult;
    }

    private void handleTabletClosedDuringScan(ArrayList<KVEntry> results, LookupResult lookupResult, boolean exceededMemoryUsage, Range range, int entriesAdded) {
        if (exceededMemoryUsage) {
            throw new IllegalStateException("tablet should not exceed memory usage or close, not both");
        }
        if (entriesAdded > 0) {
            this.addUnfinishedRange(lookupResult, range, results.get((int)(results.size() - 1)).key, false);
        } else {
            lookupResult.unfinishedRanges.add(range);
        }
        lookupResult.closed = true;
    }

    private void addUnfinishedRange(LookupResult lookupResult, Range range, Key key, boolean inclusiveStartKey) {
        if (range.getEndKey() == null || key.compareTo(range.getEndKey()) < 0) {
            Range nlur = new Range(new Key(key), inclusiveStartKey, range.getEndKey(), range.isEndKeyInclusive());
            lookupResult.unfinishedRanges.add(nlur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupResult lookup(List<Range> ranges, HashSet<Column> columns, Authorizations authorizations, ArrayList<KVEntry> results, long maxResultSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag) throws IOException {
        if (ranges.size() == 0) {
            return new LookupResult();
        }
        ranges = Range.mergeOverlapping(ranges);
        Collections.sort(ranges);
        Range tabletRange = this.extent.toDataRange();
        for (Range range : ranges) {
            tabletRange.clip(range);
        }
        ScanDataSource dataSource = new ScanDataSource(authorizations, this.defaultSecurityLabel, columns, ssiList, ssio, interruptFlag);
        LookupResult result = null;
        try {
            SourceSwitchingIterator iter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource);
            LookupResult lookupResult = result = this.lookup((SortedKeyValueIterator<Key, Value>)iter, ranges, columns, results, maxResultSize);
            return lookupResult;
        }
        catch (IOException ioe) {
            dataSource.close(true);
            throw ioe;
        }
        finally {
            dataSource.close(false);
            Tablet tablet = this;
            synchronized (tablet) {
                this.queryCount += (long)results.size();
                if (result != null) {
                    this.queryBytes += result.dataSize;
                }
            }
        }
    }

    private Batch nextBatch(SortedKeyValueIterator<Key, Value> iter, Range range, int num, Set<Column> columns) throws IOException {
        ArrayList<KVEntry> results = new ArrayList<KVEntry>();
        Key key = null;
        long resultSize = 0L;
        long resultBytes = 0L;
        long maxResultsSize = this.acuTableConf.getMemoryInBytes(Property.TABLE_SCAN_MAXMEM);
        if (columns.size() == 0) {
            iter.seek(range, (Collection)LocalityGroupUtil.EMPTY_CF_SET, false);
        } else {
            iter.seek(range, (Collection)LocalityGroupUtil.families(columns), true);
        }
        Key continueKey = null;
        boolean skipContinueKey = false;
        boolean endOfTabletReached = false;
        while (iter.hasTop()) {
            Value value = (Value)iter.getTopValue();
            key = (Key)iter.getTopKey();
            KVEntry kvEntry = new KVEntry(key, value);
            results.add(kvEntry);
            resultBytes += (long)kvEntry.numBytes();
            if ((resultSize += (long)kvEntry.estimateMemoryUsed()) >= maxResultsSize || results.size() >= num) {
                continueKey = new Key(key);
                skipContinueKey = true;
                break;
            }
            iter.next();
        }
        if (!iter.hasTop()) {
            endOfTabletReached = true;
        }
        Batch retBatch = new Batch();
        retBatch.numBytes = resultBytes;
        if (!endOfTabletReached) {
            retBatch.continueKey = continueKey;
            retBatch.skipContinueKey = skipContinueKey;
        } else {
            retBatch.continueKey = null;
        }
        retBatch.results = endOfTabletReached && results.size() == 0 ? null : results;
        return retBatch;
    }

    private boolean shutdownInProgress() {
        try {
            Runtime.getRuntime().removeShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                }
            }));
        }
        catch (IllegalStateException ise) {
            return true;
        }
        return false;
    }

    Scanner createScanner(Range range, int num, Set<Column> columns, Authorizations authorizations, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, boolean isolated, AtomicBoolean interruptFlag) {
        this.extent.toDataRange().clip(range);
        ScanOptions opts = new ScanOptions(num, authorizations, this.defaultSecurityLabel, columns, ssiList, ssio, interruptFlag, isolated);
        return new Scanner(range, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataFileValue minorCompact(Configuration conf, VolumeManager fs, InMemoryMap memTable, FileRef tmpDatafile, FileRef newDatafile, FileRef mergeFile, boolean hasQueueTime, long queued, CommitSession commitSession, long flushId, MinorCompactionReason mincReason) {
        boolean failed = false;
        long start = System.currentTimeMillis();
        this.timer.incrementStatusMinor();
        long count = 0L;
        try {
            CompactionStats stats;
            Span span = Trace.start((String)"write");
            try {
                count = memTable.getNumEntries();
                DataFileValue dfv = null;
                if (mergeFile != null) {
                    dfv = (DataFileValue)this.datafileManager.getDatafileSizes().get(mergeFile);
                }
                MinorCompactor compactor = new MinorCompactor(conf, fs, memTable, mergeFile, dfv, tmpDatafile, this.acuTableConf, this.extent, mincReason);
                stats = compactor.call();
            }
            finally {
                span.stop();
            }
            span = Trace.start((String)"bringOnline");
            try {
                this.datafileManager.bringMinorCompactionOnline(tmpDatafile, newDatafile, mergeFile, new DataFileValue(stats.getFileSize(), stats.getEntriesWritten()), commitSession, flushId);
            }
            finally {
                span.stop();
            }
            DataFileValue dataFileValue = new DataFileValue(stats.getFileSize(), stats.getEntriesWritten());
            return dataFileValue;
        }
        catch (Exception E) {
            failed = true;
            throw new RuntimeException(E);
        }
        catch (Error E) {
            failed = true;
            throw new RuntimeException(E);
        }
        finally {
            try {
                this.tabletMemory.finalizeMinC();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to free tablet memory", t);
            }
            if (!failed) {
                this.lastMinorCompactionFinishTime = System.currentTimeMillis();
            }
            if (this.tabletServer.mincMetrics.isEnabled()) {
                this.tabletServer.mincMetrics.add("minc", this.lastMinorCompactionFinishTime - start);
            }
            if (hasQueueTime) {
                this.timer.updateTime(TabletStatsKeeper.Operation.MINOR, queued, start, count, failed);
                if (this.tabletServer.mincMetrics.isEnabled()) {
                    this.tabletServer.mincMetrics.add("queue", start - queued);
                }
            } else {
                this.timer.updateTime(TabletStatsKeeper.Operation.MINOR, start, count, failed);
            }
        }
    }

    private synchronized MinorCompactionTask prepareForMinC(long flushId, MinorCompactionReason mincReason) {
        CommitSession oldCommitSession = this.tabletMemory.prepareForMinC();
        this.otherLogs = this.currentLogs;
        this.currentLogs = new HashSet<DfsLogger>();
        FileRef mergeFile = this.datafileManager.reserveMergingMinorCompactionFile();
        return new MinorCompactionTask(mergeFile, oldCommitSession, flushId, mincReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void flush(long tableFlushID) {
        Tablet tablet;
        boolean initiateMinor;
        boolean updateMetadata;
        block25: {
            updateMetadata = false;
            initiateMinor = false;
            tablet = this;
            // MONITORENTER : tablet
            if (!this.updatingFlushID) break block25;
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet2 = this;
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet2
            return;
        }
        if (this.lastFlushID >= tableFlushID) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet3 = this;
            // MONITORENTER : tablet3
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet3
            return;
        }
        if (this.closing || this.closed || this.tabletMemory.memoryReservedForMinC()) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet4 = this;
            // MONITORENTER : tablet4
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet4
            return;
        }
        try {
            if (this.tabletMemory.getMemTable().getNumEntries() == 0L) {
                this.lastFlushID = tableFlushID;
                this.updatingFlushID = true;
                updateMetadata = true;
            } else {
                initiateMinor = true;
            }
            // MONITOREXIT : tablet
            if (updateMetadata) {
                SystemCredentials creds = SystemCredentials.get();
                MetadataTableUtil.updateTabletFlushID((KeyExtent)this.extent, (long)tableFlushID, (Credentials)creds, (ZooLock)this.tabletServer.getLock());
                return;
            }
            if (!initiateMinor) return;
            this.initiateMinorCompaction(tableFlushID, MinorCompactionReason.USER);
            return;
        }
        finally {
            if (updateMetadata) {
                tablet = this;
            }
        }
    }

    boolean initiateMinorCompaction(MinorCompactionReason mincReason) {
        long flushId;
        if (this.isClosed()) {
            return false;
        }
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info((Object)("Asked to initiate MinC when there was no flush id " + this.getExtent() + " " + e.getMessage()));
            return false;
        }
        return this.initiateMinorCompaction(flushId, mincReason);
    }

    boolean minorCompactNow(MinorCompactionReason mincReason) {
        long flushId;
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info((Object)("Asked to initiate MinC when there was no flush id " + this.getExtent() + " " + e.getMessage()));
            return false;
        }
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        mct.run();
        return true;
    }

    boolean initiateMinorCompaction(long flushId, MinorCompactionReason mincReason) {
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        this.tabletResources.executeMinorCompaction(mct);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MinorCompactionTask createMinorCompactionTask(long flushId, MinorCompactionReason mincReason) {
        long t1;
        StringBuilder logMessage;
        block11: {
            MinorCompactionTask minorCompactionTask;
            logMessage = null;
            try {
                Tablet tablet = this;
                // MONITORENTER : tablet
                t1 = System.currentTimeMillis();
                if (!this.closing && !this.closed && !this.majorCompactionWaitingToStart && !this.tabletMemory.memoryReservedForMinC() && this.tabletMemory.getMemTable().getNumEntries() != 0L && !this.updatingFlushID) break block11;
                logMessage = new StringBuilder();
                logMessage.append(this.extent.toString());
                logMessage.append(" closing " + this.closing);
                logMessage.append(" closed " + this.closed);
                logMessage.append(" majorCompactionWaitingToStart " + this.majorCompactionWaitingToStart);
                if (this.tabletMemory != null) {
                    logMessage.append(" tabletMemory.memoryReservedForMinC() " + this.tabletMemory.memoryReservedForMinC());
                }
                if (this.tabletMemory != null && this.tabletMemory.getMemTable() != null) {
                    logMessage.append(" tabletMemory.getMemTable().getNumEntries() " + this.tabletMemory.getMemTable().getNumEntries());
                }
                logMessage.append(" updatingFlushID " + this.updatingFlushID);
                minorCompactionTask = null;
                // MONITOREXIT : tablet
                if (logMessage == null) return minorCompactionTask;
            }
            catch (Throwable throwable) {
                if (logMessage == null) throw throwable;
                if (!log.isDebugEnabled()) throw throwable;
                log.debug(logMessage);
                throw throwable;
            }
            if (!log.isDebugEnabled()) return minorCompactionTask;
            log.debug((Object)logMessage);
            return minorCompactionTask;
        }
        if (this.datafileManager == null) {
            logMessage = new StringBuilder();
            logMessage.append(this.extent.toString());
            logMessage.append(" datafileManager " + this.datafileManager);
            MinorCompactionTask minorCompactionTask = null;
            // MONITOREXIT : tablet
            if (logMessage == null) return minorCompactionTask;
            if (!log.isDebugEnabled()) return minorCompactionTask;
            log.debug((Object)logMessage);
            return minorCompactionTask;
        }
        MinorCompactionTask mct = this.prepareForMinC(flushId, mincReason);
        long t2 = System.currentTimeMillis();
        // MONITOREXIT : tablet
        if (logMessage != null && log.isDebugEnabled()) {
            log.debug((Object)logMessage);
        }
        log.debug((Object)String.format("MinC initiate lock %.2f secs", (double)(t2 - t1) / 1000.0));
        return mct;
    }

    long getFlushID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/flush-id";
            return Long.parseLong(new String(ZooReaderWriter.getRetryingInstance().getData(zTablePath, null), Constants.UTF8));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException(ke);
        }
    }

    long getCompactionCancelID() {
        String zTablePath = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/compact-cancel-id";
        try {
            return Long.parseLong(new String(ZooReaderWriter.getRetryingInstance().getData(zTablePath, null), Constants.UTF8));
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    Pair<Long, List<IteratorSetting>> getCompactionID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/compact-id";
            String[] tokens = new String(ZooReaderWriter.getRetryingInstance().getData(zTablePath, null), Constants.UTF8).split(",");
            long compactID = Long.parseLong(tokens[0]);
            CompactionIterators iters = new CompactionIterators();
            if (tokens.length > 1) {
                Hex hex = new Hex();
                ByteArrayInputStream bais = new ByteArrayInputStream(hex.decode(tokens[1].split("=")[1].getBytes(Constants.UTF8)));
                DataInputStream dis = new DataInputStream(bais);
                try {
                    iters.readFields((DataInput)dis);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                KeyExtent ke = new KeyExtent(this.extent.getTableId(), iters.getEndRow(), iters.getStartRow());
                if (!ke.overlaps(this.extent)) {
                    iters = new CompactionIterators();
                }
            }
            return new Pair((Object)compactID, (Object)iters.getIterators());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException(ke);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void waitForMinC() {
        this.tabletMemory.waitForMinC();
    }

    private synchronized CommitSession finishPreparingMutations(long time) {
        if (this.writesInProgress < 0) {
            throw new IllegalStateException("waitingForLogs < 0 " + this.writesInProgress);
        }
        if (this.closed || this.tabletMemory == null) {
            return null;
        }
        ++this.writesInProgress;
        CommitSession commitSession = this.tabletMemory.getCommitSession();
        commitSession.incrementCommitsInProgress();
        commitSession.updateMaxCommittedTime(time);
        return commitSession;
    }

    public void checkConstraints() {
        ConstraintChecker cc = this.constraintChecker.get();
        if (cc.classLoaderChanged()) {
            ConstraintChecker ncc = new ConstraintChecker(this.acuTableConf);
            this.constraintChecker.compareAndSet(cc, ncc);
        }
    }

    public CommitSession prepareMutationsForCommit(TabletServer.TservConstraintEnv cenv, List<Mutation> mutations) throws TConstraintViolationException {
        ConstraintChecker cc = this.constraintChecker.get();
        ArrayList<Mutation> violators = null;
        Violations violations = new Violations();
        cenv.setExtent(this.extent);
        for (Mutation mutation : mutations) {
            Violations more = cc.check(cenv, mutation);
            if (more == null) continue;
            violations.add(more);
            if (violators == null) {
                violators = new ArrayList<Mutation>();
            }
            violators.add(mutation);
        }
        long time = this.tabletTime.setUpdateTimes(mutations);
        if (!violations.isEmpty()) {
            HashSet violatorsSet = new HashSet(violators);
            ArrayList<Mutation> nonViolators = new ArrayList<Mutation>();
            for (Mutation mutation : mutations) {
                if (violatorsSet.contains(mutation)) continue;
                nonViolators.add(mutation);
            }
            CommitSession commitSession = null;
            if (nonViolators.size() > 0 && (commitSession = this.finishPreparingMutations(time)) == null) {
                return null;
            }
            throw new TConstraintViolationException(violations, violators, nonViolators, commitSession);
        }
        return this.finishPreparingMutations(time);
    }

    public synchronized void abortCommit(CommitSession commitSession, List<Mutation> value) {
        if (this.writesInProgress <= 0) {
            throw new IllegalStateException("waitingForLogs <= 0 " + this.writesInProgress);
        }
        if (this.closeComplete || this.tabletMemory == null) {
            throw new IllegalStateException("aborting commit when tablet is closed");
        }
        commitSession.decrementCommitsInProgress();
        --this.writesInProgress;
        if (this.writesInProgress == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommitSession commitSession, List<Mutation> mutations) {
        int totalCount = 0;
        long totalBytes = 0L;
        for (Mutation mutation : mutations) {
            totalCount += mutation.size();
            totalBytes += mutation.numBytes();
        }
        this.tabletMemory.mutate(commitSession, mutations);
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.writesInProgress < 1) {
                throw new IllegalStateException("commiting mutations after logging, but not waiting for any log messages");
            }
            if (this.closed && this.closeComplete) {
                throw new IllegalStateException("tablet closed with outstanding messages to the logger");
            }
            this.tabletMemory.updateMemoryUsageStats();
            --this.writesInProgress;
            if (this.writesInProgress == 0) {
                this.notifyAll();
            }
            commitSession.decrementCommitsInProgress();
            this.numEntries += (long)totalCount;
            this.numEntriesInMemory += (long)totalCount;
            this.ingestCount += (long)totalCount;
            this.ingestBytes += totalBytes;
        }
    }

    public void close(boolean saveState) throws IOException {
        this.initiateClose(saveState, false, false);
        this.completeClose(saveState, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateClose(boolean saveState, boolean queueMinC, boolean disableWrites) {
        if (!saveState && queueMinC) {
            throw new IllegalArgumentException("Not saving state on close and requesting minor compactions queue does not make sense");
        }
        log.debug((Object)("initiateClose(saveState=" + saveState + " queueMinC=" + queueMinC + " disableWrites=" + disableWrites + ") " + this.getExtent()));
        MinorCompactionTask mct = null;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.closed || this.closing || this.closeComplete) {
                String msg = "Tablet " + this.getExtent() + " already";
                if (this.closed) {
                    msg = msg + " closed";
                }
                if (this.closing) {
                    msg = msg + " closing";
                }
                if (this.closeComplete) {
                    msg = msg + " closeComplete";
                }
                throw new IllegalStateException(msg);
            }
            this.closing = true;
            this.notifyAll();
            this.closed = disableWrites;
            while (this.majorCompactionInProgress) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.toString());
                }
            }
            while (this.updatingFlushID) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.toString());
                }
            }
            if (!saveState || this.tabletMemory.getMemTable().getNumEntries() == 0L) {
                return;
            }
            this.tabletMemory.waitForMinC();
            try {
                mct = this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE);
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException(e);
            }
            if (queueMinC) {
                this.tabletResources.executeMinorCompaction(mct);
                return;
            }
        }
        mct.run();
    }

    synchronized void completeClose(boolean saveState, boolean completeClose) throws IOException {
        if (!this.closing || this.closeComplete || this.closeCompleting) {
            throw new IllegalStateException("closing = " + this.closing + " closed = " + this.closed + " closeComplete = " + this.closeComplete + " closeCompleting = " + this.closeCompleting);
        }
        log.debug((Object)("completeClose(saveState=" + saveState + " completeClose=" + completeClose + ") " + this.getExtent()));
        this.closeCompleting = true;
        this.closed = true;
        this.dataSourceDeletions.incrementAndGet();
        for (ScanDataSource activeScan : this.activeScans) {
            activeScan.interrupt();
        }
        while (this.writesInProgress > 0 || this.activeScans.size() > 0) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                log.error((Object)e.toString());
            }
        }
        this.tabletMemory.waitForMinC();
        if (saveState && this.tabletMemory.getMemTable().getNumEntries() > 0L) {
            try {
                this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE).run();
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException(e);
            }
        }
        if (saveState) {
            RuntimeException err = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    this.closeConsistencyCheck();
                    err = null;
                    continue;
                }
                catch (RuntimeException t) {
                    err = t;
                    log.error((Object)("Consistency check fails, retrying " + t));
                    UtilWaitThread.sleep((long)500L);
                }
            }
            if (err != null) {
                ProblemReports.getInstance().report(new ProblemReport(this.extent.getTableId().toString(), ProblemType.TABLET_LOAD, this.extent.toString(), (Throwable)err));
                log.error((Object)("Tablet closed consistency check has failed for " + this.extent + " giving up and closing"));
            }
        }
        try {
            this.tabletMemory.getMemTable().delete(0L);
        }
        catch (Throwable t) {
            log.error((Object)("Failed to delete mem table : " + t.getMessage()), t);
        }
        this.tabletMemory = null;
        this.tabletResources.close();
        log.log((Priority)TLevel.TABLET_HIST, (Object)(this.extent + " closed"));
        this.acuTableConf.getNamespaceConfiguration().removeObserver(this.configObserver);
        this.acuTableConf.removeObserver(this.configObserver);
        this.closeComplete = completeClose;
    }

    private void closeConsistencyCheck() {
        if (this.tabletMemory.getMemTable().getNumEntries() != 0L) {
            String msg = "Closed tablet " + this.extent + " has " + this.tabletMemory.getMemTable().getNumEntries() + " entries in memory";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (this.tabletMemory.memoryReservedForMinC()) {
            String msg = "Closed tablet " + this.extent + " has minor compacting memory";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            Pair fileLog = MetadataTableUtil.getFileAndLogEntries((Credentials)SystemCredentials.get(), (KeyExtent)this.extent);
            if (((List)fileLog.getFirst()).size() != 0) {
                String msg = "Closed tablet " + this.extent + " has walog entries in " + "accumulo.metadata" + " " + fileLog.getFirst();
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            if (this.extent.isRootTablet()) {
                if (!((Object)((SortedMap)fileLog.getSecond()).keySet()).equals(this.datafileManager.getDatafileSizes().keySet())) {
                    String msg = "Data file in accumulo.root differ from in memory data " + this.extent + "  " + ((SortedMap)fileLog.getSecond()).keySet() + "  " + this.datafileManager.getDatafileSizes().keySet();
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
            } else if (!((SortedMap)fileLog.getSecond()).equals(this.datafileManager.getDatafileSizes())) {
                String msg = "Data file in accumulo.metadata differ from in memory data " + this.extent + "  " + fileLog.getSecond() + "  " + this.datafileManager.getDatafileSizes();
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
        }
        catch (Exception e) {
            String msg = "Failed to do close consistency check for tablet " + this.extent;
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (this.otherLogs.size() != 0 || this.currentLogs.size() != 0) {
            String msg = "Closed tablet " + this.extent + " has walog entries in memory currentLogs = " + this.currentLogs + "  otherLogs = " + this.otherLogs;
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    public Path getLocation() {
        return this.location;
    }

    synchronized boolean initiateMajorCompaction(MajorCompactionReason reason) {
        if (this.closing || this.closed || !this.needsMajorCompaction(reason) || this.majorCompactionInProgress || this.majorCompactionQueued.contains((Object)reason)) {
            return false;
        }
        this.majorCompactionQueued.add(reason);
        this.tabletResources.executeMajorCompaction(this.getExtent(), new CompactionRunner(reason));
        return false;
    }

    public boolean needsMajorCompaction(MajorCompactionReason reason) {
        if (this.majorCompactionInProgress) {
            return false;
        }
        if (reason == MajorCompactionReason.CHOP || reason == MajorCompactionReason.USER) {
            return true;
        }
        return this.tabletResources.needsMajorCompaction(this.datafileManager.getDatafileSizes(), reason);
    }

    public long estimateTabletSize() {
        long size = 0L;
        for (DataFileValue sz : this.datafileManager.getDatafileSizes().values()) {
            size += sz.getSize();
        }
        return size;
    }

    private SplitRowSpec findSplitRow(Collection<FileRef> files) {
        long splitThreshold = this.acuTableConf.getMemoryInBytes(Property.TABLE_SPLIT_THRESHOLD);
        if (this.extent.isRootTablet() || this.estimateTabletSize() <= splitThreshold) {
            return null;
        }
        if (this.sawBigRow) {
            if (this.timeOfLastMinCWhenBigFreakinRowWasSeen != this.lastMinorCompactionFinishTime || this.timeOfLastImportWhenBigFreakinRowWasSeen != this.lastMapFileImportTime) {
                this.sawBigRow = false;
            } else {
                return null;
            }
        }
        SortedMap keys = null;
        try {
            keys = FileUtil.findMidPoint((VolumeManager)this.fs, (AccumuloConfiguration)this.tabletServer.getSystemConfiguration(), (Text)this.extent.getPrevEndRow(), (Text)this.extent.getEndRow(), (Collection)FileUtil.toPathStrings(files), (double)0.25);
        }
        catch (IOException e) {
            log.error((Object)("Failed to find midpoint " + e.getMessage()));
            return null;
        }
        try {
            Text lastRow;
            if (this.extent.getEndRow() == null) {
                Key lastKey = (Key)FileUtil.findLastKey((VolumeManager)this.fs, (AccumuloConfiguration)this.tabletServer.getSystemConfiguration(), files);
                lastRow = lastKey.getRow();
            } else {
                lastRow = this.extent.getEndRow();
            }
            if (((Key)keys.get(0.5)).compareRow(lastRow) == 0) {
                Key candidate;
                if ((Double)keys.firstKey() < 0.5 && (candidate = (Key)keys.get(keys.firstKey())).compareRow(lastRow) != 0) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Splitting at %6.2f instead of .5, row at .5 is same as end row%n", keys.firstKey()));
                    }
                    return new SplitRowSpec((Double)keys.firstKey(), candidate.getRow());
                }
                log.warn((Object)("Cannot split tablet " + this.extent + " it contains a big row : " + lastRow));
                this.sawBigRow = true;
                this.timeOfLastMinCWhenBigFreakinRowWasSeen = this.lastMinorCompactionFinishTime;
                this.timeOfLastImportWhenBigFreakinRowWasSeen = this.lastMapFileImportTime;
                return null;
            }
            Key mid = (Key)keys.get(0.5);
            Text text = mid == null ? null : mid.getRow();
            SortedMap firstHalf = keys.headMap(0.5);
            if (firstHalf.size() > 0) {
                Text beforeMid = ((Key)firstHalf.get(firstHalf.lastKey())).getRow();
                Text shorter = new Text();
                int trunc = Tablet.longestCommonLength(text, beforeMid);
                shorter.set(text.getBytes(), 0, Math.min(text.getLength(), trunc + 1));
                text = shorter;
            }
            return new SplitRowSpec(0.5, text);
        }
        catch (IOException e) {
            log.error((Object)("Failed to find lastkey " + e.getMessage()));
            return null;
        }
    }

    private static int longestCommonLength(Text text, Text beforeMid) {
        int common;
        for (common = 0; common < text.getLength() && common < beforeMid.getLength() && text.getBytes()[common] == beforeMid.getBytes()[common]; ++common) {
        }
        return common;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FileRef, Pair<Key, Key>> getFirstAndLastKeys(SortedMap<FileRef, DataFileValue> allFiles) throws IOException {
        HashMap<FileRef, Pair<Key, Key>> result = new HashMap<FileRef, Pair<Key, Key>>();
        FileOperations fileFactory = FileOperations.getInstance();
        for (Map.Entry<FileRef, DataFileValue> entry : allFiles.entrySet()) {
            FileRef file = entry.getKey();
            FileSystem ns = this.fs.getVolumeByPath(file.path()).getFileSystem();
            FileSKVIterator openReader = fileFactory.openReader(file.path().toString(), true, ns, ns.getConf(), (AccumuloConfiguration)this.getTableConfiguration());
            try {
                Key first = openReader.getFirstKey();
                Key last = openReader.getLastKey();
                result.put(file, (Pair<Key, Key>)new Pair((Object)first, (Object)last));
            }
            finally {
                openReader.close();
            }
        }
        return result;
    }

    List<FileRef> findChopFiles(KeyExtent extent, Map<FileRef, Pair<Key, Key>> firstAndLastKeys, Collection<FileRef> allFiles) throws IOException {
        ArrayList<FileRef> result = new ArrayList<FileRef>();
        if (firstAndLastKeys == null) {
            result.addAll(allFiles);
            return result;
        }
        for (FileRef file : allFiles) {
            Pair<Key, Key> pair = firstAndLastKeys.get(file);
            if (pair == null) {
                result.add(file);
                continue;
            }
            Key first = (Key)pair.getFirst();
            Key last = (Key)pair.getSecond();
            if ((first != null || last != null) && extent.contains((BinaryComparable)first.getRow()) && extent.contains((BinaryComparable)last.getRow())) continue;
            result.add(file);
        }
        return result;
    }

    public synchronized boolean needsSplit() {
        boolean ret = this.closing || this.closed ? false : this.findSplitRow(this.datafileManager.getFiles()) != null;
        return ret;
    }

    private boolean isCompactionEnabled() {
        return !this.closing && !this.tabletServer.isMajorCompactionDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private CompactionStats _majorCompact(MajorCompactionReason reason) throws IOException, Compactor.CompactionCanceledException {
        strategy = (CompactionStrategy)Property.createInstanceFromPropertyName((AccumuloConfiguration)this.acuTableConf, (Property)Property.TABLE_COMPACTION_STRATEGY, CompactionStrategy.class, (Object)new DefaultCompactionStrategy());
        strategy.init(Property.getCompactionStrategyOptions((AccumuloConfiguration)this.acuTableConf));
        firstAndLastKeys = null;
        if (reason == MajorCompactionReason.CHOP) {
            firstAndLastKeys = this.getFirstAndLastKeys(this.datafileManager.getDatafileSizes());
        } else if (reason != MajorCompactionReason.USER) {
            request = new MajorCompactionRequest(this.extent, reason, this.fs, (AccumuloConfiguration)this.acuTableConf);
            request.setFiles(this.datafileManager.getDatafileSizes());
            strategy.gatherInformation(request);
        }
        maxFilesToCompact = this.acuTableConf.getCount(Property.TSERV_MAJC_THREAD_MAXOPEN);
        majCStats = new CompactionStats();
        plan = null;
        propogateDeletes = false;
        var15_9 = this;
        synchronized (var15_9) {
            t1 = System.currentTimeMillis();
            this.majorCompactionWaitingToStart = true;
            this.tabletMemory.waitForMinC();
            t2 = System.currentTimeMillis();
            this.majorCompactionWaitingToStart = false;
            this.notifyAll();
            if (this.extent.isRootTablet()) {
                RootFiles.cleanupReplacement(this.fs, this.fs.listStatus(this.location), false);
            }
            allFiles = this.datafileManager.getDatafileSizes();
            inputFiles = new ArrayList<FileRef>();
            if (reason == MajorCompactionReason.CHOP) {
                inputFiles.addAll(this.findChopFiles(this.extent, firstAndLastKeys, allFiles.keySet()));
            } else if (reason == MajorCompactionReason.USER) {
                inputFiles.addAll(allFiles.keySet());
            } else {
                request = new MajorCompactionRequest(this.extent, reason, this.fs, (AccumuloConfiguration)this.acuTableConf);
                request.setFiles(allFiles);
                plan = strategy.getCompactionPlan(request);
                if (plan != null) {
                    inputFiles.addAll(plan.inputFiles);
                }
            }
            if (inputFiles.isEmpty()) {
                return majCStats;
            }
            droppedFiles = new HashSet<FileRef>();
            droppedFiles.addAll(inputFiles);
            if (plan != null) {
                droppedFiles.addAll(plan.deleteFiles);
            }
            propogateDeletes = droppedFiles.equals(allFiles.keySet()) == false;
            Tablet.log.debug((Object)("Major compaction plan: " + plan + " propogate deletes : " + propogateDeletes));
            filesToCompact = new HashMap<FileRef, DataFileValue>(allFiles);
            filesToCompact.keySet().retainAll((Collection<?>)inputFiles);
            t3 = System.currentTimeMillis();
            this.datafileManager.reserveMajorCompactingFiles(filesToCompact.keySet());
        }
        try {
            Tablet.log.debug((Object)String.format("MajC initiate lock %.2f secs, wait %.2f secs", new Object[]{(double)(t3 - t2) / 1000.0, (double)(t2 - t1) / 1000.0}));
            compactionId = null;
            if (!propogateDeletes) {
                try {
                    compactionId = this.getCompactionID();
                }
                catch (KeeperException.NoNodeException e) {
                    throw new RuntimeException(e);
                }
            }
            compactionIterators = new ArrayList<E>();
            if (compactionId != null) {
                if (reason == MajorCompactionReason.USER) {
                    if (this.getCompactionCancelID() >= (Long)compactionId.getFirst()) {
                        inputFiles = majCStats;
                        return inputFiles;
                    }
                    inputFiles = this;
                    synchronized (inputFiles) {
                        block48: {
                            if (this.lastCompactID < (Long)compactionId.getFirst()) break block48;
                            droppedFiles = majCStats;
                            return droppedFiles;
                        }
                        ** try [egrp 8[TRYBLOCK] [9 : 720->726)] { 
                        {
                        }
                    }
                }
lbl87:
                // 3 sources

                compactionIterators = (List)compactionId.getSecond();
            }
            while (filesToCompact.size() > 0) {
                numToCompact = maxFilesToCompact;
                if (filesToCompact.size() > maxFilesToCompact && filesToCompact.size() < 2 * maxFilesToCompact) {
                    numToCompact = filesToCompact.size() - maxFilesToCompact + 1;
                }
                smallestFiles = this.removeSmallest(filesToCompact, numToCompact);
                fileName = this.getNextMapFilename(filesToCompact.size() == 0 && propogateDeletes == false ? "A" : "C");
                compactTmpName = new FileRef(fileName.path().toString() + "_tmp");
                tableConf = this.createTableConfiguration(this.acuTableConf, plan);
                span = Trace.start((String)"compactFiles");
                try {
                    cenv = new Compactor.CompactionEnv(){

                        @Override
                        public boolean isCompactionEnabled() {
                            return Tablet.this.isCompactionEnabled();
                        }

                        @Override
                        public IteratorUtil.IteratorScope getIteratorScope() {
                            return IteratorUtil.IteratorScope.majc;
                        }
                    };
                    copy = new HashMap<FileRef, DataFileValue>(this.datafileManager.getDatafileSizes());
                    if (!copy.keySet().containsAll(smallestFiles)) {
                        throw new IllegalStateException("Cannot find data file values for " + smallestFiles);
                    }
                    copy.keySet().retainAll(smallestFiles);
                    Tablet.log.debug((Object)("Starting MajC " + this.extent + " (" + (Object)reason + ") " + copy.keySet() + " --> " + compactTmpName + "  " + compactionIterators));
                    lastBatch = filesToCompact.isEmpty();
                    compactor = new Compactor(this.conf, this.fs, copy, null, compactTmpName, lastBatch != false ? propogateDeletes : true, tableConf, this.extent, cenv, compactionIterators, reason);
                    mcs = compactor.call();
                    span.data("files", "" + smallestFiles.size());
                    span.data("read", "" + mcs.getEntriesRead());
                    span.data("written", "" + mcs.getEntriesWritten());
                    majCStats.add(mcs);
                    if (lastBatch && plan != null && plan.deleteFiles != null) {
                        smallestFiles.addAll(plan.deleteFiles);
                    }
                    this.datafileManager.bringMajorCompactionOnline(smallestFiles, compactTmpName, fileName, filesToCompact.size() == 0 && compactionId != null ? (Long)compactionId.getFirst() : null, new DataFileValue(mcs.getFileSize(), mcs.getEntriesWritten()));
                    if (filesToCompact.size() <= 0 || mcs.getEntriesWritten() <= 0L) continue;
                    filesToCompact.put(fileName, new DataFileValue(mcs.getFileSize(), mcs.getEntriesWritten()));
                }
                finally {
                    span.stop();
                }
            }
            var17_14 = majCStats;
            return var17_14;
        }
        finally {
            droppedFiles = this;
            synchronized (droppedFiles) {
                this.datafileManager.clearMajorCompactingFile();
            }
        }
    }

    private AccumuloConfiguration createTableConfiguration(TableConfiguration base, CompactionPlan plan) {
        if (plan == null || plan.writeParameters == null) {
            return base;
        }
        WriteParameters p = plan.writeParameters;
        ConfigurationCopy result = new ConfigurationCopy((Iterable)base);
        if (p.getHdfsBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_BLOCK_SIZE, "" + p.getHdfsBlockSize());
        }
        if (p.getBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, "" + p.getBlockSize());
        }
        if (p.getIndexBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, "" + p.getBlockSize());
        }
        if (p.getCompressType() != null) {
            result.set(Property.TABLE_FILE_COMPRESSION_TYPE, p.getCompressType());
        }
        if (p.getReplication() != 0) {
            result.set(Property.TABLE_FILE_REPLICATION, "" + p.getReplication());
        }
        return result;
    }

    private Set<FileRef> removeSmallest(Map<FileRef, DataFileValue> filesToCompact, int maxFilesToCompact) {
        PriorityQueue<Pair<FileRef, Long>> fileHeap = new PriorityQueue<Pair<FileRef, Long>>(filesToCompact.size(), new Comparator<Pair<FileRef, Long>>(){

            @Override
            public int compare(Pair<FileRef, Long> o1, Pair<FileRef, Long> o2) {
                if (o1.getSecond() == o2.getSecond()) {
                    return ((FileRef)o1.getFirst()).compareTo((FileRef)o2.getFirst());
                }
                if ((Long)o1.getSecond() < (Long)o2.getSecond()) {
                    return -1;
                }
                return 1;
            }
        });
        for (Map.Entry<FileRef, DataFileValue> entry : filesToCompact.entrySet()) {
            fileHeap.add((Pair<FileRef, Long>)new Pair((Object)entry.getKey(), (Object)entry.getValue().getSize()));
        }
        HashSet<FileRef> smallestFiles = new HashSet<FileRef>();
        while (smallestFiles.size() < maxFilesToCompact && fileHeap.size() > 0) {
            Pair pair = (Pair)fileHeap.remove();
            filesToCompact.remove(pair.getFirst());
            smallestFiles.add((FileRef)pair.getFirst());
        }
        return smallestFiles;
    }

    static void rename(VolumeManager fs, Path src, Path dst) throws IOException {
        if (!fs.rename(src, dst)) {
            throw new IOException("Rename " + src + " to " + dst + " returned false ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompactionStats majorCompact(MajorCompactionReason reason) {
        CompactionStats majCStats = null;
        Span span = Trace.on((String)"majorCompaction");
        try {
            Tablet tablet = this;
            synchronized (tablet) {
                block22: {
                    this.majorCompactionQueued.remove((Object)reason);
                    if (!this.closing && !this.closed && this.needsMajorCompaction(reason) && !this.majorCompactionInProgress && !this.needsSplit()) break block22;
                    CompactionStats compactionStats = null;
                    return compactionStats;
                }
                this.majorCompactionInProgress = true;
            }
            try {
                majCStats = this._majorCompact(reason);
                if (reason == MajorCompactionReason.CHOP) {
                    MetadataTableUtil.chopped((KeyExtent)this.getExtent(), (ZooLock)this.tabletServer.getLock());
                    this.tabletServer.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.CHOPPED, this.extent));
                }
            }
            catch (Compactor.CompactionCanceledException mcce) {
                log.debug((Object)("Major compaction canceled, extent = " + this.getExtent()));
                throw new RuntimeException(mcce);
            }
            catch (Throwable t) {
                log.error((Object)("MajC Failed, extent = " + this.getExtent()));
                log.error((Object)("MajC Failed, message = " + (t.getMessage() == null ? t.getClass().getName() : t.getMessage())), t);
                throw new RuntimeException(t);
            }
            finally {
                Tablet tablet2 = this;
                synchronized (tablet2) {
                    this.majorCompactionInProgress = false;
                    this.notifyAll();
                }
                Span curr = Trace.currentTrace();
                curr.data("extent", "" + this.getExtent());
                if (majCStats != null) {
                    curr.data("read", "" + majCStats.getEntriesRead());
                    curr.data("written", "" + majCStats.getEntriesWritten());
                }
            }
        }
        finally {
            span.stop();
        }
        return majCStats;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    private synchronized void computeNumEntries() {
        Collection<DataFileValue> vals = this.datafileManager.getDatafileSizes().values();
        long numEntries = 0L;
        for (DataFileValue tableValue : vals) {
            numEntries += tableValue.getNumEntries();
        }
        this.numEntriesInMemory = this.tabletMemory.getNumEntries();
        this.numEntries = numEntries += this.tabletMemory.getNumEntries();
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public long getNumEntriesInMemory() {
        return this.numEntriesInMemory;
    }

    public synchronized boolean isClosing() {
        return this.closing;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isCloseComplete() {
        return this.closeComplete;
    }

    public boolean majorCompactionRunning() {
        return this.majorCompactionInProgress;
    }

    public boolean minorCompactionQueued() {
        return this.minorCompactionWaitingToStart;
    }

    public boolean minorCompactionRunning() {
        return this.minorCompactionInProgress;
    }

    public boolean majorCompactionQueued() {
        return this.majorCompactionQueued.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<KeyExtent, SplitInfo> split(byte[] sp) throws IOException {
        if (sp != null && this.extent.getEndRow() != null && this.extent.getEndRow().equals((Object)new Text(sp))) {
            throw new IllegalArgumentException();
        }
        if (this.extent.isRootTablet()) {
            String msg = "Cannot split root tablet";
            log.warn((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            this.initiateClose(true, false, false);
        }
        catch (IllegalStateException ise) {
            log.debug((Object)("File " + this.extent + " not splitting : " + ise.getMessage()));
            return null;
        }
        Map firstAndLastRows = FileUtil.tryToGetFirstAndLastRows((VolumeManager)this.fs, (AccumuloConfiguration)this.tabletServer.getSystemConfiguration(), this.datafileManager.getFiles());
        Tablet tablet = this;
        synchronized (tablet) {
            SplitRowSpec splitPoint;
            TreeMap<KeyExtent, SplitInfo> newTablets = new TreeMap<KeyExtent, SplitInfo>();
            long t1 = System.currentTimeMillis();
            if (sp == null) {
                splitPoint = this.findSplitRow(this.datafileManager.getFiles());
            } else {
                Text tsp = new Text(sp);
                splitPoint = new SplitRowSpec(FileUtil.estimatePercentageLTE((VolumeManager)this.fs, (AccumuloConfiguration)this.tabletServer.getSystemConfiguration(), (Text)this.extent.getPrevEndRow(), (Text)this.extent.getEndRow(), (Collection)FileUtil.toPathStrings(this.datafileManager.getFiles()), (Text)tsp), tsp);
            }
            if (splitPoint == null || splitPoint.row == null) {
                log.info((Object)"had to abort split because splitRow was null");
                this.closing = false;
                return null;
            }
            this.closed = true;
            this.completeClose(true, false);
            Text midRow = splitPoint.row;
            double splitRatio = splitPoint.splitRatio;
            KeyExtent low = new KeyExtent(this.extent.getTableId(), midRow, this.extent.getPrevEndRow());
            KeyExtent high = new KeyExtent(this.extent.getTableId(), this.extent.getEndRow(), midRow);
            String lowDirectory = TabletOperations.createTabletDirectory((VolumeManager)this.fs, (String)this.extent.getTableId().toString(), (Text)midRow);
            TreeMap<FileRef, DataFileValue> lowDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            TreeMap<FileRef, DataFileValue> highDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            ArrayList highDatafilesToRemove = new ArrayList();
            MetadataTableUtil.splitDatafiles((Text)this.extent.getTableId(), (Text)midRow, (double)splitRatio, (Map)firstAndLastRows, this.datafileManager.getDatafileSizes(), lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
            log.debug((Object)("Files for low split " + low + "  " + lowDatafileSizes.keySet()));
            log.debug((Object)("Files for high split " + high + "  " + highDatafileSizes.keySet()));
            String time = this.tabletTime.getMetadataValue();
            Map bulkLoadedFiles = MetadataTableUtil.getBulkFilesLoaded((Credentials)SystemCredentials.get(), (KeyExtent)this.extent);
            MetadataTableUtil.splitTablet((KeyExtent)high, (Text)this.extent.getPrevEndRow(), (double)splitRatio, (Credentials)SystemCredentials.get(), (ZooLock)this.tabletServer.getLock());
            MasterMetadataUtil.addNewTablet((KeyExtent)low, (String)lowDirectory, (TServerInstance)this.tabletServer.getTabletSession(), lowDatafileSizes, (Map)bulkLoadedFiles, (Credentials)SystemCredentials.get(), (String)time, (long)this.lastFlushID, (long)this.lastCompactID, (ZooLock)this.tabletServer.getLock());
            MetadataTableUtil.finishSplit((KeyExtent)high, highDatafileSizes, highDatafilesToRemove, (Credentials)SystemCredentials.get(), (ZooLock)this.tabletServer.getLock());
            log.log((Priority)TLevel.TABLET_HIST, (Object)(this.extent + " split " + low + " " + high));
            newTablets.put(high, new SplitInfo(this.tabletDirectory, highDatafileSizes, time, this.lastFlushID, this.lastCompactID, this.lastLocation));
            newTablets.put(low, new SplitInfo(lowDirectory, lowDatafileSizes, time, this.lastFlushID, this.lastCompactID, this.lastLocation));
            long t2 = System.currentTimeMillis();
            log.debug((Object)String.format("offline split time : %6.2f secs", (double)(t2 - t1) / 1000.0));
            this.closeComplete = true;
            return newTablets;
        }
    }

    public SortedMap<FileRef, DataFileValue> getDatafiles() {
        return this.datafileManager.getDatafileSizes();
    }

    public double queryRate() {
        return this.queryRate.rate();
    }

    public double queryByteRate() {
        return this.queryByteRate.rate();
    }

    public double ingestRate() {
        return this.ingestRate.rate();
    }

    public double ingestByteRate() {
        return this.ingestByteRate.rate();
    }

    public double scanRate() {
        return this.scannedRate.rate();
    }

    public long totalQueries() {
        return this.queryCount;
    }

    public long totalIngest() {
        return this.ingestCount;
    }

    public void updateRates(long now) {
        this.queryRate.update(now, this.queryCount);
        this.queryByteRate.update(now, this.queryBytes);
        this.ingestRate.update(now, this.ingestCount);
        this.ingestByteRate.update(now, this.ingestBytes);
        this.scannedRate.update(now, this.scannedCount.get());
    }

    public long getSplitCreationTime() {
        return this.splitCreationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMapFiles(long tid, Map<FileRef, MapFileInfo> fileMap, boolean setTime) throws IOException {
        HashMap<FileRef, DataFileValue> entries = new HashMap<FileRef, DataFileValue>(fileMap.size());
        for (Map.Entry<FileRef, MapFileInfo> entry : fileMap.entrySet()) {
            entries.put(entry.getKey(), new DataFileValue(entry.getValue().estimatedSize, 0L));
        }
        long now = System.currentTimeMillis();
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.closed) {
                throw new IOException("tablet " + this.extent + " is closed");
            }
            long lockWait = System.currentTimeMillis() - now;
            if (lockWait > this.tabletServer.getSystemConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT)) {
                throw new IOException("Timeout waiting " + (double)lockWait / 1000.0 + " seconds to get tablet lock");
            }
            if (this.writesInProgress < 0) {
                throw new IllegalStateException("writesInProgress < 0 " + this.writesInProgress);
            }
            ++this.writesInProgress;
        }
        try {
            this.datafileManager.importMapFiles(tid, entries, setTime);
            this.lastMapFileImportTime = System.currentTimeMillis();
            if (this.needsSplit()) {
                this.tabletServer.executeSplit(this);
            } else {
                this.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
        }
        finally {
            tablet = this;
            synchronized (tablet) {
                if (this.writesInProgress < 1) {
                    throw new IllegalStateException("writesInProgress < 1 " + this.writesInProgress);
                }
                --this.writesInProgress;
                if (this.writesInProgress == 0) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCurrentLogFiles() {
        HashSet<String> result = new HashSet<String>();
        Set<DfsLogger> set = this.currentLogs;
        synchronized (set) {
            for (DfsLogger log : this.currentLogs) {
                result.add(log.getFileName());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> beginClearingUnusedLogs() {
        HashSet<String> doomed = new HashSet<String>();
        ArrayList<String> otherLogsCopy = new ArrayList<String>();
        ArrayList<String> currentLogsCopy = new ArrayList<String>();
        this.logLock.lock();
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.removingLogs) {
                throw new IllegalStateException("Attempted to clear logs when removal of logs in progress");
            }
            for (DfsLogger logger : this.otherLogs) {
                otherLogsCopy.add(logger.toString());
                doomed.add(logger.toString());
            }
            for (DfsLogger logger : this.currentLogs) {
                currentLogsCopy.add(logger.toString());
                doomed.remove(logger.toString());
            }
            this.otherLogs = Collections.emptySet();
            if (doomed.size() > 0) {
                this.removingLogs = true;
            }
        }
        for (String logger : otherLogsCopy) {
            log.debug((Object)("Logs for memory compacted: " + this.getExtent() + " " + logger.toString()));
        }
        for (String logger : currentLogsCopy) {
            log.debug((Object)("Logs for current memory: " + this.getExtent() + " " + logger));
        }
        return doomed;
    }

    private synchronized void finishClearingUnusedLogs() {
        this.removingLogs = false;
        this.logLock.unlock();
    }

    public synchronized int getLogCount() {
        return this.currentLogs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean beginUpdatingLogsUsed(InMemoryMap memTable, Collection<DfsLogger> more, boolean mincFinish) {
        boolean bl;
        Iterator<DfsLogger> i$;
        int numContained;
        int numAdded;
        boolean addToOther;
        boolean releaseLock = true;
        this.logLock.lock();
        try {
            Tablet tablet = this;
            synchronized (tablet) {
                if (this.closed && this.closeComplete) {
                    throw new IllegalStateException("Can not update logs of closed tablet " + this.extent);
                }
                if (memTable == this.tabletMemory.otherMemTable) {
                    addToOther = true;
                } else {
                    if (memTable != this.tabletMemory.memTable) {
                        throw new IllegalArgumentException("passed in memtable that is not in use");
                    }
                    addToOther = false;
                }
                if (mincFinish) {
                    if (addToOther) {
                        throw new IllegalStateException("Adding to other logs for mincFinish");
                    }
                    if (this.otherLogs.size() != 0) {
                        throw new IllegalStateException("Expect other logs to be 0 when min finish, but its " + this.otherLogs);
                    }
                    if (this.currentLogs.size() == 0) {
                        boolean bl2 = false;
                        // MONITOREXIT @DISABLED, blocks:[0, 17, 5, 14] lbl21 : MonitorExitStatement: MONITOREXIT : var5_5
                        if (!releaseLock) return bl2;
                        this.logLock.unlock();
                        return bl2;
                    }
                }
                numAdded = 0;
                numContained = 0;
                i$ = more.iterator();
            }
        }
        catch (Throwable throwable) {
            if (!releaseLock) throw throwable;
            this.logLock.unlock();
            throw throwable;
        }
        {
            while (i$.hasNext()) {
                DfsLogger logger = i$.next();
                if (addToOther) {
                    if (this.otherLogs.add(logger)) {
                        ++numAdded;
                    }
                    if (!this.currentLogs.contains(logger)) continue;
                    ++numContained;
                    continue;
                }
                if (this.currentLogs.add(logger)) {
                    ++numAdded;
                }
                if (!this.otherLogs.contains(logger)) continue;
                ++numContained;
            }
            if (numAdded > 0 && numAdded != more.size()) {
                throw new IllegalArgumentException("Added subset of logs " + this.extent + " " + more + " " + this.currentLogs);
            }
            if (numContained > 0 && numContained != more.size()) {
                throw new IllegalArgumentException("Other logs contained subset of logs " + this.extent + " " + more + " " + this.otherLogs);
            }
            if (numAdded > 0 && numContained == 0) {
                return true;
            }
            bl = false;
        }
        if (!releaseLock) return bl;
        this.logLock.unlock();
        return bl;
    }

    private void finishUpdatingLogsUsed() {
        this.logLock.unlock();
    }

    public synchronized void chopFiles() {
        this.initiateMajorCompaction(MajorCompactionReason.CHOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactAll(long compactionId) {
        boolean updateMetadata = false;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.lastCompactID >= compactionId) {
                return;
            }
            if (this.closing || this.closed || this.majorCompactionQueued.contains((Object)MajorCompactionReason.USER) || this.majorCompactionInProgress) {
                return;
            }
            if (this.datafileManager.getDatafileSizes().size() == 0) {
                this.majorCompactionInProgress = true;
                updateMetadata = true;
                this.lastCompactID = compactionId;
            } else {
                this.initiateMajorCompaction(MajorCompactionReason.USER);
            }
        }
        if (updateMetadata) {
            try {
                MetadataTableUtil.updateTabletCompactID((KeyExtent)this.extent, (long)compactionId, (Credentials)SystemCredentials.get(), (ZooLock)this.tabletServer.getLock());
            }
            finally {
                tablet = this;
                synchronized (tablet) {
                    this.majorCompactionInProgress = false;
                    this.notifyAll();
                }
            }
        }
    }

    public TableConfiguration getTableConfiguration() {
        return this.acuTableConf;
    }

    static class SplitInfo {
        String dir;
        SortedMap<FileRef, DataFileValue> datafiles;
        String time;
        long initFlushID;
        long initCompactID;
        TServerInstance lastLocation;

        SplitInfo(String d, SortedMap<FileRef, DataFileValue> dfv, String time, long initFlushID, long initCompactID, TServerInstance lastLocation) {
            this.dir = d;
            this.datafiles = dfv;
            this.time = time;
            this.initFlushID = initFlushID;
            this.initCompactID = initCompactID;
            this.lastLocation = lastLocation;
        }
    }

    private static class SplitRowSpec {
        double splitRatio;
        Text row;

        SplitRowSpec(double splitRatio, Text row) {
            this.splitRatio = splitRatio;
            this.row = row;
        }
    }

    private class CompactionRunner
    implements Runnable,
    Comparable<CompactionRunner> {
        long queued = System.currentTimeMillis();
        long start;
        boolean failed = false;
        private MajorCompactionReason reason;

        public CompactionRunner(MajorCompactionReason reason) {
            this.reason = reason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompactionStats majCStats = null;
            if (Tablet.this.tabletServer.isMajorCompactionDisabled()) {
                Tablet.this.majorCompactionQueued.remove((Object)this.reason);
                return;
            }
            try {
                Tablet.this.timer.incrementStatusMajor();
                this.start = System.currentTimeMillis();
                majCStats = Tablet.this.majorCompact(this.reason);
                Tablet tablet = Tablet.this;
                synchronized (tablet) {
                    if (this.reason == MajorCompactionReason.NORMAL && Tablet.this.needsMajorCompaction(this.reason)) {
                        Tablet.this.initiateMajorCompaction(this.reason);
                    }
                }
            }
            catch (RuntimeException E) {
                this.failed = true;
            }
            finally {
                long count = 0L;
                if (majCStats != null) {
                    count = majCStats.getEntriesRead();
                }
                Tablet.this.timer.updateTime(TabletStatsKeeper.Operation.MAJOR, this.queued, this.start, count, this.failed);
            }
        }

        private int getNumFiles() {
            return Tablet.this.datafileManager.datafileSizes.size();
        }

        @Override
        public int compareTo(CompactionRunner o) {
            int cmp = this.reason.compareTo(o.reason);
            if (cmp != 0) {
                return cmp;
            }
            if ((this.reason == MajorCompactionReason.USER || this.reason == MajorCompactionReason.CHOP) && (cmp = (int)(this.queued - o.queued)) != 0) {
                return cmp;
            }
            return o.getNumFiles() - this.getNumFiles();
        }
    }

    static class TConstraintViolationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Violations violations;
        private List<Mutation> violators;
        private List<Mutation> nonViolators;
        private CommitSession commitSession;

        TConstraintViolationException(Violations violations, List<Mutation> violators, List<Mutation> nonViolators, CommitSession commitSession) {
            this.violations = violations;
            this.violators = violators;
            this.nonViolators = nonViolators;
            this.commitSession = commitSession;
        }

        Violations getViolations() {
            return this.violations;
        }

        List<Mutation> getViolators() {
            return this.violators;
        }

        List<Mutation> getNonViolators() {
            return this.nonViolators;
        }

        CommitSession getCommitSession() {
            return this.commitSession;
        }
    }

    private class MinorCompactionTask
    implements Runnable {
        private long queued = System.currentTimeMillis();
        private CommitSession commitSession;
        private DataFileValue stats;
        private FileRef mergeFile;
        private long flushId;
        private MinorCompactionReason mincReason;

        MinorCompactionTask(FileRef mergeFile, CommitSession commitSession, long flushId, MinorCompactionReason mincReason) {
            Tablet.this.minorCompactionWaitingToStart = true;
            this.commitSession = commitSession;
            this.mergeFile = mergeFile;
            this.flushId = flushId;
            this.mincReason = mincReason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tablet.this.minorCompactionWaitingToStart = false;
            Tablet.this.minorCompactionInProgress = true;
            Span minorCompaction = Trace.on((String)"minorCompaction");
            try {
                FileRef newMapfileLocation = Tablet.this.getNextMapFilename(this.mergeFile == null ? "F" : "M");
                FileRef tmpFileRef = new FileRef(newMapfileLocation.path() + "_tmp");
                Span span = Trace.start((String)"waitForCommits");
                Tablet tablet = Tablet.this;
                synchronized (tablet) {
                    this.commitSession.waitForCommitsToFinish();
                }
                span.stop();
                span = Trace.start((String)"start");
                while (true) {
                    try {
                        Tablet.this.tabletServer.minorCompactionStarted(this.commitSession, this.commitSession.getWALogSeq() + 1, newMapfileLocation.path().toString());
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to write to write ahead log " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                    break;
                }
                span.stop();
                span = Trace.start((String)"compact");
                this.stats = Tablet.this.minorCompact(Tablet.this.conf, Tablet.this.fs, Tablet.this.tabletMemory.getMinCMemTable(), tmpFileRef, newMapfileLocation, this.mergeFile, true, this.queued, this.commitSession, this.flushId, this.mincReason);
                span.stop();
                if (Tablet.this.needsSplit()) {
                    Tablet.this.tabletServer.executeSplit(Tablet.this);
                } else {
                    Tablet.this.initiateMajorCompaction(MajorCompactionReason.NORMAL);
                }
            }
            catch (Throwable t) {
                log.error((Object)("Unknown error during minor compaction for extent: " + Tablet.this.getExtent()), t);
                throw new RuntimeException(t);
            }
            finally {
                Tablet.this.minorCompactionInProgress = false;
                minorCompaction.data("extent", Tablet.this.extent.toString());
                minorCompaction.data("numEntries", Long.toString(this.stats.getNumEntries()));
                minorCompaction.data("size", Long.toString(this.stats.getSize()));
                minorCompaction.stop();
            }
        }
    }

    class ScanDataSource
    implements SourceSwitchingIterator.DataSource {
        private FileManager.ScanFileManager fileManager;
        private SortedKeyValueIterator<Key, Value> iter;
        private long expectedDeletionCount;
        private List<InMemoryMap.MemoryIterator> memIters = null;
        private long fileReservationId;
        private AtomicBoolean interruptFlag;
        private StatsIterator statsIterator;
        ScanOptions options;

        ScanDataSource(Authorizations authorizations, byte[] defaultLabels, HashSet<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag) {
            this.expectedDeletionCount = Tablet.this.dataSourceDeletions.get();
            this.options = new ScanOptions(-1, authorizations, defaultLabels, columnSet, ssiList, ssio, interruptFlag, false);
            this.interruptFlag = interruptFlag;
        }

        ScanDataSource(ScanOptions options) {
            this.expectedDeletionCount = Tablet.this.dataSourceDeletions.get();
            this.options = options;
            this.interruptFlag = options.interruptFlag;
        }

        public SourceSwitchingIterator.DataSource getNewDataSource() {
            if (!this.isCurrent()) {
                if (this.memIters != null) {
                    Tablet.this.tabletMemory.returnIterators(this.memIters);
                    this.memIters = null;
                    Tablet.this.datafileManager.returnFilesForScan(this.fileReservationId);
                    this.fileReservationId = -1L;
                }
                if (this.fileManager != null) {
                    this.fileManager.releaseOpenFiles(false);
                }
                this.expectedDeletionCount = Tablet.this.dataSourceDeletions.get();
                this.iter = null;
                return this;
            }
            return this;
        }

        public boolean isCurrent() {
            return this.expectedDeletionCount == Tablet.this.dataSourceDeletions.get();
        }

        public SortedKeyValueIterator<Key, Value> iterator() throws IOException {
            if (this.iter == null) {
                this.iter = this.createIterator();
            }
            return this.iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SortedKeyValueIterator<Key, Value> createIterator() throws IOException {
            Map files;
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                if (this.memIters != null) {
                    throw new IllegalStateException("Tried to create new scan iterator w/o releasing memory");
                }
                if (Tablet.this.closed) {
                    throw new TabletClosedException();
                }
                if (this.interruptFlag.get()) {
                    throw new IterationInterruptedException(Tablet.this.extent.toString() + " " + this.interruptFlag.hashCode());
                }
                if (this.fileManager == null) {
                    this.fileManager = Tablet.this.tabletResources.newScanFileManager();
                    Tablet.this.activeScans.add(this);
                }
                if (this.fileManager.getNumOpenFiles() != 0) {
                    throw new IllegalStateException("Tried to create new scan iterator w/o releasing files");
                }
                this.expectedDeletionCount = Tablet.this.dataSourceDeletions.get();
                this.memIters = Tablet.this.tabletMemory.getIterators();
                Pair<Long, Map<FileRef, DataFileValue>> reservation = Tablet.this.datafileManager.reserveFilesForScan();
                this.fileReservationId = (Long)reservation.getFirst();
                files = (Map)reservation.getSecond();
            }
            List<InterruptibleIterator> mapfiles = this.fileManager.openFiles(files, this.options.isolated);
            ArrayList<InterruptibleIterator> iters = new ArrayList<InterruptibleIterator>(mapfiles.size() + this.memIters.size());
            iters.addAll(mapfiles);
            iters.addAll(this.memIters);
            for (SortedKeyValueIterator sortedKeyValueIterator : iters) {
                ((InterruptibleIterator)sortedKeyValueIterator).setInterruptFlag(this.interruptFlag);
            }
            MultiIterator multiIter = new MultiIterator(iters, Tablet.this.extent);
            TabletIteratorEnvironment tabletIteratorEnvironment = new TabletIteratorEnvironment(IteratorUtil.IteratorScope.scan, (AccumuloConfiguration)Tablet.this.acuTableConf, this.fileManager, files);
            this.statsIterator = new StatsIterator((SortedKeyValueIterator)multiIter, TabletServer.seekCount, Tablet.this.scannedCount);
            DeletingIterator delIter = new DeletingIterator((SortedKeyValueIterator)this.statsIterator, false);
            ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator((SortedKeyValueIterator)delIter);
            ColumnQualifierFilter colFilter = new ColumnQualifierFilter((SortedKeyValueIterator)cfsi, this.options.columnSet);
            VisibilityFilter visFilter = new VisibilityFilter((SortedKeyValueIterator)colFilter, this.options.authorizations, this.options.defaultLabels);
            return tabletIteratorEnvironment.getTopLevelIterator((SortedKeyValueIterator<Key, Value>)IteratorUtil.loadIterators((IteratorUtil.IteratorScope)IteratorUtil.IteratorScope.scan, (SortedKeyValueIterator)visFilter, (KeyExtent)Tablet.this.extent, (AccumuloConfiguration)Tablet.this.acuTableConf, this.options.ssiList, this.options.ssio, (IteratorEnvironment)tabletIteratorEnvironment));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean sawErrors) {
            if (this.memIters != null) {
                Tablet.this.tabletMemory.returnIterators(this.memIters);
                this.memIters = null;
                Tablet.this.datafileManager.returnFilesForScan(this.fileReservationId);
                this.fileReservationId = -1L;
            }
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                Tablet.this.activeScans.remove(this);
                if (Tablet.this.activeScans.size() == 0) {
                    Tablet.this.notifyAll();
                }
            }
            if (this.fileManager != null) {
                this.fileManager.releaseOpenFiles(sawErrors);
                this.fileManager = null;
            }
            if (this.statsIterator != null) {
                this.statsIterator.report();
            }
        }

        public void interrupt() {
            this.interruptFlag.set(true);
        }

        public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }
    }

    static class ScanOptions {
        Authorizations authorizations;
        byte[] defaultLabels;
        Set<Column> columnSet;
        List<IterInfo> ssiList;
        Map<String, Map<String, String>> ssio;
        AtomicBoolean interruptFlag;
        int num;
        boolean isolated;

        ScanOptions(int num, Authorizations authorizations, byte[] defaultLabels, Set<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag, boolean isolated) {
            this.num = num;
            this.authorizations = authorizations;
            this.defaultLabels = defaultLabels;
            this.columnSet = columnSet;
            this.ssiList = ssiList;
            this.ssio = ssio;
            this.interruptFlag = interruptFlag;
            this.isolated = isolated;
        }
    }

    class Scanner {
        private ScanOptions options;
        private Range range;
        private SortedKeyValueIterator<Key, Value> isolatedIter;
        private ScanDataSource isolatedDataSource;
        private boolean sawException = false;
        private boolean scanClosed = false;

        Scanner(Range range, ScanOptions options) {
            this.range = range;
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized ScanBatch read() throws IOException, TabletClosedException {
            ScanDataSource dataSource;
            if (this.sawException) {
                throw new IllegalStateException("Tried to use scanner after exception occurred.");
            }
            if (this.scanClosed) {
                throw new IllegalStateException("Tried to use scanner after it was closed.");
            }
            Batch results = null;
            if (this.options.isolated) {
                if (this.isolatedDataSource == null) {
                    this.isolatedDataSource = new ScanDataSource(this.options);
                }
                dataSource = this.isolatedDataSource;
            } else {
                dataSource = new ScanDataSource(this.options);
            }
            try {
                SortedKeyValueIterator<Key, Value> iter;
                if (this.options.isolated) {
                    if (this.isolatedIter == null) {
                        this.isolatedIter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource, true);
                    } else {
                        this.isolatedDataSource.fileManager.reattach();
                    }
                    iter = this.isolatedIter;
                } else {
                    iter = new SortedKeyValueIterator<Key, Value>((SourceSwitchingIterator.DataSource)dataSource, false);
                }
                results = Tablet.this.nextBatch((SortedKeyValueIterator<Key, Value>)iter, this.range, this.options.num, this.options.columnSet);
                if (results.results == null) {
                    this.range = null;
                    ScanBatch scanBatch = new ScanBatch(new ArrayList<KVEntry>(), false);
                    return scanBatch;
                }
                if (results.continueKey == null) {
                    ScanBatch scanBatch = new ScanBatch(results.results, false);
                    return scanBatch;
                }
                this.range = new Range(results.continueKey, !results.skipContinueKey, this.range.getEndKey(), this.range.isEndKeyInclusive());
                ScanBatch scanBatch = new ScanBatch(results.results, true);
                return scanBatch;
            }
            catch (IterationInterruptedException iie) {
                this.sawException = true;
                if (Tablet.this.isClosed()) {
                    throw new TabletClosedException((Exception)((Object)iie));
                }
                throw iie;
            }
            catch (IOException ioe) {
                if (Tablet.this.shutdownInProgress()) {
                    log.debug((Object)"IOException while shutdown in progress ", (Throwable)ioe);
                    throw new TabletClosedException(ioe);
                }
                this.sawException = true;
                dataSource.close(true);
                throw ioe;
            }
            catch (RuntimeException re) {
                this.sawException = true;
                throw re;
            }
            finally {
                if (!this.options.isolated) {
                    dataSource.close(false);
                } else if (dataSource.fileManager != null) {
                    dataSource.fileManager.detach();
                }
                Tablet tablet = Tablet.this;
                synchronized (tablet) {
                    if (results != null && results.results != null) {
                        long more = results.results.size();
                        Tablet.this.queryCount += more;
                        Tablet.this.queryBytes += results.numBytes;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            this.options.interruptFlag.set(true);
            Scanner scanner = this;
            synchronized (scanner) {
                this.scanClosed = true;
                if (this.isolatedDataSource != null) {
                    this.isolatedDataSource.close(false);
                }
            }
        }
    }

    class ScanBatch {
        boolean more;
        List<KVEntry> results;

        ScanBatch(List<KVEntry> results, boolean more) {
            this.results = results;
            this.more = more;
        }
    }

    private class Batch {
        public boolean skipContinueKey;
        public List<KVEntry> results;
        public Key continueKey;
        public long numBytes;

        private Batch() {
        }
    }

    class LookupResult {
        List<Range> unfinishedRanges = new ArrayList<Range>();
        long bytesAdded = 0L;
        long dataSize = 0L;
        boolean closed = false;

        LookupResult() {
        }
    }

    public static interface KVReceiver {
        public void receive(List<KVEntry> var1) throws IOException;
    }

    public static class KVEntry
    extends KeyValue {
        public KVEntry(Key k, Value v) {
            super(new Key(k), Arrays.copyOf(v.get(), v.get().length));
        }

        public String toString() {
            return this.key.toString() + "=" + this.getValue();
        }

        int numBytes() {
            return this.key.getSize() + this.getValue().get().length;
        }

        int estimateMemoryUsed() {
            return this.key.getSize() + this.getValue().get().length + 288;
        }
    }

    class DatafileManager {
        private final Map<FileRef, DataFileValue> datafileSizes = Collections.synchronizedMap(new TreeMap());
        FileRef mergingMinorCompactionFile = null;
        Set<FileRef> filesToDeleteAfterScan = new HashSet<FileRef>();
        Map<Long, Set<FileRef>> scanFileReservations = new HashMap<Long, Set<FileRef>>();
        MapCounter<FileRef> fileScanReferenceCounts = new MapCounter();
        long nextScanReservationId = 0L;
        boolean reservationsBlocked = false;
        Set<FileRef> majorCompactingFiles = new HashSet<FileRef>();

        DatafileManager(SortedMap<FileRef, DataFileValue> datafileSizes) {
            for (Map.Entry<FileRef, DataFileValue> datafiles : datafileSizes.entrySet()) {
                this.datafileSizes.put(datafiles.getKey(), datafiles.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Pair<Long, Map<FileRef, DataFileValue>> reserveFilesForScan() {
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                while (this.reservationsBlocked) {
                    try {
                        Tablet.this.wait(50L);
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)e, (Throwable)e);
                    }
                }
                HashSet<FileRef> absFilePaths = new HashSet<FileRef>(this.datafileSizes.keySet());
                long rid = this.nextScanReservationId++;
                this.scanFileReservations.put(rid, absFilePaths);
                HashMap<FileRef, DataFileValue> ret = new HashMap<FileRef, DataFileValue>();
                for (FileRef path : absFilePaths) {
                    this.fileScanReferenceCounts.increment((Object)path, 1L);
                    ret.put(path, this.datafileSizes.get(path));
                }
                return new Pair((Object)rid, ret);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void returnFilesForScan(Long reservationId) {
            HashSet<FileRef> filesToDelete = new HashSet<FileRef>();
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                Set<FileRef> absFilePaths = this.scanFileReservations.remove(reservationId);
                if (absFilePaths == null) {
                    throw new IllegalArgumentException("Unknown scan reservation id " + reservationId);
                }
                boolean notify = false;
                for (FileRef path : absFilePaths) {
                    long refCount = this.fileScanReferenceCounts.decrement((Object)path, 1L);
                    if (refCount == 0L) {
                        if (this.filesToDeleteAfterScan.remove(path)) {
                            filesToDelete.add(path);
                        }
                        notify = true;
                        continue;
                    }
                    if (refCount >= 0L) continue;
                    throw new IllegalStateException("Scan ref count for " + path + " is " + refCount);
                }
                if (notify) {
                    Tablet.this.notifyAll();
                }
            }
            if (filesToDelete.size() > 0) {
                log.debug((Object)("Removing scan refs from metadata " + Tablet.this.extent + " " + filesToDelete));
                MetadataTableUtil.removeScanFiles((KeyExtent)Tablet.this.extent, filesToDelete, (Credentials)SystemCredentials.get(), (ZooLock)Tablet.this.tabletServer.getLock());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFilesAfterScan(Set<FileRef> scanFiles) {
            if (scanFiles.size() == 0) {
                return;
            }
            HashSet<FileRef> filesToDelete = new HashSet<FileRef>();
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                for (FileRef path : scanFiles) {
                    if (this.fileScanReferenceCounts.get((Object)path) == 0L) {
                        filesToDelete.add(path);
                        continue;
                    }
                    this.filesToDeleteAfterScan.add(path);
                }
            }
            if (filesToDelete.size() > 0) {
                log.debug((Object)("Removing scan refs from metadata " + Tablet.this.extent + " " + filesToDelete));
                MetadataTableUtil.removeScanFiles((KeyExtent)Tablet.this.extent, filesToDelete, (Credentials)SystemCredentials.get(), (ZooLock)Tablet.this.tabletServer.getLock());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TreeSet<FileRef> waitForScansToFinish(Set<FileRef> pathsToWaitFor, boolean blockNewScans, long maxWaitTime) {
            long startTime = System.currentTimeMillis();
            TreeSet<FileRef> inUse = new TreeSet<FileRef>();
            Span waitForScans = Trace.start((String)"waitForScans");
            try {
                Tablet tablet = Tablet.this;
                synchronized (tablet) {
                    if (blockNewScans) {
                        if (this.reservationsBlocked) {
                            throw new IllegalStateException();
                        }
                        this.reservationsBlocked = true;
                    }
                    for (FileRef path : pathsToWaitFor) {
                        while (this.fileScanReferenceCounts.get((Object)path) > 0L && System.currentTimeMillis() - startTime < maxWaitTime) {
                            try {
                                Tablet.this.wait(100L);
                            }
                            catch (InterruptedException e) {
                                log.warn((Object)e, (Throwable)e);
                            }
                        }
                    }
                    for (FileRef path : pathsToWaitFor) {
                        if (this.fileScanReferenceCounts.get((Object)path) <= 0L) continue;
                        inUse.add(path);
                    }
                    if (blockNewScans) {
                        this.reservationsBlocked = false;
                        Tablet.this.notifyAll();
                    }
                }
            }
            finally {
                waitForScans.stop();
            }
            return inUse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void importMapFiles(long tid, Map<FileRef, DataFileValue> pathsString, boolean setTime) throws IOException {
            String bulkDir = null;
            HashMap<FileRef, DataFileValue> paths = new HashMap<FileRef, DataFileValue>();
            for (Map.Entry<FileRef, DataFileValue> entry : pathsString.entrySet()) {
                paths.put(entry.getKey(), entry.getValue());
            }
            for (FileRef fileRef : paths.keySet()) {
                boolean inTheRightDirectory = false;
                Path parent = fileRef.path().getParent().getParent();
                for (String tablesDir : ServerConstants.getTablesDirs()) {
                    if (!parent.equals((Object)new Path(tablesDir, Tablet.this.extent.getTableId().toString()))) continue;
                    inTheRightDirectory = true;
                    break;
                }
                if (!inTheRightDirectory) {
                    throw new IOException("Data file " + fileRef + " not in table dirs");
                }
                if (bulkDir == null) {
                    bulkDir = fileRef.path().getParent().toString();
                    continue;
                }
                if (bulkDir.equals(fileRef.path().getParent().toString())) continue;
                throw new IllegalArgumentException("bulk files in different dirs " + bulkDir + " " + fileRef);
            }
            if (Tablet.this.extent.isRootTablet()) {
                throw new IllegalArgumentException("Can not import files to root tablet");
            }
            Iterator i$ = Tablet.this.bulkFileImportLock;
            synchronized (i$) {
                Connector conn;
                SystemCredentials systemCredentials = SystemCredentials.get();
                try {
                    conn = HdfsZooInstance.getInstance().getConnector(systemCredentials.getPrincipal(), systemCredentials.getToken());
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
                List files = MetadataTableUtil.getBulkFilesLoaded((Connector)conn, (KeyExtent)Tablet.this.extent, (long)tid);
                for (FileRef file : files) {
                    if (!paths.keySet().remove(file)) continue;
                    log.debug((Object)("Ignoring request to re-import a file already imported: " + Tablet.this.extent + ": " + file));
                }
                if (paths.size() > 0) {
                    long bulkTime = Long.MIN_VALUE;
                    if (setTime) {
                        for (DataFileValue dfv : paths.values()) {
                            long nextTime = Tablet.this.tabletTime.getAndUpdateTime();
                            if (nextTime < bulkTime) {
                                throw new IllegalStateException("Time went backwards unexpectedly " + nextTime + " " + bulkTime);
                            }
                            bulkTime = nextTime;
                            dfv.setTime(bulkTime);
                        }
                    }
                    Object object = Tablet.this.timeLock;
                    synchronized (object) {
                        if (bulkTime > Tablet.this.persistedTime) {
                            Tablet.this.persistedTime = bulkTime;
                        }
                        MetadataTableUtil.updateTabletDataFile((long)tid, (KeyExtent)Tablet.this.extent, paths, (String)Tablet.this.tabletTime.getMetadataValue(Tablet.this.persistedTime), (Credentials)systemCredentials, (ZooLock)Tablet.this.tabletServer.getLock());
                    }
                }
            }
            i$ = Tablet.this;
            synchronized (i$) {
                for (Map.Entry tpath : paths.entrySet()) {
                    if (this.datafileSizes.containsKey(tpath.getKey())) {
                        log.error((Object)("Adding file that is already in set " + tpath.getKey()));
                    }
                    this.datafileSizes.put((FileRef)tpath.getKey(), (DataFileValue)tpath.getValue());
                }
                Tablet.this.tabletResources.importedMapFiles();
                Tablet.this.computeNumEntries();
            }
            for (Map.Entry entry : paths.entrySet()) {
                log.log((Priority)TLevel.TABLET_HIST, (Object)(Tablet.this.extent + " import " + entry.getKey() + " " + entry.getValue()));
            }
        }

        FileRef reserveMergingMinorCompactionFile() {
            if (this.mergingMinorCompactionFile != null) {
                throw new IllegalStateException("Tried to reserve merging minor compaction file when already reserved  : " + this.mergingMinorCompactionFile);
            }
            if (Tablet.this.extent.isRootTablet()) {
                return null;
            }
            int maxFiles = Tablet.this.acuTableConf.getMaxFilesPerTablet();
            if (this.majorCompactingFiles.size() > 0 && this.datafileSizes.size() == maxFiles) {
                return null;
            }
            if (this.datafileSizes.size() >= maxFiles) {
                long min = Long.MAX_VALUE;
                FileRef minName = null;
                for (Map.Entry<FileRef, DataFileValue> entry : this.datafileSizes.entrySet()) {
                    if (entry.getValue().getSize() >= min || this.majorCompactingFiles.contains(entry.getKey())) continue;
                    min = entry.getValue().getSize();
                    minName = entry.getKey();
                }
                if (minName == null) {
                    return null;
                }
                this.mergingMinorCompactionFile = minName;
                return minName;
            }
            return null;
        }

        void unreserveMergingMinorCompactionFile(FileRef file) {
            if (file == null && this.mergingMinorCompactionFile != null || file != null && this.mergingMinorCompactionFile == null || file != null && this.mergingMinorCompactionFile != null && !file.equals((Object)this.mergingMinorCompactionFile)) {
                throw new IllegalStateException("Disagreement " + file + " " + this.mergingMinorCompactionFile);
            }
            this.mergingMinorCompactionFile = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void bringMinorCompactionOnline(FileRef tmpDatafile, FileRef newDatafile, FileRef absMergeFile, DataFileValue dfv, CommitSession commitSession, long flushId) throws IOException {
            long t2;
            long t1;
            Object object;
            IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
            if (Tablet.this.extent.isRootTablet()) {
                try {
                    if (!zoo.isLockHeld(Tablet.this.tabletServer.getLock().getLockID())) {
                        throw new IllegalStateException();
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can not bring major compaction online, lock not held", e);
                }
            }
            while (true) {
                try {
                    if (dfv.getNumEntries() == 0L) {
                        Tablet.this.fs.deleteRecursively(tmpDatafile.path());
                        break;
                    }
                    if (Tablet.this.fs.exists(newDatafile.path())) {
                        log.warn((Object)("Target map file already exist " + newDatafile));
                        Tablet.this.fs.deleteRecursively(newDatafile.path());
                    }
                    Tablet.rename(Tablet.this.fs, tmpDatafile.path(), newDatafile.path());
                }
                catch (IOException ioe) {
                    log.warn((Object)("Tablet " + Tablet.this.extent + " failed to rename " + newDatafile + " after MinC, will retry in 60 secs..."), (Throwable)ioe);
                    UtilWaitThread.sleep((long)60000L);
                    continue;
                }
                break;
            }
            Set<FileRef> filesInUseByScans = Collections.emptySet();
            if (absMergeFile != null) {
                filesInUseByScans = Collections.singleton(absMergeFile);
            }
            if (absMergeFile != null) {
                MetadataTableUtil.addDeleteEntries((KeyExtent)Tablet.this.extent, Collections.singleton(absMergeFile), (Credentials)SystemCredentials.get());
            }
            Set unusedWalLogs = Tablet.this.beginClearingUnusedLogs();
            try {
                object = Tablet.this.timeLock;
                synchronized (object) {
                    if (commitSession.getMaxCommittedTime() > Tablet.this.persistedTime) {
                        Tablet.this.persistedTime = commitSession.getMaxCommittedTime();
                    }
                    String time = Tablet.this.tabletTime.getMetadataValue(Tablet.this.persistedTime);
                    MasterMetadataUtil.updateTabletDataFile((KeyExtent)Tablet.this.extent, (FileRef)newDatafile, (FileRef)absMergeFile, (DataFileValue)dfv, (String)time, (Credentials)SystemCredentials.get(), filesInUseByScans, (String)Tablet.this.tabletServer.getClientAddressString(), (ZooLock)Tablet.this.tabletServer.getLock(), (Set)unusedWalLogs, (TServerInstance)Tablet.this.lastLocation, (long)flushId);
                }
            }
            finally {
                Tablet.this.finishClearingUnusedLogs();
            }
            while (true) {
                try {
                    Tablet.this.tabletServer.minorCompactionFinished(Tablet.this.tabletMemory.getCommitSession(), newDatafile.toString(), commitSession.getWALogSeq() + 2);
                }
                catch (IOException e) {
                    log.error((Object)("Failed to write to write-ahead log " + e.getMessage() + " will retry"), (Throwable)e);
                    UtilWaitThread.sleep((long)1000L);
                    continue;
                }
                break;
            }
            object = Tablet.this;
            synchronized (object) {
                Tablet.this.lastLocation = null;
                t1 = System.currentTimeMillis();
                if (this.datafileSizes.containsKey(newDatafile)) {
                    log.error((Object)("Adding file that is already in set " + newDatafile));
                }
                if (dfv.getNumEntries() > 0L) {
                    this.datafileSizes.put(newDatafile, dfv);
                }
                if (absMergeFile != null) {
                    this.datafileSizes.remove(absMergeFile);
                }
                this.unreserveMergingMinorCompactionFile(absMergeFile);
                Tablet.this.dataSourceDeletions.incrementAndGet();
                Tablet.this.tabletMemory.finishedMinC();
                Tablet.this.lastFlushID = flushId;
                Tablet.this.computeNumEntries();
                t2 = System.currentTimeMillis();
            }
            this.removeFilesAfterScan(filesInUseByScans);
            if (absMergeFile != null) {
                log.log((Priority)TLevel.TABLET_HIST, (Object)(Tablet.this.extent + " MinC [" + absMergeFile + ",memory] -> " + newDatafile));
            } else {
                log.log((Priority)TLevel.TABLET_HIST, (Object)(Tablet.this.extent + " MinC [memory] -> " + newDatafile));
            }
            log.debug((Object)String.format("MinC finish lock %.2f secs %s", (double)(t2 - t1) / 1000.0, Tablet.this.getExtent().toString()));
            if (dfv.getSize() > Tablet.this.acuTableConf.getMemoryInBytes(Property.TABLE_SPLIT_THRESHOLD)) {
                log.debug((Object)String.format("Minor Compaction wrote out file larger than split threshold.  split threshold = %,d  file size = %,d", Tablet.this.acuTableConf.getMemoryInBytes(Property.TABLE_SPLIT_THRESHOLD), dfv.getSize()));
            }
        }

        public void reserveMajorCompactingFiles(Collection<FileRef> files) {
            if (this.majorCompactingFiles.size() != 0) {
                throw new IllegalStateException("Major compacting files not empty " + this.majorCompactingFiles);
            }
            if (this.mergingMinorCompactionFile != null && files.contains(this.mergingMinorCompactionFile)) {
                throw new IllegalStateException("Major compaction tried to resrve file in use by minor compaction " + this.mergingMinorCompactionFile);
            }
            this.majorCompactingFiles.addAll(files);
        }

        public void clearMajorCompactingFile() {
            this.majorCompactingFiles.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void bringMajorCompactionOnline(Set<FileRef> oldDatafiles, FileRef tmpDatafile, FileRef newDatafile, Long compactionId, DataFileValue dfv) throws IOException {
            long t2;
            long t1;
            if (!Tablet.this.extent.isRootTablet()) {
                if (Tablet.this.fs.exists(newDatafile.path())) {
                    log.error((Object)("Target map file already exist " + newDatafile), (Throwable)new Exception());
                    throw new IllegalStateException("Target map file already exist " + newDatafile);
                }
                Tablet.rename(Tablet.this.fs, tmpDatafile.path(), newDatafile.path());
                if (dfv.getNumEntries() == 0L) {
                    Tablet.this.fs.deleteRecursively(newDatafile.path());
                }
            }
            TServerInstance lastLocation = null;
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                t1 = System.currentTimeMillis();
                IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
                Tablet.this.dataSourceDeletions.incrementAndGet();
                if (Tablet.this.extent.isRootTablet()) {
                    this.waitForScansToFinish(oldDatafiles, true, Long.MAX_VALUE);
                    try {
                        if (!zoo.isLockHeld(Tablet.this.tabletServer.getLock().getLockID())) {
                            throw new IllegalStateException();
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Can not bring major compaction online, lock not held", e);
                    }
                    RootFiles.replaceFiles((AccumuloConfiguration)Tablet.this.acuTableConf, Tablet.this.fs, Tablet.this.location, oldDatafiles, tmpDatafile, newDatafile);
                }
                for (FileRef oldDatafile : oldDatafiles) {
                    if (!this.datafileSizes.containsKey(oldDatafile)) {
                        log.error((Object)("file does not exist in set " + oldDatafile));
                    }
                    this.datafileSizes.remove(oldDatafile);
                    this.majorCompactingFiles.remove(oldDatafile);
                }
                if (this.datafileSizes.containsKey(newDatafile)) {
                    log.error((Object)("Adding file that is already in set " + newDatafile));
                }
                if (dfv.getNumEntries() > 0L) {
                    this.datafileSizes.put(newDatafile, dfv);
                }
                this.majorCompactingFiles.add(newDatafile);
                Tablet.this.computeNumEntries();
                lastLocation = Tablet.this.lastLocation;
                Tablet.this.lastLocation = null;
                if (compactionId != null) {
                    Tablet.this.lastCompactID = compactionId;
                }
                t2 = System.currentTimeMillis();
            }
            if (!Tablet.this.extent.isRootTablet()) {
                TreeSet<FileRef> filesInUseByScans = this.waitForScansToFinish(oldDatafiles, false, 10000L);
                if (filesInUseByScans.size() > 0) {
                    log.debug((Object)("Adding scan refs to metadata " + Tablet.this.extent + " " + filesInUseByScans));
                }
                MasterMetadataUtil.replaceDatafiles((KeyExtent)Tablet.this.extent, oldDatafiles, filesInUseByScans, (FileRef)newDatafile, (Long)compactionId, (DataFileValue)dfv, (Credentials)SystemCredentials.get(), (String)Tablet.this.tabletServer.getClientAddressString(), (TServerInstance)lastLocation, (ZooLock)Tablet.this.tabletServer.getLock());
                this.removeFilesAfterScan(filesInUseByScans);
            }
            log.debug((Object)String.format("MajC finish lock %.2f secs", (double)(t2 - t1) / 1000.0));
            log.log((Priority)TLevel.TABLET_HIST, (Object)(Tablet.this.extent + " MajC " + oldDatafiles + " --> " + newDatafile));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap<FileRef, DataFileValue> getDatafileSizes() {
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                TreeMap<FileRef, DataFileValue> copy = new TreeMap<FileRef, DataFileValue>(this.datafileSizes);
                return Collections.unmodifiableSortedMap(copy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<FileRef> getFiles() {
            Tablet tablet = Tablet.this;
            synchronized (tablet) {
                HashSet<FileRef> files = new HashSet<FileRef>(this.datafileSizes.keySet());
                return Collections.unmodifiableSet(files);
            }
        }
    }

    public static class TabletClosedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TabletClosedException(Exception e) {
            super(e);
        }

        public TabletClosedException() {
        }
    }

    private class TabletMemory {
        private InMemoryMap memTable;
        private InMemoryMap otherMemTable;
        private InMemoryMap deletingMemTable;
        private int nextSeq = 1;
        private CommitSession commitSession;

        TabletMemory() {
            try {
                this.memTable = new InMemoryMap((AccumuloConfiguration)Tablet.this.acuTableConf);
            }
            catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
                throw new RuntimeException(e);
            }
            this.commitSession = new CommitSession(this.nextSeq, this.memTable);
            this.nextSeq += 2;
        }

        InMemoryMap getMemTable() {
            return this.memTable;
        }

        InMemoryMap getMinCMemTable() {
            return this.otherMemTable;
        }

        CommitSession prepareForMinC() {
            if (this.otherMemTable != null) {
                throw new IllegalStateException();
            }
            if (this.deletingMemTable != null) {
                throw new IllegalStateException();
            }
            this.otherMemTable = this.memTable;
            try {
                this.memTable = new InMemoryMap((AccumuloConfiguration)Tablet.this.acuTableConf);
            }
            catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
                throw new RuntimeException(e);
            }
            CommitSession oldCommitSession = this.commitSession;
            this.commitSession = new CommitSession(this.nextSeq, this.memTable);
            this.nextSeq += 2;
            Tablet.this.tabletResources.updateMemoryUsageStats(this.memTable.estimatedSizeInBytes(), this.otherMemTable.estimatedSizeInBytes());
            return oldCommitSession;
        }

        void finishedMinC() {
            if (this.otherMemTable == null) {
                throw new IllegalStateException();
            }
            if (this.deletingMemTable != null) {
                throw new IllegalStateException();
            }
            this.deletingMemTable = this.otherMemTable;
            this.otherMemTable = null;
            Tablet.this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finalizeMinC() {
            try {
                this.deletingMemTable.delete(15000L);
            }
            finally {
                Tablet tablet = Tablet.this;
                synchronized (tablet) {
                    if (this.otherMemTable != null) {
                        throw new IllegalStateException();
                    }
                    if (this.deletingMemTable == null) {
                        throw new IllegalStateException();
                    }
                    this.deletingMemTable = null;
                    Tablet.this.tabletResources.updateMemoryUsageStats(this.memTable.estimatedSizeInBytes(), 0L);
                }
            }
        }

        boolean memoryReservedForMinC() {
            return this.otherMemTable != null || this.deletingMemTable != null;
        }

        void waitForMinC() {
            while (this.otherMemTable != null || this.deletingMemTable != null) {
                try {
                    Tablet.this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }

        void mutate(CommitSession cm, List<Mutation> mutations) {
            cm.memTable.mutate(mutations);
        }

        void updateMemoryUsageStats() {
            long other = 0L;
            if (this.otherMemTable != null) {
                other = this.otherMemTable.estimatedSizeInBytes();
            } else if (this.deletingMemTable != null) {
                other = this.deletingMemTable.estimatedSizeInBytes();
            }
            Tablet.this.tabletResources.updateMemoryUsageStats(this.memTable.estimatedSizeInBytes(), other);
        }

        List<InMemoryMap.MemoryIterator> getIterators() {
            ArrayList<InMemoryMap.MemoryIterator> toReturn = new ArrayList<InMemoryMap.MemoryIterator>(2);
            toReturn.add(this.memTable.skvIterator());
            if (this.otherMemTable != null) {
                toReturn.add(this.otherMemTable.skvIterator());
            }
            return toReturn;
        }

        void returnIterators(List<InMemoryMap.MemoryIterator> iters) {
            for (InMemoryMap.MemoryIterator iter : iters) {
                iter.close();
            }
        }

        public long getNumEntries() {
            if (this.otherMemTable != null) {
                return this.memTable.getNumEntries() + this.otherMemTable.getNumEntries();
            }
            return this.memTable.getNumEntries();
        }

        CommitSession getCommitSession() {
            return this.commitSession;
        }
    }

    public class CommitSession {
        private int seq;
        private InMemoryMap memTable;
        private int commitsInProgress;
        private long maxCommittedTime = Long.MIN_VALUE;

        private CommitSession(int seq, InMemoryMap imm) {
            this.seq = seq;
            this.memTable = imm;
            this.commitsInProgress = 0;
        }

        public int getWALogSeq() {
            return this.seq;
        }

        private void decrementCommitsInProgress() {
            if (this.commitsInProgress < 1) {
                throw new IllegalStateException("commitsInProgress = " + this.commitsInProgress);
            }
            --this.commitsInProgress;
            if (this.commitsInProgress == 0) {
                Tablet.this.notifyAll();
            }
        }

        private void incrementCommitsInProgress() {
            if (this.commitsInProgress < 0) {
                throw new IllegalStateException("commitsInProgress = " + this.commitsInProgress);
            }
            ++this.commitsInProgress;
        }

        private void waitForCommitsToFinish() {
            while (this.commitsInProgress > 0) {
                try {
                    Tablet.this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }

        public void abortCommit(List<Mutation> value) {
            Tablet.this.abortCommit(this, value);
        }

        public void commit(List<Mutation> mutations) {
            Tablet.this.commit(this, mutations);
        }

        public Tablet getTablet() {
            return Tablet.this;
        }

        public boolean beginUpdatingLogsUsed(ArrayList<DfsLogger> copy, boolean mincFinish) {
            return Tablet.this.beginUpdatingLogsUsed(this.memTable, copy, mincFinish);
        }

        public void finishUpdatingLogsUsed() {
            Tablet.this.finishUpdatingLogsUsed();
        }

        public int getLogId() {
            return Tablet.this.logId;
        }

        public KeyExtent getExtent() {
            return Tablet.this.extent;
        }

        private void updateMaxCommittedTime(long time) {
            this.maxCommittedTime = Math.max(time, this.maxCommittedTime);
        }

        private long getMaxCommittedTime() {
            if (this.maxCommittedTime == Long.MIN_VALUE) {
                throw new IllegalStateException("Tried to read max committed time when it was never set");
            }
            return this.maxCommittedTime;
        }
    }

    static enum MinorCompactionReason {
        USER,
        SYSTEM,
        CLOSE;

    }
}

