/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.FileManager;
import org.apache.hadoop.fs.Path;

public class TabletIteratorEnvironment
implements IteratorEnvironment {
    private final FileManager.ScanFileManager trm;
    private final IteratorUtil.IteratorScope scope;
    private final boolean fullMajorCompaction;
    private final AccumuloConfiguration config;
    private final ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators = new ArrayList();
    private Map<FileRef, DataFileValue> files;

    TabletIteratorEnvironment(IteratorUtil.IteratorScope scope, AccumuloConfiguration config) {
        if (scope == IteratorUtil.IteratorScope.majc) {
            throw new IllegalArgumentException("must set if compaction is full");
        }
        this.scope = scope;
        this.trm = null;
        this.config = config;
        this.fullMajorCompaction = false;
    }

    TabletIteratorEnvironment(IteratorUtil.IteratorScope scope, AccumuloConfiguration config, FileManager.ScanFileManager trm, Map<FileRef, DataFileValue> files) {
        if (scope == IteratorUtil.IteratorScope.majc) {
            throw new IllegalArgumentException("must set if compaction is full");
        }
        this.scope = scope;
        this.trm = trm;
        this.config = config;
        this.fullMajorCompaction = false;
        this.files = files;
    }

    TabletIteratorEnvironment(IteratorUtil.IteratorScope scope, boolean fullMajC, AccumuloConfiguration config) {
        if (scope != IteratorUtil.IteratorScope.majc) {
            throw new IllegalArgumentException("Tried to set maj compaction type when scope was " + scope);
        }
        this.scope = scope;
        this.trm = null;
        this.config = config;
        this.fullMajorCompaction = fullMajC;
    }

    public AccumuloConfiguration getConfig() {
        return this.config;
    }

    public IteratorUtil.IteratorScope getIteratorScope() {
        return this.scope;
    }

    public boolean isFullMajorCompaction() {
        if (this.scope != IteratorUtil.IteratorScope.majc) {
            throw new IllegalStateException("Asked about major compaction type when scope is " + this.scope);
        }
        return this.fullMajorCompaction;
    }

    public SortedKeyValueIterator<Key, Value> reserveMapFileReader(String mapFileName) throws IOException {
        FileRef ref = new FileRef(mapFileName, new Path(mapFileName));
        return (SortedKeyValueIterator)this.trm.openFiles(Collections.singletonMap(ref, this.files.get(ref)), false).get(0);
    }

    public void registerSideChannel(SortedKeyValueIterator<Key, Value> iter) {
        this.topLevelIterators.add(iter);
    }

    SortedKeyValueIterator<Key, Value> getTopLevelIterator(SortedKeyValueIterator<Key, Value> iter) {
        if (this.topLevelIterators.isEmpty()) {
            return iter;
        }
        ArrayList<SortedKeyValueIterator<Key, Value>> allIters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.topLevelIterators);
        allIters.add(iter);
        return new MultiIterator(allIters, false);
    }
}

