/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.net.HostAndPort;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.CompressedIterators;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletType;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.InitialMultiScan;
import org.apache.accumulo.core.data.thrift.InitialScan;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.data.thrift.MultiScanResult;
import org.apache.accumulo.core.data.thrift.ScanResult;
import org.apache.accumulo.core.data.thrift.TCMResult;
import org.apache.accumulo.core.data.thrift.TCMStatus;
import org.apache.accumulo.core.data.thrift.TColumn;
import org.apache.accumulo.core.data.thrift.TCondition;
import org.apache.accumulo.core.data.thrift.TConditionalMutation;
import org.apache.accumulo.core.data.thrift.TConditionalSession;
import org.apache.accumulo.core.data.thrift.TKey;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TKeyValue;
import org.apache.accumulo.core.data.thrift.TMutation;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.data.thrift.UpdateErrors;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.master.thrift.Compacting;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.AuthorizationContainer;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.ScanState;
import org.apache.accumulo.core.tabletserver.thrift.ScanType;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.LoggingRunnable;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.master.recovery.RecoveryPath;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.accumulo.server.metrics.AbstractMetricsImpl;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.util.FileSystemMonitor;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.TServerUtils;
import org.apache.accumulo.server.util.time.RelativeTime;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.thrift.TraceWrap;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.accumulo.tserver.BulkFailedCopyProcessor;
import org.apache.accumulo.tserver.CompactionWatcher;
import org.apache.accumulo.tserver.Compactor;
import org.apache.accumulo.tserver.ConditionalMutationSet;
import org.apache.accumulo.tserver.HoldTimeoutException;
import org.apache.accumulo.tserver.RowLocks;
import org.apache.accumulo.tserver.ScanRunState;
import org.apache.accumulo.tserver.Tablet;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.LogSorter;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.TabletServerLogger;
import org.apache.accumulo.tserver.mastermessage.MasterMessage;
import org.apache.accumulo.tserver.mastermessage.SplitReportMessage;
import org.apache.accumulo.tserver.mastermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.metrics.TabletServerMBean;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerUpdateMetrics;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.server.TServer;
import org.apache.zookeeper.KeeperException;

public class TabletServer
extends AbstractMetricsImpl
implements TabletServerMBean {
    private static final Logger log = Logger.getLogger(TabletServer.class);
    private static HashMap<String, Long> prevGcTime = new HashMap();
    private static long lastMemorySize = 0L;
    private static long gcTimeIncreasedCount;
    private static final long MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS = 1000L;
    private static final long RECENTLY_SPLIT_MILLIES = 60000L;
    private TabletServerLogger logger;
    protected TabletServerMinCMetrics mincMetrics = new TabletServerMinCMetrics();
    private ServerConfiguration serverConfig;
    private LogSorter logSorter = null;
    private TabletStatsKeeper statsKeeper;
    TransactionWatcher watcher = new TransactionWatcher();
    public long lastPingTime = System.currentTimeMillis();
    public Socket currentMaster;
    private BlockingDeque<MasterMessage> masterMessages = new LinkedBlockingDeque<MasterMessage>();
    private VolumeManager fs;
    private Instance instance;
    private final SortedMap<KeyExtent, Tablet> onlineTablets = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedSet<KeyExtent> unopenedTablets = Collections.synchronizedSortedSet(new TreeSet());
    private final SortedSet<KeyExtent> openingTablets = Collections.synchronizedSortedSet(new TreeSet());
    private final Map<KeyExtent, Long> recentlyUnloadedCache = Collections.synchronizedMap(new LRUMap(1000));
    private Thread majorCompactorThread;
    private volatile boolean serverStopRequested = false;
    private HostAndPort clientAddress;
    private TabletServerResourceManager resourceManager;
    private SecurityOperation security;
    private volatile boolean majorCompactorDisabled = false;
    private volatile boolean shutdownComplete = false;
    private ZooLock tabletServerLock;
    private TServer server;
    private DistributedWorkQueue bulkFailedCopyQ;
    private String lockID;
    private static final String METRICS_PREFIX = "tserver";
    private static ObjectName OBJECT_NAME;
    static AtomicLong seekCount;
    private long totalMinorCompactions;
    private final AtomicInteger logIdGenerator = new AtomicInteger();

    public TabletServer(ServerConfiguration conf, VolumeManager fs) {
        this.serverConfig = conf;
        this.instance = conf.getInstance();
        this.fs = fs;
        this.logSorter = new LogSorter(this.instance, fs, this.getSystemConfiguration());
        SimpleTimer.getInstance().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SortedMap sortedMap = TabletServer.this.onlineTablets;
                synchronized (sortedMap) {
                    long now = System.currentTimeMillis();
                    for (Tablet tablet : TabletServer.this.onlineTablets.values()) {
                        try {
                            tablet.updateRates(now);
                        }
                        catch (Exception ex) {
                            log.error((Object)ex, (Throwable)ex);
                        }
                    }
                }
            }
        }, 5000L, 5000L);
    }

    private static synchronized void logGCInfo(AccumuloConfiguration conf) {
        long keepAliveTimeout;
        List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
        Runtime rt = Runtime.getRuntime();
        StringBuilder sb = new StringBuilder("gc");
        boolean sawChange = false;
        long maxIncreaseInCollectionTime = 0L;
        for (GarbageCollectorMXBean gcBean : gcmBeans) {
            long time;
            Long prevTime = prevGcTime.get(gcBean.getName());
            long pt = 0L;
            if (prevTime != null) {
                pt = prevTime;
            }
            if ((time = gcBean.getCollectionTime()) - pt != 0L) {
                sawChange = true;
            }
            long increaseInCollectionTime = time - pt;
            sb.append(String.format(" %s=%,.2f(+%,.2f) secs", gcBean.getName(), (double)time / 1000.0, (double)increaseInCollectionTime / 1000.0));
            maxIncreaseInCollectionTime = Math.max(increaseInCollectionTime, maxIncreaseInCollectionTime);
            prevGcTime.put(gcBean.getName(), time);
        }
        long mem = rt.freeMemory();
        if (maxIncreaseInCollectionTime == 0L) {
            gcTimeIncreasedCount = 0L;
        } else if (++gcTimeIncreasedCount > 3L && (double)mem < (double)rt.maxMemory() * 0.05) {
            log.warn((Object)"Running low on memory");
            gcTimeIncreasedCount = 0L;
        }
        if (mem > lastMemorySize) {
            sawChange = true;
        }
        String sign = "+";
        if (mem - lastMemorySize <= 0L) {
            sign = "";
        }
        sb.append(String.format(" freemem=%,d(%s%,d) totalmem=%,d", mem, sign, mem - lastMemorySize, rt.totalMemory()));
        if (sawChange) {
            log.debug((Object)sb.toString());
        }
        if (maxIncreaseInCollectionTime > (keepAliveTimeout = conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT))) {
            Halt.halt((String)"Garbage collection may be interfering with lock keep-alive.  Halting.", (int)-1);
        }
        lastMemorySize = mem;
    }

    public AccumuloConfiguration getSystemConfiguration() {
        return this.serverConfig.getConfiguration();
    }

    boolean isMajorCompactionDisabled() {
        return this.majorCompactorDisabled;
    }

    void executeSplit(Tablet tablet) {
        this.resourceManager.executeSplit(tablet.getExtent(), (Runnable)new LoggingRunnable(log, (Runnable)new SplitRunner(tablet)));
    }

    private void splitTablet(Tablet tablet) {
        try {
            TreeMap<KeyExtent, Tablet.SplitInfo> tabletInfo = this.splitTablet(tablet, null);
            if (tabletInfo == null) {
                tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
        }
        catch (IOException e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, 0L, true);
            log.error((Object)("split failed: " + e.getMessage() + " for tablet " + tablet.getExtent()), (Throwable)e);
        }
        catch (Exception e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, 0L, true);
            log.error((Object)("Unknown error on split: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap<KeyExtent, Tablet.SplitInfo> splitTablet(Tablet tablet, byte[] splitPoint) throws IOException {
        long t1 = System.currentTimeMillis();
        TreeMap<KeyExtent, Tablet.SplitInfo> tabletInfo = tablet.split(splitPoint);
        if (tabletInfo == null) {
            return null;
        }
        log.info((Object)("Starting split: " + tablet.getExtent()));
        this.statsKeeper.incrementStatusSplit();
        long start = System.currentTimeMillis();
        Tablet[] newTablets = new Tablet[2];
        Map.Entry<KeyExtent, Tablet.SplitInfo> first = tabletInfo.firstEntry();
        newTablets[0] = new Tablet(first.getKey(), this, this.resourceManager.createTabletResourceManager(), first.getValue());
        Map.Entry<KeyExtent, Tablet.SplitInfo> last = tabletInfo.lastEntry();
        newTablets[1] = new Tablet(last.getKey(), this, this.resourceManager.createTabletResourceManager(), last.getValue());
        this.statsKeeper.saveMinorTimes(tablet.timer);
        this.statsKeeper.saveMajorTimes(tablet.timer);
        SortedMap<KeyExtent, Tablet> sortedMap = this.onlineTablets;
        synchronized (sortedMap) {
            this.onlineTablets.remove(tablet.getExtent());
            this.onlineTablets.put(newTablets[0].getExtent(), newTablets[0]);
            this.onlineTablets.put(newTablets[1].getExtent(), newTablets[1]);
        }
        this.enqueueMasterMessage(new SplitReportMessage(tablet.getExtent(), newTablets[0].getExtent(), new Text("/" + newTablets[0].getLocation().getName()), newTablets[1].getExtent(), new Text("/" + newTablets[1].getLocation().getName())));
        this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, start, 0L, false);
        long t2 = System.currentTimeMillis();
        log.info((Object)("Tablet split: " + tablet.getExtent() + " size0 " + newTablets[0].estimateTabletSize() + " size1 " + newTablets[1].estimateTabletSize() + " time " + (t2 - t1) + "ms"));
        return tabletInfo;
    }

    void enqueueMasterMessage(MasterMessage m) {
        this.masterMessages.addLast(m);
    }

    public TabletStatsKeeper getStatsKeeper() {
        return this.statsKeeper;
    }

    public void addLoggersToMetadata(List<DfsLogger> logs, KeyExtent extent, int id) {
        if (!this.onlineTablets.containsKey(extent)) {
            log.info((Object)("Not adding " + logs.size() + " logs for extent " + extent + " as alias " + id + " tablet is offline"));
            return;
        }
        log.info((Object)("Adding " + logs.size() + " logs for extent " + extent + " as alias " + id));
        long now = RelativeTime.currentTimeMillis();
        ArrayList<String> logSet = new ArrayList<String>();
        for (DfsLogger log : logs) {
            logSet.add(log.getFileName());
        }
        LogEntry entry = new LogEntry();
        entry.extent = extent;
        entry.tabletId = id;
        entry.timestamp = now;
        entry.server = logs.get(0).getLogger();
        entry.filename = logs.get(0).getFileName();
        entry.logSet = logSet;
        MetadataTableUtil.addLogEntry((Credentials)SystemCredentials.get(), (LogEntry)entry, (ZooLock)this.getLock());
    }

    private HostAndPort startServer(AccumuloConfiguration conf, String address, Property portHint, TProcessor processor, String threadName) throws UnknownHostException {
        Property maxMessageSizeProperty = conf.get(Property.TSERV_MAX_MESSAGE_SIZE) != null ? Property.TSERV_MAX_MESSAGE_SIZE : Property.GENERAL_MAX_MESSAGE_SIZE;
        TServerUtils.ServerAddress sp = TServerUtils.startServer((AccumuloConfiguration)conf, (String)address, (Property)portHint, (TProcessor)processor, (String)this.getClass().getSimpleName(), (String)threadName, (Property)Property.TSERV_PORTSEARCH, (Property)Property.TSERV_MINTHREADS, (Property)Property.TSERV_THREADCHECK, (Property)maxMessageSizeProperty);
        this.server = sp.server;
        return sp.address;
    }

    private String getMasterAddress() {
        try {
            List locations = this.instance.getMasterLocations();
            if (locations.size() == 0) {
                return null;
            }
            return (String)locations.get(0);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to obtain master host " + e));
            return null;
        }
    }

    private MasterClientService.Client masterConnection(String address) {
        try {
            if (address == null) {
                return null;
            }
            MasterClientService.Client client = (MasterClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new MasterClientService.Client.Factory(), (String)address, (Property)Property.GENERAL_RPC_TIMEOUT, (AccumuloConfiguration)this.getSystemConfiguration());
            return client;
        }
        catch (Exception e) {
            log.warn((Object)("Issue with masterConnection (" + address + ") " + e), (Throwable)e);
            return null;
        }
    }

    private void returnMasterConnection(MasterClientService.Client client) {
        ThriftUtil.returnClient((TServiceClient)client);
    }

    private HostAndPort startTabletClientService() throws UnknownHostException {
        TabletClientService.Iface tch = (TabletClientService.Iface)TraceWrap.service((Object)((Object)new ThriftClientHandler()));
        TabletClientService.Processor processor = new TabletClientService.Processor(tch);
        HostAndPort address = this.startServer(this.getSystemConfiguration(), this.clientAddress.getHostText(), Property.TSERV_CLIENTPORT, (TProcessor)processor, "Thrift Client Server");
        log.info((Object)("address = " + address));
        return address;
    }

    ZooLock getLock() {
        return this.tabletServerLock;
    }

    private void announceExistence() {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            String zPath = ZooUtil.getRoot((Instance)this.instance) + "/tservers" + "/" + this.getClientAddressString();
            zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            this.tabletServerLock = new ZooLock(zPath);
            ZooLock.LockWatcher lw = new ZooLock.LockWatcher(){

                public void lostLock(final ZooLock.LockLossReason reason) {
                    Halt.halt((int)0, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!TabletServer.this.serverStopRequested) {
                                log.fatal((Object)("Lost tablet server lock (reason = " + reason + "), exiting."));
                            }
                            TabletServer.logGCInfo(TabletServer.this.getSystemConfiguration());
                        }
                    });
                }

                public void unableToMonitorLockNode(final Throwable e) {
                    Halt.halt((int)0, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            log.fatal((Object)"Lost ability to monitor tablet server lock, exiting.", e);
                        }
                    });
                }
            };
            byte[] lockContent = new ServerServices(this.getClientAddressString(), ServerServices.Service.TSERV_CLIENT).toString().getBytes(Constants.UTF8);
            for (int i = 0; i < 24; ++i) {
                zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                if (this.tabletServerLock.tryLock(lw, lockContent)) {
                    log.debug((Object)("Obtained tablet server lock " + this.tabletServerLock.getLockPath()));
                    this.lockID = this.tabletServerLock.getLockID().serialize(ZooUtil.getRoot((Instance)this.instance) + "/tservers" + "/");
                    return;
                }
                log.info((Object)"Waiting for tablet server lock");
                UtilWaitThread.sleep((long)5000L);
            }
            String msg = "Too many retries, exiting.";
            log.info((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.info((Object)"Could not obtain tablet server lock, exiting.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SecurityUtil.serverLogin((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
        try {
            this.clientAddress = this.startTabletClientService();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the tablet client service", e1);
        }
        this.announceExistence();
        SimpleThreadPool distWorkQThreadPool = new SimpleThreadPool(this.getSystemConfiguration().getCount(Property.TSERV_WORKQ_THREADS), "distributed work queue");
        this.bulkFailedCopyQ = new DistributedWorkQueue(ZooUtil.getRoot((Instance)this.instance) + "/bulk_failed_copyq");
        try {
            this.bulkFailedCopyQ.startProcessing((DistributedWorkQueue.Processor)new BulkFailedCopyProcessor(), (ThreadPoolExecutor)distWorkQThreadPool);
        }
        catch (Exception e1) {
            throw new RuntimeException("Failed to start distributed work queue for copying ", e1);
        }
        try {
            this.logSorter.startWatchingForRecoveryLogs((ThreadPoolExecutor)distWorkQThreadPool);
        }
        catch (Exception ex) {
            log.error((Object)"Error setting watches for recoveries");
            throw new RuntimeException(ex);
        }
        try {
            OBJECT_NAME = new ObjectName("accumulo.server.metrics:service=TServerInfo,name=TabletServerMBean,instance=" + Thread.currentThread().getName());
            StandardMBean mbean = new StandardMBean(this, TabletServerMBean.class, false);
            this.register(mbean);
            this.mincMetrics.register();
        }
        catch (Exception e) {
            log.error((Object)"Error registering with JMX", (Throwable)e);
        }
        while (!this.serverStopRequested) {
            try {
                MasterClientService.Client iface;
                block29: {
                    MasterMessage mm = null;
                    iface = null;
                    try {
                        while (mm == null && !this.serverStopRequested) {
                            mm = this.masterMessages.poll(1000L, TimeUnit.MILLISECONDS);
                        }
                        String masterHost = this.getMasterAddress();
                        MasterClientService.Client client = iface = this.masterConnection(masterHost);
                        while (!this.serverStopRequested && mm != null && client != null && client.getOutputProtocol() != null && client.getOutputProtocol().getTransport() != null && client.getOutputProtocol().getTransport().isOpen()) {
                            try {
                                mm.send(SystemCredentials.get().toThrift(this.instance), this.getClientAddressString(), (MasterClientService.Iface)iface);
                                mm = null;
                            }
                            catch (TException ex) {
                                log.warn((Object)"Error sending message: queuing message again");
                                this.masterMessages.putFirst(mm);
                                mm = null;
                                throw ex;
                            }
                            mm = this.masterMessages.poll();
                        }
                        if (mm == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (mm != null) {
                            this.masterMessages.putFirst(mm);
                        }
                        this.returnMasterConnection(iface);
                        UtilWaitThread.sleep((long)1000L);
                        throw throwable;
                    }
                    this.masterMessages.putFirst(mm);
                }
                this.returnMasterConnection(iface);
                UtilWaitThread.sleep((long)1000L);
            }
            catch (InterruptedException e) {
                log.info((Object)"Interrupt Exception received, shutting down");
                this.serverStopRequested = true;
            }
            catch (Exception e) {
                log.error((Object)(this.getClientAddressString() + ": TServerInfo: Exception. Master down?"), (Throwable)e);
            }
        }
        TabletServer e = this;
        synchronized (e) {
            while (!this.shutdownComplete) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)e2.toString());
                }
            }
        }
        log.debug((Object)"Stopping Thrift Servers");
        TServerUtils.stopTServer((TServer)this.server);
        try {
            log.debug((Object)"Closing filesystem");
            this.fs.close();
        }
        catch (IOException e2) {
            log.warn((Object)("Failed to close filesystem : " + e2.getMessage()), (Throwable)e2);
        }
        TabletServer.logGCInfo(this.getSystemConfiguration());
        log.info((Object)"TServerInfo: stop requested. exiting ... ");
        try {
            this.tabletServerLock.unlock();
        }
        catch (Exception e3) {
            log.warn((Object)"Failed to release tablet server lock", (Throwable)e3);
        }
    }

    private static Pair<Text, KeyExtent> verifyRootTablet(KeyExtent extent, TServerInstance instance) throws DistributedStoreException, AccumuloException {
        ZooTabletStateStore store = new ZooTabletStateStore();
        if (!store.iterator().hasNext()) {
            throw new AccumuloException("Illegal state: location is not set in zookeeper");
        }
        TabletLocationState next = (TabletLocationState)store.iterator().next();
        if (!instance.equals((Object)next.future)) {
            throw new AccumuloException("Future location is not to this server for the root tablet");
        }
        if (next.current != null) {
            throw new AccumuloException("Root tablet already has a location set");
        }
        try {
            return new Pair((Object)new Text(MetadataTableUtil.getRootTabletDir()), null);
        }
        catch (IOException e) {
            throw new AccumuloException((Throwable)e);
        }
    }

    public static Pair<Text, KeyExtent> verifyTabletInformation(KeyExtent extent, TServerInstance instance, SortedMap<Key, Value> tabletsKeyValues, String clientAddress, ZooLock lock) throws AccumuloSecurityException, DistributedStoreException, AccumuloException {
        log.debug((Object)("verifying extent " + extent));
        if (extent.isRootTablet()) {
            return TabletServer.verifyRootTablet(extent, instance);
        }
        String tableToVerify = "!0";
        if (extent.isMeta()) {
            tableToVerify = "+r";
        }
        List<ColumnFQ> columnsToFetch = Arrays.asList(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
        ScannerImpl scanner = new ScannerImpl(HdfsZooInstance.getInstance(), (Credentials)SystemCredentials.get(), tableToVerify, Authorizations.EMPTY);
        scanner.setRange(extent.toMetadataRange());
        TreeMap<Key, Value> tkv = new TreeMap<Key, Value>();
        for (Map.Entry entry : scanner) {
            tkv.put((Key)entry.getKey(), (Value)entry.getValue());
        }
        if (tabletsKeyValues == null) {
            tabletsKeyValues = tkv;
        } else {
            tabletsKeyValues.clear();
            tabletsKeyValues.putAll(tkv);
        }
        Text metadataEntry = extent.getMetadataEntry();
        Value dir = TabletServer.checkTabletMetadata(extent, instance, tabletsKeyValues, metadataEntry);
        if (dir == null) {
            return null;
        }
        Value oldPrevEndRow = null;
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            if (!MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.hasColumns(entry.getKey())) continue;
            oldPrevEndRow = entry.getValue();
        }
        if (oldPrevEndRow != null) {
            KeyExtent fke;
            SortedMap tabletEntries = MetadataTableUtil.getTabletEntries(tabletsKeyValues, columnsToFetch);
            try {
                fke = MasterMetadataUtil.fixSplit((Text)metadataEntry, (SortedMap)((SortedMap)tabletEntries.get(metadataEntry)), (TServerInstance)instance, (Credentials)SystemCredentials.get(), (ZooLock)lock);
            }
            catch (IOException e) {
                log.error((Object)("Error fixing split " + metadataEntry));
                throw new AccumuloException(e.toString());
            }
            if (!fke.equals((Object)extent)) {
                return new Pair(null, (Object)fke);
            }
            tabletsKeyValues.clear();
            return TabletServer.verifyTabletInformation(fke, instance, tabletsKeyValues, clientAddress, lock);
        }
        return new Pair((Object)new Text(dir.get()), null);
    }

    static Value checkTabletMetadata(KeyExtent extent, TServerInstance instance, SortedMap<Key, Value> tabletsKeyValues, Text metadataEntry) throws AccumuloException {
        TServerInstance future = null;
        Value prevEndRow = null;
        Value dir = null;
        Value time = null;
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            Key key = entry.getKey();
            if (!metadataEntry.equals((Object)key.getRow())) {
                log.info((Object)("Unexpected row in tablet metadata " + metadataEntry + " " + key.getRow()));
                return null;
            }
            Text cf = key.getColumnFamily();
            if (cf.equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) {
                if (future != null) {
                    throw new AccumuloException("Tablet has multiple future locations " + extent);
                }
                future = new TServerInstance(entry.getValue(), key.getColumnQualifier());
                continue;
            }
            if (cf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                log.info((Object)("Tablet seems to be already assigned to " + new TServerInstance(entry.getValue(), key.getColumnQualifier())));
                return null;
            }
            if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) {
                prevEndRow = entry.getValue();
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) {
                dir = entry.getValue();
                continue;
            }
            if (!MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) continue;
            time = entry.getValue();
        }
        if (prevEndRow == null) {
            throw new AccumuloException("Metadata entry does not have prev row (" + metadataEntry + ")");
        }
        KeyExtent ke2 = new KeyExtent(metadataEntry, prevEndRow);
        if (!extent.equals((Object)ke2)) {
            log.info((Object)("Tablet prev end row mismatch " + extent + " " + ke2.getPrevEndRow()));
            return null;
        }
        if (dir == null) {
            throw new AccumuloException("Metadata entry does not have directory (" + metadataEntry + ")");
        }
        if (time == null && !extent.equals((Object)RootTable.OLD_EXTENT)) {
            throw new AccumuloException("Metadata entry does not have time (" + metadataEntry + ")");
        }
        if (future == null) {
            log.info((Object)("The master has not assigned " + extent + " to " + instance));
            return null;
        }
        if (!instance.equals(future)) {
            log.info((Object)("Table " + extent + " has been assigned to " + future + " which is not " + instance));
            return null;
        }
        return dir;
    }

    public String getClientAddressString() {
        if (this.clientAddress == null) {
            return null;
        }
        return this.clientAddress.getHostText() + ":" + this.clientAddress.getPort();
    }

    TServerInstance getTabletSession() {
        String address = this.getClientAddressString();
        if (address == null) {
            return null;
        }
        try {
            return new TServerInstance(address, this.tabletServerLock.getSessionId());
        }
        catch (Exception ex) {
            log.warn((Object)("Unable to read session from tablet server lock" + ex));
            return null;
        }
    }

    public void config(String hostname) {
        log.info((Object)("Tablet server starting on " + hostname));
        this.security = AuditedSecurityOperation.getInstance();
        this.clientAddress = HostAndPort.fromParts((String)hostname, (int)0);
        long walogMaxSize = this.getSystemConfiguration().getMemoryInBytes(Property.TSERV_WALOG_MAX_SIZE);
        long minBlockSize = CachedConfiguration.getInstance().getLong("dfs.namenode.fs-limits.min-block-size", 0L);
        if (minBlockSize != 0L && minBlockSize > walogMaxSize) {
            throw new RuntimeException("Unable to start TabletServer. Logger is set to use blocksize " + walogMaxSize + " but hdfs minimum block size is " + minBlockSize + ". Either increase the " + Property.TSERV_WALOG_MAX_SIZE + " or decrease dfs.namenode.fs-limits.min-block-size in hdfs-site.xml.");
        }
        this.logger = new TabletServerLogger(this, walogMaxSize);
        try {
            AccumuloVFSClassLoader.getContextManager().setContextConfig((ContextManager.ContextsConfig)new ContextManager.DefaultContextsConfig((Iterable)new Iterable<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    return TabletServer.this.getSystemConfiguration().iterator();
                }
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runnable contextCleaner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList extents;
                SortedMap sortedMap = TabletServer.this.onlineTablets;
                synchronized (sortedMap) {
                    extents = new ArrayList(TabletServer.this.onlineTablets.keySet());
                }
                HashSet<Text> tables = new HashSet<Text>();
                for (KeyExtent keyExtent : extents) {
                    tables.add(keyExtent.getTableId());
                }
                HashSet<String> contexts = new HashSet<String>();
                for (Text tableid : tables) {
                    String context = TabletServer.this.getTableConfiguration(new KeyExtent(tableid, null, null)).get(Property.TABLE_CLASSPATH);
                    if (context.equals("")) continue;
                    contexts.add(context);
                }
                try {
                    AccumuloVFSClassLoader.getContextManager().removeUnusedContexts(contexts);
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
        SimpleTimer.getInstance().schedule(contextCleaner, 60000L, 60000L);
        FileSystemMonitor.start((AccumuloConfiguration)this.getSystemConfiguration(), (Property)Property.TSERV_MONITOR_FS);
        Runnable gcDebugTask = new Runnable(){

            @Override
            public void run() {
                TabletServer.logGCInfo(TabletServer.this.getSystemConfiguration());
            }
        };
        SimpleTimer.getInstance().schedule(gcDebugTask, 0L, 1000L);
        Runnable constraintTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList tablets;
                SortedMap sortedMap = TabletServer.this.onlineTablets;
                synchronized (sortedMap) {
                    tablets = new ArrayList(TabletServer.this.onlineTablets.values());
                }
                for (Tablet tablet : tablets) {
                    tablet.checkConstraints();
                }
            }
        };
        SimpleTimer.getInstance().schedule(constraintTask, 0L, 1000L);
        this.resourceManager = new TabletServerResourceManager(this.instance, this.fs);
        this.lastPingTime = System.currentTimeMillis();
        this.currentMaster = null;
        this.statsKeeper = new TabletStatsKeeper();
        this.majorCompactorThread = new Daemon((Runnable)new LoggingRunnable(log, (Runnable)new MajorCompactor(this.getSystemConfiguration())));
        this.majorCompactorThread.setName("Split/MajC initiator");
        this.majorCompactorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabletServerStatus getStats(Map<String, MapCounter<ScanRunState>> scanCounts) {
        Object table;
        HashMap<KeyExtent, Tablet> onlineTabletsCopy;
        TabletServerStatus result = new TabletServerStatus();
        SortedMap<KeyExtent, Tablet> sortedMap = this.onlineTablets;
        synchronized (sortedMap) {
            onlineTabletsCopy = new HashMap<KeyExtent, Tablet>(this.onlineTablets);
        }
        HashMap<Object, TableInfo> tables = new HashMap<Object, TableInfo>();
        for (Map.Entry entry : onlineTabletsCopy.entrySet()) {
            String tableId = ((KeyExtent)entry.getKey()).getTableId().toString();
            TableInfo table2 = (TableInfo)tables.get(tableId);
            if (table2 == null) {
                table2 = new TableInfo();
                table2.minors = new Compacting();
                table2.majors = new Compacting();
                tables.put(tableId, table2);
            }
            Tablet tablet = (Tablet)entry.getValue();
            long recs = tablet.getNumEntries();
            ++table2.tablets;
            ++table2.onlineTablets;
            table2.recs += recs;
            table2.queryRate += tablet.queryRate();
            table2.queryByteRate += tablet.queryByteRate();
            table2.ingestRate += tablet.ingestRate();
            table2.ingestByteRate += tablet.ingestByteRate();
            table2.scanRate += tablet.scanRate();
            long recsInMemory = tablet.getNumEntriesInMemory();
            table2.recsInMemory += recsInMemory;
            if (tablet.minorCompactionRunning()) {
                ++table2.minors.running;
            }
            if (tablet.minorCompactionQueued()) {
                ++table2.minors.queued;
            }
            if (tablet.majorCompactionRunning()) {
                ++table2.majors.running;
            }
            if (!tablet.majorCompactionQueued()) continue;
            ++table2.majors.queued;
        }
        for (Map.Entry<Object, Object> entry : scanCounts.entrySet()) {
            table = (TableInfo)tables.get(entry.getKey());
            if (table == null) {
                table = new TableInfo();
                tables.put(entry.getKey(), (TableInfo)table);
            }
            if (table.scans == null) {
                table.scans = new Compacting();
            }
            table.scans.queued = (int)((long)table.scans.queued + ((MapCounter)entry.getValue()).get((Object)ScanRunState.QUEUED));
            table.scans.running = (int)((long)table.scans.running + ((MapCounter)entry.getValue()).get((Object)ScanRunState.RUNNING));
        }
        ArrayList<KeyExtent> offlineTabletsCopy = new ArrayList<KeyExtent>();
        SortedSet<KeyExtent> sortedSet = this.unopenedTablets;
        synchronized (sortedSet) {
            table = this.openingTablets;
            synchronized (table) {
                offlineTabletsCopy.addAll(this.unopenedTablets);
                offlineTabletsCopy.addAll(this.openingTablets);
            }
        }
        for (KeyExtent extent : offlineTabletsCopy) {
            String tableId = extent.getTableId().toString();
            TableInfo table3 = (TableInfo)tables.get(tableId);
            if (table3 == null) {
                table3 = new TableInfo();
                tables.put(tableId, table3);
            }
            ++table3.tablets;
        }
        result.lastContact = RelativeTime.currentTimeMillis();
        result.tableMap = tables;
        result.osLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        result.name = this.getClientAddressString();
        result.holdTime = this.resourceManager.holdTime();
        result.lookups = seekCount.get();
        result.indexCacheHits = this.resourceManager.getIndexCache().getStats().getHitCount();
        result.indexCacheRequest = this.resourceManager.getIndexCache().getStats().getRequestCount();
        result.dataCacheHits = this.resourceManager.getDataCache().getStats().getHitCount();
        result.dataCacheRequest = this.resourceManager.getDataCache().getStats().getRequestCount();
        result.logSorts = this.logSorter.getLogSorts();
        return result;
    }

    public static void main(String[] args) throws IOException {
        try {
            SecurityUtil.serverLogin((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
            VolumeManager fs = VolumeManagerImpl.get();
            ServerOpts opts = new ServerOpts();
            opts.parseArgs(METRICS_PREFIX, args, new Object[0]);
            String hostname = opts.getAddress();
            Instance instance = HdfsZooInstance.getInstance();
            ServerConfiguration conf = new ServerConfiguration(instance);
            Accumulo.init((VolumeManager)fs, (ServerConfiguration)conf, (String)METRICS_PREFIX);
            TabletServer server = new TabletServer(conf, fs);
            server.config(hostname);
            Accumulo.enableTracing((String)hostname, (String)METRICS_PREFIX);
            server.run();
        }
        catch (Exception ex) {
            log.error((Object)"Uncaught exception in TabletServer.main, exiting", (Throwable)ex);
            System.exit(1);
        }
    }

    public void minorCompactionFinished(Tablet.CommitSession tablet, String newDatafile, int walogSeq) throws IOException {
        ++this.totalMinorCompactions;
        this.logger.minorCompactionFinished(tablet, newDatafile, walogSeq);
    }

    public void minorCompactionStarted(Tablet.CommitSession tablet, int lastUpdateSequence, String newMapfileLocation) throws IOException {
        this.logger.minorCompactionStarted(tablet, lastUpdateSequence, newMapfileLocation);
    }

    public void recover(VolumeManager fs, Tablet tablet, List<LogEntry> logEntries, Set<String> tabletFiles, MutationReceiver mutationReceiver) throws IOException {
        ArrayList<Path> recoveryLogs = new ArrayList<Path>();
        ArrayList<LogEntry> sorted = new ArrayList<LogEntry>(logEntries);
        Collections.sort(sorted, new Comparator<LogEntry>(){

            @Override
            public int compare(LogEntry e1, LogEntry e2) {
                return (int)(e1.timestamp - e2.timestamp);
            }
        });
        for (LogEntry entry : sorted) {
            Path recovery = null;
            for (String log : entry.logSet) {
                Path finished = RecoveryPath.getRecoveryPath((VolumeManager)fs, (Path)fs.getFullPath(VolumeManager.FileType.WAL, log));
                finished = new Path(finished, "finished");
                TabletServer.log.info((Object)("Looking for " + finished));
                if (!fs.exists(finished)) continue;
                recovery = finished.getParent();
                break;
            }
            if (recovery == null) {
                throw new IOException("Unable to find recovery files for extent " + tablet.getExtent() + " logEntry: " + entry);
            }
            recoveryLogs.add(recovery);
        }
        this.logger.recover(fs, tablet, recoveryLogs, tabletFiles, mutationReceiver);
    }

    public int createLogId(KeyExtent tablet) {
        TableConfiguration acuTableConf = this.getTableConfiguration(tablet);
        if (acuTableConf.getBoolean(Property.TABLE_WALOG_ENABLED)) {
            return this.logIdGenerator.incrementAndGet();
        }
        return -1;
    }

    @Override
    public long getEntries() {
        if (this.isEnabled()) {
            long result = 0L;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                result += tablet.getNumEntries();
            }
            return result;
        }
        return 0L;
    }

    @Override
    public long getEntriesInMemory() {
        if (this.isEnabled()) {
            long result = 0L;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                result += tablet.getNumEntriesInMemory();
            }
            return result;
        }
        return 0L;
    }

    @Override
    public long getIngest() {
        if (this.isEnabled()) {
            long result = 0L;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                result += tablet.getNumEntriesInMemory();
            }
            return result;
        }
        return 0L;
    }

    @Override
    public int getMajorCompactions() {
        if (this.isEnabled()) {
            int result = 0;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                if (!tablet.majorCompactionRunning()) continue;
                ++result;
            }
            return result;
        }
        return 0;
    }

    @Override
    public int getMajorCompactionsQueued() {
        if (this.isEnabled()) {
            int result = 0;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                if (!tablet.majorCompactionQueued()) continue;
                ++result;
            }
            return result;
        }
        return 0;
    }

    @Override
    public int getMinorCompactions() {
        if (this.isEnabled()) {
            int result = 0;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                if (!tablet.minorCompactionRunning()) continue;
                ++result;
            }
            return result;
        }
        return 0;
    }

    @Override
    public int getMinorCompactionsQueued() {
        if (this.isEnabled()) {
            int result = 0;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                if (!tablet.minorCompactionQueued()) continue;
                ++result;
            }
            return result;
        }
        return 0;
    }

    @Override
    public int getOnlineCount() {
        if (this.isEnabled()) {
            return this.onlineTablets.size();
        }
        return 0;
    }

    @Override
    public int getOpeningCount() {
        if (this.isEnabled()) {
            return this.openingTablets.size();
        }
        return 0;
    }

    @Override
    public long getQueries() {
        if (this.isEnabled()) {
            long result = 0L;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                result += tablet.totalQueries();
            }
            return result;
        }
        return 0L;
    }

    @Override
    public int getUnopenedCount() {
        if (this.isEnabled()) {
            return this.unopenedTablets.size();
        }
        return 0;
    }

    @Override
    public String getName() {
        if (this.isEnabled()) {
            return this.getClientAddressString();
        }
        return "";
    }

    @Override
    public long getTotalMinorCompactions() {
        if (this.isEnabled()) {
            return this.totalMinorCompactions;
        }
        return 0L;
    }

    @Override
    public double getHoldTime() {
        if (this.isEnabled()) {
            return (double)this.resourceManager.holdTime() / 1000.0;
        }
        return 0.0;
    }

    @Override
    public double getAverageFilesPerTablet() {
        if (this.isEnabled()) {
            int count = 0;
            long result = 0L;
            for (Tablet tablet : Collections.unmodifiableCollection(this.onlineTablets.values())) {
                result += (long)tablet.getDatafiles().size();
                ++count;
            }
            if (count == 0) {
                return 0.0;
            }
            return (double)result / (double)count;
        }
        return 0.0;
    }

    protected ObjectName getObjectName() {
        return OBJECT_NAME;
    }

    protected String getMetricsPrefix() {
        return METRICS_PREFIX;
    }

    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return ServerConfiguration.getTableConfiguration((Instance)this.instance, (String)extent.getTableId().toString());
    }

    public DfsLogger.ServerResources getServerConfig() {
        return new DfsLogger.ServerResources(){

            @Override
            public VolumeManager getFileSystem() {
                return TabletServer.this.fs;
            }

            @Override
            public Set<TServerInstance> getCurrentTServers() {
                return null;
            }

            @Override
            public AccumuloConfiguration getConfiguration() {
                return TabletServer.this.getSystemConfiguration();
            }
        };
    }

    public VolumeManager getFileSystem() {
        return this.fs;
    }

    static {
        OBJECT_NAME = null;
        seekCount = new AtomicLong(0L);
    }

    private class AssignmentHandler
    implements Runnable {
        private KeyExtent extent;
        private int retryAttempt = 0;

        public AssignmentHandler(KeyExtent extent) {
            this.extent = extent;
        }

        public AssignmentHandler(KeyExtent extent, int retryAttempt) {
            this(extent);
            this.retryAttempt = retryAttempt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TreeMap<Key, Value> tabletsKeyValues;
            Text locationToOpen;
            block43: {
                Set unopenedOverlapping;
                log.info((Object)(TabletServer.this.clientAddress + ": got assignment from master: " + this.extent));
                SortedSet sortedSet = TabletServer.this.unopenedTablets;
                synchronized (sortedSet) {
                    SortedSet sortedSet2 = TabletServer.this.openingTablets;
                    synchronized (sortedSet2) {
                        SortedMap sortedMap = TabletServer.this.onlineTablets;
                        synchronized (sortedMap) {
                            unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedSet)TabletServer.this.unopenedTablets);
                            Set openingOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedSet)TabletServer.this.openingTablets);
                            Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedMap)TabletServer.this.onlineTablets);
                            if (openingOverlapping.contains(this.extent) || onlineOverlapping.contains(this.extent)) {
                                return;
                            }
                            if (!unopenedOverlapping.contains(this.extent)) {
                                log.info((Object)("assignment " + this.extent + " no longer in the unopened set"));
                                return;
                            }
                            if (unopenedOverlapping.size() != 1 || openingOverlapping.size() > 0 || onlineOverlapping.size() > 0) {
                                throw new IllegalStateException("overlaps assigned " + this.extent + " " + !TabletServer.this.unopenedTablets.contains(this.extent) + " " + unopenedOverlapping + " " + openingOverlapping + " " + onlineOverlapping);
                            }
                        }
                        TabletServer.this.unopenedTablets.remove(this.extent);
                        TabletServer.this.openingTablets.add(this.extent);
                    }
                }
                log.debug((Object)("Loading extent: " + this.extent));
                locationToOpen = null;
                tabletsKeyValues = new TreeMap<Key, Value>();
                try {
                    Pair<Text, KeyExtent> pair = TabletServer.verifyTabletInformation(this.extent, TabletServer.this.getTabletSession(), tabletsKeyValues, TabletServer.this.getClientAddressString(), TabletServer.this.getLock());
                    if (pair == null) break block43;
                    locationToOpen = (Text)pair.getFirst();
                    if (pair.getSecond() == null) break block43;
                    unopenedOverlapping = TabletServer.this.openingTablets;
                    synchronized (unopenedOverlapping) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                        if (!KeyExtent.findOverlapping((KeyExtent)this.extent, new TreeSet<KeyExtent>(Arrays.asList((KeyExtent)pair.getSecond()))).contains(pair.getSecond())) {
                            throw new IllegalStateException("Fixed split does not overlap " + this.extent + " " + pair.getSecond());
                        }
                        TabletServer.this.unopenedTablets.add(pair.getSecond());
                    }
                    new AssignmentHandler((KeyExtent)pair.getSecond()).run();
                    return;
                }
                catch (Exception e) {
                    unopenedOverlapping = TabletServer.this.openingTablets;
                    synchronized (unopenedOverlapping) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                    }
                    log.warn((Object)("Failed to verify tablet " + this.extent), (Throwable)e);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                    throw new RuntimeException(e);
                }
            }
            if (locationToOpen == null) {
                log.debug((Object)("Reporting tablet " + this.extent + " assignment failure: unable to verify Tablet Information"));
                SortedSet e = TabletServer.this.openingTablets;
                synchronized (e) {
                    TabletServer.this.openingTablets.remove(this.extent);
                    TabletServer.this.openingTablets.notifyAll();
                }
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                return;
            }
            Tablet tablet = null;
            boolean successful = false;
            try {
                TabletServerResourceManager.TabletResourceManager trm = TabletServer.this.resourceManager.createTabletResourceManager();
                locationToOpen = VolumeUtil.switchRootTabletVolume((KeyExtent)this.extent, (Text)locationToOpen);
                tablet = new Tablet(TabletServer.this, locationToOpen, this.extent, trm, tabletsKeyValues);
                if (tablet.getNumEntriesInMemory() > 0L && !tablet.minorCompactNow(Tablet.MinorCompactionReason.SYSTEM)) {
                    throw new RuntimeException("Minor compaction after recovery fails for " + this.extent);
                }
                Assignment assignment = new Assignment(this.extent, TabletServer.this.getTabletSession());
                TabletStateStore.setLocation((Assignment)assignment);
                SortedSet sortedSet = TabletServer.this.openingTablets;
                synchronized (sortedSet) {
                    SortedMap sortedMap = TabletServer.this.onlineTablets;
                    synchronized (sortedMap) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.onlineTablets.put(this.extent, tablet);
                        TabletServer.this.openingTablets.notifyAll();
                        TabletServer.this.recentlyUnloadedCache.remove(tablet.getExtent());
                    }
                }
                tablet = null;
                successful = true;
            }
            catch (Throwable e) {
                log.warn((Object)("exception trying to assign tablet " + this.extent + " " + locationToOpen), e);
                if (e.getMessage() != null) {
                    log.warn((Object)e.getMessage());
                }
                String table = this.extent.getTableId().toString();
                ProblemReports.getInstance().report(new ProblemReport(table, ProblemType.TABLET_LOAD, this.extent.getUUID().toString(), TabletServer.this.getClientAddressString(), e));
            }
            if (!successful) {
                SortedSet e = TabletServer.this.unopenedTablets;
                synchronized (e) {
                    SortedSet sortedSet = TabletServer.this.openingTablets;
                    synchronized (sortedSet) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.unopenedTablets.add(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                    }
                }
                log.warn((Object)("failed to open tablet " + this.extent + " reporting failure to master"));
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                long reschedule = Math.min((1L << Math.min(32, this.retryAttempt)) * 1000L, 600000L);
                log.warn((Object)String.format("rescheduling tablet load in %.2f seconds", (double)reschedule / 1000.0));
                SimpleTimer.getInstance().schedule((Runnable)new TimerTask(){

                    @Override
                    public void run() {
                        log.info((Object)("adding tablet " + AssignmentHandler.this.extent + " back to the assignment pool (retry " + AssignmentHandler.this.retryAttempt + ")"));
                        AssignmentHandler handler = new AssignmentHandler(AssignmentHandler.this.extent, AssignmentHandler.this.retryAttempt + 1);
                        if (AssignmentHandler.this.extent.isMeta()) {
                            if (AssignmentHandler.this.extent.isRootTablet()) {
                                new Daemon((Runnable)new LoggingRunnable(log, (Runnable)handler), "Root tablet assignment retry").start();
                            } else {
                                TabletServer.this.resourceManager.addMetaDataAssignment(handler);
                            }
                        } else {
                            TabletServer.this.resourceManager.addAssignment(handler);
                        }
                    }
                }, reschedule);
            } else {
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOADED, this.extent));
            }
        }
    }

    private class UnloadTabletHandler
    implements Runnable {
        private KeyExtent extent;
        private boolean saveState;

        public UnloadTabletHandler(KeyExtent extent, boolean saveState) {
            this.extent = extent;
            this.saveState = saveState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tablet t = null;
            Object object = TabletServer.this.unopenedTablets;
            synchronized (object) {
                if (TabletServer.this.unopenedTablets.contains(this.extent)) {
                    TabletServer.this.unopenedTablets.remove(this.extent);
                    return;
                }
            }
            object = TabletServer.this.openingTablets;
            synchronized (object) {
                while (TabletServer.this.openingTablets.contains(this.extent)) {
                    try {
                        TabletServer.this.openingTablets.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            object = TabletServer.this.onlineTablets;
            synchronized (object) {
                if (TabletServer.this.onlineTablets.containsKey(this.extent)) {
                    t = (Tablet)TabletServer.this.onlineTablets.get(this.extent);
                }
            }
            if (t == null) {
                if (!TabletServer.this.recentlyUnloadedCache.containsKey(this.extent)) {
                    log.info((Object)("told to unload tablet that was not being served " + this.extent));
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_FAILURE_NOT_SERVING, this.extent));
                }
                return;
            }
            try {
                t.close(this.saveState);
            }
            catch (Throwable e) {
                if ((t.isClosing() || t.isClosed()) && e instanceof IllegalStateException) {
                    log.debug((Object)("Failed to unload tablet " + this.extent + "... it was alread closing or closed : " + e.getMessage()));
                } else {
                    log.error((Object)("Failed to close tablet " + this.extent + "... Aborting migration"), e);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_ERROR, this.extent));
                }
                return;
            }
            TabletServer.this.recentlyUnloadedCache.put(this.extent, System.currentTimeMillis());
            TabletServer.this.onlineTablets.remove(this.extent);
            try {
                TServerInstance instance = new TServerInstance(TabletServer.this.clientAddress, TabletServer.this.getLock().getSessionId());
                TabletLocationState tls = null;
                try {
                    tls = new TabletLocationState(this.extent, null, instance, null, null, false);
                }
                catch (TabletLocationState.BadLocationStateException e) {
                    log.error((Object)"Unexpected error ", (Throwable)e);
                }
                log.debug((Object)("Unassigning " + tls));
                TabletStateStore.unassign((TabletLocationState)tls);
            }
            catch (DistributedStoreException ex) {
                log.warn((Object)"Unable to update storage", (Throwable)ex);
            }
            catch (KeeperException e) {
                log.warn((Object)"Unable determine our zookeeper session information", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Interrupted while getting our zookeeper session information", (Throwable)e);
            }
            TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOADED, this.extent));
            TabletServer.this.statsKeeper.saveMinorTimes(t.timer);
            TabletServer.this.statsKeeper.saveMajorTimes(t.timer);
            log.info((Object)("unloaded " + this.extent));
        }
    }

    private class MajorCompactor
    implements Runnable {
        public MajorCompactor(AccumuloConfiguration config) {
            CompactionWatcher.startWatching(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TabletServer.this.majorCompactorDisabled) {
                try {
                    UtilWaitThread.sleep((long)TabletServer.this.getSystemConfiguration().getTimeInMillis(Property.TSERV_MAJC_DELAY));
                    TreeMap copyOnlineTablets = new TreeMap();
                    SortedMap sortedMap = TabletServer.this.onlineTablets;
                    synchronized (sortedMap) {
                        copyOnlineTablets.putAll(TabletServer.this.onlineTablets);
                    }
                    int numMajorCompactionsInProgress = 0;
                    Iterator iter = copyOnlineTablets.entrySet().iterator();
                    while (iter.hasNext() && !TabletServer.this.majorCompactorDisabled) {
                        Map.Entry entry = iter.next();
                        Tablet tablet = (Tablet)entry.getValue();
                        if (tablet.needsSplit()) {
                            TabletServer.this.executeSplit(tablet);
                            continue;
                        }
                        int maxLogEntriesPerTablet = TabletServer.this.getTableConfiguration(tablet.getExtent()).getCount(Property.TABLE_MINC_LOGS_MAX);
                        if (tablet.getLogCount() >= maxLogEntriesPerTablet) {
                            log.debug((Object)("Initiating minor compaction for " + tablet.getExtent() + " because it has " + tablet.getLogCount() + " write ahead logs"));
                            tablet.initiateMinorCompaction(Tablet.MinorCompactionReason.SYSTEM);
                        }
                        Tablet tablet2 = tablet;
                        synchronized (tablet2) {
                            if (tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL) || tablet.majorCompactionQueued() || tablet.majorCompactionRunning()) {
                                ++numMajorCompactionsInProgress;
                            }
                        }
                    }
                    int idleCompactionsToStart = Math.max(1, TabletServer.this.getSystemConfiguration().getCount(Property.TSERV_MAJC_MAXCONCURRENT) / 2);
                    if (numMajorCompactionsInProgress >= idleCompactionsToStart) continue;
                    iter = copyOnlineTablets.entrySet().iterator();
                    while (iter.hasNext() && !TabletServer.this.majorCompactorDisabled && numMajorCompactionsInProgress < idleCompactionsToStart) {
                        Map.Entry entry = iter.next();
                        Tablet tablet = (Tablet)entry.getValue();
                        if (!tablet.initiateMajorCompaction(MajorCompactionReason.IDLE)) continue;
                        ++numMajorCompactionsInProgress;
                    }
                }
                catch (Throwable t) {
                    log.error((Object)("Unexpected exception in " + Thread.currentThread().getName()), t);
                    UtilWaitThread.sleep((long)1000L);
                }
            }
        }
    }

    private class SplitRunner
    implements Runnable {
        private Tablet tablet;

        public SplitRunner(Tablet tablet) {
            this.tablet = tablet;
        }

        @Override
        public void run() {
            if (TabletServer.this.majorCompactorDisabled) {
                return;
            }
            TabletServer.this.splitTablet(this.tablet);
        }
    }

    private class ThriftClientHandler
    extends ClientServiceHandler
    implements TabletClientService.Iface {
        SessionManager sessionManager;
        AccumuloConfiguration acuConf;
        TabletServerUpdateMetrics updateMetrics;
        TabletServerScanMetrics scanMetrics;
        WriteTracker writeTracker;
        private RowLocks rowLocks;
        private ZooCache masterLockCache;

        ThriftClientHandler() {
            super(TabletServer.this.instance, TabletServer.this.watcher, TabletServer.this.fs);
            this.acuConf = TabletServer.this.getSystemConfiguration();
            this.updateMetrics = new TabletServerUpdateMetrics();
            this.scanMetrics = new TabletServerScanMetrics();
            this.writeTracker = new WriteTracker();
            this.rowLocks = new RowLocks();
            this.masterLockCache = new ZooCache();
            log.debug((Object)(ThriftClientHandler.class.getName() + " created"));
            this.sessionManager = new SessionManager(TabletServer.this.getSystemConfiguration());
            try {
                this.updateMetrics.register();
                this.scanMetrics.register();
            }
            catch (Exception e) {
                log.error((Object)"Exception registering MBean with MBean Server", (Throwable)e);
            }
        }

        public List<TKeyExtent> bulkImport(TInfo tinfo, TCredentials credentials, long tid, Map<TKeyExtent, Map<String, MapFileInfo>> files, boolean setTime) throws ThriftSecurityException {
            if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            ArrayList<TKeyExtent> failures = new ArrayList<TKeyExtent>();
            for (Map.Entry<TKeyExtent, Map<String, MapFileInfo>> entry : files.entrySet()) {
                TKeyExtent tke = entry.getKey();
                Map<String, MapFileInfo> fileMap = entry.getValue();
                HashMap<FileRef, MapFileInfo> fileRefMap = new HashMap<FileRef, MapFileInfo>();
                for (Map.Entry<String, MapFileInfo> mapping : fileMap.entrySet()) {
                    Path path = new Path(mapping.getKey());
                    FileSystem ns = TabletServer.this.fs.getVolumeByPath(path).getFileSystem();
                    path = ns.makeQualified(path);
                    fileRefMap.put(new FileRef(path.toString(), path), mapping.getValue());
                }
                Tablet importTablet = (Tablet)TabletServer.this.onlineTablets.get(new KeyExtent(tke));
                if (importTablet == null) {
                    failures.add(tke);
                    continue;
                }
                try {
                    importTablet.importMapFiles(tid, fileRefMap, setTime);
                }
                catch (IOException ioe) {
                    log.info((Object)("files " + fileMap.keySet() + " not imported to " + new KeyExtent(tke) + ": " + ioe.getMessage()));
                    failures.add(tke);
                }
            }
            return failures;
        }

        public InitialScan startScan(TInfo tinfo, TCredentials credentials, TKeyExtent textent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold) throws NotServingTabletException, ThriftSecurityException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException {
            ScanResult scanResult;
            Tablet tablet;
            String tableId = new String(textent.getTable(), Constants.UTF8);
            if (!TabletServer.this.security.canScan(credentials, tableId, Tables.getNamespaceId((Instance)TabletServer.this.instance, (String)tableId), range, columns, ssiList, ssio, authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            if (!TabletServer.this.security.userHasAuthorizations(credentials, authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
            }
            KeyExtent extent = new KeyExtent(textent);
            if (waitForWrites) {
                this.writeTracker.waitForWrites(TabletType.type((KeyExtent)extent));
            }
            if ((tablet = (Tablet)TabletServer.this.onlineTablets.get(extent)) == null) {
                throw new NotServingTabletException(textent);
            }
            ScanSession scanSession = new ScanSession();
            scanSession.user = credentials.getPrincipal();
            scanSession.extent = new KeyExtent(extent);
            scanSession.columnSet = new HashSet();
            scanSession.ssiList = ssiList;
            scanSession.ssio = ssio;
            scanSession.auths = new Authorizations(authorizations);
            scanSession.interruptFlag = new AtomicBoolean();
            scanSession.readaheadThreshold = readaheadThreshold;
            for (TColumn tcolumn : columns) {
                scanSession.columnSet.add(new Column(tcolumn));
            }
            scanSession.scanner = tablet.createScanner(new Range(range), batchSize, scanSession.columnSet, scanSession.auths, ssiList, ssio, isolated, scanSession.interruptFlag);
            long sid = this.sessionManager.createSession(scanSession, true);
            try {
                scanResult = this.continueScan(tinfo, sid, scanSession);
            }
            catch (NoSuchScanIDException e) {
                log.error((Object)"The impossible happened", (Throwable)e);
                throw new RuntimeException();
            }
            finally {
                this.sessionManager.unreserveSession(sid);
            }
            return new InitialScan(sid, scanResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScanResult continueScan(TInfo tinfo, long scanID) throws NoSuchScanIDException, NotServingTabletException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException {
            ScanSession scanSession = (ScanSession)this.sessionManager.reserveSession(scanID);
            if (scanSession == null) {
                throw new NoSuchScanIDException();
            }
            try {
                ScanResult scanResult = this.continueScan(tinfo, scanID, scanSession);
                return scanResult;
            }
            finally {
                this.sessionManager.unreserveSession(scanSession);
            }
        }

        private ScanResult continueScan(TInfo tinfo, long scanID, ScanSession scanSession) throws NoSuchScanIDException, NotServingTabletException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException {
            Tablet.ScanBatch bresult;
            if (scanSession.nextBatchTask == null) {
                scanSession.nextBatchTask = new NextBatchTask(scanID, scanSession.interruptFlag);
                TabletServer.this.resourceManager.executeReadAhead(scanSession.extent, scanSession.nextBatchTask);
            }
            try {
                bresult = scanSession.nextBatchTask.get(1000L, TimeUnit.MILLISECONDS);
                scanSession.nextBatchTask = null;
            }
            catch (ExecutionException e) {
                this.sessionManager.removeSession(scanID);
                if (e.getCause() instanceof NotServingTabletException) {
                    throw (NotServingTabletException)e.getCause();
                }
                if (e.getCause() instanceof TooManyFilesException) {
                    throw new org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException(scanSession.extent.toThrift());
                }
                throw new RuntimeException(e);
            }
            catch (CancellationException ce) {
                this.sessionManager.removeSession(scanID);
                Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(scanSession.extent);
                if (tablet == null || tablet.isClosed()) {
                    throw new NotServingTabletException(scanSession.extent.toThrift());
                }
                throw new NoSuchScanIDException();
            }
            catch (TimeoutException e) {
                List param = Collections.emptyList();
                long timeout = this.acuConf.getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
                this.sessionManager.removeIfNotAccessed(scanID, timeout);
                return new ScanResult(param, true);
            }
            catch (Throwable t) {
                this.sessionManager.removeSession(scanID);
                log.warn((Object)"Failed to get next batch", t);
                throw new RuntimeException(t);
            }
            ScanResult scanResult = new ScanResult(Key.compress(bresult.results), bresult.more);
            scanSession.entriesReturned += (long)scanResult.results.size();
            ++scanSession.batchCount;
            if (scanResult.more && scanSession.batchCount > scanSession.readaheadThreshold) {
                scanSession.nextBatchTask = new NextBatchTask(scanID, scanSession.interruptFlag);
                TabletServer.this.resourceManager.executeReadAhead(scanSession.extent, scanSession.nextBatchTask);
            }
            if (!scanResult.more) {
                this.closeScan(tinfo, scanID);
            }
            return scanResult;
        }

        public void closeScan(TInfo tinfo, long scanID) {
            ScanSession ss = (ScanSession)this.sessionManager.removeSession(scanID);
            if (ss != null) {
                long t2 = System.currentTimeMillis();
                log.debug((Object)String.format("ScanSess tid %s %s %,d entries in %.2f secs, nbTimes = [%s] ", TServerUtils.clientAddress.get(), ss.extent.getTableId().toString(), ss.entriesReturned, (double)(t2 - ss.startTime) / 1000.0, ss.nbTimes.toString()));
                if (this.scanMetrics.isEnabled()) {
                    this.scanMetrics.add("scan", t2 - ss.startTime);
                    this.scanMetrics.add("result", ss.entriesReturned);
                }
            }
        }

        public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites) throws ThriftSecurityException {
            MultiScanResult result;
            HashSet<String> tables = new HashSet<String>();
            for (TKeyExtent keyExtent : tbatch.keySet()) {
                tables.add(new String(keyExtent.getTable(), Constants.UTF8));
            }
            if (tables.size() != 1) {
                throw new IllegalArgumentException("Cannot batch scan over multiple tables");
            }
            for (String tableId : tables) {
                if (TabletServer.this.security.canScan(credentials, tableId, Tables.getNamespaceId((Instance)TabletServer.this.instance, (String)tableId), tbatch, tcolumns, ssiList, ssio, authorizations)) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            try {
                if (!TabletServer.this.security.userHasAuthorizations(credentials, authorizations)) {
                    throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
                }
            }
            catch (ThriftSecurityException tse) {
                log.error((Object)tse, (Throwable)tse);
                throw tse;
            }
            Map batch = Translator.translate(tbatch, (Translator)new Translator.TKeyExtentTranslator(), (Translator)new Translator.ListTranslator((Translator)new Translator.TRangeTranslator()));
            KeyExtent threadPoolExtent = (KeyExtent)batch.keySet().iterator().next();
            if (waitForWrites) {
                this.writeTracker.waitForWrites(TabletType.type(batch.keySet()));
            }
            MultiScanSession mss = new MultiScanSession();
            mss.user = credentials.getPrincipal();
            mss.queries = batch;
            mss.columnSet = new HashSet(tcolumns.size());
            mss.ssiList = ssiList;
            mss.ssio = ssio;
            mss.auths = new Authorizations(authorizations);
            mss.numTablets = batch.size();
            for (List ranges : batch.values()) {
                mss.numRanges += ranges.size();
            }
            for (TColumn tcolumn : tcolumns) {
                mss.columnSet.add(new Column(tcolumn));
            }
            mss.threadPoolExtent = threadPoolExtent;
            long sid = this.sessionManager.createSession(mss, true);
            try {
                result = this.continueMultiScan(tinfo, sid, mss);
            }
            catch (NoSuchScanIDException e) {
                log.error((Object)"the impossible happened", (Throwable)e);
                throw new RuntimeException("the impossible happened", e);
            }
            finally {
                this.sessionManager.unreserveSession(sid);
            }
            return new InitialMultiScan(sid, result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiScanResult continueMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException {
            MultiScanSession session = (MultiScanSession)this.sessionManager.reserveSession(scanID);
            if (session == null) {
                throw new NoSuchScanIDException();
            }
            try {
                MultiScanResult multiScanResult = this.continueMultiScan(tinfo, scanID, session);
                return multiScanResult;
            }
            finally {
                this.sessionManager.unreserveSession(session);
            }
        }

        private MultiScanResult continueMultiScan(TInfo tinfo, long scanID, MultiScanSession session) throws NoSuchScanIDException {
            if (session.lookupTask == null) {
                session.lookupTask = new LookupTask(scanID);
                TabletServer.this.resourceManager.executeReadAhead(session.threadPoolExtent, session.lookupTask);
            }
            try {
                MultiScanResult scanResult = session.lookupTask.get(1000L, TimeUnit.MILLISECONDS);
                session.lookupTask = null;
                return scanResult;
            }
            catch (TimeoutException e1) {
                long timeout = this.acuConf.getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
                this.sessionManager.removeIfNotAccessed(scanID, timeout);
                List results = Collections.emptyList();
                Map failures = Collections.emptyMap();
                List fullScans = Collections.emptyList();
                return new MultiScanResult(results, failures, fullScans, null, null, false, true);
            }
            catch (Throwable t) {
                this.sessionManager.removeSession(scanID);
                log.warn((Object)"Failed to get multiscan result", t);
                throw new RuntimeException(t);
            }
        }

        public void closeMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException {
            MultiScanSession session = (MultiScanSession)this.sessionManager.removeSession(scanID);
            if (session == null) {
                throw new NoSuchScanIDException();
            }
            long t2 = System.currentTimeMillis();
            log.debug((Object)String.format("MultiScanSess %s %,d entries in %.2f secs (lookup_time:%.2f secs tablets:%,d ranges:%,d) ", TServerUtils.clientAddress.get(), session.numEntries, (double)(t2 - session.startTime) / 1000.0, (double)session.totalLookupTime / 1000.0, session.numTablets, session.numRanges));
        }

        public long startUpdate(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
            TabletServer.this.security.authenticateUser(credentials, credentials);
            if (this.updateMetrics.isEnabled()) {
                this.updateMetrics.add("permissionErrors", 0L);
            }
            UpdateSession us = new UpdateSession();
            us.violations = new Violations();
            us.credentials = credentials;
            us.cenv = new TservConstraintEnv(TabletServer.this.security, us.credentials);
            long sid = this.sessionManager.createSession(us, false);
            return sid;
        }

        private void setUpdateTablet(UpdateSession us, KeyExtent keyExtent) {
            block10: {
                long t1 = System.currentTimeMillis();
                if (us.currentTablet != null && us.currentTablet.getExtent().equals((Object)keyExtent)) {
                    return;
                }
                if (us.currentTablet == null && (us.failures.containsKey(keyExtent) || us.authFailures.containsKey(keyExtent))) {
                    return;
                }
                try {
                    boolean sameTable = us.currentTablet != null && us.currentTablet.getExtent().getTableId().equals((Object)keyExtent.getTableId());
                    String tableId = keyExtent.getTableId().toString();
                    if (sameTable || TabletServer.this.security.canWrite(us.credentials, tableId, Tables.getNamespaceId((Instance)TabletServer.this.instance, (String)tableId))) {
                        long t2 = System.currentTimeMillis();
                        us.authTimes.addStat(t2 - t1);
                        us.currentTablet = (Tablet)TabletServer.this.onlineTablets.get(keyExtent);
                        if (us.currentTablet != null) {
                            us.queuedMutations.put(us.currentTablet, new ArrayList());
                        } else {
                            us.failures.put(keyExtent, 0L);
                            if (this.updateMetrics.isEnabled()) {
                                this.updateMetrics.add("unknownTabletErrors", 0L);
                            }
                        }
                        break block10;
                    }
                    log.warn((Object)("Denying access to table " + keyExtent.getTableId() + " for user " + us.credentials.getPrincipal()));
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, SecurityErrorCode.PERMISSION_DENIED);
                    if (this.updateMetrics.isEnabled()) {
                        this.updateMetrics.add("permissionErrors", 0L);
                    }
                    return;
                }
                catch (ThriftSecurityException e) {
                    log.error((Object)("Denying permission to check user " + us.credentials.getPrincipal() + " with user " + e.getUser()), (Throwable)e);
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, e.getCode());
                    if (this.updateMetrics.isEnabled()) {
                        this.updateMetrics.add("permissionErrors", 0L);
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyUpdates(TInfo tinfo, long updateID, TKeyExtent tkeyExtent, List<TMutation> tmutations) {
            UpdateSession us = (UpdateSession)this.sessionManager.reserveSession(updateID);
            if (us == null) {
                throw new RuntimeException("No Such SessionID");
            }
            try {
                KeyExtent keyExtent = new KeyExtent(tkeyExtent);
                this.setUpdateTablet(us, keyExtent);
                if (us.currentTablet != null) {
                    List<Mutation> mutations = us.queuedMutations.get(us.currentTablet);
                    for (TMutation tmutation : tmutations) {
                        ServerMutation mutation = new ServerMutation(tmutation);
                        mutations.add((Mutation)mutation);
                        us.queuedMutationSize += mutation.numBytes();
                    }
                    if (us.queuedMutationSize > TabletServer.this.getSystemConfiguration().getMemoryInBytes(Property.TSERV_MUTATION_QUEUE_MAX)) {
                        this.flush(us);
                    }
                }
            }
            finally {
                this.sessionManager.unreserveSession(us);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush(UpdateSession us) {
            int mutationCount = 0;
            HashMap<Tablet.CommitSession, List<Mutation>> sendables = new HashMap<Tablet.CommitSession, List<Mutation>>();
            Throwable error = null;
            long pt1 = System.currentTimeMillis();
            boolean containsMetadataTablet = false;
            for (Tablet tablet : us.queuedMutations.keySet()) {
                if (!tablet.getExtent().isMeta()) continue;
                containsMetadataTablet = true;
            }
            if (!containsMetadataTablet && us.queuedMutations.size() > 0) {
                TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
            }
            Span prep = Trace.start((String)"prep");
            try {
                for (Map.Entry<Tablet, List<Mutation>> entry : us.queuedMutations.entrySet()) {
                    Tablet tablet = entry.getKey();
                    List<Mutation> mutations = entry.getValue();
                    if (mutations.size() <= 0) continue;
                    try {
                        Tablet.CommitSession commitSession;
                        if (this.updateMetrics.isEnabled()) {
                            this.updateMetrics.add("mutationArraysSize", mutations.size());
                        }
                        if ((commitSession = tablet.prepareMutationsForCommit(us.cenv, mutations)) == null) {
                            if (us.currentTablet == tablet) {
                                us.currentTablet = null;
                            }
                            us.failures.put(tablet.getExtent(), us.successfulCommits.get((Object)tablet));
                            continue;
                        }
                        sendables.put(commitSession, mutations);
                        mutationCount += mutations.size();
                    }
                    catch (Tablet.TConstraintViolationException e) {
                        us.violations.add(e.getViolations());
                        if (this.updateMetrics.isEnabled()) {
                            this.updateMetrics.add("constraintViolations", 0L);
                        }
                        if (e.getNonViolators().size() > 0) {
                            sendables.put(e.getCommitSession(), e.getNonViolators());
                        }
                        mutationCount += mutations.size();
                    }
                    catch (HoldTimeoutException t) {
                        error = t;
                        log.debug((Object)"Giving up on mutations due to a long memory hold time");
                        break;
                    }
                    catch (Throwable t) {
                        error = t;
                        log.error((Object)"Unexpected error preparing for commit", error);
                        break;
                    }
                }
            }
            finally {
                prep.stop();
            }
            long pt2 = System.currentTimeMillis();
            us.prepareTimes.addStat(pt2 - pt1);
            this.updateAvgPrepTime(pt2 - pt1, us.queuedMutations.size());
            if (error != null) {
                for (Map.Entry e : sendables.entrySet()) {
                    ((Tablet.CommitSession)e.getKey()).abortCommit((List)e.getValue());
                }
                throw new RuntimeException(error);
            }
            try {
                Span wal = Trace.start((String)"wal");
                try {
                    while (true) {
                        try {
                            long t1 = System.currentTimeMillis();
                            TabletServer.this.logger.logManyTablets(sendables);
                            long t2 = System.currentTimeMillis();
                            us.walogTimes.addStat(t2 - t1);
                            this.updateWalogWriteTime(t2 - t1);
                        }
                        catch (IOException ex) {
                            log.warn((Object)"logging mutations failed, retrying");
                            continue;
                        }
                        catch (FSError ex) {
                            log.warn((Object)"logging mutations failed, retrying");
                            continue;
                        }
                        catch (Throwable t) {
                            log.error((Object)"Unknown exception logging mutations, counts for mutations in flight not decremented!", t);
                            throw new RuntimeException(t);
                        }
                        break;
                    }
                }
                finally {
                    wal.stop();
                }
                Span commit = Trace.start((String)"commit");
                try {
                    long t1 = System.currentTimeMillis();
                    for (Map.Entry entry : sendables.entrySet()) {
                        Tablet.CommitSession commitSession = (Tablet.CommitSession)entry.getKey();
                        List mutations = (List)entry.getValue();
                        commitSession.commit(mutations);
                        Tablet tablet = commitSession.getTablet();
                        if (tablet != us.currentTablet) continue;
                        us.successfulCommits.increment((Object)tablet, (long)us.queuedMutations.get(tablet).size());
                    }
                    long t2 = System.currentTimeMillis();
                    us.flushTime += t2 - pt1;
                    us.commitTimes.addStat(t2 - t1);
                    this.updateAvgCommitTime(t2 - t1, sendables.size());
                }
                finally {
                    commit.stop();
                }
            }
            finally {
                us.queuedMutations.clear();
                if (us.currentTablet != null) {
                    us.queuedMutations.put(us.currentTablet, new ArrayList());
                }
                us.queuedMutationSize = 0L;
            }
            us.totalUpdates += (long)mutationCount;
        }

        private void updateWalogWriteTime(long time) {
            if (this.updateMetrics.isEnabled()) {
                this.updateMetrics.add("waLogWriteTime", time);
            }
        }

        private void updateAvgCommitTime(long time, int size) {
            if (this.updateMetrics.isEnabled()) {
                this.updateMetrics.add("commitTime", (long)((double)time / (double)size));
            }
        }

        private void updateAvgPrepTime(long time, int size) {
            if (this.updateMetrics.isEnabled()) {
                this.updateMetrics.add("commitPrep", (long)((double)time / (double)size));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpdateErrors closeUpdate(TInfo tinfo, long updateID) throws NoSuchScanIDException {
            ConstraintViolationSummary first;
            List violations;
            UpdateSession us = (UpdateSession)this.sessionManager.removeSession(updateID);
            if (us == null) {
                throw new NoSuchScanIDException();
            }
            long opid = this.writeTracker.startWrite(us.queuedMutations.keySet());
            try {
                this.flush(us);
            }
            finally {
                this.writeTracker.finishWrite(opid);
            }
            log.debug((Object)String.format("UpSess %s %,d in %.3fs, at=[%s] ft=%.3fs(pt=%.3fs lt=%.3fs ct=%.3fs)", TServerUtils.clientAddress.get(), us.totalUpdates, (double)(System.currentTimeMillis() - us.startTime) / 1000.0, us.authTimes.toString(), (double)us.flushTime / 1000.0, (double)us.prepareTimes.getSum() / 1000.0, (double)us.walogTimes.getSum() / 1000.0, (double)us.commitTimes.getSum() / 1000.0));
            if (us.failures.size() > 0) {
                Map.Entry<KeyExtent, Long> first2 = us.failures.entrySet().iterator().next();
                log.debug((Object)String.format("Failures: %d, first extent %s successful commits: %d", us.failures.size(), first2.getKey().toString(), first2.getValue()));
            }
            if ((violations = us.violations.asList()).size() > 0) {
                first = (ConstraintViolationSummary)us.violations.asList().iterator().next();
                log.debug((Object)String.format("Violations: %d, first %s occurs %d", violations.size(), first.violationDescription, first.numberOfViolatingMutations));
            }
            if (us.authFailures.size() > 0) {
                first = us.authFailures.keySet().iterator().next();
                log.debug((Object)String.format("Authentication Failures: %d, first %s", us.authFailures.size(), first.toString()));
            }
            return new UpdateErrors(Translator.translate(us.failures, (Translator)Translators.KET), Translator.translate((Collection)violations, (Translator)Translators.CVST), Translator.translate(us.authFailures, (Translator)Translators.KET));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, TMutation tmutation) throws NotServingTabletException, ConstraintViolationException, ThriftSecurityException {
            String tableId = new String(tkeyExtent.getTable(), Constants.UTF8);
            if (!TabletServer.this.security.canWrite(credentials, tableId, Tables.getNamespaceId((Instance)TabletServer.this.instance, (String)tableId))) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            KeyExtent keyExtent = new KeyExtent(tkeyExtent);
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(new KeyExtent(keyExtent));
            if (tablet == null) {
                throw new NotServingTabletException(tkeyExtent);
            }
            if (!keyExtent.isMeta()) {
                TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
            }
            long opid = this.writeTracker.startWrite(TabletType.type((KeyExtent)keyExtent));
            try {
                Tablet.CommitSession cs;
                ServerMutation mutation = new ServerMutation(tmutation);
                List<ServerMutation> mutations = Collections.singletonList(mutation);
                Span prep = Trace.start((String)"prep");
                try {
                    cs = tablet.prepareMutationsForCommit(new TservConstraintEnv(TabletServer.this.security, credentials), mutations);
                }
                finally {
                    prep.stop();
                }
                if (cs == null) {
                    throw new NotServingTabletException(tkeyExtent);
                }
                while (true) {
                    try {
                        Span wal = Trace.start((String)"wal");
                        try {
                            TabletServer.this.logger.log(cs, cs.getWALogSeq(), (Mutation)mutation);
                        }
                        finally {
                            wal.stop();
                        }
                    }
                    catch (IOException ex) {
                        log.warn((Object)ex, (Throwable)ex);
                        continue;
                    }
                    break;
                }
                Span commit = Trace.start((String)"commit");
                try {
                    cs.commit(mutations);
                }
                finally {
                    commit.stop();
                }
            }
            catch (Tablet.TConstraintViolationException e) {
                throw new ConstraintViolationException(Translator.translate((Collection)e.getViolations().asList(), (Translator)Translators.CVST));
            }
            finally {
                this.writeTracker.finishWrite(opid);
            }
        }

        private void checkConditions(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession cs, List<String> symbols) throws IOException {
            Iterator<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> iter = updates.entrySet().iterator();
            CompressedIterators compressedIters = new CompressedIterators(symbols);
            while (iter.hasNext()) {
                Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry = iter.next();
                Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(entry.getKey());
                if (tablet == null || tablet.isClosed()) {
                    for (ServerConditionalMutation scm : entry.getValue()) {
                        results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    }
                    iter.remove();
                    continue;
                }
                ArrayList<ServerConditionalMutation> okMutations = new ArrayList<ServerConditionalMutation>(entry.getValue().size());
                for (ServerConditionalMutation scm : entry.getValue()) {
                    if (!this.checkCondition(results, cs, compressedIters, tablet, scm)) continue;
                    okMutations.add(scm);
                }
                entry.setValue(okMutations);
            }
        }

        boolean checkCondition(ArrayList<TCMResult> results, ConditionalSession cs, CompressedIterators compressedIters, Tablet tablet, ServerConditionalMutation scm) throws IOException {
            boolean add = true;
            Set<Column> emptyCols = Collections.emptySet();
            for (TCondition tc : scm.getConditions()) {
                Range range = tc.hasTimestamp ? Range.exact((Text)new Text(scm.getRow()), (Text)new Text(tc.getCf()), (Text)new Text(tc.getCq()), (Text)new Text(tc.getCv()), (long)tc.getTs()) : Range.exact((Text)new Text(scm.getRow()), (Text)new Text(tc.getCf()), (Text)new Text(tc.getCq()), (Text)new Text(tc.getCv()));
                CompressedIterators.IterConfig ic = compressedIters.decompress(tc.iterators);
                Tablet.Scanner scanner = tablet.createScanner(range, 1, emptyCols, cs.auths, ic.ssiList, ic.ssio, false, cs.interruptFlag);
                try {
                    Tablet.ScanBatch batch = scanner.read();
                    Value val = null;
                    Iterator<Tablet.KVEntry> i$ = batch.results.iterator();
                    if (i$.hasNext()) {
                        Tablet.KVEntry entry2 = i$.next();
                        val = entry2.getValue();
                    }
                    if (!(val == null ^ tc.getVal() == null) && (val == null || Arrays.equals(tc.getVal(), val.get()))) continue;
                    results.add(new TCMResult(scm.getID(), TCMStatus.REJECTED));
                    add = false;
                }
                catch (Tablet.TabletClosedException e) {
                    results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    add = false;
                }
                catch (IterationInterruptedException iie) {
                    results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    add = false;
                }
                catch (TooManyFilesException tmfe) {
                    results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    add = false;
                }
                break;
            }
            return add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeConditionalMutations(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession sess) {
            Set<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> es = updates.entrySet();
            HashMap<Tablet.CommitSession, List<Mutation>> sendables = new HashMap<Tablet.CommitSession, List<Mutation>>();
            boolean sessionCanceled = sess.interruptFlag.get();
            Span prepSpan = Trace.start((String)"prep");
            try {
                long t1 = System.currentTimeMillis();
                for (Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry : es) {
                    Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(entry.getKey());
                    if (tablet == null || tablet.isClosed() || sessionCanceled) {
                        for (ServerConditionalMutation scm : entry.getValue()) {
                            results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                        }
                        continue;
                    }
                    try {
                        List<ServerConditionalMutation> mutations = entry.getValue();
                        if (mutations.size() <= 0) continue;
                        Tablet.CommitSession cs = tablet.prepareMutationsForCommit(new TservConstraintEnv(TabletServer.this.security, sess.credentials), mutations);
                        if (cs == null) {
                            for (ServerConditionalMutation scm : entry.getValue()) {
                                results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                            }
                            continue;
                        }
                        for (ServerConditionalMutation scm : entry.getValue()) {
                            results.add(new TCMResult(scm.getID(), TCMStatus.ACCEPTED));
                        }
                        sendables.put(cs, mutations);
                    }
                    catch (Tablet.TConstraintViolationException e) {
                        if (e.getNonViolators().size() > 0) {
                            sendables.put(e.getCommitSession(), e.getNonViolators());
                            for (Mutation m : e.getNonViolators()) {
                                results.add(new TCMResult(((ServerConditionalMutation)m).getID(), TCMStatus.ACCEPTED));
                            }
                        }
                        for (Mutation m : e.getViolators()) {
                            results.add(new TCMResult(((ServerConditionalMutation)m).getID(), TCMStatus.VIOLATED));
                        }
                    }
                }
                long t2 = System.currentTimeMillis();
                this.updateAvgPrepTime(t2 - t1, es.size());
            }
            finally {
                prepSpan.stop();
            }
            Span walSpan = Trace.start((String)"wal");
            try {
                while (sendables.size() > 0) {
                    try {
                        long t1 = System.currentTimeMillis();
                        TabletServer.this.logger.logManyTablets(sendables);
                        long t2 = System.currentTimeMillis();
                        this.updateWalogWriteTime(t2 - t1);
                        break;
                    }
                    catch (IOException ex) {
                        log.warn((Object)"logging mutations failed, retrying");
                    }
                    catch (FSError ex) {
                        log.warn((Object)"logging mutations failed, retrying");
                    }
                    catch (Throwable t) {
                        log.error((Object)"Unknown exception logging mutations, counts for mutations in flight not decremented!", t);
                        throw new RuntimeException(t);
                    }
                }
            }
            finally {
                walSpan.stop();
            }
            Span commitSpan = Trace.start((String)"commit");
            try {
                long t1 = System.currentTimeMillis();
                for (Map.Entry entry : sendables.entrySet()) {
                    Tablet.CommitSession commitSession = (Tablet.CommitSession)entry.getKey();
                    List mutations = (List)entry.getValue();
                    commitSession.commit(mutations);
                }
                long t2 = System.currentTimeMillis();
                this.updateAvgCommitTime(t2 - t1, sendables.size());
                return;
            }
            finally {
                commitSpan.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<KeyExtent, List<ServerConditionalMutation>> conditionalUpdate(ConditionalSession cs, Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, List<String> symbols) throws IOException {
            ConditionalMutationSet.sortConditionalMutations(updates);
            HashMap<KeyExtent, List<ServerConditionalMutation>> deferred = new HashMap<KeyExtent, List<ServerConditionalMutation>>();
            ConditionalMutationSet.deferDuplicatesRows(updates, deferred);
            List<RowLocks.RowLock> locks = this.rowLocks.acquireRowlocks(updates, deferred);
            try {
                Span checkSpan = Trace.start((String)"Check conditions");
                try {
                    this.checkConditions(updates, results, cs, symbols);
                }
                finally {
                    checkSpan.stop();
                }
                Span updateSpan = Trace.start((String)"apply conditional mutations");
                try {
                    this.writeConditionalMutations(updates, results, cs);
                }
                finally {
                    updateSpan.stop();
                }
            }
            finally {
                this.rowLocks.releaseRowLocks(locks);
            }
            return deferred;
        }

        public TConditionalSession startConditionalUpdate(TInfo tinfo, TCredentials credentials, List<ByteBuffer> authorizations, String tableId) throws ThriftSecurityException, TException {
            Authorizations userauths = null;
            if (!TabletServer.this.security.canConditionallyUpdate(credentials, tableId, Tables.getNamespaceId((Instance)TabletServer.this.instance, (String)tableId), authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            userauths = TabletServer.this.security.getUserAuthorizations(credentials);
            for (ByteBuffer auth : authorizations) {
                if (userauths.contains(ByteBufferUtil.toBytes((ByteBuffer)auth))) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
            }
            ConditionalSession cs = new ConditionalSession();
            cs.auths = new Authorizations(authorizations);
            cs.credentials = credentials;
            cs.tableId = tableId;
            cs.interruptFlag = new AtomicBoolean();
            long sid = this.sessionManager.createSession(cs, false);
            return new TConditionalSession(sid, TabletServer.this.lockID, this.sessionManager.getMaxIdleTime());
        }

        public List<TCMResult> conditionalUpdate(TInfo tinfo, long sessID, Map<TKeyExtent, List<TConditionalMutation>> mutations, List<String> symbols) throws NoSuchScanIDException, TException {
            ConditionalSession cs = (ConditionalSession)this.sessionManager.reserveSession(sessID);
            if (cs == null || cs.interruptFlag.get()) {
                throw new NoSuchScanIDException();
            }
            if (!cs.tableId.equals("!0") && !cs.tableId.equals("+r")) {
                TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
            }
            Text tid = new Text(cs.tableId);
            long opid = this.writeTracker.startWrite(TabletType.type((KeyExtent)new KeyExtent(tid, null, null)));
            try {
                Map updates = Translator.translate(mutations, (Translator)Translators.TKET, (Translator)new Translator.ListTranslator((Translator)ServerConditionalMutation.TCMT));
                for (KeyExtent ke : updates.keySet()) {
                    if (ke.getTableId().equals((Object)tid)) continue;
                    throw new IllegalArgumentException("Unexpected table id " + tid + " != " + ke.getTableId());
                }
                ArrayList<TCMResult> results = new ArrayList<TCMResult>();
                Map<KeyExtent, List<ServerConditionalMutation>> deferred = this.conditionalUpdate(cs, updates, results, symbols);
                while (deferred.size() > 0) {
                    deferred = this.conditionalUpdate(cs, deferred, results, symbols);
                }
                ArrayList<TCMResult> arrayList = results;
                return arrayList;
            }
            catch (IOException ioe) {
                throw new TException((Throwable)ioe);
            }
            finally {
                this.writeTracker.finishWrite(opid);
                this.sessionManager.unreserveSession(sessID);
            }
        }

        public void invalidateConditionalUpdate(TInfo tinfo, long sessID) throws TException {
            ConditionalSession cs = (ConditionalSession)this.sessionManager.getSession(sessID);
            if (cs != null) {
                cs.interruptFlag.set(true);
            }
            if ((cs = (ConditionalSession)this.sessionManager.reserveSession(sessID, true)) != null) {
                this.sessionManager.removeSession(sessID, true);
            }
        }

        public void closeConditionalUpdate(TInfo tinfo, long sessID) throws TException {
            this.sessionManager.removeSession(sessID, false);
        }

        public void splitTablet(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, ByteBuffer splitPoint) throws NotServingTabletException, ThriftSecurityException {
            String namespaceId;
            String tableId = new String(ByteBufferUtil.toBytes((ByteBuffer)tkeyExtent.table));
            try {
                namespaceId = Tables.getNamespaceId((Instance)TabletServer.this.instance, (String)tableId);
            }
            catch (IllegalArgumentException ex) {
                throw new NotServingTabletException(tkeyExtent);
            }
            if (!TabletServer.this.security.canSplitTablet(credentials, tableId, namespaceId)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            KeyExtent keyExtent = new KeyExtent(tkeyExtent);
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(keyExtent);
            if (tablet == null) {
                throw new NotServingTabletException(tkeyExtent);
            }
            if (keyExtent.getEndRow() == null || !keyExtent.getEndRow().equals((Object)ByteBufferUtil.toText((ByteBuffer)splitPoint))) {
                try {
                    if (TabletServer.this.splitTablet(tablet, ByteBufferUtil.toBytes((ByteBuffer)splitPoint)) == null) {
                        throw new NotServingTabletException(tkeyExtent);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Failed to split " + keyExtent), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return TabletServer.this.getStats(this.sessionManager.getActiveScansPerTable());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TabletStats> getTabletStats(TInfo tinfo, TCredentials credentials, String tableId) throws ThriftSecurityException, TException {
            TreeMap onlineTabletsCopy;
            SortedMap sortedMap = TabletServer.this.onlineTablets;
            synchronized (sortedMap) {
                onlineTabletsCopy = new TreeMap(TabletServer.this.onlineTablets);
            }
            ArrayList<TabletStats> result = new ArrayList<TabletStats>();
            Text text = new Text(tableId);
            KeyExtent start = new KeyExtent(text, new Text(), null);
            for (Map.Entry entry : onlineTabletsCopy.tailMap(start).entrySet()) {
                KeyExtent ke = entry.getKey();
                if (ke.getTableId().compareTo((BinaryComparable)text) != 0) continue;
                Tablet tablet = (Tablet)entry.getValue();
                TabletStats stats = tablet.timer.getTabletStats();
                stats.extent = ke.toThrift();
                stats.ingestRate = tablet.ingestRate();
                stats.queryRate = tablet.queryRate();
                stats.splitCreationTime = tablet.getSplitCreationTime();
                stats.numEntries = tablet.getNumEntries();
                result.add(stats);
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void checkPermission(TCredentials credentials, String lock, final String request) throws ThriftSecurityException {
            block9: {
                boolean fatal = false;
                try {
                    log.debug((Object)("Got " + request + " message from user: " + credentials.getPrincipal()));
                    if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                        log.warn((Object)("Got " + request + " message from user: " + credentials.getPrincipal()));
                        throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    if (!fatal) break block9;
                }
                catch (ThriftSecurityException e) {
                    try {
                        log.warn((Object)("Got " + request + " message from unauthenticatable user: " + e.getUser()));
                        if (!SystemCredentials.get().getToken().getClass().getName().equals(credentials.getTokenClassName())) throw e;
                        log.fatal((Object)"Got message from a service with a mismatched configuration. Please ensure a compatible configuration.", (Throwable)e);
                        fatal = true;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (!fatal) throw throwable;
                        Halt.halt((int)1, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TabletServer.logGCInfo(TabletServer.this.getSystemConfiguration());
                            }
                        });
                        throw throwable;
                    }
                }
                Halt.halt((int)1, (Runnable)new /* invalid duplicate definition of identical inner class */);
            }
            if (TabletServer.this.tabletServerLock == null || !TabletServer.this.tabletServerLock.wasLockAcquired()) {
                log.warn((Object)("Got " + request + " message from master before lock acquired, ignoring..."));
                throw new RuntimeException("Lock not acquired");
            }
            if (TabletServer.this.tabletServerLock != null && TabletServer.this.tabletServerLock.wasLockAcquired() && !TabletServer.this.tabletServerLock.isLocked()) {
                Halt.halt((int)1, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        log.info((Object)("Tablet server no longer holds lock during checkPermission() : " + request + ", exiting"));
                        TabletServer.logGCInfo(TabletServer.this.getSystemConfiguration());
                    }
                });
            }
            if (lock == null) return;
            ZooUtil.LockID lid = new ZooUtil.LockID(ZooUtil.getRoot((Instance)TabletServer.this.instance) + "/masters/lock", lock);
            try {
                if (ZooLock.isLockHeld((org.apache.accumulo.fate.zookeeper.ZooCache)this.masterLockCache, (ZooUtil.LockID)lid)) return;
                this.masterLockCache.clear();
                if (ZooLock.isLockHeld((org.apache.accumulo.fate.zookeeper.ZooCache)this.masterLockCache, (ZooUtil.LockID)lid)) return;
                log.warn((Object)("Got " + request + " message from a master that does not hold the current lock " + lock));
                throw new RuntimeException("bad master lock");
            }
            catch (Exception e) {
                throw new RuntimeException("bad master lock", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
            try {
                this.checkPermission(credentials, lock, "loadTablet");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent extent = new KeyExtent(textent);
            SortedSet sortedSet = TabletServer.this.unopenedTablets;
            synchronized (sortedSet) {
                SortedSet sortedSet2 = TabletServer.this.openingTablets;
                synchronized (sortedSet2) {
                    SortedMap sortedMap = TabletServer.this.onlineTablets;
                    synchronized (sortedMap) {
                        Set unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedSet)TabletServer.this.unopenedTablets);
                        Set openingOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedSet)TabletServer.this.openingTablets);
                        Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedMap)TabletServer.this.onlineTablets);
                        HashSet all = new HashSet();
                        all.addAll(unopenedOverlapping);
                        all.addAll(openingOverlapping);
                        all.addAll(onlineOverlapping);
                        if (!all.isEmpty()) {
                            for (KeyExtent e2 : onlineOverlapping) {
                                Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(e2);
                                if (System.currentTimeMillis() - tablet.getSplitCreationTime() >= 60000L) continue;
                                all.remove(e2);
                            }
                            all.remove(extent);
                            if (all.size() > 0) {
                                log.error((Object)("Tablet " + extent + " overlaps previously assigned " + unopenedOverlapping + " " + openingOverlapping + " " + onlineOverlapping + " " + all));
                            }
                            return;
                        }
                        TabletServer.this.unopenedTablets.add(extent);
                    }
                }
            }
            log.info((Object)("Loading tablet " + extent));
            LoggingRunnable ah = new LoggingRunnable(log, (Runnable)new AssignmentHandler(extent));
            if (extent.isRootTablet()) {
                new Daemon("Root Tablet Assignment", (Runnable)ah, extent){
                    final /* synthetic */ Runnable val$ah;
                    final /* synthetic */ KeyExtent val$extent;
                    {
                        this.val$ah = runnable;
                        this.val$extent = keyExtent;
                        super(x0);
                    }

                    public void run() {
                        this.val$ah.run();
                        if (TabletServer.this.onlineTablets.containsKey(this.val$extent)) {
                            log.info((Object)("Root tablet loaded: " + this.val$extent));
                        } else {
                            log.info((Object)"Root tablet failed to load");
                        }
                    }
                }.start();
            } else if (extent.isMeta()) {
                TabletServer.this.resourceManager.addMetaDataAssignment((Runnable)ah);
            } else {
                TabletServer.this.resourceManager.addAssignment((Runnable)ah);
            }
        }

        public void unloadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent, boolean save) {
            try {
                this.checkPermission(credentials, lock, "unloadTablet");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent extent = new KeyExtent(textent);
            TabletServer.this.resourceManager.addMigration(extent, (Runnable)new LoggingRunnable(log, (Runnable)new UnloadTabletHandler(extent, save)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
            try {
                this.checkPermission(credentials, lock, "flush");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            ArrayList<Tablet> tabletsToFlush = new ArrayList<Tablet>();
            KeyExtent ke = new KeyExtent(new Text(tableId), ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
            SortedMap sortedMap = TabletServer.this.onlineTablets;
            synchronized (sortedMap) {
                for (Tablet tablet : TabletServer.this.onlineTablets.values()) {
                    if (!ke.overlaps(tablet.getExtent())) continue;
                    tabletsToFlush.add(tablet);
                }
            }
            Long flushID = null;
            for (Tablet tablet : tabletsToFlush) {
                if (flushID == null) {
                    try {
                        flushID = tablet.getFlushID();
                    }
                    catch (KeeperException.NoNodeException e) {
                        log.info((Object)("Asked to flush table that has no flush id " + ke + " " + e.getMessage()));
                        return;
                    }
                }
                tablet.flush(flushID);
            }
        }

        public void flushTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) throws TException {
            try {
                this.checkPermission(credentials, lock, "flushTablet");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(new KeyExtent(textent));
            if (tablet != null) {
                log.info((Object)("Flushing " + tablet.getExtent()));
                try {
                    tablet.flush(tablet.getFlushID());
                }
                catch (KeeperException.NoNodeException nne) {
                    log.info((Object)("Asked to flush tablet that has no flush id " + new KeyExtent(textent) + " " + nne.getMessage()));
                }
            }
        }

        public void halt(TInfo tinfo, TCredentials credentials, String lock) throws ThriftSecurityException {
            this.checkPermission(credentials, lock, "halt");
            Halt.halt((int)0, (Runnable)new Runnable(){

                @Override
                public void run() {
                    log.info((Object)"Master requested tablet server halt");
                    TabletServer.logGCInfo(TabletServer.this.getSystemConfiguration());
                    TabletServer.this.serverStopRequested = true;
                    try {
                        TabletServer.this.tabletServerLock.unlock();
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            });
        }

        public void fastHalt(TInfo info, TCredentials credentials, String lock) {
            try {
                this.halt(info, credentials, lock);
            }
            catch (Exception e) {
                log.warn((Object)"Error halting", (Throwable)e);
            }
        }

        public TabletStats getHistoricalStats(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return TabletServer.this.statsKeeper.getTabletStats();
        }

        public List<ActiveScan> getActiveScans(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            try {
                this.checkPermission(credentials, null, "getScans");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw e;
            }
            return this.sessionManager.getActiveScans();
        }

        public void chop(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) throws TException {
            try {
                this.checkPermission(credentials, lock, "chop");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent ke = new KeyExtent(textent);
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(ke);
            if (tablet != null) {
                tablet.chopFiles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void compact(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws TException {
            try {
                this.checkPermission(credentials, lock, "compact");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent ke = new KeyExtent(new Text(tableId), ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
            ArrayList<Tablet> tabletsToCompact = new ArrayList<Tablet>();
            SortedMap sortedMap = TabletServer.this.onlineTablets;
            synchronized (sortedMap) {
                for (Tablet tablet : TabletServer.this.onlineTablets.values()) {
                    if (!ke.overlaps(tablet.getExtent())) continue;
                    tabletsToCompact.add(tablet);
                }
            }
            Long compactionId = null;
            for (Tablet tablet : tabletsToCompact) {
                if (compactionId == null) {
                    try {
                        compactionId = (Long)tablet.getCompactionID().getFirst();
                    }
                    catch (KeeperException.NoNodeException e) {
                        log.info((Object)("Asked to compact table with no compaction id " + ke + " " + e.getMessage()));
                        return;
                    }
                }
                tablet.compactAll(compactionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLogs(TInfo tinfo, TCredentials credentials, List<String> filenames) throws TException {
            String myname = TabletServer.this.getClientAddressString();
            myname = myname.replace(':', '+');
            HashSet<String> loggers = new HashSet<String>();
            TabletServer.this.logger.getLogFiles(loggers);
            HashSet<String> loggerUUIDs = new HashSet<String>();
            for (String logger : loggers) {
                loggerUUIDs.add(new Path(logger).getName());
            }
            block8: for (String filename : filenames) {
                String uuid = new Path(filename).getName();
                if (loggerUUIDs.contains(uuid)) continue;
                ArrayList onlineTabletsCopy = new ArrayList();
                SortedMap sortedMap = TabletServer.this.onlineTablets;
                synchronized (sortedMap) {
                    onlineTabletsCopy.addAll(TabletServer.this.onlineTablets.values());
                }
                for (Tablet tablet : onlineTabletsCopy) {
                    for (String current : tablet.getCurrentLogFiles()) {
                        if (!current.contains(uuid)) continue;
                        log.info((Object)("Attempted to delete " + filename + " from tablet " + tablet.getExtent()));
                        continue block8;
                    }
                }
                try {
                    Path source = new Path(filename);
                    if (this.acuConf.getBoolean(Property.TSERV_ARCHIVE_WALOGS)) {
                        Path walogArchive = TabletServer.this.fs.matchingFileSystem(source, ServerConstants.getWalogArchives());
                        TabletServer.this.fs.mkdirs(walogArchive);
                        Path dest = new Path(walogArchive, source.getName());
                        log.info((Object)("Archiving walog " + source + " to " + dest));
                        if (TabletServer.this.fs.rename(source, dest)) continue;
                        log.error((Object)"rename is unsuccessful");
                        continue;
                    }
                    log.info((Object)("Deleting walog " + filename));
                    Path sourcePath = new Path(filename);
                    if (!(!this.acuConf.getBoolean(Property.GC_TRASH_IGNORE) && TabletServer.this.fs.moveToTrash(sourcePath) || TabletServer.this.fs.deleteRecursively(sourcePath))) {
                        log.warn((Object)("Failed to delete walog " + source));
                    }
                    for (String recovery : ServerConstants.getRecoveryDirs()) {
                        Path recoveryPath = new Path(recovery, source.getName());
                        try {
                            if (!TabletServer.this.fs.moveToTrash(recoveryPath) && !TabletServer.this.fs.deleteRecursively(recoveryPath)) continue;
                            log.info((Object)("Deleted any recovery log " + filename));
                        }
                        catch (FileNotFoundException ex) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Error attempting to delete write-ahead log " + filename + ": " + e));
                }
            }
        }

        public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            try {
                this.checkPermission(credentials, null, "getActiveCompactions");
            }
            catch (ThriftSecurityException e) {
                log.error((Object)e, (Throwable)e);
                throw e;
            }
            List<Compactor.CompactionInfo> compactions = Compactor.getRunningCompactions();
            ArrayList<ActiveCompaction> ret = new ArrayList<ActiveCompaction>(compactions.size());
            for (Compactor.CompactionInfo compactionInfo : compactions) {
                ret.add(compactionInfo.toThrift());
            }
            return ret;
        }

        private class LookupTask
        extends ScanTask<MultiScanResult> {
            private long scanID;

            LookupTask(long scanID) {
                this.scanID = scanID;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MultiScanSession session = (MultiScanSession)ThriftClientHandler.this.sessionManager.getSession(this.scanID);
                String oldThreadName = Thread.currentThread().getName();
                try {
                    if (this.isCancelled() || session == null) {
                        return;
                    }
                    TableConfiguration acuTableConf = ServerConfiguration.getTableConfiguration((Instance)TabletServer.this.instance, (String)session.threadPoolExtent.getTableId().toString());
                    long maxResultsSize = acuTableConf.getMemoryInBytes(Property.TABLE_SCAN_MAXMEM);
                    this.runState.set(ScanRunState.RUNNING);
                    Thread.currentThread().setName("Client: " + session.client + " User: " + session.user + " Start: " + session.startTime + " Table: ");
                    long bytesAdded = 0L;
                    long maxScanTime = 4000L;
                    long startTime = System.currentTimeMillis();
                    ArrayList<Tablet.KVEntry> results = new ArrayList<Tablet.KVEntry>();
                    HashMap<KeyExtent, List<Range>> failures = new HashMap<KeyExtent, List<Range>>();
                    ArrayList<KeyExtent> fullScans = new ArrayList<KeyExtent>();
                    KeyExtent partScan = null;
                    Key partNextKey = null;
                    boolean partNextKeyInclusive = false;
                    Iterator<Map.Entry<KeyExtent, List<Range>>> iter = session.queries.entrySet().iterator();
                    while (iter.hasNext() && bytesAdded < maxResultsSize && System.currentTimeMillis() - startTime < maxScanTime) {
                        Tablet.LookupResult lookupResult;
                        Map.Entry<KeyExtent, List<Range>> entry = iter.next();
                        iter.remove();
                        Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(entry.getKey());
                        if (tablet == null) {
                            failures.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        Thread.currentThread().setName("Client: " + session.client + " User: " + session.user + " Start: " + session.startTime + " Tablet: " + entry.getKey().toString());
                        try {
                            if (this.isCancelled()) {
                                this.interruptFlag.set(true);
                            }
                            lookupResult = tablet.lookup(entry.getValue(), session.columnSet, session.auths, results, maxResultsSize - bytesAdded, session.ssiList, session.ssio, this.interruptFlag);
                            this.interruptFlag.set(false);
                        }
                        catch (IOException e) {
                            log.warn((Object)("lookup failed for tablet " + entry.getKey()), (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        bytesAdded += lookupResult.bytesAdded;
                        if (lookupResult.unfinishedRanges.size() > 0) {
                            if (lookupResult.closed) {
                                failures.put(entry.getKey(), lookupResult.unfinishedRanges);
                                continue;
                            }
                            session.queries.put(entry.getKey(), lookupResult.unfinishedRanges);
                            partScan = entry.getKey();
                            partNextKey = lookupResult.unfinishedRanges.get(0).getStartKey();
                            partNextKeyInclusive = lookupResult.unfinishedRanges.get(0).isStartKeyInclusive();
                            continue;
                        }
                        fullScans.add(entry.getKey());
                    }
                    long finishTime = System.currentTimeMillis();
                    session.totalLookupTime += finishTime - startTime;
                    session.numEntries += results.size();
                    ArrayList<TKeyValue> retResults = new ArrayList<TKeyValue>();
                    for (Tablet.KVEntry entry : results) {
                        retResults.add(new TKeyValue(entry.key.toThrift(), ByteBuffer.wrap(entry.value)));
                    }
                    Map retFailures = Translator.translate(failures, (Translator)Translators.KET, (Translator)new Translator.ListTranslator(Translators.RT));
                    List retFullScans = Translator.translate(fullScans, (Translator)Translators.KET);
                    TKeyExtent retPartScan = null;
                    TKey retPartNextKey = null;
                    if (partScan != null) {
                        retPartScan = partScan.toThrift();
                        retPartNextKey = partNextKey.toThrift();
                    }
                    this.addResult(new MultiScanResult(retResults, retFailures, retFullScans, retPartScan, retPartNextKey, partNextKeyInclusive, session.queries.size() != 0));
                }
                catch (IterationInterruptedException iie) {
                    if (!this.isCancelled()) {
                        log.warn((Object)"Iteration interrupted, when scan not cancelled", (Throwable)iie);
                        this.addResult((Object)iie);
                    }
                }
                catch (Throwable e) {
                    log.warn((Object)"exception while doing multi-scan ", e);
                    this.addResult(e);
                }
                finally {
                    Thread.currentThread().setName(oldThreadName);
                    this.runState.set(ScanRunState.FINISHED);
                }
            }
        }

        private class NextBatchTask
        extends ScanTask<Tablet.ScanBatch> {
            private long scanID;

            NextBatchTask(long scanID, AtomicBoolean interruptFlag) {
                this.scanID = scanID;
                this.interruptFlag = interruptFlag;
                if (interruptFlag.get()) {
                    this.cancel(true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ScanSession scanSession = (ScanSession)ThriftClientHandler.this.sessionManager.getSession(this.scanID);
                String oldThreadName = Thread.currentThread().getName();
                try {
                    if (this.isCancelled() || scanSession == null) {
                        return;
                    }
                    this.runState.set(ScanRunState.RUNNING);
                    Thread.currentThread().setName("User: " + scanSession.user + " Start: " + scanSession.startTime + " Client: " + scanSession.client + " Tablet: " + scanSession.extent);
                    Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(scanSession.extent);
                    if (tablet == null) {
                        this.addResult(new NotServingTabletException(scanSession.extent.toThrift()));
                        return;
                    }
                    long t1 = System.currentTimeMillis();
                    Tablet.ScanBatch batch = scanSession.scanner.read();
                    long t2 = System.currentTimeMillis();
                    scanSession.nbTimes.addStat(t2 - t1);
                    this.addResult(batch);
                }
                catch (Tablet.TabletClosedException e) {
                    this.addResult(new NotServingTabletException(scanSession.extent.toThrift()));
                }
                catch (IterationInterruptedException iie) {
                    if (!this.isCancelled()) {
                        log.warn((Object)"Iteration interrupted, when scan not cancelled", (Throwable)iie);
                        this.addResult((Object)iie);
                    }
                }
                catch (TooManyFilesException tmfe) {
                    this.addResult(tmfe);
                }
                catch (Throwable e) {
                    log.warn((Object)("exception while scanning tablet " + (scanSession == null ? "(unknown)" : scanSession.extent)), e);
                    this.addResult(e);
                }
                finally {
                    this.runState.set(ScanRunState.FINISHED);
                    Thread.currentThread().setName(oldThreadName);
                }
            }
        }
    }

    static class WriteTracker {
        private static AtomicLong operationCounter = new AtomicLong(1L);
        private Map<TabletType, TreeSet<Long>> inProgressWrites = new EnumMap<TabletType, TreeSet<Long>>(TabletType.class);

        WriteTracker() {
            for (TabletType ttype : TabletType.values()) {
                this.inProgressWrites.put(ttype, new TreeSet());
            }
        }

        synchronized long startWrite(TabletType ttype) {
            long operationId = operationCounter.getAndIncrement();
            this.inProgressWrites.get(ttype).add(operationId);
            return operationId;
        }

        synchronized void finishWrite(long operationId) {
            TabletType ttype;
            if (operationId == -1L) {
                return;
            }
            boolean removed = false;
            TabletType[] arr$ = TabletType.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(removed = this.inProgressWrites.get(ttype = arr$[i$]).remove(operationId)); ++i$) {
            }
            if (!removed) {
                throw new IllegalArgumentException("Attempted to finish write not in progress,  operationId " + operationId);
            }
            this.notifyAll();
        }

        synchronized void waitForWrites(TabletType ttype) {
            long operationId = operationCounter.getAndIncrement();
            while (this.inProgressWrites.get(ttype).floor(operationId) != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }

        public long startWrite(Set<Tablet> keySet) {
            if (keySet.size() == 0) {
                return -1L;
            }
            ArrayList<KeyExtent> extents = new ArrayList<KeyExtent>(keySet.size());
            for (Tablet tablet : keySet) {
                extents.add(tablet.getExtent());
            }
            return this.startWrite(TabletType.type(extents));
        }
    }

    private static class MultiScanSession
    extends Session {
        HashSet<Column> columnSet;
        Map<KeyExtent, List<Range>> queries;
        public List<IterInfo> ssiList;
        public Map<String, Map<String, String>> ssio;
        public Authorizations auths;
        int numRanges;
        int numTablets;
        int numEntries;
        long totalLookupTime;
        public volatile ScanTask<MultiScanResult> lookupTask;
        public KeyExtent threadPoolExtent;

        private MultiScanSession() {
        }

        @Override
        public void cleanup() {
            if (this.lookupTask != null) {
                this.lookupTask.cancel(true);
            }
        }
    }

    private static class ScanSession
    extends Session {
        public KeyExtent extent;
        public HashSet<Column> columnSet;
        public List<IterInfo> ssiList;
        public Map<String, Map<String, String>> ssio;
        public Authorizations auths;
        public long entriesReturned = 0L;
        public Stat nbTimes = new Stat();
        public long batchCount = 0L;
        public volatile ScanTask<Tablet.ScanBatch> nextBatchTask;
        public AtomicBoolean interruptFlag;
        public Tablet.Scanner scanner;
        public long readaheadThreshold = 3L;

        private ScanSession() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanup() {
            try {
                if (this.nextBatchTask != null) {
                    this.nextBatchTask.cancel(true);
                }
            }
            finally {
                if (this.scanner != null) {
                    this.scanner.close();
                }
            }
        }
    }

    private static class UpdateSession
    extends Session {
        public Tablet currentTablet;
        public MapCounter<Tablet> successfulCommits = new MapCounter();
        Map<KeyExtent, Long> failures = new HashMap<KeyExtent, Long>();
        HashMap<KeyExtent, SecurityErrorCode> authFailures = new HashMap();
        public Violations violations;
        public TCredentials credentials;
        public long totalUpdates = 0L;
        public long flushTime = 0L;
        Stat prepareTimes = new Stat();
        Stat walogTimes = new Stat();
        Stat commitTimes = new Stat();
        Stat authTimes = new Stat();
        public Map<Tablet, List<Mutation>> queuedMutations = new HashMap<Tablet, List<Mutation>>();
        public long queuedMutationSize = 0L;
        TservConstraintEnv cenv = null;

        private UpdateSession() {
        }
    }

    private static class ConditionalSession
    extends Session {
        public TCredentials credentials;
        public Authorizations auths;
        public String tableId;
        public AtomicBoolean interruptFlag;

        private ConditionalSession() {
        }

        @Override
        public void cleanup() {
            this.interruptFlag.set(true);
        }
    }

    private abstract class ScanTask<T>
    implements RunnableFuture<T> {
        protected AtomicBoolean interruptFlag = new AtomicBoolean(false);
        protected ArrayBlockingQueue<Object> resultQueue;
        protected AtomicInteger state;
        protected AtomicReference<ScanRunState> runState = new AtomicReference<ScanRunState>(ScanRunState.QUEUED);
        private static final int INITIAL = 1;
        private static final int ADDED = 2;
        private static final int CANCELED = 3;

        ScanTask() {
            this.state = new AtomicInteger(1);
            this.resultQueue = new ArrayBlockingQueue(1);
        }

        protected void addResult(Object o) {
            if (this.state.compareAndSet(1, 2)) {
                this.resultQueue.add(o);
            } else if (this.state.get() == 2) {
                throw new IllegalStateException("Tried to add more than one result");
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!mayInterruptIfRunning) {
                throw new IllegalArgumentException("Cancel will always attempt to interupt running next batch task");
            }
            if (this.state.get() == 3) {
                return true;
            }
            if (this.state.compareAndSet(1, 3)) {
                this.interruptFlag.set(true);
                this.resultQueue = null;
                return true;
            }
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ArrayBlockingQueue<Object> localRQ = this.resultQueue;
            if (this.state.get() == 3) {
                throw new CancellationException();
            }
            if (localRQ == null && this.state.get() == 2) {
                throw new IllegalStateException("Tried to get result twice");
            }
            Object r = localRQ.poll(timeout, unit);
            if (this.state.get() == 3) {
                if (r != null) {
                    throw new IllegalStateException("Nothing should have been added when in canceled state");
                }
                throw new CancellationException();
            }
            if (r == null) {
                throw new TimeoutException();
            }
            this.resultQueue = null;
            if (r instanceof Throwable) {
                throw new ExecutionException((Throwable)r);
            }
            return (T)r;
        }

        @Override
        public boolean isCancelled() {
            return this.state.get() == 3;
        }

        @Override
        public boolean isDone() {
            return this.runState.get().equals((Object)ScanRunState.FINISHED);
        }

        public ScanRunState getScanRunState() {
            return this.runState.get();
        }
    }

    static class TservConstraintEnv
    implements Constraint.Environment {
        private TCredentials credentials;
        private SecurityOperation security;
        private Authorizations auths;
        private KeyExtent ke;

        TservConstraintEnv(SecurityOperation secOp, TCredentials credentials) {
            this.security = secOp;
            this.credentials = credentials;
        }

        void setExtent(KeyExtent ke) {
            this.ke = ke;
        }

        public KeyExtent getExtent() {
            return this.ke;
        }

        public String getUser() {
            return this.credentials.getPrincipal();
        }

        @Deprecated
        public Authorizations getAuthorizations() {
            if (this.auths == null) {
                try {
                    this.auths = this.security.getUserAuthorizations(this.credentials);
                }
                catch (ThriftSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.auths;
        }

        public AuthorizationContainer getAuthorizationsContainer() {
            return new AuthorizationContainer(){

                public boolean contains(ByteSequence auth) {
                    try {
                        return TservConstraintEnv.this.security.userHasAuthorizations(TservConstraintEnv.this.credentials, Collections.singletonList(ByteBuffer.wrap(auth.getBackingArray(), auth.offset(), auth.length())));
                    }
                    catch (ThriftSecurityException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    private static class SessionManager {
        SecureRandom random = new SecureRandom();
        Map<Long, Session> sessions = new HashMap<Long, Session>();
        long maxIdle;

        SessionManager(AccumuloConfiguration conf) {
            this.maxIdle = conf.getTimeInMillis(Property.TSERV_SESSION_MAXIDLE);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SessionManager.this.sweep(SessionManager.this.maxIdle);
                }
            };
            SimpleTimer.getInstance().schedule(r, 0L, Math.max(this.maxIdle / 2L, 1000L));
        }

        synchronized long createSession(Session session, boolean reserve) {
            long sid = this.random.nextLong();
            while (this.sessions.containsKey(sid)) {
                sid = this.random.nextLong();
            }
            this.sessions.put(sid, session);
            session.reserved = reserve;
            session.startTime = session.lastAccessTime = System.currentTimeMillis();
            return sid;
        }

        long getMaxIdleTime() {
            return this.maxIdle;
        }

        synchronized Session reserveSession(long sessionId) {
            Session session = this.sessions.get(sessionId);
            if (session != null) {
                if (session.reserved) {
                    throw new IllegalStateException();
                }
                session.reserved = true;
            }
            return session;
        }

        synchronized Session reserveSession(long sessionId, boolean wait) {
            Session session = this.sessions.get(sessionId);
            if (session != null) {
                while (wait && session.reserved) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException();
                    }
                }
                if (session.reserved) {
                    throw new IllegalStateException();
                }
                session.reserved = true;
            }
            return session;
        }

        synchronized void unreserveSession(Session session) {
            if (!session.reserved) {
                throw new IllegalStateException();
            }
            this.notifyAll();
            session.reserved = false;
            session.lastAccessTime = System.currentTimeMillis();
        }

        synchronized void unreserveSession(long sessionId) {
            Session session = this.getSession(sessionId);
            if (session != null) {
                this.unreserveSession(session);
            }
        }

        synchronized Session getSession(long sessionId) {
            Session session = this.sessions.get(sessionId);
            if (session != null) {
                session.lastAccessTime = System.currentTimeMillis();
            }
            return session;
        }

        Session removeSession(long sessionId) {
            return this.removeSession(sessionId, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Session removeSession(long sessionId, boolean unreserve) {
            Session session = null;
            SessionManager sessionManager = this;
            synchronized (sessionManager) {
                session = this.sessions.remove(sessionId);
                if (unreserve && session != null) {
                    this.unreserveSession(session);
                }
            }
            if (session != null) {
                session.cleanup();
            }
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sweep(long maxIdle) {
            ArrayList<Session> sessionsToCleanup = new ArrayList<Session>();
            SessionManager sessionManager = this;
            synchronized (sessionManager) {
                Iterator<Session> iter = this.sessions.values().iterator();
                while (iter.hasNext()) {
                    Session session = iter.next();
                    long idleTime = System.currentTimeMillis() - session.lastAccessTime;
                    if (idleTime <= maxIdle || session.reserved) continue;
                    iter.remove();
                    sessionsToCleanup.add(session);
                }
            }
            for (Session session : sessionsToCleanup) {
                session.cleanup();
            }
        }

        synchronized void removeIfNotAccessed(final long sessionId, long delay) {
            Session session = this.sessions.get(sessionId);
            if (session != null) {
                final long removeTime = session.lastAccessTime;
                TimerTask r = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Session sessionToCleanup = null;
                        SessionManager sessionManager = SessionManager.this;
                        synchronized (sessionManager) {
                            Session session2 = SessionManager.this.sessions.get(sessionId);
                            if (session2 != null && session2.lastAccessTime == removeTime && !session2.reserved) {
                                SessionManager.this.sessions.remove(sessionId);
                                sessionToCleanup = session2;
                            }
                        }
                        if (sessionToCleanup != null) {
                            sessionToCleanup.cleanup();
                        }
                    }
                };
                SimpleTimer.getInstance().schedule((Runnable)r, delay);
            }
        }

        public synchronized Map<String, MapCounter<ScanRunState>> getActiveScansPerTable() {
            HashMap<String, MapCounter<ScanRunState>> counts = new HashMap<String, MapCounter<ScanRunState>>();
            for (Map.Entry<Long, Session> entry : this.sessions.entrySet()) {
                ScanRunState srs;
                Session session = entry.getValue();
                ScanTask<Tablet.ScanBatch> nbt = null;
                String tableID = null;
                if (session instanceof ScanSession) {
                    ScanSession ss = (ScanSession)session;
                    nbt = ss.nextBatchTask;
                    tableID = ss.extent.getTableId().toString();
                } else if (session instanceof MultiScanSession) {
                    MultiScanSession mss = (MultiScanSession)session;
                    nbt = mss.lookupTask;
                    tableID = mss.threadPoolExtent.getTableId().toString();
                }
                if (nbt == null || (srs = nbt.getScanRunState()) == ScanRunState.FINISHED) continue;
                MapCounter stateCounts = (MapCounter)counts.get(tableID);
                if (stateCounts == null) {
                    stateCounts = new MapCounter();
                    counts.put(tableID, (MapCounter<ScanRunState>)stateCounts);
                }
                stateCounts.increment((Object)srs, 1L);
            }
            return counts;
        }

        public synchronized List<ActiveScan> getActiveScans() {
            ArrayList<ActiveScan> activeScans = new ArrayList<ActiveScan>();
            long ct = System.currentTimeMillis();
            for (Map.Entry<Long, Session> entry : this.sessions.entrySet()) {
                ScanTask<Tablet.ScanBatch> nbt;
                ScanState state;
                Session session = entry.getValue();
                if (session instanceof ScanSession) {
                    ScanSession ss = (ScanSession)session;
                    state = ScanState.RUNNING;
                    nbt = ss.nextBatchTask;
                    if (nbt == null) {
                        state = ScanState.IDLE;
                    } else {
                        switch (nbt.getScanRunState()) {
                            case QUEUED: {
                                state = ScanState.QUEUED;
                                break;
                            }
                            case FINISHED: {
                                state = ScanState.IDLE;
                                break;
                            }
                        }
                    }
                    activeScans.add(new ActiveScan(ss.client, ss.user, ss.extent.getTableId().toString(), ct - ss.startTime, ct - ss.lastAccessTime, ScanType.SINGLE, state, ss.extent.toThrift(), Translator.translate(ss.columnSet, (Translator)Translators.CT), ss.ssiList, ss.ssio, ss.auths.getAuthorizationsBB()));
                    continue;
                }
                if (!(session instanceof MultiScanSession)) continue;
                MultiScanSession mss = (MultiScanSession)session;
                state = ScanState.RUNNING;
                nbt = mss.lookupTask;
                if (nbt == null) {
                    state = ScanState.IDLE;
                } else {
                    switch (nbt.getScanRunState()) {
                        case QUEUED: {
                            state = ScanState.QUEUED;
                            break;
                        }
                        case FINISHED: {
                            state = ScanState.IDLE;
                            break;
                        }
                    }
                }
                activeScans.add(new ActiveScan(mss.client, mss.user, mss.threadPoolExtent.getTableId().toString(), ct - mss.startTime, ct - mss.lastAccessTime, ScanType.BATCH, state, mss.threadPoolExtent.toThrift(), Translator.translate(mss.columnSet, (Translator)Translators.CT), mss.ssiList, mss.ssio, mss.auths.getAuthorizationsBB()));
            }
            return activeScans;
        }
    }

    private static class Session {
        long lastAccessTime;
        long startTime;
        String user;
        String client = (String)TServerUtils.clientAddress.get();
        public boolean reserved;

        private Session() {
        }

        public void cleanup() {
        }
    }
}

