/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.file.blockfile.cache.LruBlockCache;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.LoggingRunnable;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.tabletserver.LargestFirstMemoryManager;
import org.apache.accumulo.server.tabletserver.MemoryManagementActions;
import org.apache.accumulo.server.tabletserver.MemoryManager;
import org.apache.accumulo.server.tabletserver.TabletState;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.trace.instrument.TraceExecutorService;
import org.apache.accumulo.tserver.CompactionQueue;
import org.apache.accumulo.tserver.FileManager;
import org.apache.accumulo.tserver.HoldTimeoutException;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.accumulo.tserver.Tablet;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.log4j.Logger;

public class TabletServerResourceManager {
    private ExecutorService minorCompactionThreadPool;
    private ExecutorService majorCompactionThreadPool;
    private ExecutorService rootMajorCompactionThreadPool;
    private ExecutorService defaultMajorCompactionThreadPool;
    private ExecutorService splitThreadPool;
    private ExecutorService defaultSplitThreadPool;
    private ExecutorService defaultMigrationPool;
    private ExecutorService migrationPool;
    private ExecutorService assignmentPool;
    private ExecutorService assignMetaDataPool;
    private ExecutorService readAheadThreadPool;
    private ExecutorService defaultReadAheadThreadPool;
    private Map<String, ExecutorService> threadPools = new TreeMap<String, ExecutorService>();
    private HashSet<TabletResourceManager> tabletResources;
    private final VolumeManager fs;
    private FileManager fileManager;
    private MemoryManager memoryManager;
    private MemoryManagementFramework memMgmt;
    private final LruBlockCache _dCache;
    private final LruBlockCache _iCache;
    private final ServerConfiguration conf;
    private static final Logger log = Logger.getLogger(TabletServerResourceManager.class);
    private final Object commitHold = new Object();
    private volatile boolean holdCommits = false;
    private long holdStartTime;

    private ExecutorService addEs(String name, ExecutorService tp) {
        if (this.threadPools.containsKey(name)) {
            throw new IllegalArgumentException("Cannot create two executor services with same name " + name);
        }
        tp = new TraceExecutorService(tp);
        this.threadPools.put(name, tp);
        return tp;
    }

    private ExecutorService addEs(final Property maxThreads, String name, final ThreadPoolExecutor tp) {
        ExecutorService result = this.addEs(name, tp);
        SimpleTimer.getInstance().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    int max = TabletServerResourceManager.this.conf.getConfiguration().getCount(maxThreads);
                    if (tp.getMaximumPoolSize() != max) {
                        log.info((Object)("Changing " + maxThreads.getKey() + " to " + max));
                        tp.setCorePoolSize(max);
                        tp.setMaximumPoolSize(max);
                    }
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                }
            }
        }, 1000L, 10000L);
        return result;
    }

    private ExecutorService createEs(int max, String name) {
        return this.addEs(name, Executors.newFixedThreadPool(max, (ThreadFactory)new NamingThreadFactory(name)));
    }

    private ExecutorService createEs(Property max, String name) {
        return this.createEs(max, name, new LinkedBlockingQueue<Runnable>());
    }

    private ExecutorService createEs(Property max, String name, BlockingQueue<Runnable> queue) {
        int maxThreads = this.conf.getConfiguration().getCount(max);
        ThreadPoolExecutor tp = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, queue, (ThreadFactory)new NamingThreadFactory(name));
        return this.addEs(max, name, tp);
    }

    private ExecutorService createEs(int min, int max, int timeout, String name) {
        return this.addEs(name, new ThreadPoolExecutor(min, max, (long)timeout, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamingThreadFactory(name)));
    }

    public TabletServerResourceManager(Instance instance, VolumeManager fs) {
        this.conf = new ServerConfiguration(instance);
        this.fs = fs;
        AccumuloConfiguration acuConf = this.conf.getConfiguration();
        long maxMemory = acuConf.getMemoryInBytes(Property.TSERV_MAXMEM);
        boolean usingNativeMap = acuConf.getBoolean(Property.TSERV_NATIVEMAP_ENABLED) && NativeMap.isLoaded();
        long blockSize = acuConf.getMemoryInBytes(Property.TSERV_DEFAULT_BLOCKSIZE);
        long dCacheSize = acuConf.getMemoryInBytes(Property.TSERV_DATACACHE_SIZE);
        long iCacheSize = acuConf.getMemoryInBytes(Property.TSERV_INDEXCACHE_SIZE);
        this._iCache = new LruBlockCache(iCacheSize, blockSize);
        this._dCache = new LruBlockCache(dCacheSize, blockSize);
        Runtime runtime = Runtime.getRuntime();
        if (!usingNativeMap && maxMemory + dCacheSize + iCacheSize > runtime.maxMemory()) {
            throw new IllegalArgumentException(String.format("Maximum tablet server map memory %,d and block cache sizes %,d is too large for this JVM configuration %,d", maxMemory, dCacheSize + iCacheSize, runtime.maxMemory()));
        }
        runtime.gc();
        if (!usingNativeMap && maxMemory > runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) {
            log.warn((Object)"In-memory map may not fit into local memory space.");
        }
        this.minorCompactionThreadPool = this.createEs(Property.TSERV_MINC_MAXCONCURRENT, "minor compactor");
        this.majorCompactionThreadPool = this.createEs(Property.TSERV_MAJC_MAXCONCURRENT, "major compactor", new CompactionQueue());
        this.rootMajorCompactionThreadPool = this.createEs(0, 1, 300, "md root major compactor");
        this.defaultMajorCompactionThreadPool = this.createEs(0, 1, 300, "md major compactor");
        this.splitThreadPool = this.createEs(1, "splitter");
        this.defaultSplitThreadPool = this.createEs(0, 1, 60, "md splitter");
        this.defaultMigrationPool = this.createEs(0, 1, 60, "metadata tablet migration");
        this.migrationPool = this.createEs(Property.TSERV_MIGRATE_MAXCONCURRENT, "tablet migration");
        this.assignmentPool = this.createEs(1, "tablet assignment");
        this.assignMetaDataPool = this.createEs(0, 1, 60, "metadata tablet assignment");
        this.readAheadThreadPool = this.createEs(Property.TSERV_READ_AHEAD_MAXCONCURRENT, "tablet read ahead");
        this.defaultReadAheadThreadPool = this.createEs(Property.TSERV_METADATA_READ_AHEAD_MAXCONCURRENT, "metadata tablets read ahead");
        this.tabletResources = new HashSet();
        int maxOpenFiles = acuConf.getCount(Property.TSERV_SCAN_MAX_OPENFILES);
        this.fileManager = new FileManager(this.conf, fs, maxOpenFiles, (BlockCache)this._dCache, (BlockCache)this._iCache);
        this.memoryManager = (MemoryManager)Property.createInstanceFromPropertyName((AccumuloConfiguration)acuConf, (Property)Property.TSERV_MEM_MGMT, MemoryManager.class, (Object)new LargestFirstMemoryManager());
        this.memoryManager.init(this.conf);
        this.memMgmt = new MemoryManagementFramework();
        this.memMgmt.startThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void holdAllCommits(boolean holdAllCommits) {
        Object object = this.commitHold;
        synchronized (object) {
            if (this.holdCommits != holdAllCommits) {
                this.holdCommits = holdAllCommits;
                if (this.holdCommits) {
                    this.holdStartTime = System.currentTimeMillis();
                }
                if (!this.holdCommits) {
                    log.debug((Object)String.format("Commits held for %6.2f secs", (double)(System.currentTimeMillis() - this.holdStartTime) / 1000.0));
                    this.commitHold.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilCommitsAreEnabled() {
        if (this.holdCommits) {
            long timeout = System.currentTimeMillis() + this.conf.getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT);
            Object object = this.commitHold;
            synchronized (object) {
                while (this.holdCommits) {
                    try {
                        if (System.currentTimeMillis() > timeout) {
                            throw new HoldTimeoutException("Commits are held");
                        }
                        this.commitHold.wait(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long holdTime() {
        if (!this.holdCommits) {
            return 0L;
        }
        Object object = this.commitHold;
        synchronized (object) {
            return System.currentTimeMillis() - this.holdStartTime;
        }
    }

    public void close() {
        for (ExecutorService executorService : this.threadPools.values()) {
            executorService.shutdown();
        }
        block3: for (Map.Entry entry : this.threadPools.entrySet()) {
            while (true) {
                try {
                    while (!((ExecutorService)entry.getValue()).awaitTermination(60L, TimeUnit.SECONDS)) {
                        log.info((Object)("Waiting for thread pool " + (String)entry.getKey() + " to shutdown"));
                    }
                    continue block3;
                }
                catch (InterruptedException e) {
                    log.warn((Object)e);
                    continue;
                }
                break;
            }
        }
    }

    public synchronized TabletResourceManager createTabletResourceManager() {
        TabletResourceManager trm = new TabletResourceManager();
        return trm;
    }

    private synchronized void addTabletResource(TabletResourceManager tr) {
        this.tabletResources.add(tr);
    }

    private synchronized void removeTabletResource(TabletResourceManager tr) {
        this.tabletResources.remove(tr);
    }

    public void executeSplit(KeyExtent tablet, Runnable splitTask) {
        if (tablet.isMeta()) {
            if (tablet.isRootTablet()) {
                log.warn((Object)"Saw request to split root tablet, ignoring");
                return;
            }
            this.defaultSplitThreadPool.execute(splitTask);
        } else {
            this.splitThreadPool.execute(splitTask);
        }
    }

    public void executeMajorCompaction(KeyExtent tablet, Runnable compactionTask) {
        if (tablet.isRootTablet()) {
            this.rootMajorCompactionThreadPool.execute(compactionTask);
        } else if (tablet.isMeta()) {
            this.defaultMajorCompactionThreadPool.execute(compactionTask);
        } else {
            this.majorCompactionThreadPool.execute(compactionTask);
        }
    }

    public void executeReadAhead(KeyExtent tablet, Runnable task) {
        if (tablet.isRootTablet()) {
            task.run();
        } else if (tablet.isMeta()) {
            this.defaultReadAheadThreadPool.execute(task);
        } else {
            this.readAheadThreadPool.execute(task);
        }
    }

    public void addAssignment(Runnable assignmentHandler) {
        this.assignmentPool.execute(assignmentHandler);
    }

    public void addMetaDataAssignment(Runnable assignmentHandler) {
        this.assignMetaDataPool.execute(assignmentHandler);
    }

    public void addMigration(KeyExtent tablet, Runnable migrationHandler) {
        if (tablet.isRootTablet()) {
            migrationHandler.run();
        } else if (tablet.isMeta()) {
            this.defaultMigrationPool.execute(migrationHandler);
        } else {
            this.migrationPool.execute(migrationHandler);
        }
    }

    public void stopSplits() {
        this.splitThreadPool.shutdown();
        this.defaultSplitThreadPool.shutdown();
        while (true) {
            try {
                while (!this.splitThreadPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                    log.info((Object)"Waiting for metadata split thread pool to stop");
                }
                while (!this.defaultSplitThreadPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                    log.info((Object)"Waiting for split thread pool to stop");
                }
            }
            catch (InterruptedException ex) {
                log.info((Object)ex, (Throwable)ex);
                continue;
            }
            break;
        }
    }

    public void stopNormalAssignments() {
        this.assignmentPool.shutdown();
        while (true) {
            try {
                while (!this.assignmentPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                    log.info((Object)"Waiting for assignment thread pool to stop");
                }
            }
            catch (InterruptedException ex) {
                log.info((Object)ex, (Throwable)ex);
                continue;
            }
            break;
        }
    }

    public void stopMetadataAssignments() {
        this.assignMetaDataPool.shutdown();
        while (true) {
            try {
                while (!this.assignMetaDataPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                    log.info((Object)"Waiting for metadata assignment thread pool to stop");
                }
            }
            catch (InterruptedException ex) {
                log.info((Object)ex, (Throwable)ex);
                continue;
            }
            break;
        }
    }

    public LruBlockCache getIndexCache() {
        return this._iCache;
    }

    public LruBlockCache getDataCache() {
        return this._dCache;
    }

    public class TabletResourceManager {
        private final long creationTime = System.currentTimeMillis();
        private volatile boolean openFilesReserved = false;
        private volatile boolean closed = false;
        private Tablet tablet;
        private AccumuloConfiguration tableConf;
        private AtomicLong lastReportedSize = new AtomicLong();
        private AtomicLong lastReportedMincSize = new AtomicLong();
        private volatile long lastReportedCommitTime = 0L;

        TabletResourceManager() {
        }

        void setTablet(Tablet tablet, AccumuloConfiguration tableConf) {
            this.tablet = tablet;
            this.tableConf = tableConf;
            TabletServerResourceManager.this.addTabletResource(this);
        }

        public void importedMapFiles() {
            this.lastReportedCommitTime = System.currentTimeMillis();
        }

        synchronized FileManager.ScanFileManager newScanFileManager() {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            return TabletServerResourceManager.this.fileManager.newScanFileManager(this.tablet.getExtent());
        }

        public void updateMemoryUsageStats(long size, long mincSize) {
            long totalSize = size + mincSize;
            long lrs = this.lastReportedSize.get();
            long delta = totalSize - lrs;
            long lrms = this.lastReportedMincSize.get();
            boolean report = false;
            if ((lrms > 0L && mincSize == 0L || lrms == 0L && mincSize > 0L) && this.lastReportedMincSize.compareAndSet(lrms, mincSize)) {
                report = true;
            }
            long currentTime = System.currentTimeMillis();
            if ((delta > 32000L || delta < 0L || currentTime - this.lastReportedCommitTime > 1000L) && this.lastReportedSize.compareAndSet(lrs, totalSize)) {
                if (delta > 0L) {
                    this.lastReportedCommitTime = currentTime;
                }
                report = true;
            }
            if (report) {
                TabletServerResourceManager.this.memMgmt.updateMemoryUsageStats(this.tablet, size, this.lastReportedCommitTime, mincSize);
            }
        }

        boolean needsMajorCompaction(SortedMap<FileRef, DataFileValue> tabletFiles, MajorCompactionReason reason) {
            long idleTime;
            if (this.closed) {
                return false;
            }
            if (reason == MajorCompactionReason.USER) {
                return true;
            }
            if (reason == MajorCompactionReason.IDLE && (idleTime = this.lastReportedCommitTime == 0L ? System.currentTimeMillis() - this.creationTime : System.currentTimeMillis() - this.lastReportedCommitTime) < this.tableConf.getTimeInMillis(Property.TABLE_MAJC_COMPACTALL_IDLETIME)) {
                return false;
            }
            CompactionStrategy strategy = (CompactionStrategy)Property.createInstanceFromPropertyName((AccumuloConfiguration)this.tableConf, (Property)Property.TABLE_COMPACTION_STRATEGY, CompactionStrategy.class, (Object)new DefaultCompactionStrategy());
            strategy.init(Property.getCompactionStrategyOptions((AccumuloConfiguration)this.tableConf));
            MajorCompactionRequest request = new MajorCompactionRequest(this.tablet.getExtent(), reason, TabletServerResourceManager.this.fs, this.tableConf);
            request.setFiles(tabletFiles);
            try {
                return strategy.shouldCompact(request);
            }
            catch (IOException ex) {
                return false;
            }
        }

        void executeMinorCompaction(Runnable r) {
            TabletServerResourceManager.this.minorCompactionThreadPool.execute((Runnable)new LoggingRunnable(log, r));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws IOException {
            TabletServerResourceManager tabletServerResourceManager = TabletServerResourceManager.this;
            synchronized (tabletServerResourceManager) {
                TabletResourceManager tabletResourceManager = this;
                synchronized (tabletResourceManager) {
                    if (this.closed) {
                        throw new IOException("closed");
                    }
                    if (this.openFilesReserved) {
                        throw new IOException("tired to close files while open files reserved");
                    }
                    TabletServerResourceManager.this.removeTabletResource(this);
                    TabletServerResourceManager.this.memMgmt.tabletClosed(this.tablet.getExtent());
                    TabletServerResourceManager.this.memoryManager.tabletClosed(this.tablet.getExtent());
                    this.closed = true;
                }
            }
        }

        public TabletServerResourceManager getTabletServerResourceManager() {
            return TabletServerResourceManager.this;
        }

        public void executeMajorCompaction(KeyExtent tablet, Runnable compactionTask) {
            TabletServerResourceManager.this.executeMajorCompaction(tablet, compactionTask);
        }
    }

    private class MemoryManagementFramework {
        private final Map<KeyExtent, TabletStateImpl> tabletReports;
        private LinkedBlockingQueue<TabletStateImpl> memUsageReports;
        private long lastMemCheckTime = System.currentTimeMillis();
        private long maxMem;
        private Thread memoryGuardThread;
        private Thread minorCompactionInitiatorThread;
        private long lastMemTotal = 0L;

        MemoryManagementFramework() {
            this.tabletReports = Collections.synchronizedMap(new HashMap());
            this.memUsageReports = new LinkedBlockingQueue();
            this.maxMem = TabletServerResourceManager.this.conf.getConfiguration().getMemoryInBytes(Property.TSERV_MAXMEM);
            Runnable r1 = new Runnable(){

                @Override
                public void run() {
                    MemoryManagementFramework.this.processTabletMemStats();
                }
            };
            this.memoryGuardThread = new Daemon((Runnable)new LoggingRunnable(log, r1));
            this.memoryGuardThread.setPriority(6);
            this.memoryGuardThread.setName("Accumulo Memory Guard");
            Runnable r2 = new Runnable(){

                @Override
                public void run() {
                    MemoryManagementFramework.this.manageMemory();
                }
            };
            this.minorCompactionInitiatorThread = new Daemon((Runnable)new LoggingRunnable(log, r2));
            this.minorCompactionInitiatorThread.setName("Accumulo Minor Compaction Initiator");
        }

        void startThreads() {
            this.memoryGuardThread.start();
            this.minorCompactionInitiatorThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTabletMemStats() {
            while (true) {
                try {
                    while (true) {
                        TabletStateImpl report = this.memUsageReports.take();
                        while (report != null) {
                            this.tabletReports.put(report.getExtent(), report);
                            report = this.memUsageReports.poll();
                        }
                        long delta = System.currentTimeMillis() - this.lastMemCheckTime;
                        if (!TabletServerResourceManager.this.holdCommits && delta <= 50L && !((double)this.lastMemTotal > 0.9 * (double)this.maxMem)) continue;
                        this.lastMemCheckTime = System.currentTimeMillis();
                        long totalMemUsed = 0L;
                        Map<KeyExtent, TabletStateImpl> map = this.tabletReports;
                        synchronized (map) {
                            for (TabletStateImpl tsi : this.tabletReports.values()) {
                                totalMemUsed += tsi.getMemTableSize();
                                totalMemUsed += tsi.getMinorCompactingMemTableSize();
                            }
                        }
                        if ((double)totalMemUsed > 0.95 * (double)this.maxMem) {
                            TabletServerResourceManager.this.holdAllCommits(true);
                        } else {
                            TabletServerResourceManager.this.holdAllCommits(false);
                        }
                        this.lastMemTotal = totalMemUsed;
                    }
                }
                catch (InterruptedException e) {
                    log.warn((Object)e, (Throwable)e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageMemory() {
            while (true) {
                MemoryManagementActions mma = null;
                try {
                    ArrayList<TabletStateImpl> tablets;
                    Map<KeyExtent, TabletStateImpl> map = this.tabletReports;
                    synchronized (map) {
                        tablets = new ArrayList<TabletStateImpl>(this.tabletReports.values());
                    }
                    mma = TabletServerResourceManager.this.memoryManager.getMemoryManagementActions(tablets);
                }
                catch (Throwable t) {
                    log.error((Object)("Memory manager failed " + t.getMessage()), t);
                }
                try {
                    if (mma != null && mma.tabletsToMinorCompact != null && mma.tabletsToMinorCompact.size() > 0) {
                        for (KeyExtent keyExtent : mma.tabletsToMinorCompact) {
                            TabletStateImpl tabletReport = this.tabletReports.get(keyExtent);
                            if (tabletReport == null) {
                                log.warn((Object)("Memory manager asked to compact nonexistant tablet " + keyExtent));
                                continue;
                            }
                            if (tabletReport.getTablet().initiateMinorCompaction(Tablet.MinorCompactionReason.SYSTEM)) continue;
                            if (tabletReport.getTablet().isClosed()) {
                                this.tabletReports.remove(tabletReport.getExtent());
                                log.debug((Object)("Ignoring memory manager recommendation: not minor compacting closed tablet " + keyExtent));
                                continue;
                            }
                            log.info((Object)("Ignoring memory manager recommendation: not minor compacting " + keyExtent));
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Minor compactions for memory managment failed", t);
                }
                UtilWaitThread.sleep((long)250L);
            }
        }

        public void updateMemoryUsageStats(Tablet tablet, long size, long lastCommitTime, long mincSize) {
            this.memUsageReports.add(new TabletStateImpl(tablet, size, lastCommitTime, mincSize));
        }

        public void tabletClosed(KeyExtent extent) {
            this.tabletReports.remove(extent);
        }
    }

    private static class TabletStateImpl
    implements TabletState,
    Cloneable {
        private long lct;
        private Tablet tablet;
        private long mts;
        private long mcmts;

        public TabletStateImpl(Tablet t, long mts, long lct, long mcmts) {
            this.tablet = t;
            this.mts = mts;
            this.lct = lct;
            this.mcmts = mcmts;
        }

        public KeyExtent getExtent() {
            return this.tablet.getExtent();
        }

        Tablet getTablet() {
            return this.tablet;
        }

        public long getLastCommitTime() {
            return this.lct;
        }

        public long getMemTableSize() {
            return this.mts;
        }

        public long getMinorCompactingMemTableSize() {
            return this.mcmts;
        }
    }
}

