/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.WriteParameters;

public class CompactionPlan {
    public final List<FileRef> inputFiles = new ArrayList<FileRef>();
    public final List<FileRef> deleteFiles = new ArrayList<FileRef>();
    public WriteParameters writeParameters = null;

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.inputFiles.toString());
        if (!this.deleteFiles.isEmpty()) {
            b.append(" files to be deleted ");
            b.append(this.deleteFiles);
            if (this.writeParameters != null) {
                if (this.writeParameters.getCompressType() != null) {
                    b.append(" compress type " + this.writeParameters.getCompressType());
                }
                if (this.writeParameters.getHdfsBlockSize() != 0L) {
                    b.append(" hdfs block size " + this.writeParameters.getHdfsBlockSize());
                }
                if (this.writeParameters.getBlockSize() != 0L) {
                    b.append(" data block size " + this.writeParameters.getBlockSize());
                }
                if (this.writeParameters.getIndexBlockSize() != 0L) {
                    b.append(" index block size " + this.writeParameters.getIndexBlockSize());
                }
                if (this.writeParameters.getReplication() != 0) {
                    b.append(" replication " + this.writeParameters.getReplication());
                }
            }
        }
        return b.toString();
    }
}

