/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;

public class DefaultCompactionStrategy
extends CompactionStrategy {
    @Override
    public boolean shouldCompact(MajorCompactionRequest request) throws IOException {
        CompactionPlan plan = this.getCompactionPlan(request);
        return plan != null && !plan.inputFiles.isEmpty();
    }

    @Override
    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) throws IOException {
        CompactionPlan result = new CompactionPlan();
        List<FileRef> toCompact = this.findMapFilesToCompact(request);
        if (toCompact == null || toCompact.isEmpty()) {
            return result;
        }
        result.inputFiles.addAll(toCompact);
        return result;
    }

    private List<FileRef> findMapFilesToCompact(MajorCompactionRequest request) {
        MajorCompactionReason reason = request.getReason();
        if (reason == MajorCompactionReason.USER) {
            return new ArrayList<FileRef>(request.getFiles().keySet());
        }
        if (reason == MajorCompactionReason.CHOP) {
            return new ArrayList<FileRef>(request.getFiles().keySet());
        }
        if (request.getFiles().size() <= 1) {
            return null;
        }
        TreeSet<CompactionFile> candidateFiles = new TreeSet<CompactionFile>(new Comparator<CompactionFile>(){

            @Override
            public int compare(CompactionFile o1, CompactionFile o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1.size < o2.size) {
                    return -1;
                }
                if (o1.size > o2.size) {
                    return 1;
                }
                return o1.file.compareTo(o2.file);
            }
        });
        double ratio = Double.parseDouble(request.getTableConfig(Property.TABLE_MAJC_RATIO.getKey()));
        int maxFilesToCompact = Integer.parseInt(request.getTableConfig(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey()));
        int maxFilesPerTablet = request.getMaxFilesPerTablet();
        for (Map.Entry<FileRef, DataFileValue> entry : request.getFiles().entrySet()) {
            candidateFiles.add(new CompactionFile(entry.getKey(), entry.getValue().getSize()));
        }
        long totalSize = 0L;
        for (CompactionFile mfi : candidateFiles) {
            totalSize += mfi.size;
        }
        ArrayList<FileRef> files = new ArrayList<FileRef>();
        block2: while (candidateFiles.size() > 1) {
            CompactionFile max = candidateFiles.last();
            if ((double)max.size * ratio <= (double)totalSize) {
                files.clear();
                for (CompactionFile mfi : candidateFiles) {
                    files.add(mfi.file);
                    if (files.size() < maxFilesToCompact) continue;
                    break block2;
                }
                break;
            }
            totalSize -= max.size;
            candidateFiles.remove(max);
        }
        int totalFilesToCompact = 0;
        if (request.getFiles().size() > maxFilesPerTablet) {
            totalFilesToCompact = request.getFiles().size() - maxFilesPerTablet + 1;
        }
        totalFilesToCompact = Math.min(totalFilesToCompact, maxFilesToCompact);
        if (files.size() < totalFilesToCompact) {
            TreeMap<FileRef, Long> tfc = new TreeMap<FileRef, Long>();
            for (Map.Entry<FileRef, DataFileValue> entry : request.getFiles().entrySet()) {
                tfc.put(entry.getKey(), entry.getValue().getSize());
            }
            tfc.keySet().removeAll(files);
            candidateFiles.clear();
            for (Map.Entry<Object, Object> entry : tfc.entrySet()) {
                candidateFiles.add(new CompactionFile((FileRef)entry.getKey(), (Long)entry.getValue()));
            }
            for (CompactionFile compactionFile : candidateFiles) {
                files.add(compactionFile.file);
                if (files.size() < totalFilesToCompact) continue;
                break;
            }
        }
        return files;
    }

    private static class CompactionFile {
        public FileRef file;
        public long size;

        public CompactionFile(FileRef file, long size) {
            this.file = file;
            this.size = size;
        }
    }
}

