/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class MajorCompactionRequest
implements Cloneable {
    private final KeyExtent extent;
    private final MajorCompactionReason reason;
    private final VolumeManager volumeManager;
    private final AccumuloConfiguration tableConfig;
    private Map<FileRef, DataFileValue> files;

    public MajorCompactionRequest(KeyExtent extent, MajorCompactionReason reason, VolumeManager manager, AccumuloConfiguration tabletConfig) {
        this.extent = extent;
        this.reason = reason;
        this.volumeManager = manager;
        this.tableConfig = tabletConfig;
        this.files = Collections.emptyMap();
    }

    public MajorCompactionRequest(MajorCompactionRequest mcr) {
        this(mcr.extent, mcr.reason, mcr.volumeManager, mcr.tableConfig);
        this.files = mcr.files;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    public MajorCompactionReason getReason() {
        return this.reason;
    }

    public Map<FileRef, DataFileValue> getFiles() {
        return this.files;
    }

    public void setFiles(Map<FileRef, DataFileValue> update) {
        this.files = Collections.unmodifiableMap(update);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.volumeManager.listStatus(path);
    }

    public FileSKVIterator openReader(FileRef ref) throws IOException {
        FileOperations fileFactory = FileOperations.getInstance();
        FileSystem ns = this.volumeManager.getVolumeByPath(ref.path()).getFileSystem();
        FileSKVIterator openReader = fileFactory.openReader(ref.path().toString(), true, ns, ns.getConf(), this.tableConfig);
        return openReader;
    }

    public Map<String, String> getTableProperties() {
        return this.tableConfig.getAllPropertiesWithPrefix(Property.TABLE_PREFIX);
    }

    public String getTableConfig(String key) {
        Property property = Property.getPropertyByKey((String)key);
        if (property == null || property.isSensitive()) {
            throw new RuntimeException("Unable to access the configuration value " + key);
        }
        return this.tableConfig.get(property);
    }

    public int getMaxFilesPerTablet() {
        return this.tableConfig.getMaxFilesPerTablet();
    }
}

