/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;

public class SizeLimitCompactionStrategy
extends DefaultCompactionStrategy {
    public static final String SIZE_LIMIT_OPT = "sizeLimit";
    private long limit;

    @Override
    public void init(Map<String, String> options) {
        this.limit = AccumuloConfiguration.getMemoryInBytes((String)options.get(SIZE_LIMIT_OPT));
    }

    private MajorCompactionRequest filterFiles(MajorCompactionRequest mcr) {
        HashMap<FileRef, DataFileValue> filteredFiles = new HashMap<FileRef, DataFileValue>();
        for (Map.Entry<FileRef, DataFileValue> entry : mcr.getFiles().entrySet()) {
            if (entry.getValue().getSize() > this.limit) continue;
            filteredFiles.put(entry.getKey(), entry.getValue());
        }
        mcr = new MajorCompactionRequest(mcr);
        mcr.setFiles(filteredFiles);
        return mcr;
    }

    @Override
    public boolean shouldCompact(MajorCompactionRequest request) throws IOException {
        return super.shouldCompact(this.filterFiles(request));
    }

    @Override
    public void gatherInformation(MajorCompactionRequest request) throws IOException {
        super.gatherInformation(this.filterFiles(request));
    }

    @Override
    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) throws IOException {
        return super.getCompactionPlan(this.filterFiles(request));
    }
}

