/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.CryptoModuleFactory;
import org.apache.accumulo.core.security.crypto.CryptoModuleParameters;
import org.apache.accumulo.core.security.crypto.DefaultCryptoModule;
import org.apache.accumulo.core.security.crypto.NoFlushOutputStream;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DfsLogger {
    static final String LOG_FILE_HEADER_V2 = "--- Log File Header (v2) ---";
    static final String LOG_FILE_HEADER_V3 = "--- Log File Header (v3) ---";
    private static Logger log = Logger.getLogger(DfsLogger.class);
    private final LinkedBlockingQueue<LogWork> workQueue = new LinkedBlockingQueue();
    private final Object closeLock = new Object();
    private static final LogWork CLOSED_MARKER = new LogWork(null);
    private static final LogFileValue EMPTY = new LogFileValue();
    private boolean closed = false;
    private final ServerResources conf;
    private FSDataOutputStream logFile;
    private DataOutputStream encryptingLogFile = null;
    private Method sync;
    private String logPath;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DfsLogger) {
            return this.getFileName().equals(((DfsLogger)obj).getFileName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFileName().hashCode();
    }

    public DfsLogger(ServerResources conf) throws IOException {
        this.conf = conf;
    }

    public DfsLogger(ServerResources conf, String filename) throws IOException {
        this.conf = conf;
        this.logPath = filename;
    }

    public static DFSLoggerInputStreams readHeaderAndReturnStream(VolumeManager fs, Path path, AccumuloConfiguration conf) throws IOException {
        FSDataInputStream input = fs.open(path);
        Object decryptingInput = null;
        byte[] magic = LOG_FILE_HEADER_V3.getBytes();
        byte[] magicBuffer = new byte[magic.length];
        input.readFully(magicBuffer);
        if (Arrays.equals(magicBuffer, magic)) {
            String cryptoModuleClassname = input.readUTF();
            CryptoModule cryptoModule = CryptoModuleFactory.getCryptoModule((String)cryptoModuleClassname);
            CryptoModuleParameters params = CryptoModuleFactory.createParamsObjectFromAccumuloConfiguration((AccumuloConfiguration)conf);
            params.setEncryptedInputStream((InputStream)input);
            params = cryptoModule.getDecryptingInputStream(params);
            decryptingInput = params.getPlaintextInputStream() instanceof DataInputStream ? (DataInputStream)params.getPlaintextInputStream() : new DataInputStream(params.getPlaintextInputStream());
        } else {
            input.seek(0L);
            byte[] magicV2 = LOG_FILE_HEADER_V2.getBytes();
            byte[] magicBufferV2 = new byte[magic.length];
            input.readFully(magicBufferV2);
            if (Arrays.equals(magicBufferV2, magicV2)) {
                HashMap<String, String> opts = new HashMap<String, String>();
                int count = input.readInt();
                for (int i = 0; i < count; ++i) {
                    String key = input.readUTF();
                    String value = input.readUTF();
                    opts.put(key, value);
                }
                if (opts.size() == 0) {
                    decryptingInput = input;
                } else {
                    CryptoModule cryptoModule = CryptoModuleFactory.getCryptoModule((String)DefaultCryptoModule.class.getName());
                    CryptoModuleParameters params = CryptoModuleFactory.createParamsObjectFromAccumuloConfiguration((AccumuloConfiguration)conf);
                    input.seek(0L);
                    input.readFully(magicBuffer);
                    params.setEncryptedInputStream((InputStream)input);
                    params = cryptoModule.getDecryptingInputStream(params);
                    decryptingInput = params.getPlaintextInputStream() instanceof DataInputStream ? (DataInputStream)params.getPlaintextInputStream() : new DataInputStream(params.getPlaintextInputStream());
                }
            } else {
                input.seek(0L);
                decryptingInput = input;
            }
        }
        return new DFSLoggerInputStreams(input, (DataInputStream)decryptingInput);
    }

    public synchronized void open(String address) throws IOException {
        String filename = UUID.randomUUID().toString();
        String logger = StringUtil.join(Arrays.asList(address.split(":")), (String)"+");
        log.debug((Object)"DfsLogger.open() begin");
        VolumeManager fs = this.conf.getFileSystem();
        this.logPath = fs.choose(ServerConstants.getWalDirs()) + "/" + logger + "/" + filename;
        try {
            long blockSize;
            short replication = (short)this.conf.getConfiguration().getCount(Property.TSERV_WAL_REPLICATION);
            if (replication == 0) {
                replication = fs.getDefaultReplication(new Path(this.logPath));
            }
            if ((blockSize = this.conf.getConfiguration().getMemoryInBytes(Property.TSERV_WAL_BLOCKSIZE)) == 0L) {
                blockSize = (long)((double)this.conf.getConfiguration().getMemoryInBytes(Property.TSERV_WALOG_MAX_SIZE) * 1.1);
            }
            this.logFile = this.conf.getConfiguration().getBoolean(Property.TSERV_WAL_SYNC) ? fs.createSyncable(new Path(this.logPath), 0, replication, blockSize) : fs.create(new Path(this.logPath), true, 0, replication, blockSize);
            try {
                NoSuchMethodException e = null;
                try {
                    this.sync = this.logFile.getClass().getMethod("sync", new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    e = ex;
                }
                try {
                    this.sync = this.logFile.getClass().getMethod("hsync", new Class[0]);
                    e = null;
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                if (e != null) {
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            CryptoModule cryptoModule = CryptoModuleFactory.getCryptoModule((String)this.conf.getConfiguration().get(Property.CRYPTO_MODULE_CLASS));
            this.logFile.write(LOG_FILE_HEADER_V3.getBytes(Constants.UTF8));
            CryptoModuleParameters params = CryptoModuleFactory.createParamsObjectFromAccumuloConfiguration((AccumuloConfiguration)this.conf.getConfiguration());
            NoFlushOutputStream nfos = new NoFlushOutputStream((OutputStream)this.logFile);
            params.setPlaintextOutputStream((OutputStream)nfos);
            this.logFile.writeUTF(this.conf.getConfiguration().get(Property.CRYPTO_MODULE_CLASS));
            params = cryptoModule.getEncryptingOutputStream(params);
            OutputStream encipheringOutputStream = params.getEncryptedOutputStream();
            if (encipheringOutputStream == nfos) {
                log.debug((Object)"No enciphering, using raw output stream");
                this.encryptingLogFile = nfos;
            } else {
                log.debug((Object)"Enciphering found, wrapping in DataOutputStream");
                this.encryptingLogFile = new DataOutputStream(encipheringOutputStream);
            }
            LogFileKey key = new LogFileKey();
            key.event = LogEvents.OPEN;
            key.tserverSession = filename;
            key.filename = filename;
            this.write(key, EMPTY);
            this.sync.invoke((Object)this.logFile, new Object[0]);
            log.debug((Object)("Got new write-ahead log: " + this));
        }
        catch (Exception ex) {
            if (this.logFile != null) {
                this.logFile.close();
            }
            this.logFile = null;
            this.encryptingLogFile = null;
            throw new IOException(ex);
        }
        Daemon t = new Daemon((Runnable)new LogSyncingTask());
        t.setName("Accumulo WALog thread " + this.toString());
        t.start();
    }

    public String toString() {
        String fileName = this.getFileName();
        if (fileName.contains(":")) {
            return this.getLogger() + "/" + this.getFileName();
        }
        return fileName;
    }

    public String getFileName() {
        return this.logPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.workQueue.add(CLOSED_MARKER);
            while (!this.workQueue.isEmpty()) {
                try {
                    this.closeLock.wait();
                }
                catch (InterruptedException e) {
                    log.info((Object)"Interrupted");
                }
            }
        }
        if (this.encryptingLogFile != null) {
            try {
                this.logFile.close();
            }
            catch (IOException ex) {
                log.error((Object)ex);
                throw new LogClosedException();
            }
        }
    }

    public synchronized void defineTablet(int seq, int tid, KeyExtent tablet) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.DEFINE_TABLET;
        key.seq = seq;
        key.tid = tid;
        key.tablet = tablet;
        try {
            this.write(key, EMPTY);
            this.sync.invoke((Object)this.logFile, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Signature of sync method changed. Accumulo is likely incompatible with this version of Hadoop.");
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Could not invoke sync method due to permission error.");
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private synchronized void write(LogFileKey key, LogFileValue value) throws IOException {
        key.write(this.encryptingLogFile);
        value.write(this.encryptingLogFile);
        this.encryptingLogFile.flush();
    }

    public LoggerOperation log(int seq, int tid, Mutation mutation) throws IOException {
        return this.logManyTablets(Collections.singletonList(new TabletMutations(tid, seq, Collections.singletonList(mutation))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerOperation logFileData(List<Pair<LogFileKey, LogFileValue>> keys) throws IOException {
        LogWork work = new LogWork(new CountDownLatch(1));
        Object object = this;
        synchronized (object) {
            try {
                for (Pair<LogFileKey, LogFileValue> pair : keys) {
                    this.write((LogFileKey)pair.getFirst(), (LogFileValue)pair.getSecond());
                }
            }
            catch (ClosedChannelException ex) {
                throw new LogClosedException();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                work.exception = e;
            }
        }
        object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new LogClosedException();
            }
            this.workQueue.add(work);
        }
        return new LoggerOperation(work);
    }

    public LoggerOperation logManyTablets(List<TabletMutations> mutations) throws IOException {
        ArrayList<Pair<LogFileKey, LogFileValue>> data = new ArrayList<Pair<LogFileKey, LogFileValue>>();
        for (TabletMutations tabletMutations : mutations) {
            LogFileKey key = new LogFileKey();
            key.event = LogEvents.MANY_MUTATIONS;
            key.seq = tabletMutations.getSeq();
            key.tid = tabletMutations.getTid();
            LogFileValue value = new LogFileValue();
            value.mutations = tabletMutations.getMutations();
            data.add((Pair<LogFileKey, LogFileValue>)new Pair((Object)key, (Object)value));
        }
        return this.logFileData(data);
    }

    public LoggerOperation minorCompactionFinished(int seq, int tid, String fqfn) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.COMPACTION_FINISH;
        key.seq = seq;
        key.tid = tid;
        return this.logFileData(Collections.singletonList(new Pair((Object)key, (Object)EMPTY)));
    }

    public LoggerOperation minorCompactionStarted(int seq, int tid, String fqfn) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.COMPACTION_START;
        key.seq = seq;
        key.tid = tid;
        key.filename = fqfn;
        return this.logFileData(Collections.singletonList(new Pair((Object)key, (Object)EMPTY)));
    }

    public String getLogger() {
        String[] parts = this.logPath.split("/");
        return StringUtil.join(Arrays.asList(parts[parts.length - 2].split("[+]")), (String)":");
    }

    public static class LoggerOperation {
        private final LogWork work;

        public LoggerOperation(LogWork work) {
            this.work = work;
        }

        public void await() throws IOException {
            try {
                this.work.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.work.exception != null) {
                if (this.work.exception instanceof IOException) {
                    throw (IOException)this.work.exception;
                }
                if (this.work.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.work.exception;
                }
                throw new RuntimeException(this.work.exception);
            }
        }
    }

    static class LogWork {
        CountDownLatch latch;
        volatile Exception exception;

        public LogWork(CountDownLatch latch) {
            this.latch = latch;
        }
    }

    private class LogSyncingTask
    implements Runnable {
        private LogSyncingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList work = new ArrayList();
            while (true) {
                work.clear();
                try {
                    work.add(DfsLogger.this.workQueue.take());
                }
                catch (InterruptedException ex) {
                    continue;
                }
                DfsLogger.this.workQueue.drainTo(work);
                Object ex = DfsLogger.this.closeLock;
                synchronized (ex) {
                    if (!DfsLogger.this.closed) {
                        try {
                            DfsLogger.this.sync.invoke((Object)DfsLogger.this.logFile, new Object[0]);
                        }
                        catch (Exception ex2) {
                            log.warn((Object)("Exception syncing " + ex2));
                            for (LogWork logWork : work) {
                                logWork.exception = ex2;
                            }
                        }
                    } else {
                        for (LogWork logWork : work) {
                            logWork.exception = new LogClosedException();
                        }
                    }
                }
                boolean sawClosedMarker = false;
                for (LogWork logWork : work) {
                    if (logWork == CLOSED_MARKER) {
                        sawClosedMarker = true;
                        continue;
                    }
                    logWork.latch.countDown();
                }
                if (sawClosedMarker) break;
            }
            Object object = DfsLogger.this.closeLock;
            synchronized (object) {
                DfsLogger.this.closeLock.notifyAll();
            }
        }
    }

    public static interface ServerResources {
        public AccumuloConfiguration getConfiguration();

        public VolumeManager getFileSystem();

        public Set<TServerInstance> getCurrentTServers();
    }

    public static class DFSLoggerInputStreams {
        private FSDataInputStream originalInput;
        private DataInputStream decryptingInputStream;

        public DFSLoggerInputStreams(FSDataInputStream originalInput, DataInputStream decryptingInputStream) {
            this.originalInput = originalInput;
            this.decryptingInputStream = decryptingInputStream;
        }

        public FSDataInputStream getOriginalInput() {
            return this.originalInput;
        }

        public void setOriginalInput(FSDataInputStream originalInput) {
            this.originalInput = originalInput;
        }

        public DataInputStream getDecryptingInputStream() {
            return this.decryptingInputStream;
        }

        public void setDecryptingInputStream(DataInputStream decryptingInputStream) {
            this.decryptingInputStream = decryptingInputStream;
        }
    }

    public static class LogClosedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public LogClosedException() {
            super("LogClosed");
        }
    }
}

