/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.Tablet;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.SortedLogRecovery;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TabletServerLogger {
    private static final Logger log = Logger.getLogger(TabletServerLogger.class);
    private final AtomicLong logSizeEstimate = new AtomicLong();
    private final long maxSize;
    private final TabletServer tserver;
    private final List<DfsLogger> loggers = new ArrayList<DfsLogger>();
    private AtomicInteger logSetId = new AtomicInteger();
    private final ReentrantReadWriteLock logSetLock = new ReentrantReadWriteLock();
    private final AtomicInteger seqGen = new AtomicInteger();

    private static boolean enabled(Tablet tablet) {
        return tablet.getTableConfiguration().getBoolean(Property.TABLE_WALOG_ENABLED);
    }

    private static boolean enabled(Tablet.CommitSession commitSession) {
        return TabletServerLogger.enabled(commitSession.getTablet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testLockAndRun(ReadWriteLock rwlock, TestCallWithWriteLock code) throws IOException {
        block7: {
            rwlock.readLock().lock();
            try {
                if (!code.test()) break block7;
                rwlock.readLock().unlock();
                rwlock.writeLock().lock();
                try {
                    if (code.test()) {
                        code.withWriteLock();
                    }
                }
                finally {
                    rwlock.readLock().lock();
                    rwlock.writeLock().unlock();
                }
            }
            finally {
                rwlock.readLock().unlock();
            }
        }
    }

    public TabletServerLogger(TabletServer tserver, long maxSize) {
        this.tserver = tserver;
        this.maxSize = maxSize;
    }

    private int initializeLoggers(final List<DfsLogger> copy) throws IOException {
        final int[] result = new int[]{-1};
        TabletServerLogger.testLockAndRun(this.logSetLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                copy.clear();
                copy.addAll(TabletServerLogger.this.loggers);
                if (!TabletServerLogger.this.loggers.isEmpty()) {
                    result[0] = TabletServerLogger.this.logSetId.get();
                }
                return TabletServerLogger.this.loggers.isEmpty();
            }

            @Override
            void withWriteLock() throws IOException {
                try {
                    TabletServerLogger.this.createLoggers();
                    copy.clear();
                    copy.addAll(TabletServerLogger.this.loggers);
                    result[0] = copy.size() > 0 ? TabletServerLogger.this.logSetId.get() : -1;
                }
                catch (IOException e) {
                    log.error((Object)"Unable to create loggers", (Throwable)e);
                }
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLogFiles(Set<String> loggersOut) {
        this.logSetLock.readLock().lock();
        try {
            for (DfsLogger logger : this.loggers) {
                loggersOut.add(logger.getFileName());
            }
        }
        finally {
            this.logSetLock.readLock().unlock();
        }
    }

    private synchronized void createLoggers() throws IOException {
        if (!this.logSetLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("createLoggers should be called with write lock held!");
        }
        if (this.loggers.size() != 0) {
            throw new IllegalStateException("createLoggers should not be called when loggers.size() is " + this.loggers.size());
        }
        try {
            DfsLogger alog = new DfsLogger(this.tserver.getServerConfig());
            alog.open(this.tserver.getClientAddressString());
            this.loggers.add(alog);
            this.logSetId.incrementAndGet();
            return;
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLoggers() throws IOException {
        this.logSetLock.writeLock().lock();
        try {
            this.close();
        }
        finally {
            this.logSetLock.writeLock().unlock();
        }
    }

    private synchronized void close() throws IOException {
        if (!this.logSetLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("close should be called with write lock held!");
        }
        try {
            for (DfsLogger logger : this.loggers) {
                try {
                    logger.close();
                }
                catch (DfsLogger.LogClosedException ex) {
                }
                catch (Throwable ex) {
                    log.error((Object)("Unable to cleanly close log " + logger.getFileName() + ": " + ex), ex);
                }
            }
            this.loggers.clear();
            this.logSizeEstimate.set(0L);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private int write(Tablet.CommitSession commitSession, boolean mincFinish, Writer writer) throws IOException {
        List<Tablet.CommitSession> sessions = Collections.singletonList(commitSession);
        return this.write(sessions, mincFinish, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(Collection<Tablet.CommitSession> sessions, boolean mincFinish, Writer writer) throws IOException {
        int currentLogSet = this.logSetId.get();
        int seq = -1;
        int attempt = 1;
        boolean success = false;
        while (!success) {
            try {
                ArrayList<DfsLogger> copy = new ArrayList<DfsLogger>();
                currentLogSet = this.initializeLoggers(copy);
                if (currentLogSet == this.logSetId.get()) {
                    for (Tablet.CommitSession commitSession : sessions) {
                        if (!commitSession.beginUpdatingLogsUsed(copy, mincFinish)) continue;
                        try {
                            this.defineTablet(commitSession);
                            if (currentLogSet != this.logSetId.get()) continue;
                            this.tserver.addLoggersToMetadata(copy, commitSession.getExtent(), commitSession.getLogId());
                        }
                        finally {
                            commitSession.finishUpdatingLogsUsed();
                        }
                    }
                }
                if (currentLogSet == this.logSetId.get()) {
                    seq = this.seqGen.incrementAndGet();
                    if (seq < 0) {
                        throw new RuntimeException("Logger sequence generator wrapped!  Onos!!!11!eleven");
                    }
                    ArrayList<DfsLogger.LoggerOperation> queuedOperations = new ArrayList<DfsLogger.LoggerOperation>(copy.size());
                    for (DfsLogger wal : copy) {
                        DfsLogger.LoggerOperation lop = writer.write(wal, seq);
                        if (lop == null) continue;
                        queuedOperations.add(lop);
                    }
                    for (DfsLogger.LoggerOperation lop : queuedOperations) {
                        lop.await();
                    }
                    success = currentLogSet == this.logSetId.get();
                }
            }
            catch (DfsLogger.LogClosedException ex) {
                log.debug((Object)("Logs closed while writing, retrying " + attempt));
            }
            catch (Exception t) {
                if (attempt != 1) {
                    log.error((Object)("Unexpected error writing to log, retrying attempt " + attempt), (Throwable)t);
                }
                UtilWaitThread.sleep((long)100L);
            }
            finally {
                ++attempt;
            }
            final int finalCurrent = currentLogSet;
            if (success) continue;
            TabletServerLogger.testLockAndRun(this.logSetLock, new TestCallWithWriteLock(){

                @Override
                boolean test() {
                    return finalCurrent == TabletServerLogger.this.logSetId.get();
                }

                @Override
                void withWriteLock() throws IOException {
                    TabletServerLogger.this.close();
                }
            });
        }
        this.logSizeEstimate.addAndGet(12L);
        TabletServerLogger.testLockAndRun(this.logSetLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                return TabletServerLogger.this.logSizeEstimate.get() > TabletServerLogger.this.maxSize;
            }

            @Override
            void withWriteLock() throws IOException {
                TabletServerLogger.this.close();
            }
        });
        return seq;
    }

    public int defineTablet(final Tablet.CommitSession commitSession) throws IOException {
        if (!TabletServerLogger.enabled(commitSession)) {
            return -1;
        }
        return this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger, int ignored) throws Exception {
                logger.defineTablet(commitSession.getWALogSeq(), commitSession.getLogId(), commitSession.getExtent());
                return null;
            }
        });
    }

    public int log(final Tablet.CommitSession commitSession, final int tabletSeq, final Mutation m) throws IOException {
        if (!TabletServerLogger.enabled(commitSession)) {
            return -1;
        }
        int seq = this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger, int ignored) throws Exception {
                return logger.log(tabletSeq, commitSession.getLogId(), m);
            }
        });
        this.logSizeEstimate.addAndGet(m.numBytes());
        return seq;
    }

    public int logManyTablets(Map<Tablet.CommitSession, List<Mutation>> mutations) throws IOException {
        final HashMap<Tablet.CommitSession, List<Mutation>> loggables = new HashMap<Tablet.CommitSession, List<Mutation>>(mutations);
        for (Tablet.CommitSession t : mutations.keySet()) {
            if (TabletServerLogger.enabled(t)) continue;
            loggables.remove(t);
        }
        if (loggables.size() == 0) {
            return -1;
        }
        int seq = this.write(loggables.keySet(), false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger, int ignored) throws Exception {
                ArrayList<TabletMutations> copy = new ArrayList<TabletMutations>(loggables.size());
                for (Map.Entry entry : loggables.entrySet()) {
                    Tablet.CommitSession cs = (Tablet.CommitSession)entry.getKey();
                    copy.add(new TabletMutations(cs.getLogId(), cs.getWALogSeq(), (List)entry.getValue()));
                }
                return logger.logManyTablets(copy);
            }
        });
        for (List entry : loggables.values()) {
            if (entry.size() < 1) {
                throw new IllegalArgumentException("logManyTablets: logging empty mutation list");
            }
            for (Mutation m : entry) {
                this.logSizeEstimate.addAndGet(m.numBytes());
            }
        }
        return seq;
    }

    public void minorCompactionFinished(final Tablet.CommitSession commitSession, final String fullyQualifiedFileName, final int walogSeq) throws IOException {
        if (!TabletServerLogger.enabled(commitSession)) {
            return;
        }
        long t1 = System.currentTimeMillis();
        int seq = this.write(commitSession, true, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger, int ignored) throws Exception {
                logger.minorCompactionFinished(walogSeq, commitSession.getLogId(), fullyQualifiedFileName).await();
                return null;
            }
        });
        long t2 = System.currentTimeMillis();
        log.debug((Object)(" wrote MinC finish  " + seq + ": writeTime:" + (t2 - t1) + "ms "));
    }

    public int minorCompactionStarted(final Tablet.CommitSession commitSession, final int seq, final String fullyQualifiedFileName) throws IOException {
        if (!TabletServerLogger.enabled(commitSession)) {
            return -1;
        }
        this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger, int ignored) throws Exception {
                logger.minorCompactionStarted(seq, commitSession.getLogId(), fullyQualifiedFileName).await();
                return null;
            }
        });
        return seq;
    }

    public void recover(VolumeManager fs, Tablet tablet, List<Path> logs, Set<String> tabletFiles, MutationReceiver mr) throws IOException {
        if (!TabletServerLogger.enabled(tablet)) {
            return;
        }
        try {
            SortedLogRecovery recovery = new SortedLogRecovery(fs);
            KeyExtent extent = tablet.getExtent();
            recovery.recover(extent, logs, tabletFiles, mr);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static interface Writer {
        public DfsLogger.LoggerOperation write(DfsLogger var1, int var2) throws Exception;
    }

    private static abstract class TestCallWithWriteLock {
        private TestCallWithWriteLock() {
        }

        abstract boolean test();

        abstract void withWriteLock() throws IOException;
    }
}

