/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.logger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.hadoop.io.Writable;

public class LogFileValue
implements Writable {
    private static final List<Mutation> empty = Collections.emptyList();
    public List<Mutation> mutations = empty;

    public void readFields(DataInput in) throws IOException {
        int count = in.readInt();
        this.mutations = new ArrayList<Mutation>(count);
        for (int i = 0; i < count; ++i) {
            ServerMutation mutation = new ServerMutation();
            mutation.readFields(in);
            this.mutations.add((Mutation)mutation);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.mutations.size());
        for (Mutation m : this.mutations) {
            m.write(out);
        }
    }

    public static void print(LogFileValue value) {
        System.out.println(value.toString());
    }

    private static String displayLabels(byte[] labels) {
        String s = new String(labels, Constants.UTF8);
        s = s.replace("&", " & ");
        s = s.replace("|", " | ");
        return s;
    }

    public static String format(LogFileValue lfv, int maxMutations) {
        if (lfv.mutations.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(lfv.mutations.size() + " mutations:\n");
        int i = 0;
        for (Mutation m : lfv.mutations) {
            if (i++ >= maxMutations) {
                builder.append("...");
                break;
            }
            builder.append("  ").append(new String(m.getRow(), Constants.UTF8)).append("\n");
            for (ColumnUpdate update : m.getUpdates()) {
                String value = new String(update.getValue());
                builder.append("      ").append(new String(update.getColumnFamily(), Constants.UTF8)).append(":").append(new String(update.getColumnQualifier(), Constants.UTF8)).append(" ").append(update.hasTimestamp() ? "[user]:" : "[system]:").append(update.getTimestamp()).append(" [").append(LogFileValue.displayLabels(update.getColumnVisibility())).append("] ").append(update.isDeleted() ? "<deleted>" : value).append("\n");
            }
        }
        return builder.toString();
    }

    public String toString() {
        return LogFileValue.format(this, 5);
    }
}

