/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.impl.CompressedIterators;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.TCMResult;
import org.apache.accumulo.core.data.thrift.TCMStatus;
import org.apache.accumulo.core.data.thrift.TCondition;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.tserver.TabletIteratorEnvironment;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;
import org.apache.hadoop.io.Text;

public class ConditionCheckerContext {
    private CompressedIterators compressedIters;
    private List<IterInfo> tableIters;
    private Map<String, Map<String, String>> tableIterOpts;
    private TabletIteratorEnvironment tie;
    private String context;
    private Map<String, Class<? extends SortedKeyValueIterator<Key, Value>>> classCache;
    private Map<ByteSequence, MergedIterConfig> mergedIterCache = new HashMap<ByteSequence, MergedIterConfig>();

    ConditionCheckerContext(CompressedIterators compressedIters, AccumuloConfiguration tableConf) {
        this.compressedIters = compressedIters;
        this.tableIters = new ArrayList<IterInfo>();
        this.tableIterOpts = new HashMap<String, Map<String, String>>();
        IteratorUtil.parseIterConf((IteratorUtil.IteratorScope)IteratorUtil.IteratorScope.scan, this.tableIters, this.tableIterOpts, (AccumuloConfiguration)tableConf);
        this.context = tableConf.get(Property.TABLE_CLASSPATH);
        this.classCache = new HashMap<String, Class<? extends SortedKeyValueIterator<Key, Value>>>();
        this.tie = new TabletIteratorEnvironment(IteratorUtil.IteratorScope.scan, tableConf);
    }

    SortedKeyValueIterator<Key, Value> buildIterator(SortedKeyValueIterator<Key, Value> systemIter, TCondition tc) throws IOException {
        ArrayByteSequence key = new ArrayByteSequence(tc.iterators);
        MergedIterConfig mic = this.mergedIterCache.get(key);
        if (mic == null) {
            CompressedIterators.IterConfig ic = this.compressedIters.decompress(tc.iterators);
            ArrayList<IterInfo> mergedIters = new ArrayList<IterInfo>(this.tableIters.size() + ic.ssiList.size());
            HashMap<String, Map<String, String>> mergedItersOpts = new HashMap<String, Map<String, String>>(this.tableIterOpts.size() + ic.ssio.size());
            IteratorUtil.mergeIteratorConfig(mergedIters, mergedItersOpts, this.tableIters, this.tableIterOpts, (List)ic.ssiList, (Map)ic.ssio);
            mic = new MergedIterConfig(mergedIters, mergedItersOpts);
            this.mergedIterCache.put((ByteSequence)key, mic);
        }
        return IteratorUtil.loadIterators(systemIter, mic.mergedIters, mic.mergedItersOpts, (IteratorEnvironment)this.tie, (boolean)true, (String)this.context, this.classCache);
    }

    boolean checkConditions(SortedKeyValueIterator<Key, Value> systemIter, ServerConditionalMutation scm) throws IOException {
        boolean add = true;
        for (TCondition tc : scm.getConditions()) {
            Range range = tc.hasTimestamp ? Range.exact((Text)new Text(scm.getRow()), (Text)new Text(tc.getCf()), (Text)new Text(tc.getCq()), (Text)new Text(tc.getCv()), (long)tc.getTs()) : Range.exact((Text)new Text(scm.getRow()), (Text)new Text(tc.getCf()), (Text)new Text(tc.getCq()), (Text)new Text(tc.getCv()));
            SortedKeyValueIterator<Key, Value> iter = this.buildIterator(systemIter, tc);
            ArrayByteSequence cf = new ArrayByteSequence(tc.getCf());
            iter.seek(range, Collections.singleton(cf), true);
            Value val = null;
            if (iter.hasTop()) {
                val = (Value)iter.getTopValue();
            }
            if (!(val == null ^ tc.getVal() == null) && (val == null || Arrays.equals(tc.getVal(), val.get()))) continue;
            add = false;
            break;
        }
        return add;
    }

    public ConditionChecker newChecker(List<ServerConditionalMutation> conditionsToCheck, List<ServerConditionalMutation> okMutations, List<TCMResult> results) {
        return new ConditionChecker(conditionsToCheck, okMutations, results);
    }

    public class ConditionChecker {
        private List<ServerConditionalMutation> conditionsToCheck;
        private List<ServerConditionalMutation> okMutations;
        private List<TCMResult> results;
        private boolean checked = false;

        public ConditionChecker(List<ServerConditionalMutation> conditionsToCheck, List<ServerConditionalMutation> okMutations, List<TCMResult> results) {
            this.conditionsToCheck = conditionsToCheck;
            this.okMutations = okMutations;
            this.results = results;
        }

        public void check(SortedKeyValueIterator<Key, Value> systemIter) throws IOException {
            Preconditions.checkArgument((!this.checked ? 1 : 0) != 0, (Object)"check() method should only be called once");
            this.checked = true;
            for (ServerConditionalMutation scm : this.conditionsToCheck) {
                if (ConditionCheckerContext.this.checkConditions(systemIter, scm)) {
                    this.okMutations.add(scm);
                    continue;
                }
                this.results.add(new TCMResult(scm.getID(), TCMStatus.REJECTED));
            }
        }
    }

    private static class MergedIterConfig {
        List<IterInfo> mergedIters;
        Map<String, Map<String, String>> mergedItersOpts;

        MergedIterConfig(List<IterInfo> mergedIters, Map<String, Map<String, String>> mergedItersOpts) {
            this.mergedIters = mergedIters;
            this.mergedItersOpts = mergedItersOpts;
        }
    }
}

