/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.logger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.hadoop.io.WritableComparable;

public class LogFileKey
implements WritableComparable<LogFileKey> {
    public LogEvents event;
    public String filename = null;
    public KeyExtent tablet = null;
    public long seq = -1L;
    public int tid = -1;
    public static final int VERSION = 2;
    public String tserverSession;

    public void readFields(DataInput in) throws IOException {
        byte value = in.readByte();
        if (value >= LogEvents.values().length) {
            throw new IOException("Invalid LogEvent type, got ordinal " + value + ", but only know about " + LogEvents.values().length + " possible types.");
        }
        this.event = LogEvents.values()[value];
        switch (this.event) {
            case OPEN: {
                this.tid = in.readInt();
                this.tserverSession = in.readUTF();
                if (this.tid == 2) break;
                throw new RuntimeException(String.format("Bad version number for log file: expected %d, but saw %d", 2, this.tid));
            }
            case COMPACTION_FINISH: {
                this.seq = in.readLong();
                this.tid = in.readInt();
                break;
            }
            case COMPACTION_START: {
                this.seq = in.readLong();
                this.tid = in.readInt();
                this.filename = in.readUTF();
                break;
            }
            case DEFINE_TABLET: {
                this.seq = in.readLong();
                this.tid = in.readInt();
                this.tablet = new KeyExtent();
                this.tablet.readFields(in);
                break;
            }
            case MANY_MUTATIONS: {
                this.seq = in.readLong();
                this.tid = in.readInt();
                break;
            }
            case MUTATION: {
                this.seq = in.readLong();
                this.tid = in.readInt();
                break;
            }
            default: {
                throw new RuntimeException("Unknown log event type: " + (Object)((Object)this.event));
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.event.ordinal());
        switch (this.event) {
            case OPEN: {
                this.seq = -1L;
                this.tid = -1;
                out.writeInt(2);
                out.writeUTF(this.tserverSession);
                break;
            }
            case COMPACTION_FINISH: {
                out.writeLong(this.seq);
                out.writeInt(this.tid);
                break;
            }
            case COMPACTION_START: {
                out.writeLong(this.seq);
                out.writeInt(this.tid);
                out.writeUTF(this.filename);
                break;
            }
            case DEFINE_TABLET: {
                out.writeLong(this.seq);
                out.writeInt(this.tid);
                this.tablet.write(out);
                break;
            }
            case MANY_MUTATIONS: {
                out.writeLong(this.seq);
                out.writeInt(this.tid);
                break;
            }
            case MUTATION: {
                out.writeLong(this.seq);
                out.writeInt(this.tid);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad value for LogFileEntry type");
            }
        }
    }

    static int eventType(LogEvents event) {
        if (event == LogEvents.MUTATION || event == LogEvents.MANY_MUTATIONS) {
            return 3;
        }
        if (event == LogEvents.DEFINE_TABLET) {
            return 1;
        }
        if (event == LogEvents.OPEN) {
            return 0;
        }
        return 2;
    }

    private static int sign(long l) {
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public int compareTo(LogFileKey o) {
        if (LogFileKey.eventType(this.event) != LogFileKey.eventType(o.event)) {
            return LogFileKey.eventType(this.event) - LogFileKey.eventType(o.event);
        }
        if (this.event == LogEvents.OPEN) {
            return 0;
        }
        if (this.tid != o.tid) {
            return this.tid - o.tid;
        }
        return LogFileKey.sign(this.seq - o.seq);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogFileKey) {
            return this.compareTo((LogFileKey)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.seq;
    }

    public String toString() {
        switch (this.event) {
            case OPEN: {
                return String.format("OPEN %s", this.tserverSession);
            }
            case COMPACTION_FINISH: {
                return String.format("COMPACTION_FINISH %d %d", this.tid, this.seq);
            }
            case COMPACTION_START: {
                return String.format("COMPACTION_START %d %d %s", this.tid, this.seq, this.filename);
            }
            case MUTATION: {
                return String.format("MUTATION %d %d", this.tid, this.seq);
            }
            case MANY_MUTATIONS: {
                return String.format("MANY_MUTATIONS %d %d", this.tid, this.seq);
            }
            case DEFINE_TABLET: {
                return String.format("DEFINE_TABLET %d %d %s", this.tid, this.seq, this.tablet);
            }
        }
        throw new RuntimeException("Unknown type of entry: " + (Object)((Object)this.event));
    }
}

