/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.logger;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.MultiReader;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReader {
    private static final Logger log = LoggerFactory.getLogger(LogReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Opts opts = new Opts();
        opts.parseArgs(LogReader.class.getName(), args, new Object[0]);
        VolumeManager fs = VolumeManagerImpl.get();
        Matcher rowMatcher = null;
        KeyExtent ke = null;
        Text row = null;
        if (opts.files.isEmpty()) {
            new JCommander((Object)opts).usage();
            return;
        }
        if (opts.row != null) {
            row = new Text(opts.row);
        }
        if (opts.extent != null) {
            String[] sa = opts.extent.split(";");
            ke = new KeyExtent(new Text(sa[0]), new Text(sa[1]), new Text(sa[2]));
        }
        if (opts.regexp != null) {
            Pattern pattern = Pattern.compile(opts.regexp);
            rowMatcher = pattern.matcher("");
        }
        HashSet<Integer> tabletIds = new HashSet<Integer>();
        block7: for (String file : opts.files) {
            Path path = new Path(file);
            LogFileKey key = new LogFileKey();
            LogFileValue value = new LogFileValue();
            if (fs.isFile(path)) {
                DfsLogger.DFSLoggerInputStreams streams;
                try {
                    streams = DfsLogger.readHeaderAndReturnStream(fs, path, (AccumuloConfiguration)SiteConfiguration.getInstance());
                }
                catch (DfsLogger.LogHeaderIncompleteException e) {
                    log.warn("Could not read header for " + path + ". Ignoring...");
                    continue;
                }
                DataInputStream input = streams.getDecryptingInputStream();
                try {
                    while (true) {
                        try {
                            key.readFields(input);
                            value.readFields(input);
                        }
                        catch (EOFException ex) {
                            continue block7;
                        }
                        LogReader.printLogEvent(key, value, row, rowMatcher, ke, tabletIds, opts.maxMutations);
                    }
                }
                finally {
                    input.close();
                    continue;
                }
            }
            MultiReader input = new MultiReader(fs, path);
            while (input.next(key, value)) {
                LogReader.printLogEvent(key, value, row, rowMatcher, ke, tabletIds, opts.maxMutations);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void printLogEvent(LogFileKey key, LogFileValue value, Text row, Matcher rowMatcher, KeyExtent ke, Set<Integer> tabletIds, int maxMutations) {
        if (ke != null) {
            if (key.event == LogEvents.DEFINE_TABLET) {
                if (!key.tablet.equals((Object)ke)) return;
                tabletIds.add(key.tid);
            } else if (!tabletIds.contains(key.tid)) {
                return;
            }
        }
        if (row != null || rowMatcher != null) {
            if (key.event != LogEvents.MUTATION && key.event != LogEvents.MANY_MUTATIONS) return;
            boolean found = false;
            for (Mutation m : value.mutations) {
                if (row != null && new Text(m.getRow()).equals((Object)row)) {
                    found = true;
                    break;
                }
                if (rowMatcher == null) continue;
                rowMatcher.reset(new String(m.getRow(), StandardCharsets.UTF_8));
                if (!rowMatcher.matches()) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        System.out.println(key);
        System.out.println(LogFileValue.format(value, maxMutations));
    }

    static class Opts
    extends Help {
        @Parameter(names={"-r"}, description="print only mutations associated with the given row")
        String row;
        @Parameter(names={"-m"}, description="limit the number of mutations printed per row")
        int maxMutations = 5;
        @Parameter(names={"-t"}, description="print only mutations that fall within the given key extent")
        String extent;
        @Parameter(names={"-p"}, description="search for a row that matches the given regex")
        String regexp;
        @Parameter(description="<logfile> { <logfile> ... }")
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }
}

