/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.metrics.TabletServerMetricsKeys;
import org.apache.accumulo.tserver.metrics.TabletServerMetricsUtil;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class Metrics2TabletServerMetrics
implements Metrics,
MetricsSource,
TabletServerMetricsKeys {
    public static final String NAME = "TabletServer,sub=General";
    public static final String DESCRIPTION = "General TabletServer Metrics";
    public static final String CONTEXT = "tserver";
    public static final String RECORD = "general";
    private final TabletServerMetricsUtil util;
    private final MetricsSystem system;
    private final MetricsRegistry registry;
    private final MutableGaugeLong entries;
    private final MutableGaugeLong entriesInMemory;
    private final MutableGaugeLong activeMajcs;
    private final MutableGaugeLong queuedMajcs;
    private final MutableGaugeLong activeMincs;
    private final MutableGaugeLong queuedMincs;
    private final MutableGaugeLong onlineTablets;
    private final MutableGaugeLong openingTablets;
    private final MutableGaugeLong unopenedTablets;
    private final MutableGaugeLong queries;
    private final MutableGaugeLong totalMincs;

    Metrics2TabletServerMetrics(TabletServer tserver, MetricsSystem system) {
        this.util = new TabletServerMetricsUtil(tserver);
        this.system = system;
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.entries = this.registry.newGauge(Interns.info((String)"entries", (String)"Number of entries"), 0L);
        this.entriesInMemory = this.registry.newGauge(Interns.info((String)"entriesInMem", (String)"Number of entries in memory"), 0L);
        this.activeMajcs = this.registry.newGauge(Interns.info((String)"activeMajCs", (String)"Number of active major compactions"), 0L);
        this.queuedMajcs = this.registry.newGauge(Interns.info((String)"queuedMajCs", (String)"Number of queued major compactions"), 0L);
        this.activeMincs = this.registry.newGauge(Interns.info((String)"activeMinCs", (String)"Number of active minor compactions"), 0L);
        this.queuedMincs = this.registry.newGauge(Interns.info((String)"queuedMinCs", (String)"Number of queued minor compactions"), 0L);
        this.onlineTablets = this.registry.newGauge(Interns.info((String)"onlineTablets", (String)"Number of online tablets"), 0L);
        this.openingTablets = this.registry.newGauge(Interns.info((String)"openingTablets", (String)"Number of opening tablets"), 0L);
        this.unopenedTablets = this.registry.newGauge(Interns.info((String)"unopenedTablets", (String)"Number of unopened tablets"), 0L);
        this.queries = this.registry.newGauge(Interns.info((String)"queries", (String)"Number of queries"), 0L);
        this.totalMincs = this.registry.newGauge(Interns.info((String)"totalMinCs", (String)"Total number of minor compactions performed"), 0L);
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public void register() {
        this.system.register(NAME, DESCRIPTION, (Object)this);
    }

    public boolean isEnabled() {
        return true;
    }

    protected void snapshot() {
        this.entries.set(this.util.getEntries());
        this.entriesInMemory.set(this.util.getEntriesInMemory());
        this.activeMajcs.set((long)this.util.getMajorCompactions());
        this.queuedMajcs.set((long)this.util.getMajorCompactionsQueued());
        this.activeMincs.set((long)this.util.getMinorCompactions());
        this.queuedMincs.set((long)this.util.getMinorCompactionsQueued());
        this.onlineTablets.set((long)this.util.getOnlineCount());
        this.openingTablets.set((long)this.util.getOpeningCount());
        this.unopenedTablets.set((long)this.util.getUnopenedCount());
        this.queries.set(this.util.getQueries());
        this.totalMincs.set(this.util.getTotalMinorCompactions());
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.snapshot();
        this.registry.snapshot(builder, all);
        builder.addGauge(Interns.info((String)"filesPerTablet", (String)"Number of files per tablet"), this.util.getAverageFilesPerTablet());
        builder.addGauge(Interns.info((String)"holdTime", (String)"Time commits held"), this.util.getHoldTime());
    }
}

