/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetricsKeys;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableStat;

public class Metrics2TabletServerMinCMetrics
implements Metrics,
MetricsSource,
TabletServerMinCMetricsKeys {
    public static final String NAME = "TabletServer,sub=MinorCompactions";
    public static final String DESCRIPTION = "TabletServer Minor Compaction Metrics";
    public static final String CONTEXT = "tserver";
    public static final String RECORD = "MinorCompactions";
    private final MetricsSystem system;
    private final MetricsRegistry registry;
    private final MutableStat activeMinc;
    private final MutableStat queuedMinc;

    Metrics2TabletServerMinCMetrics(MetricsSystem system) {
        this.system = system;
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.activeMinc = this.registry.newStat("minc", "Minor compactions", "Ops", "Count", true);
        this.queuedMinc = this.registry.newStat("queue", "Queued minor compactions", "Ops", "Count", true);
    }

    public void add(String name, long value) {
        if ("minc".equals(name)) {
            this.activeMinc.add(value);
        } else if ("queue".equals(name)) {
            this.queuedMinc.add(value);
        }
    }

    public void register() {
        this.system.register(NAME, DESCRIPTION, (Object)this);
    }

    public boolean isEnabled() {
        return true;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.registry.snapshot(builder, all);
    }
}

