/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.tserver.metrics.TabletServerUpdateMetricsKeys;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableStat;

public class Metrics2TabletServerUpdateMetrics
implements Metrics,
MetricsSource,
TabletServerUpdateMetricsKeys {
    public static final String NAME = "TabletServer,sub=Updates";
    public static final String DESCRIPTION = "TabletServer Update Metrics";
    public static final String CONTEXT = "tserver";
    public static final String RECORD = "Updates";
    private final MetricsSystem system;
    private final MetricsRegistry registry;
    private final MutableCounterLong permissionErrorsCounter;
    private final MutableCounterLong unknownTabletErrorsCounter;
    private final MutableCounterLong constraintViolationsCounter;
    private final MutableStat commitPrepStat;
    private final MutableStat walogWriteTimeStat;
    private final MutableStat commitTimeStat;
    private final MutableStat mutationArraySizeStat;

    Metrics2TabletServerUpdateMetrics(MetricsSystem system) {
        this.system = system;
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.permissionErrorsCounter = this.registry.newCounter(Interns.info((String)"permissionErrors", (String)"Permission Errors"), 0L);
        this.unknownTabletErrorsCounter = this.registry.newCounter(Interns.info((String)"unknownTabletErrors", (String)"Unknown Tablet Errors"), 0L);
        this.constraintViolationsCounter = this.registry.newCounter(Interns.info((String)"constraintViolations", (String)"Table Constraint Violations"), 0L);
        this.commitPrepStat = this.registry.newStat("commitPrep", "preparing to commit mutations", "Ops", "Time", true);
        this.walogWriteTimeStat = this.registry.newStat("waLogWriteTime", "writing mutations to WAL", "Ops", "Time", true);
        this.commitTimeStat = this.registry.newStat("commitTime", "committing mutations", "Ops", "Time", true);
        this.mutationArraySizeStat = this.registry.newStat("mutationArraysSize", "mutation array", "ops", "Size", true);
    }

    public void add(String name, long value) {
        if ("permissionErrors".equals(name)) {
            this.permissionErrorsCounter.incr(value);
        } else if ("unknownTabletErrors".equals(name)) {
            this.unknownTabletErrorsCounter.incr(value);
        } else if ("mutationArraysSize".equals(name)) {
            this.mutationArraySizeStat.add(value);
        } else if ("commitPrep".equals(name)) {
            this.commitPrepStat.add(value);
        } else if ("constraintViolations".equals(name)) {
            this.constraintViolationsCounter.incr(value);
        } else if ("waLogWriteTime".equals(name)) {
            this.walogWriteTimeStat.add(value);
        } else if ("commitTime".equals(name)) {
            this.commitTimeStat.add(value);
        } else {
            throw new RuntimeException("Cannot process metric with name " + name);
        }
    }

    public void register() {
        this.system.register(NAME, DESCRIPTION, (Object)this);
    }

    public boolean isEnabled() {
        return true;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.registry.snapshot(builder, all);
    }
}

