/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.ScanState;
import org.apache.accumulo.core.tabletserver.thrift.ScanType;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.session.UpdateSession;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private final SecureRandom random = new SecureRandom();
    private final Map<Long, Session> sessions = new HashMap<Long, Session>();
    private final long maxIdle;
    private final long maxUpdateIdle;
    private final List<Session> idleSessions = new ArrayList<Session>();
    private final Long expiredSessionMarker = -1L;
    private final AccumuloConfiguration aconf;

    public SessionManager(AccumuloConfiguration conf) {
        this.aconf = conf;
        this.maxUpdateIdle = conf.getTimeInMillis(Property.TSERV_UPDATE_SESSION_MAXIDLE);
        this.maxIdle = conf.getTimeInMillis(Property.TSERV_SESSION_MAXIDLE);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SessionManager.this.sweep(SessionManager.this.maxIdle, SessionManager.this.maxUpdateIdle);
            }
        };
        SimpleTimer.getInstance((AccumuloConfiguration)conf).schedule(r, 0L, Math.max(this.maxIdle / 2L, 1000L));
    }

    public synchronized long createSession(Session session, boolean reserve) {
        long sid = this.random.nextLong();
        while (this.sessions.containsKey(sid)) {
            sid = this.random.nextLong();
        }
        this.sessions.put(sid, session);
        session.reserved = reserve;
        session.startTime = session.lastAccessTime = System.currentTimeMillis();
        return sid;
    }

    public long getMaxIdleTime() {
        return this.maxIdle;
    }

    public synchronized Session reserveSession(long sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            if (session.reserved) {
                throw new IllegalStateException();
            }
            session.reserved = true;
        }
        return session;
    }

    public synchronized Session reserveSession(long sessionId, boolean wait) {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            while (wait && session.reserved) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
            }
            if (session.reserved) {
                throw new IllegalStateException();
            }
            session.reserved = true;
        }
        return session;
    }

    public synchronized void unreserveSession(Session session) {
        if (!session.reserved) {
            throw new IllegalStateException();
        }
        this.notifyAll();
        session.reserved = false;
        session.lastAccessTime = System.currentTimeMillis();
    }

    public synchronized void unreserveSession(long sessionId) {
        Session session = this.getSession(sessionId);
        if (session != null) {
            this.unreserveSession(session);
        }
    }

    public synchronized Session getSession(long sessionId) {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            session.lastAccessTime = System.currentTimeMillis();
        }
        return session;
    }

    public Session removeSession(long sessionId) {
        return this.removeSession(sessionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session removeSession(long sessionId, boolean unreserve) {
        Session session = null;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            session = this.sessions.remove(sessionId);
            if (unreserve && session != null) {
                this.unreserveSession(session);
            }
        }
        if (session != null) {
            session.cleanup();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep(long maxIdle, long maxUpdateIdle) {
        ArrayList<Session> sessionsToCleanup = new ArrayList<Session>();
        Object object = this;
        synchronized (object) {
            Iterator<Session> iter = this.sessions.values().iterator();
            while (iter.hasNext()) {
                long idleTime;
                Session session = iter.next();
                long configuredIdle = maxIdle;
                if (session instanceof UpdateSession) {
                    configuredIdle = maxUpdateIdle;
                }
                if ((idleTime = System.currentTimeMillis() - session.lastAccessTime) <= configuredIdle || session.reserved) continue;
                log.info("Closing idle session from user=" + session.getUser() + ", client=" + session.client + ", idle=" + idleTime + "ms");
                iter.remove();
                sessionsToCleanup.add(session);
            }
        }
        object = this.idleSessions;
        synchronized (object) {
            sessionsToCleanup.addAll(this.idleSessions);
            this.idleSessions.clear();
            for (Session session : sessionsToCleanup) {
                if (session.cleanup()) continue;
                this.idleSessions.add(session);
            }
        }
    }

    public synchronized void removeIfNotAccessed(final long sessionId, final long delay) {
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            final long removeTime = session.lastAccessTime;
            TimerTask r = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Session sessionToCleanup = null;
                    SessionManager sessionManager = SessionManager.this;
                    synchronized (sessionManager) {
                        Session session2 = (Session)SessionManager.this.sessions.get(sessionId);
                        if (session2 != null && session2.lastAccessTime == removeTime && !session2.reserved) {
                            log.info("Closing not accessed session from user=" + session2.getUser() + ", client=" + session2.client + ", duration=" + delay + "ms");
                            SessionManager.this.sessions.remove(sessionId);
                            sessionToCleanup = session2;
                        }
                    }
                    if (sessionToCleanup != null) {
                        sessionToCleanup.cleanup();
                    }
                }
            };
            SimpleTimer.getInstance((AccumuloConfiguration)this.aconf).schedule((Runnable)r, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, MapCounter<ScanRunState>> getActiveScansPerTable() {
        HashMap<String, MapCounter<ScanRunState>> counts = new HashMap<String, MapCounter<ScanRunState>>();
        HashSet<Map.Entry> copiedIdleSessions = new HashSet<Map.Entry>();
        List<Session> list = this.idleSessions;
        synchronized (list) {
            for (Session session : this.idleSessions) {
                copiedIdleSessions.add(Maps.immutableEntry((Object)this.expiredSessionMarker, (Object)session));
            }
        }
        for (Map.Entry entry : this.sessions.entrySet()) {
            ScanRunState srs;
            Session session;
            session = (Session)entry.getValue();
            ScanTask<ScanBatch> nbt = null;
            String tableID = null;
            if (session instanceof ScanSession) {
                ScanSession ss = (ScanSession)session;
                nbt = ss.nextBatchTask;
                tableID = ss.extent.getTableId().toString();
            } else if (session instanceof MultiScanSession) {
                MultiScanSession mss = (MultiScanSession)session;
                nbt = mss.lookupTask;
                tableID = mss.threadPoolExtent.getTableId().toString();
            }
            if (nbt == null || (srs = nbt.getScanRunState()) == ScanRunState.FINISHED) continue;
            MapCounter stateCounts = (MapCounter)counts.get(tableID);
            if (stateCounts == null) {
                stateCounts = new MapCounter();
                counts.put(tableID, (MapCounter<ScanRunState>)stateCounts);
            }
            stateCounts.increment((Object)srs, 1L);
        }
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ActiveScan> getActiveScans() {
        ArrayList<ActiveScan> activeScans = new ArrayList<ActiveScan>();
        long ct = System.currentTimeMillis();
        HashSet<Map.Entry> copiedIdleSessions = new HashSet<Map.Entry>();
        List<Session> list = this.idleSessions;
        synchronized (list) {
            for (Session session : this.idleSessions) {
                copiedIdleSessions.add(Maps.immutableEntry((Object)this.expiredSessionMarker, (Object)session));
            }
        }
        for (Map.Entry entry : Iterables.concat(this.sessions.entrySet(), copiedIdleSessions)) {
            ScanTask<ScanBatch> nbt;
            ScanState state;
            Session session;
            session = (Session)entry.getValue();
            if (session instanceof ScanSession) {
                ScanSession ss = (ScanSession)session;
                state = ScanState.RUNNING;
                nbt = ss.nextBatchTask;
                if (nbt == null) {
                    state = ScanState.IDLE;
                } else {
                    switch (nbt.getScanRunState()) {
                        case QUEUED: {
                            state = ScanState.QUEUED;
                            break;
                        }
                        case FINISHED: {
                            state = ScanState.IDLE;
                            break;
                        }
                    }
                }
                ActiveScan activeScan = new ActiveScan(ss.client, ss.getUser(), ss.extent.getTableId().toString(), ct - ss.startTime, ct - ss.lastAccessTime, ScanType.SINGLE, state, ss.extent.toThrift(), Translator.translate(ss.columnSet, (Translator)Translators.CT), ss.ssiList, ss.ssio, ss.auths.getAuthorizationsBB());
                activeScan.setScanId(((Long)entry.getKey()).longValue());
                activeScans.add(activeScan);
                continue;
            }
            if (!(session instanceof MultiScanSession)) continue;
            MultiScanSession mss = (MultiScanSession)session;
            state = ScanState.RUNNING;
            nbt = mss.lookupTask;
            if (nbt == null) {
                state = ScanState.IDLE;
            } else {
                switch (nbt.getScanRunState()) {
                    case QUEUED: {
                        state = ScanState.QUEUED;
                        break;
                    }
                    case FINISHED: {
                        state = ScanState.IDLE;
                        break;
                    }
                }
            }
            activeScans.add(new ActiveScan(mss.client, mss.getUser(), mss.threadPoolExtent.getTableId().toString(), ct - mss.startTime, ct - mss.lastAccessTime, ScanType.BATCH, state, mss.threadPoolExtent.toThrift(), Translator.translate(mss.columnSet, (Translator)Translators.CT), mss.ssiList, mss.ssio, mss.auths.getAuthorizationsBB()));
        }
        return activeScans;
    }
}

