/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.tablet.TabletCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitSession {
    private static final Logger log = LoggerFactory.getLogger(CommitSession.class);
    private final int seq;
    private final InMemoryMap memTable;
    private final TabletCommitter committer;
    private int commitsInProgress;
    private long maxCommittedTime = Long.MIN_VALUE;

    CommitSession(TabletCommitter committer, int seq, InMemoryMap imm) {
        this.seq = seq;
        this.memTable = imm;
        this.committer = committer;
        this.commitsInProgress = 0;
    }

    public int getWALogSeq() {
        return this.seq;
    }

    public void decrementCommitsInProgress() {
        if (this.commitsInProgress < 1) {
            throw new IllegalStateException("commitsInProgress = " + this.commitsInProgress);
        }
        --this.commitsInProgress;
        if (this.commitsInProgress == 0) {
            this.committer.notifyAll();
        }
    }

    public void incrementCommitsInProgress() {
        if (this.commitsInProgress < 0) {
            throw new IllegalStateException("commitsInProgress = " + this.commitsInProgress);
        }
        ++this.commitsInProgress;
    }

    public void waitForCommitsToFinish() {
        while (this.commitsInProgress > 0) {
            try {
                this.committer.wait(50L);
            }
            catch (InterruptedException e) {
                log.warn("InterruptedException", (Throwable)e);
            }
        }
    }

    public void abortCommit(List<Mutation> value) {
        this.committer.abortCommit(this, value);
    }

    public void commit(List<Mutation> mutations) {
        this.committer.commit(this, mutations);
    }

    public TabletCommitter getTablet() {
        return this.committer;
    }

    public boolean beginUpdatingLogsUsed(ArrayList<DfsLogger> copy, boolean mincFinish) {
        return this.committer.beginUpdatingLogsUsed(this.memTable, copy, mincFinish);
    }

    public void finishUpdatingLogsUsed() {
        this.committer.finishUpdatingLogsUsed();
    }

    public int getLogId() {
        return this.committer.getLogId();
    }

    public KeyExtent getExtent() {
        return this.committer.getExtent();
    }

    public void updateMaxCommittedTime(long time) {
        this.maxCommittedTime = Math.max(time, this.maxCommittedTime);
    }

    public long getMaxCommittedTime() {
        if (this.maxCommittedTime == Long.MIN_VALUE) {
            throw new IllegalStateException("Tried to read max committed time when it was never set");
        }
        return this.maxCommittedTime;
    }

    public void mutate(List<Mutation> mutations) {
        this.memTable.mutate(mutations);
    }
}

