/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.CompactionReason;
import org.apache.accumulo.core.tabletserver.thrift.CompactionType;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.tablet.Compactor;

public class CompactionInfo {
    private final Compactor compactor;
    private final String localityGroup;
    private final long entriesRead;
    private final long entriesWritten;

    CompactionInfo(Compactor compactor) {
        this.localityGroup = compactor.getCurrentLocalityGroup();
        this.entriesRead = compactor.getEntriesRead();
        this.entriesWritten = compactor.getEntriesWritten();
        this.compactor = compactor;
    }

    public long getID() {
        return this.compactor.getCompactorID();
    }

    public KeyExtent getExtent() {
        return this.compactor.getExtent();
    }

    public long getEntriesRead() {
        return this.entriesRead;
    }

    public long getEntriesWritten() {
        return this.entriesWritten;
    }

    public Thread getThread() {
        return this.compactor.thread;
    }

    public String getOutputFile() {
        return this.compactor.getOutputFile();
    }

    public ActiveCompaction toThrift() {
        CompactionReason reason;
        CompactionType type = this.compactor.hasIMM() ? (this.compactor.getFilesToCompact().size() > 0 ? CompactionType.MERGE : CompactionType.MINOR) : (!this.compactor.willPropogateDeletes() ? CompactionType.FULL : CompactionType.MAJOR);
        if (this.compactor.hasIMM()) {
            switch (this.compactor.getMinCReason()) {
                case USER: {
                    reason = CompactionReason.USER;
                    break;
                }
                case CLOSE: {
                    reason = CompactionReason.CLOSE;
                    break;
                }
                default: {
                    reason = CompactionReason.SYSTEM;
                    break;
                }
            }
        } else {
            switch (this.compactor.getMajorCompactionReason()) {
                case USER: {
                    reason = CompactionReason.USER;
                    break;
                }
                case CHOP: {
                    reason = CompactionReason.CHOP;
                    break;
                }
                case IDLE: {
                    reason = CompactionReason.IDLE;
                    break;
                }
                default: {
                    reason = CompactionReason.SYSTEM;
                }
            }
        }
        ArrayList<IterInfo> iiList = new ArrayList<IterInfo>();
        HashMap<String, Map> iterOptions = new HashMap<String, Map>();
        for (IteratorSetting iterSetting : this.compactor.getIterators()) {
            iiList.add(new IterInfo(iterSetting.getPriority(), iterSetting.getIteratorClass(), iterSetting.getName()));
            iterOptions.put(iterSetting.getName(), iterSetting.getOptions());
        }
        ArrayList<String> filesToCompact = new ArrayList<String>();
        for (FileRef ref : this.compactor.getFilesToCompact()) {
            filesToCompact.add(ref.toString());
        }
        return new ActiveCompaction(this.compactor.extent.toThrift(), System.currentTimeMillis() - this.compactor.getStartTime(), filesToCompact, this.compactor.getOutputFile(), type, reason, this.localityGroup, this.entriesRead, this.entriesWritten, iiList, iterOptions);
    }
}

