/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.security.AuthorizationContainer;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.security.SecurityOperation;

public class TservConstraintEnv
implements Constraint.Environment {
    private final TCredentials credentials;
    private final SecurityOperation security;
    private Authorizations auths;
    private KeyExtent ke;

    TservConstraintEnv(SecurityOperation secOp, TCredentials credentials) {
        this.security = secOp;
        this.credentials = credentials;
    }

    public void setExtent(KeyExtent ke) {
        this.ke = ke;
    }

    public KeyExtent getExtent() {
        return this.ke;
    }

    public String getUser() {
        return this.credentials.getPrincipal();
    }

    @Deprecated
    public Authorizations getAuthorizations() {
        if (this.auths == null) {
            try {
                this.auths = this.security.getUserAuthorizations(this.credentials);
            }
            catch (ThriftSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return this.auths;
    }

    public AuthorizationContainer getAuthorizationsContainer() {
        return new AuthorizationContainer(){

            public boolean contains(ByteSequence auth) {
                try {
                    return TservConstraintEnv.this.security.userHasAuthorizations(TservConstraintEnv.this.credentials, Collections.singletonList(ByteBuffer.wrap(auth.getBackingArray(), auth.offset(), auth.length())));
                }
                catch (ThriftSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

