/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction.strategies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.accumulo.core.compaction.CompactionSettings;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.apache.hadoop.fs.Path;

public class ConfigurableCompactionStrategy
extends CompactionStrategy {
    private List<Test> tests = new ArrayList<Test>();
    private boolean andTest = true;
    private int minFiles = 1;
    private WriteParameters writeParams = new WriteParameters();

    @Override
    public void init(Map<String, String> options) {
        Set<Map.Entry<String, String>> es = options.entrySet();
        block12: for (Map.Entry<String, String> entry : es) {
            switch (CompactionSettings.valueOf((String)entry.getKey())) {
                case SF_LT_ESIZE_OPT: {
                    this.tests.add(new FileSizeTest(entry.getValue()){

                        @Override
                        public boolean shouldCompact(long fsize, long esize) {
                            return fsize < esize;
                        }
                    });
                    continue block12;
                }
                case SF_GT_ESIZE_OPT: {
                    this.tests.add(new FileSizeTest(entry.getValue()){

                        @Override
                        public boolean shouldCompact(long fsize, long esize) {
                            return fsize > esize;
                        }
                    });
                    continue block12;
                }
                case SF_NAME_RE_OPT: {
                    this.tests.add(new PatternPathTest(entry.getValue()){

                        @Override
                        public String getInput(Path path) {
                            return path.getName();
                        }
                    });
                    continue block12;
                }
                case SF_PATH_RE_OPT: {
                    this.tests.add(new PatternPathTest(entry.getValue()){

                        @Override
                        public String getInput(Path path) {
                            return path.toString();
                        }
                    });
                    continue block12;
                }
                case MIN_FILES_OPT: {
                    this.minFiles = Integer.parseInt(entry.getValue());
                    continue block12;
                }
                case OUTPUT_COMPRESSION_OPT: {
                    this.writeParams.setCompressType(entry.getValue());
                    continue block12;
                }
                case OUTPUT_BLOCK_SIZE_OPT: {
                    this.writeParams.setBlockSize(Long.parseLong(entry.getValue()));
                    continue block12;
                }
                case OUTPUT_INDEX_BLOCK_SIZE_OPT: {
                    this.writeParams.setIndexBlockSize(Long.parseLong(entry.getValue()));
                    continue block12;
                }
                case OUTPUT_HDFS_BLOCK_SIZE_OPT: {
                    this.writeParams.setHdfsBlockSize(Long.parseLong(entry.getValue()));
                    continue block12;
                }
                case OUTPUT_REPLICATION_OPT: {
                    this.writeParams.setReplication(Integer.parseInt(entry.getValue()));
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown option " + entry.getKey());
        }
    }

    private List<FileRef> getFilesToCompact(MajorCompactionRequest request) {
        ArrayList<FileRef> filesToCompact = new ArrayList<FileRef>();
        for (Map.Entry<FileRef, DataFileValue> entry : request.getFiles().entrySet()) {
            boolean compact = false;
            for (Test test : this.tests) {
                if (this.andTest) {
                    compact = test.shouldCompact(entry, request);
                    if (compact) continue;
                    break;
                }
                compact |= test.shouldCompact(entry, request);
            }
            if (!compact && !this.tests.isEmpty()) continue;
            filesToCompact.add(entry.getKey());
        }
        return filesToCompact;
    }

    @Override
    public boolean shouldCompact(MajorCompactionRequest request) throws IOException {
        return this.getFilesToCompact(request).size() >= this.minFiles;
    }

    @Override
    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) throws IOException {
        List<FileRef> filesToCompact = this.getFilesToCompact(request);
        if (filesToCompact.size() >= this.minFiles) {
            CompactionPlan plan = new CompactionPlan();
            plan.inputFiles.addAll(filesToCompact);
            plan.writeParameters = this.writeParams;
            return plan;
        }
        return null;
    }

    private static abstract class PatternPathTest
    implements Test {
        private Pattern pattern;

        private PatternPathTest(String p) {
            this.pattern = Pattern.compile(p);
        }

        @Override
        public boolean shouldCompact(Map.Entry<FileRef, DataFileValue> file, MajorCompactionRequest request) {
            return this.pattern.matcher(this.getInput(file.getKey().path())).matches();
        }

        public abstract String getInput(Path var1);
    }

    private static abstract class FileSizeTest
    implements Test {
        private final long esize;

        private FileSizeTest(String s) {
            this.esize = Long.parseLong(s);
        }

        @Override
        public boolean shouldCompact(Map.Entry<FileRef, DataFileValue> file, MajorCompactionRequest request) {
            return this.shouldCompact(file.getValue().getSize(), this.esize);
        }

        public abstract boolean shouldCompact(long var1, long var3);
    }

    private static interface Test {
        public boolean shouldCompact(Map.Entry<FileRef, DataFileValue> var1, MajorCompactionRequest var2);
    }
}

