/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalWALRecovery
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LocalWALRecovery.class);
    private final AccumuloConfiguration configuration;
    private final Options options;

    public static void main(String[] args) throws IOException {
        SiteConfiguration configuration = SiteConfiguration.getInstance();
        LocalWALRecovery main = new LocalWALRecovery((AccumuloConfiguration)configuration);
        main.parseArgs(args);
        main.run();
    }

    public LocalWALRecovery(AccumuloConfiguration configuration) {
        this.configuration = configuration;
        this.options = new Options();
    }

    @VisibleForTesting
    public void parseArgs(String ... args) {
        JCommander jcommander = new JCommander();
        jcommander.addObject((Object)this.options);
        try {
            jcommander.parse(args);
        }
        catch (ParameterException e) {
            jcommander.usage();
        }
    }

    @Override
    public void run() {
        SecurityUtil.serverLogin((AccumuloConfiguration)SiteConfiguration.getInstance());
        try {
            this.recoverLocalWriteAheadLogs(VolumeManagerImpl.get().getDefaultVolume().getFileSystem());
        }
        catch (IOException e) {
            log.error("Error while recovering WAL files.", (Throwable)e);
        }
    }

    public void recoverLocalWriteAheadLogs(FileSystem fs) throws IOException {
        for (String directory : this.options.directories) {
            File localDirectory = new File(directory);
            if (!localDirectory.isAbsolute()) {
                localDirectory = new File(System.getenv("ACCUMULO_HOME"), directory);
            }
            if (!localDirectory.isDirectory()) {
                log.warn("Local walog dir " + localDirectory.getAbsolutePath() + " does not exist or is not a directory.");
                continue;
            }
            if (this.options.destination == null) {
                this.options.destination = ServerConstants.getWalDirs()[0];
            }
            log.info("Copying WALs to " + this.options.destination);
            File[] files = localDirectory.listFiles();
            if (files == null) continue;
            for (File file : files) {
                String name = file.getName();
                try {
                    UUID.fromString(name);
                }
                catch (IllegalArgumentException ex) {
                    log.info("Ignoring non-log file " + file.getAbsolutePath());
                    continue;
                }
                LogFileKey key = new LogFileKey();
                LogFileValue value = new LogFileValue();
                log.info("Openning local log " + file.getAbsolutePath());
                Path localWal = new Path(file.toURI());
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)fs.getConf());
                SequenceFile.Reader reader = new SequenceFile.Reader((FileSystem)localFs, localWal, localFs.getConf());
                Path tmp = new Path(this.options.destination + "/" + name + ".copy");
                FSDataOutputStream writer = fs.create(tmp);
                while (reader.next((Writable)key, (Writable)value)) {
                    try {
                        key.write((DataOutput)writer);
                        value.write((DataOutput)writer);
                    }
                    catch (EOFException ex) {
                        // empty catch block
                        break;
                    }
                }
                writer.close();
                reader.close();
                fs.rename(tmp, new Path(tmp.getParent(), name));
                if (this.options.deleteLocal) {
                    if (file.delete()) {
                        log.info("Copied and deleted: " + name);
                        continue;
                    }
                    log.info("Failed to delete: " + name + " (but it is safe for you to delete it manually).");
                    continue;
                }
                log.info("Safe to delete: " + name);
            }
        }
    }

    static {
        WritableName.addName(LogFileKey.class, (String)"org.apache.accumulo.server.logger.LogFileKey");
        WritableName.addName(LogFileValue.class, (String)"org.apache.accumulo.server.logger.LogFileValue");
    }

    public final class Options {
        @Parameter(names={"--delete-local"}, description="Specify whether to delete the local WAL files after they have been re-written in HDFS.")
        public boolean deleteLocal = false;
        @Parameter(names={"--local-wal-directories"}, description="Comma separated list of local directories containing WALs, default is set according to the logger.dir.walog property.")
        public List<String> directories = this.getDefaultDirectories();
        @Parameter(names={"--dfs-wal-directory"}, description="The directory that WALs will be copied into. Will default to the first configured base dir + '/wal'")
        public String destination = null;

        private List<String> getDefaultDirectories() {
            String property = LocalWALRecovery.this.configuration.get(Property.LOGGER_DIR);
            return Arrays.asList(property.split(","));
        }
    }
}

