/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.commons.collections.buffer.PriorityBuffer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class MultiReader {
    private PriorityBuffer heap = new PriorityBuffer();

    public MultiReader(VolumeManager fs, Path directory) throws IOException {
        boolean foundFinish = false;
        for (FileStatus child : fs.listStatus(directory)) {
            if (child.getPath().getName().startsWith("_")) continue;
            if (SortedLogState.isFinished((String)child.getPath().getName())) {
                foundFinish = true;
                continue;
            }
            FileSystem ns = fs.getVolumeByPath(child.getPath()).getFileSystem();
            this.heap.add((Object)new Index(new MapFile.Reader(ns.makeQualified(child.getPath()), ns.getConf(), new SequenceFile.Reader.Option[0])));
        }
        if (!foundFinish) {
            throw new IOException("Sort \"" + SortedLogState.FINISHED.getMarker() + "\" flag not found in " + directory);
        }
    }

    private static void copy(Writable src, Writable dest) throws IOException {
        DataOutputBuffer output = new DataOutputBuffer();
        src.write((DataOutput)output);
        DataInputBuffer input = new DataInputBuffer();
        input.reset(output.getData(), output.getLength());
        dest.readFields((DataInput)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean next(WritableComparable key, Writable val) throws IOException {
        block4: {
            Index elt = (Index)this.heap.remove();
            try {
                elt.cache();
                if (elt.cached) {
                    MultiReader.copy((Writable)elt.key, (Writable)key);
                    MultiReader.copy(elt.value, val);
                    elt.cached = false;
                    break block4;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.heap.add((Object)elt);
            }
        }
        return true;
    }

    public synchronized boolean seek(WritableComparable key) throws IOException {
        PriorityBuffer reheap = new PriorityBuffer(this.heap.size());
        boolean result = false;
        for (Object obj : this.heap) {
            Index index = (Index)obj;
            try {
                WritableComparable found = index.reader.getClosest(key, index.value, true);
                if (found != null && found.equals(key)) {
                    result = true;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            index.cached = false;
            reheap.add((Object)index);
        }
        this.heap = reheap;
        return result;
    }

    public void close() throws IOException {
        IOException problem = null;
        for (Object obj : this.heap) {
            Index index = (Index)obj;
            try {
                index.reader.close();
            }
            catch (IOException ex) {
                problem = ex;
            }
        }
        if (problem != null) {
            throw problem;
        }
        this.heap = null;
    }

    private static class Index
    implements Comparable<Index> {
        MapFile.Reader reader;
        WritableComparable key;
        Writable value;
        boolean cached = false;

        private static Object create(Class<?> klass) {
            try {
                return klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to construct objects to use for comparison");
            }
        }

        public Index(MapFile.Reader reader) {
            this.reader = reader;
            this.key = (WritableComparable)Index.create(reader.getKeyClass());
            this.value = (Writable)Index.create(reader.getValueClass());
        }

        private void cache() throws IOException {
            if (!this.cached && this.reader.next(this.key, this.value)) {
                this.cached = true;
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.key);
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj instanceof Index && 0 == this.compareTo((Index)obj);
        }

        @Override
        public int compareTo(Index o) {
            try {
                this.cache();
                o.cache();
                if (!this.cached) {
                    return 1;
                }
                if (!o.cached) {
                    return -1;
                }
                return this.key.compareTo((Object)o.key);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

