/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.log.MultiReader;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedLogRecovery {
    private static final Logger log = LoggerFactory.getLogger(SortedLogRecovery.class);
    private VolumeManager fs;

    public SortedLogRecovery(VolumeManager fs) {
        this.fs = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(KeyExtent extent, List<Path> recoveryLogs, Set<String> tabletFiles, MutationReceiver mr) throws IOException {
        MultiReader reader;
        Path logfile;
        int i;
        int[] tids = new int[recoveryLogs.size()];
        LastStartToFinish lastStartToFinish = new LastStartToFinish();
        for (i = 0; i < recoveryLogs.size(); ++i) {
            logfile = recoveryLogs.get(i);
            log.info("Looking at mutations from " + logfile + " for " + extent);
            reader = new MultiReader(this.fs, logfile);
            try {
                try {
                    tids[i] = this.findLastStartToFinish(reader, i, extent, tabletFiles, lastStartToFinish);
                }
                catch (EmptyMapFileException ex) {
                    log.info("Ignoring empty map file " + logfile);
                    tids[i] = -1;
                }
                catch (UnusedException ex) {
                    log.info("Ignoring log file " + logfile + " appears to be unused by " + extent);
                    tids[i] = -1;
                }
                continue;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    log.warn("Ignoring error closing file");
                }
            }
        }
        if (lastStartToFinish.compactionStatus == Status.LOOKING_FOR_FINISH) {
            throw new RuntimeException("COMPACTION_FINISH (without preceding COMPACTION_START) not followed by successful minor compaction");
        }
        for (i = 0; i < recoveryLogs.size(); ++i) {
            logfile = recoveryLogs.get(i);
            reader = new MultiReader(this.fs, logfile);
            try {
                this.playbackMutations(reader, tids[i], lastStartToFinish, mr);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    log.warn("Ignoring error closing file");
                }
            }
            log.info("Recovery complete for " + extent + " using " + logfile);
        }
    }

    private String getPathSuffix(String pathString) {
        Path path = new Path(pathString);
        if (path.depth() < 2) {
            throw new IllegalArgumentException("Bad path " + pathString);
        }
        return path.getParent().getName() + "/" + path.getName();
    }

    int findLastStartToFinish(MultiReader reader, int fileno, KeyExtent extent, Set<String> tabletFiles, LastStartToFinish lastStartToFinish) throws IOException, EmptyMapFileException, UnusedException {
        HashSet<String> suffixes = new HashSet<String>();
        for (String path : tabletFiles) {
            suffixes.add(this.getPathSuffix(path));
        }
        LogFileKey key = new LogFileKey();
        LogFileValue value = new LogFileValue();
        int tid = -1;
        if (!reader.next(key, value)) {
            throw new EmptyMapFileException();
        }
        if (key.event != LogEvents.OPEN) {
            throw new RuntimeException("First log entry value is not OPEN");
        }
        if (key.tserverSession.compareTo(lastStartToFinish.tserverSession) != 0) {
            if (lastStartToFinish.compactionStatus == Status.LOOKING_FOR_FINISH) {
                throw new RuntimeException("COMPACTION_FINISH (without preceding COMPACTION_START) is not followed by a successful minor compaction.");
            }
            lastStartToFinish.update(key.tserverSession);
        }
        KeyExtent alternative = extent;
        if (extent.isRootTablet()) {
            alternative = RootTable.OLD_EXTENT;
        }
        LogFileKey defineKey = null;
        while (reader.next(key, value) && key.event == LogEvents.DEFINE_TABLET) {
            if (!key.tablet.equals((Object)extent) && !key.tablet.equals((Object)alternative) || tid == key.tid) continue;
            tid = key.tid;
            defineKey = key;
            key = new LogFileKey();
        }
        if (tid < 0) {
            throw new UnusedException();
        }
        log.debug("Found tid, seq " + tid + " " + defineKey.seq);
        key = defineKey;
        key.event = LogEvents.COMPACTION_START;
        reader.seek(key);
        while (reader.next(key, value) && key.tid == tid) {
            if (key.event == LogEvents.COMPACTION_START) {
                if (lastStartToFinish.compactionStatus == Status.INITIAL) {
                    lastStartToFinish.compactionStatus = Status.COMPLETE;
                }
                if (key.seq <= lastStartToFinish.lastStart) {
                    throw new RuntimeException("Sequence numbers are not increasing for start/stop events.");
                }
                lastStartToFinish.update(fileno, key.seq);
                log.debug("minor compaction into " + key.filename + " finished, but was still in the METADATA");
                if (!suffixes.contains(this.getPathSuffix(key.filename))) continue;
                lastStartToFinish.update(-1L);
                continue;
            }
            if (key.event != LogEvents.COMPACTION_FINISH) break;
            if (key.seq <= lastStartToFinish.lastStart) {
                throw new RuntimeException("Sequence numbers are not increasing for start/stop events.");
            }
            if (lastStartToFinish.compactionStatus == Status.INITIAL) {
                lastStartToFinish.compactionStatus = Status.LOOKING_FOR_FINISH;
            } else {
                if (lastStartToFinish.lastFinish > lastStartToFinish.lastStart) {
                    throw new RuntimeException("COMPACTION_FINISH does not have preceding COMPACTION_START event.");
                }
                lastStartToFinish.compactionStatus = Status.COMPLETE;
            }
            lastStartToFinish.update(key.seq);
        }
        return tid;
    }

    private void playbackMutations(MultiReader reader, int tid, LastStartToFinish lastStartToFinish, MutationReceiver mr) throws IOException {
        LogFileKey key = new LogFileKey();
        LogFileValue value = new LogFileValue();
        log.info("Scanning for mutations starting at sequence number " + lastStartToFinish.seq + " for tid " + tid);
        key.event = LogEvents.MUTATION;
        key.tid = tid;
        key.seq = lastStartToFinish.seq;
        reader.seek(key);
        while (reader.next(key, value) && key.tid == tid) {
            if (key.event == LogEvents.MUTATION) {
                mr.receive(value.mutations.get(0));
                continue;
            }
            if (key.event == LogEvents.MANY_MUTATIONS) {
                for (Mutation m : value.mutations) {
                    mr.receive(m);
                }
                continue;
            }
            throw new RuntimeException("unexpected log key type: " + (Object)((Object)key.event));
        }
    }

    private static class LastStartToFinish {
        long lastStart = -1L;
        long seq = -1L;
        long lastFinish = -1L;
        Status compactionStatus = Status.INITIAL;
        String tserverSession = "";

        private LastStartToFinish() {
        }

        private void update(long newFinish) {
            this.seq = this.lastStart;
            if (newFinish != -1L) {
                this.lastFinish = newFinish;
            }
        }

        private void update(int newStartFile, long newStart) {
            this.lastStart = newStart;
        }

        private void update(String newSession) {
            this.lastStart = -1L;
            this.lastFinish = -1L;
            this.compactionStatus = Status.INITIAL;
            this.tserverSession = newSession;
        }
    }

    private static enum Status {
        INITIAL,
        LOOKING_FOR_FINISH,
        COMPLETE;

    }

    static class UnusedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    static class EmptyMapFileException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

