/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationConfigurationUtil;
import org.apache.accumulo.fate.util.Retry;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.tserver.Mutations;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.SortedLogRecovery;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerLogger {
    private static final Logger log = LoggerFactory.getLogger(TabletServerLogger.class);
    private final AtomicLong logSizeEstimate = new AtomicLong();
    private final long maxSize;
    private final long maxAge;
    private final TabletServer tserver;
    private final List<DfsLogger> loggers = new ArrayList<DfsLogger>();
    private AtomicInteger logSetId = new AtomicInteger();
    private final ReentrantReadWriteLock logSetLock = new ReentrantReadWriteLock();
    private final AtomicLong syncCounter;
    private final AtomicLong flushCounter;
    private long createTime = 0L;
    private final Retry.RetryFactory createRetryFactory;
    private Retry createRetry = null;
    private final Retry.RetryFactory writeRetryFactory;

    private static void testLockAndRun(ReadWriteLock rwlock, TestCallWithWriteLock code) throws IOException {
        block7: {
            rwlock.readLock().lock();
            try {
                if (!code.test()) break block7;
                rwlock.readLock().unlock();
                rwlock.writeLock().lock();
                try {
                    if (code.test()) {
                        code.withWriteLock();
                    }
                }
                finally {
                    rwlock.readLock().lock();
                    rwlock.writeLock().unlock();
                }
            }
            finally {
                rwlock.readLock().unlock();
            }
        }
    }

    public TabletServerLogger(TabletServer tserver, long maxSize, AtomicLong syncCounter, AtomicLong flushCounter, Retry.RetryFactory createRetryFactory, Retry.RetryFactory writeRetryFactory, long maxAge) {
        this.tserver = tserver;
        this.maxSize = maxSize;
        this.syncCounter = syncCounter;
        this.flushCounter = flushCounter;
        this.createRetryFactory = createRetryFactory;
        this.createRetry = null;
        this.writeRetryFactory = writeRetryFactory;
        this.maxAge = maxAge;
    }

    private int initializeLoggers(final List<DfsLogger> copy) throws IOException {
        final int[] result = new int[]{-1};
        TabletServerLogger.testLockAndRun(this.logSetLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                copy.clear();
                copy.addAll(TabletServerLogger.this.loggers);
                if (!TabletServerLogger.this.loggers.isEmpty()) {
                    result[0] = TabletServerLogger.this.logSetId.get();
                }
                return TabletServerLogger.this.loggers.isEmpty();
            }

            @Override
            void withWriteLock() throws IOException {
                try {
                    TabletServerLogger.this.createLoggers();
                    copy.clear();
                    copy.addAll(TabletServerLogger.this.loggers);
                    result[0] = copy.size() > 0 ? TabletServerLogger.this.logSetId.get() : -1;
                }
                catch (IOException e) {
                    log.error("Unable to create loggers", (Throwable)e);
                }
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLogFiles(Set<String> loggersOut) {
        this.logSetLock.readLock().lock();
        try {
            for (DfsLogger logger : this.loggers) {
                loggersOut.add(logger.getFileName());
            }
        }
        finally {
            this.logSetLock.readLock().unlock();
        }
    }

    private synchronized void createLoggers() throws IOException {
        if (!this.logSetLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("createLoggers should be called with write lock held!");
        }
        if (this.loggers.size() != 0) {
            throw new IllegalStateException("createLoggers should not be called when loggers.size() is " + this.loggers.size());
        }
        try {
            DfsLogger alog = new DfsLogger(this.tserver.getServerConfig(), this.syncCounter, this.flushCounter);
            alog.open(this.tserver.getClientAddressString());
            this.loggers.add(alog);
            this.logSetId.incrementAndGet();
            if (null != this.createRetry) {
                this.createRetry = null;
            }
            this.createTime = System.currentTimeMillis();
            return;
        }
        catch (Exception t) {
            if (null == this.createRetry) {
                this.createRetry = this.createRetryFactory.createRetry();
            }
            if (this.createRetry.canRetry()) {
                this.createRetry.useRetry();
                try {
                    this.createRetry.waitForNextAttempt();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            } else {
                log.error("Repeatedly failed to create WAL. Going to exit tabletserver.", (Throwable)t);
                Halt.halt((String)"Experienced too many errors creating WALs, giving up", (int)1);
            }
            throw new RuntimeException(t);
        }
    }

    private synchronized void close() throws IOException {
        if (!this.logSetLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("close should be called with write lock held!");
        }
        try {
            for (DfsLogger logger : this.loggers) {
                try {
                    logger.close();
                }
                catch (DfsLogger.LogClosedException logClosedException) {
                }
                catch (Throwable ex) {
                    log.error("Unable to cleanly close log " + logger.getFileName() + ": " + ex, ex);
                }
            }
            this.loggers.clear();
            this.logSizeEstimate.set(0L);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private void write(CommitSession commitSession, boolean mincFinish, Writer writer) throws IOException {
        this.write(commitSession, mincFinish, writer, this.writeRetryFactory.createRetry());
    }

    private void write(CommitSession commitSession, boolean mincFinish, Writer writer, Retry writeRetry) throws IOException {
        List<CommitSession> sessions = Collections.singletonList(commitSession);
        this.write(sessions, mincFinish, writer, writeRetry);
    }

    private void write(Collection<CommitSession> sessions, boolean mincFinish, Writer writer) throws IOException {
        this.write(sessions, mincFinish, writer, this.writeRetryFactory.createRetry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(final Collection<CommitSession> sessions, boolean mincFinish, Writer writer, Retry writeRetry) throws IOException {
        int currentLogSet = this.logSetId.get();
        boolean success = false;
        while (!success) {
            try {
                ArrayList<DfsLogger> copy = new ArrayList<DfsLogger>();
                currentLogSet = this.initializeLoggers(copy);
                if (currentLogSet == this.logSetId.get()) {
                    for (CommitSession commitSession : sessions) {
                        if (!commitSession.beginUpdatingLogsUsed(copy, mincFinish)) continue;
                        try {
                            this.defineTablet(commitSession, writeRetry);
                            if (currentLogSet == this.logSetId.get()) {
                                this.tserver.addLoggersToMetadata(copy, commitSession.getExtent(), commitSession.getLogId());
                            }
                        }
                        finally {
                            commitSession.finishUpdatingLogsUsed();
                        }
                        KeyExtent extent = commitSession.getExtent();
                        if (!ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)this.tserver.getTableConfiguration(extent))) continue;
                        HashSet<String> logs = new HashSet<String>();
                        for (DfsLogger logger : copy) {
                            logs.add(logger.getFileName());
                        }
                        Replication.Status status = StatusUtil.fileCreated((long)System.currentTimeMillis());
                        log.debug("Writing " + ProtobufUtil.toString((GeneratedMessage)status) + " to metadata table for " + logs);
                        ReplicationTableUtil.updateFiles((ClientContext)this.tserver, (KeyExtent)commitSession.getExtent(), logs, (Replication.Status)status);
                    }
                }
                if (currentLogSet == this.logSetId.get()) {
                    ArrayList<DfsLogger.LoggerOperation> queuedOperations = new ArrayList<DfsLogger.LoggerOperation>(copy.size());
                    for (DfsLogger wal : copy) {
                        queuedOperations.add(writer.write(wal));
                    }
                    for (DfsLogger.LoggerOperation lop : queuedOperations) {
                        lop.await();
                    }
                    success = currentLogSet == this.logSetId.get();
                }
            }
            catch (DfsLogger.LogClosedException ex) {
                writeRetry.logRetry(log, "Logs closed while writing", (Throwable)ex);
            }
            catch (Exception t) {
                writeRetry.logRetry(log, "Failed to write to WAL", (Throwable)t);
                try {
                    writeRetry.waitForNextAttempt();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            finally {
                writeRetry.useRetry();
            }
            final int finalCurrent = currentLogSet;
            if (success) continue;
            TabletServerLogger.testLockAndRun(this.logSetLock, new TestCallWithWriteLock(){

                @Override
                boolean test() {
                    return finalCurrent == TabletServerLogger.this.logSetId.get();
                }

                @Override
                void withWriteLock() throws IOException {
                    TabletServerLogger.this.close();
                    TabletServerLogger.this.closeForReplication(sessions);
                }
            });
        }
        this.logSizeEstimate.addAndGet(12L);
        TabletServerLogger.testLockAndRun(this.logSetLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                return TabletServerLogger.this.logSizeEstimate.get() > TabletServerLogger.this.maxSize || System.currentTimeMillis() - TabletServerLogger.this.createTime > TabletServerLogger.this.maxAge;
            }

            @Override
            void withWriteLock() throws IOException {
                TabletServerLogger.this.close();
                TabletServerLogger.this.closeForReplication(sessions);
            }
        });
    }

    protected void closeForReplication(Collection<CommitSession> sessions) {
    }

    public void defineTablet(final CommitSession commitSession, Retry writeRetry) throws IOException {
        this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                logger.defineTablet(commitSession.getWALogSeq(), commitSession.getLogId(), commitSession.getExtent());
                return DfsLogger.NO_WAIT_LOGGER_OP;
            }
        }, writeRetry);
    }

    public void log(final CommitSession commitSession, final long tabletSeq, final Mutation m, final Durability durability) throws IOException {
        if (durability == Durability.NONE) {
            return;
        }
        if (durability == Durability.DEFAULT) {
            throw new IllegalArgumentException("Unexpected durability " + durability);
        }
        this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                return logger.log(tabletSeq, commitSession.getLogId(), m, durability);
            }
        });
        this.logSizeEstimate.addAndGet(m.numBytes());
    }

    public void logManyTablets(Map<CommitSession, Mutations> mutations) throws IOException {
        final HashMap<CommitSession, Mutations> loggables = new HashMap<CommitSession, Mutations>(mutations);
        for (Map.Entry<CommitSession, Mutations> entry : mutations.entrySet()) {
            if (entry.getValue().getDurability() != Durability.NONE) continue;
            loggables.remove(entry.getKey());
        }
        if (loggables.size() == 0) {
            return;
        }
        this.write(loggables.keySet(), false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                ArrayList<TabletMutations> copy = new ArrayList<TabletMutations>(loggables.size());
                for (Map.Entry entry : loggables.entrySet()) {
                    CommitSession cs = (CommitSession)entry.getKey();
                    Durability durability = ((Mutations)entry.getValue()).getDurability();
                    copy.add(new TabletMutations(cs.getLogId(), cs.getWALogSeq(), ((Mutations)entry.getValue()).getMutations(), durability));
                }
                return logger.logManyTablets(copy);
            }
        });
        for (Mutations mutations2 : loggables.values()) {
            if (mutations2.getMutations().size() < 1) {
                throw new IllegalArgumentException("logManyTablets: logging empty mutation list");
            }
            for (Mutation m : mutations2.getMutations()) {
                this.logSizeEstimate.addAndGet(m.numBytes());
            }
        }
    }

    public void minorCompactionFinished(final CommitSession commitSession, final String fullyQualifiedFileName, final long walogSeq, final Durability durability) throws IOException {
        long t1 = System.currentTimeMillis();
        this.write(commitSession, true, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                logger.minorCompactionFinished(walogSeq, commitSession.getLogId(), fullyQualifiedFileName, durability).await();
                return DfsLogger.NO_WAIT_LOGGER_OP;
            }
        });
        long t2 = System.currentTimeMillis();
        log.debug(" wrote MinC finish: writeTime:{}ms  durability:{}", (Object)(t2 - t1), (Object)durability);
    }

    public long minorCompactionStarted(final CommitSession commitSession, final long seq, final String fullyQualifiedFileName, final Durability durability) throws IOException {
        this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                logger.minorCompactionStarted(seq, commitSession.getLogId(), fullyQualifiedFileName, durability).await();
                return DfsLogger.NO_WAIT_LOGGER_OP;
            }
        });
        return seq;
    }

    public void recover(VolumeManager fs, KeyExtent extent, TableConfiguration tconf, List<Path> logs, Set<String> tabletFiles, MutationReceiver mr) throws IOException {
        try {
            SortedLogRecovery recovery = new SortedLogRecovery(fs);
            recovery.recover(extent, logs, tabletFiles, mr);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static interface Writer {
        public DfsLogger.LoggerOperation write(DfsLogger var1) throws Exception;
    }

    private static abstract class TestCallWithWriteLock {
        private TestCallWithWriteLock() {
        }

        abstract boolean test();

        abstract void withWriteLock() throws IOException;
    }
}

