/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.replication;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.replication.AccumuloReplicationReplayer;
import org.apache.accumulo.core.replication.thrift.KeyValues;
import org.apache.accumulo.core.replication.thrift.RemoteReplicationErrorCode;
import org.apache.accumulo.core.replication.thrift.RemoteReplicationException;
import org.apache.accumulo.core.replication.thrift.WalEdits;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchWriterReplicationReplayer
implements AccumuloReplicationReplayer {
    private static final Logger log = LoggerFactory.getLogger(BatchWriterReplicationReplayer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replicateLog(ClientContext context, String tableName, WalEdits data) throws RemoteReplicationException, AccumuloException, AccumuloSecurityException {
        LogFileKey key = new LogFileKey();
        LogFileValue value = new LogFileValue();
        long memoryInBytes = context.getConfiguration().getMemoryInBytes(Property.TSERV_REPLICATION_BW_REPLAYER_MEMORY);
        BatchWriter bw = null;
        long mutationsApplied = 0L;
        try {
            for (ByteBuffer edit : data.getEdits()) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(edit.array()));
                try {
                    key.readFields(dis);
                    value.readFields(dis);
                }
                catch (IOException e) {
                    log.error("Could not deserialize edit from stream", (Throwable)e);
                    throw new RemoteReplicationException(RemoteReplicationErrorCode.COULD_NOT_DESERIALIZE, "Could not deserialize edit from stream");
                }
                if (null == bw) {
                    BatchWriterConfig bwConfig = new BatchWriterConfig();
                    bwConfig.setMaxMemory(memoryInBytes);
                    try {
                        bw = context.getConnector().createBatchWriter(tableName, bwConfig);
                    }
                    catch (TableNotFoundException e) {
                        throw new RemoteReplicationException(RemoteReplicationErrorCode.TABLE_DOES_NOT_EXIST, "Table " + tableName + " does not exist");
                    }
                }
                log.info("Applying {} mutations to table {} as part of batch", (Object)value.mutations.size(), (Object)tableName);
                ArrayList<Mutation> mutationsCopy = new ArrayList<Mutation>(value.mutations.size());
                long mutationsCopied = 0L;
                for (Mutation orig : value.mutations) {
                    if (orig instanceof ServerMutation) {
                        ++mutationsCopied;
                        ServerMutation origServer = (ServerMutation)orig;
                        Mutation copy = new Mutation(orig.getRow());
                        for (ColumnUpdate update : orig.getUpdates()) {
                            long timestamp = !update.hasTimestamp() ? origServer.getSystemTimestamp() : update.getTimestamp();
                            if (update.isDeleted()) {
                                copy.putDelete(update.getColumnFamily(), update.getColumnQualifier(), new ColumnVisibility(update.getColumnVisibility()), timestamp);
                                continue;
                            }
                            copy.put(update.getColumnFamily(), update.getColumnQualifier(), new ColumnVisibility(update.getColumnVisibility()), timestamp, update.getValue());
                        }
                        Set replicationSources = orig.getReplicationSources();
                        if (null != replicationSources && !replicationSources.isEmpty()) {
                            for (String replicationSource : replicationSources) {
                                copy.addReplicationSource(replicationSource);
                            }
                        }
                        mutationsCopy.add(copy);
                        continue;
                    }
                    mutationsCopy.add(orig);
                }
                log.debug("Copied {} mutations to ensure server-assigned timestamps are propagated", (Object)mutationsCopied);
                try {
                    bw.addMutations(mutationsCopy);
                }
                catch (MutationsRejectedException e) {
                    log.error("Could not apply mutations to {}", (Object)tableName);
                    throw new RemoteReplicationException(RemoteReplicationErrorCode.COULD_NOT_APPLY, "Could not apply mutations to " + tableName);
                }
                log.debug("{} mutations added to the BatchScanner", (Object)mutationsCopy.size());
                mutationsApplied += (long)mutationsCopy.size();
            }
        }
        finally {
            if (null != bw) {
                try {
                    bw.close();
                }
                catch (MutationsRejectedException e) {
                    log.error("Could not apply mutations to {}", (Object)tableName);
                    throw new RemoteReplicationException(RemoteReplicationErrorCode.COULD_NOT_APPLY, "Could not apply mutations to " + tableName);
                }
            }
        }
        log.info("Applied {} mutations in total to {}", (Object)mutationsApplied, (Object)tableName);
        return mutationsApplied;
    }

    public long replicateKeyValues(ClientContext context, String tableName, KeyValues kvs) {
        throw new UnsupportedOperationException();
    }
}

