/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.tablet.CompactionStats;
import org.apache.accumulo.tserver.tablet.Compactor;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinorCompactor
extends Compactor {
    private static final Logger log = LoggerFactory.getLogger(MinorCompactor.class);
    private static final Map<FileRef, DataFileValue> EMPTY_MAP = Collections.emptyMap();
    private final TabletServer tabletServer;

    private static Map<FileRef, DataFileValue> toFileMap(FileRef mergeFile, DataFileValue dfv) {
        if (mergeFile == null) {
            return EMPTY_MAP;
        }
        return Collections.singletonMap(mergeFile, dfv);
    }

    public MinorCompactor(TabletServer tabletServer, Tablet tablet, InMemoryMap imm, FileRef mergeFile, DataFileValue dfv, FileRef outputFile, MinorCompactionReason mincReason, TableConfiguration tableConfig) {
        super(tabletServer, tablet, MinorCompactor.toFileMap(mergeFile, dfv), imm, outputFile, true, new Compactor.CompactionEnv(){

            @Override
            public boolean isCompactionEnabled() {
                return true;
            }

            @Override
            public IteratorUtil.IteratorScope getIteratorScope() {
                return IteratorUtil.IteratorScope.minc;
            }
        }, Collections.emptyList(), mincReason.ordinal(), (AccumuloConfiguration)tableConfig);
        this.tabletServer = tabletServer;
    }

    private boolean isTableDeleting() {
        try {
            return Tables.getTableState((Instance)this.tabletServer.getInstance(), (String)this.extent.getTableId().toString()) == TableState.DELETING;
        }
        catch (Exception e) {
            log.warn("Failed to determine if table " + this.extent.getTableId() + " was deleting ", (Throwable)e);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompactionStats call() {
        outputFileName = this.getOutputFile();
        MinorCompactor.log.debug("Begin minor compaction " + outputFileName + " " + this.getExtent());
        sleepTime = 100;
        growthFactor = 4.0;
        maxSleepTime = 180000;
        reportedProblem = false;
        MinorCompactor.runningCompactions.add(this);
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                ret = super.call();
                if (reportedProblem) {
                    ProblemReports.getInstance((AccumuloServerContext)this.tabletServer).deleteProblemReport(this.getExtent().getTableId().toString(), ProblemType.FILE_WRITE, outputFileName);
                }
                var8_11 = ret;
                return var8_11;
            }
        }
        catch (IOException e) {
            MinorCompactor.log.warn("MinC failed ({}) to create {} retrying ...", (Object)e.getMessage(), (Object)outputFileName);
            ProblemReports.getInstance((AccumuloServerContext)this.tabletServer).report(new ProblemReport(this.getExtent().getTableId().toString(), ProblemType.FILE_WRITE, outputFileName, (Throwable)e));
            reportedProblem = true;
        }
        catch (RuntimeException e) {
            MinorCompactor.log.warn("MinC failed ({}) to create {} retrying ...", new Object[]{e.getMessage(), outputFileName, e});
            ProblemReports.getInstance((AccumuloServerContext)this.tabletServer).report(new ProblemReport(this.getExtent().getTableId().toString(), ProblemType.FILE_WRITE, outputFileName, (Throwable)e));
            reportedProblem = true;
        }
        catch (Compactor.CompactionCanceledException e) {
            throw new IllegalStateException(e);
        }
        {
            random = new Random();
            sleep = sleepTime + random.nextInt(sleepTime);
            MinorCompactor.log.debug("MinC failed sleeping " + sleep + " ms before retrying");
            UtilWaitThread.sleep((long)sleep);
            sleepTime = (int)Math.round(Math.min((double)maxSleepTime, (double)sleepTime * growthFactor));
            try {
                if (this.getFileSystem().exists(new Path(outputFileName))) {
                    this.getFileSystem().deleteRecursively(new Path(outputFileName));
                }
            }
            catch (IOException e) {
                MinorCompactor.log.warn("Failed to delete failed MinC file {} {}", (Object)outputFileName, (Object)e.getMessage());
            }
            if (!this.isTableDeleting()) ** GOTO lbl-1000
            var9_13 = new CompactionStats(0L, 0L);
        }
        return var9_13;
lbl-1000:
        // 1 sources

        {
            ** continue;
        }
        finally {
            this.thread = null;
            MinorCompactor.runningCompactions.remove(this);
        }
    }
}

