/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.ColumnQualifierFilter;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.iterators.system.StatsIterator;
import org.apache.accumulo.core.iterators.system.VisibilityFilter;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.FileManager;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.TabletIteratorEnvironment;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.tablet.ScanOptions;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletClosedException;

class ScanDataSource
implements SourceSwitchingIterator.DataSource {
    private final Tablet tablet;
    private FileManager.ScanFileManager fileManager;
    private SortedKeyValueIterator<Key, Value> iter;
    private long expectedDeletionCount;
    private List<InMemoryMap.MemoryIterator> memIters = null;
    private long fileReservationId;
    private AtomicBoolean interruptFlag;
    private StatsIterator statsIterator;
    private final ScanOptions options;
    private final boolean loadIters;
    private static final Set<Column> EMPTY_COLS = Collections.emptySet();

    ScanDataSource(Tablet tablet, Authorizations authorizations, byte[] defaultLabels, HashSet<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag) {
        this.tablet = tablet;
        this.expectedDeletionCount = tablet.getDataSourceDeletions();
        this.options = new ScanOptions(-1, authorizations, defaultLabels, columnSet, ssiList, ssio, interruptFlag, false);
        this.interruptFlag = interruptFlag;
        this.loadIters = true;
    }

    ScanDataSource(Tablet tablet, ScanOptions options) {
        this.tablet = tablet;
        this.expectedDeletionCount = tablet.getDataSourceDeletions();
        this.options = options;
        this.interruptFlag = options.getInterruptFlag();
        this.loadIters = true;
    }

    ScanDataSource(Tablet tablet, Authorizations authorizations, byte[] defaultLabels, AtomicBoolean iFlag) {
        this.tablet = tablet;
        this.expectedDeletionCount = tablet.getDataSourceDeletions();
        this.options = new ScanOptions(-1, authorizations, defaultLabels, EMPTY_COLS, null, null, iFlag, false);
        this.interruptFlag = iFlag;
        this.loadIters = false;
    }

    public SourceSwitchingIterator.DataSource getNewDataSource() {
        if (!this.isCurrent()) {
            if (this.memIters != null) {
                this.tablet.getTabletMemory().returnIterators(this.memIters);
                this.memIters = null;
                this.tablet.getDatafileManager().returnFilesForScan(this.fileReservationId);
                this.fileReservationId = -1L;
            }
            if (this.fileManager != null) {
                this.fileManager.releaseOpenFiles(false);
            }
            this.expectedDeletionCount = this.tablet.getDataSourceDeletions();
            this.iter = null;
            return this;
        }
        return this;
    }

    public boolean isCurrent() {
        return this.expectedDeletionCount == this.tablet.getDataSourceDeletions();
    }

    public SortedKeyValueIterator<Key, Value> iterator() throws IOException {
        if (this.iter == null) {
            this.iter = this.createIterator();
        }
        return this.iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedKeyValueIterator<Key, Value> createIterator() throws IOException {
        Map files;
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            if (this.memIters != null) {
                throw new IllegalStateException("Tried to create new scan iterator w/o releasing memory");
            }
            if (this.tablet.isClosed()) {
                throw new TabletClosedException();
            }
            if (this.interruptFlag.get()) {
                throw new IterationInterruptedException(this.tablet.getExtent().toString() + " " + this.interruptFlag.hashCode());
            }
            if (this.fileManager == null) {
                this.fileManager = this.tablet.getTabletResources().newScanFileManager();
                this.tablet.addActiveScans(this);
            }
            if (this.fileManager.getNumOpenFiles() != 0) {
                throw new IllegalStateException("Tried to create new scan iterator w/o releasing files");
            }
            this.expectedDeletionCount = this.tablet.getDataSourceDeletions();
            this.memIters = this.tablet.getTabletMemory().getIterators();
            Pair<Long, Map<FileRef, DataFileValue>> reservation = this.tablet.getDatafileManager().reserveFilesForScan();
            this.fileReservationId = (Long)reservation.getFirst();
            files = (Map)reservation.getSecond();
        }
        List<InterruptibleIterator> mapfiles = this.fileManager.openFiles(files, this.options.isIsolated());
        ArrayList<InterruptibleIterator> iters = new ArrayList<InterruptibleIterator>(mapfiles.size() + this.memIters.size());
        iters.addAll(mapfiles);
        iters.addAll(this.memIters);
        for (SortedKeyValueIterator sortedKeyValueIterator : iters) {
            ((InterruptibleIterator)sortedKeyValueIterator).setInterruptFlag(this.interruptFlag);
        }
        MultiIterator multiIter = new MultiIterator(iters, this.tablet.getExtent());
        TabletIteratorEnvironment tabletIteratorEnvironment = new TabletIteratorEnvironment(IteratorUtil.IteratorScope.scan, (AccumuloConfiguration)this.tablet.getTableConfiguration(), this.fileManager, files, this.options.getAuthorizations());
        this.statsIterator = new StatsIterator((SortedKeyValueIterator)multiIter, TabletServer.seekCount, this.tablet.getScannedCounter());
        DeletingIterator delIter = new DeletingIterator((SortedKeyValueIterator)this.statsIterator, false);
        ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator((SortedKeyValueIterator)delIter);
        ColumnQualifierFilter colFilter = new ColumnQualifierFilter((SortedKeyValueIterator)cfsi, this.options.getColumnSet());
        SortedKeyValueIterator visFilter = VisibilityFilter.wrap((SortedKeyValueIterator)colFilter, (Authorizations)this.options.getAuthorizations(), (byte[])this.options.getDefaultLabels());
        if (!this.loadIters) {
            return visFilter;
        }
        return tabletIteratorEnvironment.getTopLevelIterator((SortedKeyValueIterator<Key, Value>)IteratorUtil.loadIterators((IteratorUtil.IteratorScope)IteratorUtil.IteratorScope.scan, (SortedKeyValueIterator)visFilter, (KeyExtent)this.tablet.getExtent(), (AccumuloConfiguration)this.tablet.getTableConfiguration(), this.options.getSsiList(), this.options.getSsio(), (IteratorEnvironment)tabletIteratorEnvironment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean sawErrors) {
        if (this.memIters != null) {
            this.tablet.getTabletMemory().returnIterators(this.memIters);
            this.memIters = null;
            this.tablet.getDatafileManager().returnFilesForScan(this.fileReservationId);
            this.fileReservationId = -1L;
        }
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            if (this.tablet.removeScan(this) == 0) {
                this.tablet.notifyAll();
            }
        }
        if (this.fileManager != null) {
            this.fileManager.releaseOpenFiles(sawErrors);
            this.fileManager = null;
        }
        if (this.statsIterator != null) {
            this.statsIterator.report();
        }
    }

    public void interrupt() {
        this.interruptFlag.set(true);
    }

    public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public void reattachFileManager() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.reattach();
        }
    }

    public void detachFileManager() {
        if (this.fileManager != null) {
            this.fileManager.detach();
        }
    }

    public void setInterruptFlag(AtomicBoolean flag) {
        throw new UnsupportedOperationException();
    }
}

