/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.iterators.system.TimeSettingIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReportingIterator;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    private static final Logger log = LoggerFactory.getLogger(FileManager.class);
    private int maxOpen;
    private Map<String, List<OpenReader>> openFiles;
    private HashMap<FileSKVIterator, String> reservedReaders;
    private Semaphore filePermits;
    private VolumeManager fs;
    private BlockCache dataCache = null;
    private BlockCache indexCache = null;
    private Cache<String, Long> fileLenCache;
    private long maxIdleTime;
    private final AccumuloServerContext context;

    public FileManager(AccumuloServerContext context, VolumeManager fs, int maxOpen, Cache<String, Long> fileLenCache, BlockCache dataCache, BlockCache indexCache) {
        if (maxOpen <= 0) {
            throw new IllegalArgumentException("maxOpen <= 0");
        }
        this.context = context;
        this.dataCache = dataCache;
        this.indexCache = indexCache;
        this.fileLenCache = fileLenCache;
        this.filePermits = new Semaphore(maxOpen, false);
        this.maxOpen = maxOpen;
        this.fs = fs;
        this.openFiles = new HashMap<String, List<OpenReader>>();
        this.reservedReaders = new HashMap();
        this.maxIdleTime = context.getConfiguration().getTimeInMillis(Property.TSERV_MAX_IDLE);
        SimpleTimer.getInstance((AccumuloConfiguration)context.getConfiguration()).schedule((Runnable)new IdleFileCloser(), this.maxIdleTime, this.maxIdleTime / 2L);
    }

    private static int countReaders(Map<String, List<OpenReader>> files) {
        int count = 0;
        for (List<OpenReader> list : files.values()) {
            count += list.size();
        }
        return count;
    }

    private List<FileSKVIterator> takeLRUOpenFiles(int numToTake) {
        ArrayList openReaders = new ArrayList();
        for (Map.Entry<String, List<OpenReader>> entry : this.openFiles.entrySet()) {
            openReaders.addAll(entry.getValue());
        }
        Collections.sort(openReaders);
        ArrayList<FileSKVIterator> ret = new ArrayList<FileSKVIterator>();
        for (int i = 0; i < numToTake && i < openReaders.size(); ++i) {
            OpenReader or = (OpenReader)openReaders.get(i);
            List<OpenReader> ofl = this.openFiles.get(or.fileName);
            if (!ofl.remove(or)) {
                throw new RuntimeException("Failed to remove open reader that should have been there");
            }
            if (ofl.size() == 0) {
                this.openFiles.remove(or.fileName);
            }
            ret.add(or.reader);
        }
        return ret;
    }

    private static <T> List<T> getFileList(String file, Map<String, List<T>> files) {
        List<T> ofl = files.get(file);
        if (ofl == null) {
            ofl = new ArrayList<T>();
            files.put(file, ofl);
        }
        return ofl;
    }

    private void closeReaders(Collection<FileSKVIterator> filesToClose) {
        for (FileSKVIterator reader : filesToClose) {
            try {
                reader.close();
            }
            catch (Exception e) {
                log.error("Failed to close file {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private List<String> takeOpenFiles(Collection<String> files, Map<FileSKVIterator, String> readersReserved) {
        List<String> filesToOpen = Collections.emptyList();
        for (String file : files) {
            List<OpenReader> ofl = this.openFiles.get(file);
            if (ofl != null && ofl.size() > 0) {
                OpenReader openReader = ofl.remove(ofl.size() - 1);
                readersReserved.put(openReader.reader, file);
                if (ofl.size() != 0) continue;
                this.openFiles.remove(file);
                continue;
            }
            if (filesToOpen.isEmpty()) {
                filesToOpen = new ArrayList<String>(files.size());
            }
            filesToOpen.add(file);
        }
        return filesToOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FileSKVIterator, String> reserveReaders(KeyExtent tablet, Collection<String> files, boolean continueOnFailure) throws IOException {
        if (!tablet.isMeta() && files.size() >= this.maxOpen) {
            throw new IllegalArgumentException("requested files exceeds max open");
        }
        if (files.size() == 0) {
            return Collections.emptyMap();
        }
        List<String> filesToOpen = null;
        List<FileSKVIterator> filesToClose = Collections.emptyList();
        HashMap<FileSKVIterator, String> readersReserved = new HashMap<FileSKVIterator, String>();
        if (!tablet.isMeta()) {
            this.filePermits.acquireUninterruptibly(files.size());
        }
        Object object = this;
        synchronized (object) {
            filesToOpen = this.takeOpenFiles(files, readersReserved);
            if (!filesToOpen.isEmpty()) {
                int numOpen = FileManager.countReaders(this.openFiles);
                if (filesToOpen.size() + numOpen + this.reservedReaders.size() > this.maxOpen) {
                    filesToClose = this.takeLRUOpenFiles(filesToOpen.size() + numOpen + this.reservedReaders.size() - this.maxOpen);
                }
            }
        }
        this.closeReaders(filesToClose);
        for (String file : filesToOpen) {
            try {
                if (!file.contains(":")) {
                    throw new IllegalArgumentException("Expected uri, got : " + file);
                }
                Path path = new Path(file);
                FileSystem ns = this.fs.getVolumeByPath(path).getFileSystem();
                FileSKVIterator reader = ((FileOperations.OpenReaderOperationBuilder)((FileOperations.OpenReaderOperationBuilder)((FileOperations.OpenReaderOperationBuilder)FileOperations.getInstance().newReaderBuilder().forFile(path.toString(), ns, ns.getConf()).withTableConfiguration((AccumuloConfiguration)this.context.getServerConfigurationFactory().getTableConfiguration(tablet))).withBlockCache(this.dataCache, this.indexCache)).withFileLenCache(this.fileLenCache)).build();
                readersReserved.put(reader, file);
            }
            catch (Exception e) {
                ProblemReports.getInstance((AccumuloServerContext)this.context).report(new ProblemReport(tablet.getTableId(), ProblemType.FILE_READ, file, (Throwable)e));
                if (continueOnFailure) {
                    if (!tablet.isMeta()) {
                        this.filePermits.release(1);
                    }
                    log.warn("Failed to open file {} {}  continuing...", (Object)file, (Object)e.getMessage());
                    continue;
                }
                this.closeReaders(readersReserved.keySet());
                if (!tablet.isMeta()) {
                    this.filePermits.release(files.size());
                }
                log.error("Failed to open file {} {}", (Object)file, (Object)e.getMessage());
                throw new IOException("Failed to open " + file, e);
            }
        }
        object = this;
        synchronized (object) {
            this.reservedReaders.putAll(readersReserved);
        }
        return readersReserved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReaders(KeyExtent tablet, List<FileSKVIterator> readers, boolean sawIOException) {
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (!this.reservedReaders.keySet().containsAll(readers)) {
                throw new IllegalArgumentException("Asked to release readers that were never reserved ");
            }
            for (FileSKVIterator reader : readers) {
                try {
                    reader.closeDeepCopies();
                }
                catch (IOException e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                    sawIOException = true;
                }
            }
            for (FileSKVIterator reader : readers) {
                String fileName = this.reservedReaders.remove(reader);
                if (sawIOException) continue;
                FileManager.getFileList(fileName, this.openFiles).add(new OpenReader(fileName, reader));
            }
        }
        if (sawIOException) {
            this.closeReaders(readers);
        }
        if (!tablet.isMeta()) {
            this.filePermits.release(readers.size());
        }
    }

    public ScanFileManager newScanFileManager(KeyExtent tablet) {
        return new ScanFileManager(tablet);
    }

    public class ScanFileManager {
        private ArrayList<FileDataSource> dataSources;
        private ArrayList<FileSKVIterator> tabletReservedReaders = new ArrayList();
        private KeyExtent tablet;
        private boolean continueOnFailure;

        ScanFileManager(KeyExtent tablet) {
            this.dataSources = new ArrayList();
            this.tablet = tablet;
            this.continueOnFailure = FileManager.this.context.getServerConfigurationFactory().getTableConfiguration(tablet).getBoolean(Property.TABLE_FAILURES_IGNORE);
            if (tablet.isMeta()) {
                this.continueOnFailure = false;
            }
        }

        private Map<FileSKVIterator, String> openFileRefs(Collection<FileRef> files) throws TooManyFilesException, IOException {
            ArrayList<String> strings = new ArrayList<String>(files.size());
            for (FileRef ref : files) {
                strings.add(ref.path().toString());
            }
            return this.openFiles(strings);
        }

        private Map<FileSKVIterator, String> openFiles(Collection<String> files) throws TooManyFilesException, IOException {
            if (this.tabletReservedReaders.size() + files.size() >= FileManager.this.maxOpen) {
                throw new TooManyFilesException("Request to open files would exceed max open files reservedReaders.size()=" + this.tabletReservedReaders.size() + " files.size()=" + files.size() + " maxOpen=" + FileManager.this.maxOpen + " tablet = " + this.tablet);
            }
            Map newlyReservedReaders = FileManager.this.reserveReaders(this.tablet, files, this.continueOnFailure);
            this.tabletReservedReaders.addAll(newlyReservedReaders.keySet());
            return newlyReservedReaders;
        }

        public synchronized List<InterruptibleIterator> openFiles(Map<FileRef, DataFileValue> files, boolean detachable, SamplerConfigurationImpl samplerConfig) throws IOException {
            Map<FileSKVIterator, String> newlyReservedReaders = this.openFileRefs(files.keySet());
            ArrayList<InterruptibleIterator> iters = new ArrayList<InterruptibleIterator>();
            boolean sawTimeSet = false;
            for (DataFileValue dataFileValue : files.values()) {
                if (!dataFileValue.isTimeSet()) continue;
                sawTimeSet = true;
                break;
            }
            for (Map.Entry entry : newlyReservedReaders.entrySet()) {
                DataFileValue value;
                ProblemReportingIterator iter;
                FileSKVIterator reader = (FileSKVIterator)entry.getKey();
                String filename = (String)entry.getValue();
                FileSKVIterator source = reader;
                if (samplerConfig != null && (source = source.getSample(samplerConfig)) == null) {
                    throw new SampleNotPresentException();
                }
                if (detachable) {
                    FileDataSource fds = new FileDataSource(filename, (SortedKeyValueIterator<Key, Value>)source);
                    this.dataSources.add(fds);
                    SourceSwitchingIterator ssi = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)fds);
                    iter = new ProblemReportingIterator(FileManager.this.context, this.tablet.getTableId(), filename, this.continueOnFailure, (SortedKeyValueIterator)ssi);
                } else {
                    iter = new ProblemReportingIterator(FileManager.this.context, this.tablet.getTableId(), filename, this.continueOnFailure, (SortedKeyValueIterator)source);
                }
                if (sawTimeSet && (value = files.get(new FileRef(filename))).isTimeSet()) {
                    iter = new TimeSettingIterator((SortedKeyValueIterator)iter, value.getTime());
                }
                iters.add((InterruptibleIterator)iter);
            }
            return iters;
        }

        public synchronized void detach() {
            FileManager.this.releaseReaders(this.tablet, this.tabletReservedReaders, false);
            this.tabletReservedReaders.clear();
            for (FileDataSource fds : this.dataSources) {
                fds.unsetIterator();
            }
        }

        public synchronized void reattach(SamplerConfigurationImpl samplerConfig) throws IOException {
            FileSKVIterator reader;
            if (this.tabletReservedReaders.size() != 0) {
                throw new IllegalStateException();
            }
            ArrayList<String> files = new ArrayList<String>();
            for (FileDataSource fds : this.dataSources) {
                files.add(fds.file);
            }
            Map<FileSKVIterator, String> newlyReservedReaders = this.openFiles(files);
            HashMap<String, LinkedList<FileSKVIterator>> map = new HashMap<String, LinkedList<FileSKVIterator>>();
            for (Map.Entry<FileSKVIterator, String> entry : newlyReservedReaders.entrySet()) {
                reader = entry.getKey();
                String fileName = entry.getValue();
                LinkedList<FileSKVIterator> list = (LinkedList<FileSKVIterator>)map.get(fileName);
                if (list == null) {
                    list = new LinkedList<FileSKVIterator>();
                    map.put(fileName, list);
                }
                list.add(reader);
            }
            for (FileDataSource fds : this.dataSources) {
                FileSKVIterator source = reader = (FileSKVIterator)((List)map.get(fds.file)).remove(0);
                if (samplerConfig != null && (source = source.getSample(samplerConfig)) == null) {
                    throw new SampleNotPresentException();
                }
                fds.setIterator((SortedKeyValueIterator<Key, Value>)source);
            }
        }

        public synchronized void releaseOpenFiles(boolean sawIOException) {
            FileManager.this.releaseReaders(this.tablet, this.tabletReservedReaders, sawIOException);
            this.tabletReservedReaders.clear();
            this.dataSources.clear();
        }

        public synchronized int getNumOpenFiles() {
            return this.tabletReservedReaders.size();
        }
    }

    static class FileDataSource
    implements SourceSwitchingIterator.DataSource {
        private SortedKeyValueIterator<Key, Value> iter;
        private ArrayList<FileDataSource> deepCopies;
        private boolean current = true;
        private IteratorEnvironment env;
        private String file;
        private AtomicBoolean iflag;

        FileDataSource(String file, SortedKeyValueIterator<Key, Value> iter) {
            this.file = file;
            this.iter = iter;
            this.deepCopies = new ArrayList();
        }

        public FileDataSource(IteratorEnvironment env, SortedKeyValueIterator<Key, Value> deepCopy, ArrayList<FileDataSource> deepCopies) {
            this.iter = deepCopy;
            this.env = env;
            this.deepCopies = deepCopies;
            deepCopies.add(this);
        }

        public boolean isCurrent() {
            return this.current;
        }

        public SourceSwitchingIterator.DataSource getNewDataSource() {
            this.current = true;
            return this;
        }

        public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
            return new FileDataSource(env, (SortedKeyValueIterator<Key, Value>)this.iter.deepCopy(env), this.deepCopies);
        }

        public SortedKeyValueIterator<Key, Value> iterator() {
            return this.iter;
        }

        void unsetIterator() {
            this.current = false;
            this.iter = null;
            for (FileDataSource fds : this.deepCopies) {
                fds.current = false;
                fds.iter = null;
            }
        }

        void setIterator(SortedKeyValueIterator<Key, Value> iter) {
            this.current = false;
            this.iter = iter;
            if (this.iflag != null) {
                ((InterruptibleIterator)this.iter).setInterruptFlag(this.iflag);
            }
            for (FileDataSource fds : this.deepCopies) {
                fds.current = false;
                fds.iter = iter.deepCopy(fds.env);
            }
        }

        public void setInterruptFlag(AtomicBoolean flag) {
            this.iflag = flag;
            ((InterruptibleIterator)this.iter).setInterruptFlag(this.iflag);
        }
    }

    private class IdleFileCloser
    implements Runnable {
        private IdleFileCloser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long curTime = System.currentTimeMillis();
            ArrayList<FileSKVIterator> filesToClose = new ArrayList<FileSKVIterator>();
            FileManager fileManager = FileManager.this;
            synchronized (fileManager) {
                Iterator iter = FileManager.this.openFiles.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    List ofl = (List)entry.getValue();
                    Iterator oflIter = ofl.iterator();
                    while (oflIter.hasNext()) {
                        OpenReader openReader = (OpenReader)oflIter.next();
                        if (curTime - openReader.releaseTime <= FileManager.this.maxIdleTime) continue;
                        filesToClose.add(openReader.reader);
                        oflIter.remove();
                    }
                    if (ofl.size() != 0) continue;
                    iter.remove();
                }
            }
            FileManager.this.closeReaders(filesToClose);
        }
    }

    private static class OpenReader
    implements Comparable<OpenReader> {
        long releaseTime;
        FileSKVIterator reader;
        String fileName;

        public OpenReader(String fileName, FileSKVIterator reader) {
            this.fileName = fileName;
            this.reader = reader;
            this.releaseTime = System.currentTimeMillis();
        }

        @Override
        public int compareTo(OpenReader o) {
            if (this.releaseTime < o.releaseTime) {
                return -1;
            }
            if (this.releaseTime > o.releaseTime) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpenReader) {
                return this.compareTo((OpenReader)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.fileName.hashCode();
        }
    }
}

