/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.tserver.log.CloseableIterator;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.commons.collections.buffer.PriorityBuffer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class RecoveryLogReader
implements CloseableIterator<Map.Entry<LogFileKey, LogFileValue>> {
    private PriorityBuffer heap = new PriorityBuffer();
    private Iterator<Map.Entry<LogFileKey, LogFileValue>> iter;

    public RecoveryLogReader(VolumeManager fs, Path directory) throws IOException {
        this(fs, directory, null, null);
    }

    public RecoveryLogReader(VolumeManager fs, Path directory, LogFileKey start, LogFileKey end) throws IOException {
        boolean foundFinish = false;
        for (FileStatus child : fs.listStatus(directory)) {
            if (child.getPath().getName().startsWith("_")) continue;
            if (SortedLogState.isFinished((String)child.getPath().getName())) {
                foundFinish = true;
                continue;
            }
            FileSystem ns = fs.getVolumeByPath(child.getPath()).getFileSystem();
            this.heap.add((Object)new Index(new MapFile.Reader(ns.makeQualified(child.getPath()), ns.getConf(), new SequenceFile.Reader.Option[0])));
        }
        if (!foundFinish) {
            throw new IOException("Sort \"" + SortedLogState.FINISHED.getMarker() + "\" flag not found in " + directory);
        }
        this.iter = new SortCheckIterator(new RangeIterator(start, end));
    }

    private static void copy(Writable src, Writable dest) throws IOException {
        DataOutputBuffer output = new DataOutputBuffer();
        src.write((DataOutput)output);
        DataInputBuffer input = new DataInputBuffer();
        input.reset(output.getData(), output.getLength());
        dest.readFields((DataInput)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    synchronized boolean next(WritableComparable<?> key, Writable val) throws IOException {
        block4: {
            Index elt = (Index)this.heap.remove();
            try {
                elt.cache();
                if (elt.cached) {
                    RecoveryLogReader.copy(elt.key, key);
                    RecoveryLogReader.copy(elt.value, val);
                    elt.cached = false;
                    break block4;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.heap.add((Object)elt);
            }
        }
        return true;
    }

    @VisibleForTesting
    synchronized boolean seek(WritableComparable<?> key) throws IOException {
        PriorityBuffer reheap = new PriorityBuffer(this.heap.size());
        boolean result = false;
        for (Object obj : this.heap) {
            Index index = (Index)obj;
            try {
                WritableComparable found = index.reader.getClosest(key, index.value, true);
                if (found != null && found.equals(key)) {
                    result = true;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            index.cached = false;
            reheap.add((Object)index);
        }
        this.heap = reheap;
        return result;
    }

    @Override
    public void close() throws IOException {
        IOException problem = null;
        for (Object obj : this.heap) {
            Index index = (Index)obj;
            try {
                index.reader.close();
            }
            catch (IOException ex) {
                problem = ex;
            }
        }
        if (problem != null) {
            throw problem;
        }
        this.heap = null;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Map.Entry<LogFileKey, LogFileValue> next() {
        return this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private class RangeIterator
    implements Iterator<Map.Entry<LogFileKey, LogFileValue>> {
        private LogFileKey key = new LogFileKey();
        private LogFileValue value = new LogFileValue();
        private boolean hasNext;
        private LogFileKey end;

        private boolean next(LogFileKey key, LogFileValue value) throws IOException {
            try {
                return RecoveryLogReader.this.next(key, value);
            }
            catch (EOFException e) {
                return false;
            }
        }

        RangeIterator(LogFileKey start, LogFileKey end) throws IOException {
            this.end = end;
            if (start != null) {
                this.hasNext = this.next(this.key, this.value);
                if (this.hasNext && this.key.event != LogEvents.OPEN) {
                    throw new IllegalStateException("First log entry value is not OPEN");
                }
                RecoveryLogReader.this.seek(start);
            }
            this.hasNext = this.next(this.key, this.value);
            if (this.hasNext && start != null && this.key.compareTo(start) < 0) {
                throw new IllegalStateException("First key is less than start " + this.key + " " + start);
            }
            if (this.hasNext && end != null && this.key.compareTo(end) > 0) {
                this.hasNext = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Map.Entry<LogFileKey, LogFileValue> next() {
            Preconditions.checkState((boolean)this.hasNext);
            AbstractMap.SimpleImmutableEntry<LogFileKey, LogFileValue> entry = new AbstractMap.SimpleImmutableEntry<LogFileKey, LogFileValue>(this.key, this.value);
            this.key = new LogFileKey();
            this.value = new LogFileValue();
            try {
                this.hasNext = this.next(this.key, this.value);
                if (this.hasNext && this.end != null && this.key.compareTo(this.end) > 0) {
                    this.hasNext = false;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    @VisibleForTesting
    static class SortCheckIterator
    implements Iterator<Map.Entry<LogFileKey, LogFileValue>> {
        private PeekingIterator<Map.Entry<LogFileKey, LogFileValue>> source;

        SortCheckIterator(Iterator<Map.Entry<LogFileKey, LogFileValue>> source) {
            this.source = Iterators.peekingIterator(source);
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public Map.Entry<LogFileKey, LogFileValue> next() {
            Map.Entry next = (Map.Entry)this.source.next();
            if (this.source.hasNext()) {
                Preconditions.checkState((((LogFileKey)next.getKey()).compareTo((LogFileKey)((Map.Entry)this.source.peek()).getKey()) <= 0 ? 1 : 0) != 0, (String)"Keys not in order %s %s", (Object[])new Object[]{next.getKey(), ((Map.Entry)this.source.peek()).getKey()});
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class Index
    implements Comparable<Index> {
        MapFile.Reader reader;
        WritableComparable<?> key;
        Writable value;
        boolean cached = false;

        private static Object create(Class<?> klass) {
            try {
                return klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to construct objects to use for comparison");
            }
        }

        public Index(MapFile.Reader reader) {
            this.reader = reader;
            this.key = (WritableComparable)Index.create(reader.getKeyClass());
            this.value = (Writable)Index.create(reader.getValueClass());
        }

        private void cache() throws IOException {
            if (!this.cached && this.reader.next(this.key, this.value)) {
                this.cached = true;
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.key);
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj instanceof Index && 0 == this.compareTo((Index)obj);
        }

        @Override
        public int compareTo(Index o) {
            try {
                this.cache();
                o.cache();
                if (!this.cached) {
                    return 1;
                }
                if (!o.cached) {
                    return -1;
                }
                int result = this.key.compareTo(o.key);
                return result;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

