/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.log.CloseableIterator;
import org.apache.accumulo.tserver.log.RecoveryLogReader;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryLogsIterator
implements CloseableIterator<Map.Entry<LogFileKey, LogFileValue>> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryLogsIterator.class);
    List<CloseableIterator<Map.Entry<LogFileKey, LogFileValue>>> iterators;
    private UnmodifiableIterator<Map.Entry<LogFileKey, LogFileValue>> iter;

    RecoveryLogsIterator(VolumeManager fs, List<Path> recoveryLogPaths, LogFileKey start, LogFileKey end) throws IOException {
        this.iterators = new ArrayList<CloseableIterator<Map.Entry<LogFileKey, LogFileValue>>>(recoveryLogPaths.size());
        try {
            for (Path log : recoveryLogPaths) {
                this.iterators.add(new RecoveryLogReader(fs, log, start, end));
            }
            this.iter = Iterators.mergeSorted(this.iterators, (Comparator)new Comparator<Map.Entry<LogFileKey, LogFileValue>>(){

                @Override
                public int compare(Map.Entry<LogFileKey, LogFileValue> o1, Map.Entry<LogFileKey, LogFileValue> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
        }
        catch (IOException | RuntimeException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public Map.Entry<LogFileKey, LogFileValue> next() {
        return (Map.Entry)this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() {
        for (CloseableIterator<Map.Entry<LogFileKey, LogFileValue>> reader : this.iterators) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close reader", (Throwable)e);
            }
        }
    }
}

