/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationConfigurationUtil;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.util.Retry;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.tserver.Mutations;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.SortedLogRecovery;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerLogger {
    private static final Logger log = LoggerFactory.getLogger(TabletServerLogger.class);
    private final AtomicLong logSizeEstimate = new AtomicLong();
    private final long maxSize;
    private final long maxAge;
    private final TabletServer tserver;
    private DfsLogger currentLog = null;
    private final SynchronousQueue<Object> nextLog = new SynchronousQueue();
    private ThreadPoolExecutor nextLogMaker;
    private final AtomicInteger logId = new AtomicInteger();
    private final ReentrantReadWriteLock logIdLock = new ReentrantReadWriteLock();
    private final AtomicLong syncCounter;
    private final AtomicLong flushCounter;
    private long createTime = 0L;
    private final Retry.RetryFactory createRetryFactory;
    private Retry createRetry = null;
    private final Retry.RetryFactory writeRetryFactory;

    private static void testLockAndRun(ReadWriteLock rwlock, TestCallWithWriteLock code) throws IOException {
        block7: {
            rwlock.readLock().lock();
            try {
                if (!code.test()) break block7;
                rwlock.readLock().unlock();
                rwlock.writeLock().lock();
                try {
                    if (code.test()) {
                        code.withWriteLock();
                    }
                }
                finally {
                    rwlock.readLock().lock();
                    rwlock.writeLock().unlock();
                }
            }
            finally {
                rwlock.readLock().unlock();
            }
        }
    }

    public TabletServerLogger(TabletServer tserver, long maxSize, AtomicLong syncCounter, AtomicLong flushCounter, Retry.RetryFactory createRetryFactory, Retry.RetryFactory writeRetryFactory, long maxAge) {
        this.tserver = tserver;
        this.maxSize = maxSize;
        this.syncCounter = syncCounter;
        this.flushCounter = flushCounter;
        this.createRetryFactory = createRetryFactory;
        this.createRetry = null;
        this.writeRetryFactory = writeRetryFactory;
        this.maxAge = maxAge;
    }

    private DfsLogger initializeLoggers(final AtomicInteger logIdOut) throws IOException {
        final AtomicReference result = new AtomicReference();
        TabletServerLogger.testLockAndRun(this.logIdLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                result.set(TabletServerLogger.this.currentLog);
                if (TabletServerLogger.this.currentLog != null) {
                    logIdOut.set(TabletServerLogger.this.logId.get());
                }
                return TabletServerLogger.this.currentLog == null;
            }

            @Override
            void withWriteLock() throws IOException {
                try {
                    TabletServerLogger.this.createLogger();
                    result.set(TabletServerLogger.this.currentLog);
                    if (TabletServerLogger.this.currentLog != null) {
                        logIdOut.set(TabletServerLogger.this.logId.get());
                    } else {
                        logIdOut.set(-1);
                    }
                }
                catch (IOException e) {
                    log.error("Unable to create loggers", (Throwable)e);
                }
            }
        });
        return (DfsLogger)result.get();
    }

    public String getLogFile() {
        this.logIdLock.readLock().lock();
        try {
            if (null == this.currentLog) {
                String string = null;
                return string;
            }
            String string = this.currentLog.getFileName();
            return string;
        }
        finally {
            this.logIdLock.readLock().unlock();
        }
    }

    private synchronized void createLogger() throws IOException {
        if (!this.logIdLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("createLoggers should be called with write lock held!");
        }
        if (this.currentLog != null) {
            throw new IllegalStateException("createLoggers should not be called when current log is set");
        }
        try {
            this.startLogMaker();
            Object next = this.nextLog.take();
            if (next instanceof Exception) {
                throw (Exception)next;
            }
            if (next instanceof DfsLogger) {
                this.currentLog = (DfsLogger)next;
                this.logId.incrementAndGet();
                log.info("Using next log " + this.currentLog.getFileName());
                if (null != this.createRetry) {
                    this.createRetry = null;
                }
                this.createTime = System.currentTimeMillis();
                return;
            }
            throw new RuntimeException("Error: unexpected type seen: " + next);
        }
        catch (Exception t) {
            if (null == this.createRetry) {
                this.createRetry = this.createRetryFactory.createRetry();
            }
            if (this.createRetry.canRetry()) {
                this.createRetry.useRetry();
                try {
                    this.createRetry.waitForNextAttempt();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            } else {
                log.error("Repeatedly failed to create WAL. Going to exit tabletserver.", (Throwable)t);
                Halt.halt((String)"Experienced too many errors creating WALs, giving up", (int)1);
            }
            throw new RuntimeException(t);
        }
    }

    private synchronized void startLogMaker() {
        if (this.nextLogMaker != null) {
            return;
        }
        this.nextLogMaker = new SimpleThreadPool(1, "WALog creator");
        this.nextLogMaker.submit((Runnable)new LoggingRunnable(log, new Runnable(){

            @Override
            public void run() {
                DfsLogger.ServerResources conf = TabletServerLogger.this.tserver.getServerConfig();
                VolumeManager fs = conf.getFileSystem();
                while (!TabletServerLogger.this.nextLogMaker.isShutdown()) {
                    DfsLogger alog = null;
                    try {
                        log.debug("Creating next WAL");
                        alog = new DfsLogger(conf, TabletServerLogger.this.syncCounter, TabletServerLogger.this.flushCounter);
                        alog.open(TabletServerLogger.this.tserver.getClientAddressString());
                        String fileName = alog.getFileName();
                        log.debug("Created next WAL " + fileName);
                        TabletServerLogger.this.tserver.addNewLogMarker(alog);
                        while (!TabletServerLogger.this.nextLog.offer(alog, 12L, TimeUnit.HOURS)) {
                            log.info("Our WAL was not used for 12 hours: " + fileName);
                        }
                    }
                    catch (Exception t) {
                        log.error("Failed to open WAL", (Throwable)t);
                        if (null != alog) {
                            try {
                                alog.close();
                            }
                            catch (Exception e) {
                                log.error("Failed to close WAL after it failed to open", (Throwable)e);
                            }
                            try {
                                Path path = alog.getPath();
                                if (fs.exists(path)) {
                                    fs.delete(path);
                                }
                            }
                            catch (Exception e) {
                                log.warn("Failed to delete a WAL that failed to open", (Throwable)e);
                            }
                        }
                        try {
                            TabletServerLogger.this.nextLog.offer(t, 12L, TimeUnit.HOURS);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }));
    }

    public void resetLoggers() throws IOException {
        this.logIdLock.writeLock().lock();
        try {
            this.close();
        }
        finally {
            this.logIdLock.writeLock().unlock();
        }
    }

    private synchronized void close() throws IOException {
        block9: {
            if (!this.logIdLock.isWriteLockedByCurrentThread()) {
                throw new IllegalStateException("close should be called with write lock held!");
            }
            try {
                if (null == this.currentLog) break block9;
                try {
                    this.currentLog.close();
                }
                catch (DfsLogger.LogClosedException logClosedException) {
                }
                catch (Throwable ex) {
                    log.error("Unable to cleanly close log " + this.currentLog.getFileName() + ": " + ex, ex);
                }
                finally {
                    this.tserver.walogClosed(this.currentLog);
                }
                this.currentLog = null;
                this.logSizeEstimate.set(0L);
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
    }

    private void write(CommitSession commitSession, boolean mincFinish, Writer writer) throws IOException {
        this.write(commitSession, mincFinish, writer, this.writeRetryFactory.createRetry());
    }

    private void write(CommitSession commitSession, boolean mincFinish, Writer writer, Retry writeRetry) throws IOException {
        List<CommitSession> sessions = Collections.singletonList(commitSession);
        this.write(sessions, mincFinish, writer, writeRetry);
    }

    private void write(Collection<CommitSession> sessions, boolean mincFinish, Writer writer) throws IOException {
        this.write(sessions, mincFinish, writer, this.writeRetryFactory.createRetry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(final Collection<CommitSession> sessions, boolean mincFinish, Writer writer, Retry writeRetry) throws IOException {
        int currentLogId = this.logId.get();
        boolean success = false;
        while (!success) {
            try {
                DfsLogger copy = null;
                AtomicInteger currentId = new AtomicInteger(-1);
                copy = this.initializeLoggers(currentId);
                currentLogId = currentId.get();
                if (currentLogId == this.logId.get()) {
                    for (CommitSession commitSession : sessions) {
                        if (!commitSession.beginUpdatingLogsUsed(copy, mincFinish)) continue;
                        try {
                            this.defineTablet(commitSession, writeRetry);
                        }
                        finally {
                            commitSession.finishUpdatingLogsUsed();
                        }
                        KeyExtent extent = commitSession.getExtent();
                        if (!ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)this.tserver.getTableConfiguration(extent))) continue;
                        Replication.Status status = StatusUtil.openWithUnknownLength((long)System.currentTimeMillis());
                        log.debug("Writing " + ProtobufUtil.toString((GeneratedMessage)status) + " to metadata table for " + copy.getFileName());
                        ReplicationTableUtil.updateFiles((ClientContext)this.tserver, (KeyExtent)commitSession.getExtent(), (String)copy.getFileName(), (Replication.Status)status);
                    }
                }
                if (currentLogId == this.logId.get()) {
                    DfsLogger.LoggerOperation lop = writer.write(copy);
                    lop.await();
                    success = currentLogId == this.logId.get();
                }
            }
            catch (DfsLogger.LogClosedException ex) {
                writeRetry.logRetry(log, "Logs closed while writing", (Throwable)ex);
            }
            catch (Exception t) {
                writeRetry.logRetry(log, "Failed to write to WAL", (Throwable)t);
                try {
                    writeRetry.waitForNextAttempt();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            finally {
                writeRetry.useRetry();
            }
            final int finalCurrent = currentLogId;
            if (success) continue;
            TabletServerLogger.testLockAndRun(this.logIdLock, new TestCallWithWriteLock(){

                @Override
                boolean test() {
                    return finalCurrent == TabletServerLogger.this.logId.get();
                }

                @Override
                void withWriteLock() throws IOException {
                    TabletServerLogger.this.close();
                    TabletServerLogger.this.closeForReplication(sessions);
                }
            });
        }
        this.logSizeEstimate.addAndGet(12L);
        TabletServerLogger.testLockAndRun(this.logIdLock, new TestCallWithWriteLock(){

            @Override
            boolean test() {
                return TabletServerLogger.this.logSizeEstimate.get() > TabletServerLogger.this.maxSize || System.currentTimeMillis() - TabletServerLogger.this.createTime > TabletServerLogger.this.maxAge;
            }

            @Override
            void withWriteLock() throws IOException {
                TabletServerLogger.this.close();
                TabletServerLogger.this.closeForReplication(sessions);
            }
        });
    }

    protected void closeForReplication(Collection<CommitSession> sessions) {
    }

    public void defineTablet(final CommitSession commitSession, Retry writeRetry) throws IOException {
        this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                logger.defineTablet(commitSession.getWALogSeq(), commitSession.getLogId(), commitSession.getExtent());
                return DfsLogger.NO_WAIT_LOGGER_OP;
            }
        }, writeRetry);
    }

    public void log(final CommitSession commitSession, final long tabletSeq, final Mutation m, final Durability durability) throws IOException {
        if (durability == Durability.NONE) {
            return;
        }
        if (durability == Durability.DEFAULT) {
            throw new IllegalArgumentException("Unexpected durability " + durability);
        }
        this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                return logger.log(tabletSeq, commitSession.getLogId(), m, durability);
            }
        });
        this.logSizeEstimate.addAndGet(m.numBytes());
    }

    public void logManyTablets(Map<CommitSession, Mutations> mutations) throws IOException {
        final HashMap<CommitSession, Mutations> loggables = new HashMap<CommitSession, Mutations>(mutations);
        for (Map.Entry<CommitSession, Mutations> entry : mutations.entrySet()) {
            if (entry.getValue().getDurability() != Durability.NONE) continue;
            loggables.remove(entry.getKey());
        }
        if (loggables.size() == 0) {
            return;
        }
        this.write(loggables.keySet(), false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                ArrayList<TabletMutations> copy = new ArrayList<TabletMutations>(loggables.size());
                for (Map.Entry entry : loggables.entrySet()) {
                    CommitSession cs = (CommitSession)entry.getKey();
                    Durability durability = ((Mutations)entry.getValue()).getDurability();
                    copy.add(new TabletMutations(cs.getLogId(), cs.getWALogSeq(), ((Mutations)entry.getValue()).getMutations(), durability));
                }
                return logger.logManyTablets(copy);
            }
        });
        for (Mutations mutations2 : loggables.values()) {
            if (mutations2.getMutations().size() < 1) {
                throw new IllegalArgumentException("logManyTablets: logging empty mutation list");
            }
            for (Mutation m : mutations2.getMutations()) {
                this.logSizeEstimate.addAndGet(m.numBytes());
            }
        }
    }

    public void minorCompactionFinished(final CommitSession commitSession, final String fullyQualifiedFileName, final long walogSeq, final Durability durability) throws IOException {
        long t1 = System.currentTimeMillis();
        this.write(commitSession, true, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                return logger.minorCompactionFinished(walogSeq, commitSession.getLogId(), fullyQualifiedFileName, durability);
            }
        });
        long t2 = System.currentTimeMillis();
        log.debug(" wrote MinC finish: writeTime:{}ms  durability:{}", (Object)(t2 - t1), (Object)durability);
    }

    public long minorCompactionStarted(final CommitSession commitSession, final long seq, final String fullyQualifiedFileName, final Durability durability) throws IOException {
        this.write(commitSession, false, new Writer(){

            @Override
            public DfsLogger.LoggerOperation write(DfsLogger logger) throws Exception {
                return logger.minorCompactionStarted(seq, commitSession.getLogId(), fullyQualifiedFileName, durability);
            }
        });
        return seq;
    }

    public void recover(VolumeManager fs, KeyExtent extent, TableConfiguration tconf, List<Path> logs, Set<String> tabletFiles, MutationReceiver mr) throws IOException {
        try {
            SortedLogRecovery recovery = new SortedLogRecovery(fs);
            recovery.recover(extent, logs, tabletFiles, mr);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static interface Writer {
        public DfsLogger.LoggerOperation write(DfsLogger var1) throws Exception;
    }

    private static abstract class TestCallWithWriteLock {
        private TestCallWithWriteLock() {
        }

        abstract boolean test();

        abstract void withWriteLock() throws IOException;
    }
}

