/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImportCacheCleaner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BulkImportCacheCleaner.class);
    private final TabletServer server;

    public BulkImportCacheCleaner(TabletServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        HashSet<Long> tids = new HashSet<Long>();
        for (Tablet tablet : this.server.getOnlineTablets()) {
            tids.addAll(tablet.getBulkIngestedFiles().keySet());
        }
        try {
            Set allTransactionsAlive = TransactionWatcher.ZooArbitrator.allTransactionsAlive((String)"bulkTx");
            tids.removeAll(allTransactionsAlive);
            for (Tablet tablet : this.server.getOnlineTablets()) {
                tablet.cleanupBulkLoadedFiles(tids);
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.debug("Error reading bulk import live transactions {}", (Object)e.toString());
        }
    }
}

