/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.GeneratedMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.DurabilityImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.YieldCallback;
import org.apache.accumulo.core.iterators.YieldingKeyValueIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationConfigurationUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.ProbabilitySampler;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.tableOps.UserCompactionConfig;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.tablets.TabletTime;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.tserver.ConditionCheckerContext;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.TConstraintViolationException;
import org.apache.accumulo.tserver.TLevel;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.accumulo.tserver.TservConstraintEnv;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.apache.accumulo.tserver.constraints.ConstraintChecker;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.mastermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.tablet.Batch;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.CompactionRunner;
import org.apache.accumulo.tserver.tablet.CompactionStats;
import org.apache.accumulo.tserver.tablet.Compactor;
import org.apache.accumulo.tserver.tablet.DatafileManager;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.MinorCompactionTask;
import org.apache.accumulo.tserver.tablet.MinorCompactor;
import org.apache.accumulo.tserver.tablet.Rate;
import org.apache.accumulo.tserver.tablet.RootFiles;
import org.apache.accumulo.tserver.tablet.ScanDataSource;
import org.apache.accumulo.tserver.tablet.ScanOptions;
import org.apache.accumulo.tserver.tablet.Scanner;
import org.apache.accumulo.tserver.tablet.SplitRowSpec;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.apache.accumulo.tserver.tablet.TabletCommitter;
import org.apache.accumulo.tserver.tablet.TabletData;
import org.apache.accumulo.tserver.tablet.TabletMemory;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Sampler;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.zookeeper.KeeperException;

public class Tablet
implements TabletCommitter {
    private static final Logger log = Logger.getLogger(Tablet.class);
    private final TabletServer tabletServer;
    private final KeyExtent extent;
    private final TabletServerResourceManager.TabletResourceManager tabletResources;
    private final DatafileManager datafileManager;
    private final TableConfiguration tableConfiguration;
    private final String tabletDirectory;
    private final Path location;
    private final TabletMemory tabletMemory;
    private final TabletTime tabletTime;
    private final Object timeLock = new Object();
    private long persistedTime;
    private TServerInstance lastLocation = null;
    private volatile boolean tableDirChecked = false;
    private final AtomicLong dataSourceDeletions = new AtomicLong(0L);
    private final Set<ScanDataSource> activeScans = new HashSet<ScanDataSource>();
    private volatile CloseState closeState = CloseState.OPEN;
    private boolean updatingFlushID = false;
    private long lastFlushID = -1L;
    private long lastCompactID = -1L;
    private final CompactionWaitInfo compactionWaitInfo = new CompactionWaitInfo();
    private volatile CompactionState minorCompactionState = null;
    private volatile CompactionState majorCompactionState = null;
    private final Set<MajorCompactionReason> majorCompactionQueued = Collections.synchronizedSet(EnumSet.noneOf(MajorCompactionReason.class));
    private final AtomicReference<ConstraintChecker> constraintChecker = new AtomicReference();
    private int writesInProgress = 0;
    private final TabletStatsKeeper timer = new TabletStatsKeeper();
    private final Rate queryRate = new Rate(0.95);
    private long queryCount = 0L;
    private final Rate queryByteRate = new Rate(0.95);
    private long queryBytes = 0L;
    private final Rate ingestRate = new Rate(0.95);
    private long ingestCount = 0L;
    private final Rate ingestByteRate = new Rate(0.95);
    private long ingestBytes = 0L;
    private byte[] defaultSecurityLabel = new byte[0];
    private long lastMinorCompactionFinishTime = 0L;
    private long lastMapFileImportTime = 0L;
    private volatile long numEntries = 0L;
    private volatile long numEntriesInMemory = 0L;
    private final Rate scannedRate = new Rate(0.95);
    private final AtomicLong scannedCount = new AtomicLong(0L);
    private final ConfigurationObserver configObserver;
    private final Cache<Long, List<FileRef>> bulkImported = CacheBuilder.newBuilder().build();
    private final int logId;
    private boolean closeCompleting = false;
    private boolean sawBigRow = false;
    private long timeOfLastMinCWhenBigFreakinRowWasSeen = 0L;
    private long timeOfLastImportWhenBigFreakinRowWasSeen = 0L;
    private final long splitCreationTime;
    private Set<DfsLogger> currentLogs = new HashSet<DfsLogger>();
    private Set<DfsLogger> otherLogs = Collections.emptySet();
    private volatile Set<DfsLogger> referencedLogs = Collections.emptySet();
    private boolean removingLogs = false;
    private final ReentrantLock logLock = new ReentrantLock();

    public long getDataSourceDeletions() {
        return this.dataSourceDeletions.get();
    }

    @Override
    public int getLogId() {
        return this.logId;
    }

    FileRef getNextMapFilename(String prefix) throws IOException {
        String extension = FileOperations.getNewFileExtension((AccumuloConfiguration)this.tableConfiguration);
        this.checkTabletDir();
        return new FileRef(this.location.toString() + "/" + prefix + UniqueNameAllocator.getInstance().getNextName() + "." + extension);
    }

    private void checkTabletDir() throws IOException {
        if (!this.tableDirChecked) {
            FileStatus[] files = null;
            try {
                files = this.getTabletServer().getFileSystem().listStatus(this.location);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (files == null) {
                if (this.location.getName().startsWith("c-")) {
                    log.debug((Object)("Tablet " + this.extent + " had no dir, creating " + this.location));
                } else {
                    log.warn((Object)("Tablet " + this.extent + " had no dir, creating " + this.location));
                }
                this.getTabletServer().getFileSystem().mkdirs(this.location);
            }
            this.tableDirChecked = true;
        }
    }

    @VisibleForTesting
    protected Tablet(TabletTime tabletTime, String tabletDirectory, int logId, Path location, DatafileManager datafileManager, TabletServer tabletServer, TabletServerResourceManager.TabletResourceManager tabletResources, TabletMemory tabletMemory, TableConfiguration tableConfiguration, KeyExtent extent, ConfigurationObserver configObserver) {
        this.tabletTime = tabletTime;
        this.tabletDirectory = tabletDirectory;
        this.logId = logId;
        this.location = location;
        this.datafileManager = datafileManager;
        this.tabletServer = tabletServer;
        this.tabletResources = tabletResources;
        this.tabletMemory = tabletMemory;
        this.tableConfiguration = tableConfiguration;
        this.extent = extent;
        this.configObserver = configObserver;
        this.splitCreationTime = 0L;
    }

    public Tablet(TabletServer tabletServer, final KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, TabletData data) throws IOException {
        String contextName;
        this.tabletServer = tabletServer;
        this.extent = extent;
        this.tabletResources = trm;
        this.lastLocation = data.getLastLocation();
        this.lastFlushID = data.getFlushID();
        this.lastCompactID = data.getCompactID();
        this.splitCreationTime = data.getSplitTime();
        this.tabletTime = TabletTime.getInstance((String)data.getTime());
        this.persistedTime = this.tabletTime.getTime();
        this.logId = tabletServer.createLogId();
        TableConfiguration tblConf = tabletServer.getTableConfiguration(extent);
        if (null == tblConf) {
            Tables.clearCache((Instance)tabletServer.getInstance());
            tblConf = tabletServer.getTableConfiguration(extent);
            Objects.requireNonNull(tblConf, "Could not get table configuration for " + extent.getTableId());
        }
        this.tableConfiguration = tblConf;
        VolumeManager fs = tabletServer.getFileSystem();
        boolean replicationEnabled = ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)this.tableConfiguration);
        VolumeUtil.TabletFiles tabletPaths = new VolumeUtil.TabletFiles(data.getDirectory(), data.getLogEntris(), data.getDataFiles());
        tabletPaths = VolumeUtil.updateTabletVolumes((AccumuloServerContext)tabletServer, (ZooLock)tabletServer.getLock(), (VolumeManager)fs, (KeyExtent)extent, (VolumeUtil.TabletFiles)tabletPaths, (boolean)replicationEnabled);
        Path locationPath = tabletPaths.dir.contains(":") ? new Path(tabletPaths.dir) : tabletServer.getFileSystem().getFullPath(VolumeManager.FileType.TABLE, extent.getTableId() + tabletPaths.dir);
        this.location = locationPath;
        this.tabletDirectory = tabletPaths.dir;
        for (Map.Entry<Long, List<FileRef>> entry : data.getBulkImported().entrySet()) {
            this.bulkImported.put((Object)entry.getKey(), new CopyOnWriteArrayList(entry.getValue()));
        }
        this.setupDefaultSecurityLabels(extent);
        List logEntries = tabletPaths.logEntries;
        SortedMap datafiles = tabletPaths.datafiles;
        this.configObserver = new ConfigurationObserver(){

            private void reloadConstraints() {
                log.debug((Object)("Reloading constraints for extent: " + extent));
                Tablet.this.constraintChecker.set(new ConstraintChecker(Tablet.this.tableConfiguration));
            }

            public void propertiesChanged() {
                this.reloadConstraints();
                try {
                    Tablet.this.setupDefaultSecurityLabels(extent);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to reload default security labels for extent: " + extent.toString()));
                }
            }

            public void propertyChanged(String prop) {
                if (prop.startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey())) {
                    this.reloadConstraints();
                } else if (prop.equals(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey())) {
                    try {
                        log.info((Object)("Default security labels changed for extent: " + extent.toString()));
                        Tablet.this.setupDefaultSecurityLabels(extent);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to reload default security labels for extent: " + extent.toString()));
                    }
                }
            }

            public void sessionExpired() {
                log.debug((Object)"Session expired, no longer updating per table props...");
            }
        };
        this.tableConfiguration.addObserver(this.configObserver);
        this.tableConfiguration.getNamespaceConfiguration().addObserver(this.configObserver);
        this.tabletMemory = new TabletMemory(this);
        this.configObserver.propertiesChanged();
        if (!logEntries.isEmpty()) {
            log.info((Object)("Starting Write-Ahead Log recovery for " + this.extent));
            final AtomicLong entriesUsedOnTablet = new AtomicLong(0L);
            final AtomicLong maxTime = new AtomicLong(Long.MIN_VALUE);
            final CommitSession commitSession = this.getTabletMemory().getCommitSession();
            try {
                HashSet<String> absPaths = new HashSet<String>();
                for (FileRef ref : datafiles.keySet()) {
                    absPaths.add(ref.path().toString());
                }
                tabletServer.recover(this.getTabletServer().getFileSystem(), extent, this.tableConfiguration, logEntries, absPaths, new MutationReceiver(){

                    @Override
                    public void receive(Mutation m) {
                        List muts = m.getUpdates();
                        for (ColumnUpdate columnUpdate : muts) {
                            if (columnUpdate.hasTimestamp()) continue;
                            maxTime.set(Math.max(maxTime.get(), columnUpdate.getTimestamp()));
                        }
                        Tablet.this.getTabletMemory().mutate(commitSession, Collections.singletonList(m));
                        entriesUsedOnTablet.incrementAndGet();
                    }
                });
                if (maxTime.get() != Long.MIN_VALUE) {
                    this.tabletTime.useMaxTimeFromWALog(maxTime.get());
                }
                commitSession.updateMaxCommittedTime(this.tabletTime.getTime());
                if (entriesUsedOnTablet.get() == 0L) {
                    log.debug((Object)("No replayed mutations applied, removing unused entries for " + extent));
                    MetadataTableUtil.removeUnusedWALEntries((AccumuloServerContext)this.getTabletServer(), (KeyExtent)extent, (List)logEntries, (ZooLock)tabletServer.getLock());
                    logEntries.clear();
                } else if (ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)tabletServer.getTableConfiguration(extent))) {
                    Replication.Status status = StatusUtil.openWithUnknownLength();
                    for (LogEntry logEntry : logEntries) {
                        log.debug((Object)("Writing updated status to metadata table for " + logEntry.filename + " " + ProtobufUtil.toString((GeneratedMessage)status)));
                        ReplicationTableUtil.updateFiles((ClientContext)tabletServer, (KeyExtent)extent, (String)logEntry.filename, (Replication.Status)status);
                    }
                }
            }
            catch (Throwable t) {
                if (this.tableConfiguration.getBoolean(Property.TABLE_FAILURES_IGNORE)) {
                    log.warn((Object)"Error recovering from log files: ", t);
                }
                throw new RuntimeException(t);
            }
            this.currentLogs = new HashSet<DfsLogger>();
            for (LogEntry logEntry : logEntries) {
                this.currentLogs.add(new DfsLogger(tabletServer.getServerConfig(), logEntry.filename, logEntry.getColumnQualifier().toString()));
            }
            this.rebuildReferencedLogs();
            log.info((Object)("Write-Ahead Log recovery complete for " + this.extent + " (" + entriesUsedOnTablet.get() + " mutations applied, " + this.getTabletMemory().getNumEntries() + " entries created)"));
        }
        if ((contextName = this.tableConfiguration.get(Property.TABLE_CLASSPATH)) != null && !contextName.equals("")) {
            AccumuloVFSClassLoader.getContextManager().getClassLoader(contextName);
        }
        this.datafileManager = new DatafileManager(this, datafiles);
        this.computeNumEntries();
        this.getDatafileManager().removeFilesAfterScan(data.getScanFiles());
        if (!logEntries.isEmpty() || this.needsMajorCompaction(MajorCompactionReason.NORMAL)) {
            this.removeOldTemporaryFiles();
        }
        log.log((Priority)TLevel.TABLET_HIST, (Object)(extent + " opened"));
    }

    private void removeOldTemporaryFiles() {
        try {
            for (FileStatus tmp : this.getTabletServer().getFileSystem().globStatus(new Path(this.location, "*_tmp"))) {
                try {
                    log.debug((Object)("Removing old temp file " + tmp.getPath()));
                    this.getTabletServer().getFileSystem().delete(tmp.getPath());
                }
                catch (IOException ex) {
                    log.error((Object)("Unable to remove old temp file " + tmp.getPath() + ": " + ex));
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error scanning for old temp files in " + this.location));
        }
    }

    private void setupDefaultSecurityLabels(KeyExtent extent) {
        if (extent.isMeta()) {
            this.defaultSecurityLabel = new byte[0];
        } else {
            try {
                ColumnVisibility cv = new ColumnVisibility(this.tableConfiguration.get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY));
                this.defaultSecurityLabel = cv.getExpression();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.defaultSecurityLabel = new byte[0];
            }
        }
    }

    private LookupResult lookup(SortedKeyValueIterator<Key, Value> mmfi, List<Range> ranges, HashSet<Column> columnSet, List<KVEntry> results, long maxResultsSize, long batchTimeOut) throws IOException {
        LookupResult lookupResult = new LookupResult();
        boolean exceededMemoryUsage = false;
        boolean tabletClosed = false;
        ImmutableSet cfset = null;
        if (columnSet.size() > 0) {
            cfset = LocalityGroupUtil.families(columnSet);
        }
        long returnTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(batchTimeOut);
        if (batchTimeOut <= 0L || batchTimeOut == Long.MAX_VALUE) {
            batchTimeOut = 0L;
        }
        YieldCallback yield = new YieldCallback();
        if (mmfi instanceof YieldingKeyValueIterator) {
            ((YieldingKeyValueIterator)mmfi).enableYielding(yield);
        }
        boolean yielded = false;
        for (Range range : ranges) {
            boolean timesUp;
            boolean bl = timesUp = batchTimeOut > 0L && System.nanoTime() > returnTime;
            if (exceededMemoryUsage || tabletClosed || timesUp || yielded) {
                lookupResult.unfinishedRanges.add(range);
                continue;
            }
            int entriesAdded = 0;
            try {
                if (cfset != null) {
                    mmfi.seek(range, (Collection)cfset, true);
                } else {
                    mmfi.seek(range, (Collection)LocalityGroupUtil.EMPTY_CF_SET, false);
                }
                while (mmfi.hasTop()) {
                    if (yield.hasYielded()) {
                        throw new IOException("Coding error: hasTop returned true but has yielded at " + yield.getPositionAndReset());
                    }
                    Key key = (Key)mmfi.getTopKey();
                    KVEntry kve = new KVEntry(key, (Value)mmfi.getTopValue());
                    results.add(kve);
                    ++entriesAdded;
                    lookupResult.bytesAdded += (long)kve.estimateMemoryUsed();
                    lookupResult.dataSize += (long)kve.numBytes();
                    exceededMemoryUsage = lookupResult.bytesAdded > maxResultsSize;
                    boolean bl2 = timesUp = batchTimeOut > 0L && System.nanoTime() > returnTime;
                    if (exceededMemoryUsage || timesUp) {
                        this.addUnfinishedRange(lookupResult, range, key, false);
                        break;
                    }
                    mmfi.next();
                }
                if (!yield.hasYielded()) continue;
                yielded = true;
                Key yieldPosition = (Key)yield.getPositionAndReset();
                if (!range.contains(yieldPosition)) {
                    throw new IOException("Underlying iterator yielded to a position outside of its range: " + yieldPosition + " not in " + range);
                }
                if (!results.isEmpty() && yieldPosition.compareTo((Key)results.get(results.size() - 1).getKey()) <= 0) {
                    throw new IOException("Underlying iterator yielded to a position that does not follow the last key returned: " + yieldPosition + " <= " + results.get(results.size() - 1).getKey());
                }
                this.addUnfinishedRange(lookupResult, range, yieldPosition, false);
                log.debug((Object)("Scan yield detected at position " + yieldPosition));
                Metrics scanMetrics = this.getTabletServer().getScanMetrics();
                if (!scanMetrics.isEnabled()) continue;
                scanMetrics.add("yield", 1L);
            }
            catch (TooManyFilesException tmfe) {
                log.warn((Object)("Tablet " + this.getExtent() + " has too many files, batch lookup can not run"));
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
            catch (IOException ioe) {
                if (this.shutdownInProgress()) {
                    log.debug((Object)"IOException while shutdown in progress ", (Throwable)ioe);
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw ioe;
            }
            catch (IterationInterruptedException iie) {
                if (this.isClosed()) {
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw iie;
            }
            catch (TabletClosedException tce) {
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
        }
        return lookupResult;
    }

    private void handleTabletClosedDuringScan(List<KVEntry> results, LookupResult lookupResult, boolean exceededMemoryUsage, Range range, int entriesAdded) {
        if (exceededMemoryUsage) {
            throw new IllegalStateException("tablet should not exceed memory usage or close, not both");
        }
        if (entriesAdded > 0) {
            this.addUnfinishedRange(lookupResult, range, (Key)results.get(results.size() - 1).getKey(), false);
        } else {
            lookupResult.unfinishedRanges.add(range);
        }
        lookupResult.closed = true;
    }

    private void addUnfinishedRange(LookupResult lookupResult, Range range, Key key, boolean inclusiveStartKey) {
        if (range.getEndKey() == null || key.compareTo(range.getEndKey()) < 0) {
            Range nlur = new Range(new Key(key), inclusiveStartKey, range.getEndKey(), range.isEndKeyInclusive());
            lookupResult.unfinishedRanges.add(nlur);
        }
    }

    public void checkConditions(ConditionCheckerContext.ConditionChecker checker, Authorizations authorizations, AtomicBoolean iFlag) throws IOException {
        ScanDataSource dataSource = new ScanDataSource(this, authorizations, this.defaultSecurityLabel, iFlag);
        try {
            SourceSwitchingIterator iter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource);
            checker.check((SortedKeyValueIterator<Key, Value>)iter);
        }
        catch (IOException ioe) {
            dataSource.close(true);
            throw ioe;
        }
        finally {
            dataSource.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupResult lookup(List<Range> ranges, HashSet<Column> columns, Authorizations authorizations, List<KVEntry> results, long maxResultSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws IOException {
        if (ranges.size() == 0) {
            return new LookupResult();
        }
        if ((ranges = Range.mergeOverlapping(ranges)).size() > 1) {
            Collections.sort(ranges);
        }
        Range tabletRange = this.extent.toDataRange();
        for (Range range : ranges) {
            tabletRange.clip(range);
        }
        ScanDataSource dataSource = new ScanDataSource(this, authorizations, this.defaultSecurityLabel, columns, ssiList, ssio, interruptFlag, samplerConfig, batchTimeOut, classLoaderContext);
        LookupResult result = null;
        try {
            SourceSwitchingIterator iter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource);
            LookupResult lookupResult = result = this.lookup((SortedKeyValueIterator<Key, Value>)iter, ranges, columns, results, maxResultSize, batchTimeOut);
            return lookupResult;
        }
        catch (IOException ioe) {
            dataSource.close(true);
            throw ioe;
        }
        finally {
            dataSource.close(false);
            Tablet tablet = this;
            synchronized (tablet) {
                this.queryCount += (long)results.size();
                if (result != null) {
                    this.queryBytes += result.dataSize;
                }
            }
        }
    }

    Batch nextBatch(SortedKeyValueIterator<Key, Value> iter, Range range, int num, Set<Column> columns, long batchTimeOut, boolean isolated) throws IOException {
        long stopTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(batchTimeOut);
        if (batchTimeOut == Long.MAX_VALUE || batchTimeOut <= 0L) {
            batchTimeOut = 0L;
        }
        ArrayList<KVEntry> results = new ArrayList<KVEntry>();
        Key key = null;
        long resultSize = 0L;
        long resultBytes = 0L;
        long maxResultsSize = this.tableConfiguration.getMemoryInBytes(Property.TABLE_SCAN_MAXMEM);
        Key continueKey = null;
        boolean skipContinueKey = false;
        YieldCallback yield = new YieldCallback();
        if (!isolated && iter instanceof YieldingKeyValueIterator) {
            ((YieldingKeyValueIterator)iter).enableYielding(yield);
        }
        if (columns.size() == 0) {
            iter.seek(range, (Collection)LocalityGroupUtil.EMPTY_CF_SET, false);
        } else {
            iter.seek(range, (Collection)LocalityGroupUtil.families(columns), true);
        }
        while (iter.hasTop()) {
            boolean timesUp;
            if (yield.hasYielded()) {
                throw new IOException("Coding error: hasTop returned true but has yielded at " + yield.getPositionAndReset());
            }
            Value value = (Value)iter.getTopValue();
            key = (Key)iter.getTopKey();
            KVEntry kvEntry = new KVEntry(key, value);
            results.add(kvEntry);
            resultBytes += (long)kvEntry.numBytes();
            boolean bl = timesUp = batchTimeOut > 0L && System.nanoTime() >= stopTime;
            if ((resultSize += (long)kvEntry.estimateMemoryUsed()) >= maxResultsSize || results.size() >= num || timesUp) {
                continueKey = new Key(key);
                skipContinueKey = true;
                break;
            }
            iter.next();
        }
        if (yield.hasYielded()) {
            continueKey = new Key((Key)yield.getPositionAndReset());
            skipContinueKey = true;
            if (!range.contains(continueKey)) {
                throw new IOException("Underlying iterator yielded to a position outside of its range: " + continueKey + " not in " + range);
            }
            if (!results.isEmpty() && continueKey.compareTo((Key)((KVEntry)((Object)results.get(results.size() - 1))).getKey()) <= 0) {
                throw new IOException("Underlying iterator yielded to a position that does not follow the last key returned: " + continueKey + " <= " + ((KVEntry)((Object)results.get(results.size() - 1))).getKey());
            }
            log.debug((Object)("Scan yield detected at position " + continueKey));
            Metrics scanMetrics = this.getTabletServer().getScanMetrics();
            if (scanMetrics.isEnabled()) {
                scanMetrics.add("yield", 1L);
            }
        } else if (!iter.hasTop()) {
            continueKey = null;
            if (results.size() == 0) {
                results = null;
            }
        }
        return new Batch(skipContinueKey, results, continueKey, resultBytes);
    }

    boolean shutdownInProgress() {
        try {
            Runtime.getRuntime().removeShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                }
            }));
        }
        catch (IllegalStateException ise) {
            return true;
        }
        return false;
    }

    public Scanner createScanner(Range range, int num, Set<Column> columns, Authorizations authorizations, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, boolean isolated, AtomicBoolean interruptFlag, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) {
        this.extent.toDataRange().clip(range);
        ScanOptions opts = new ScanOptions(num, authorizations, this.defaultSecurityLabel, columns, ssiList, ssio, interruptFlag, isolated, samplerConfig, batchTimeOut, classLoaderContext);
        return new Scanner(this, range, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileValue minorCompact(VolumeManager fs, InMemoryMap memTable, FileRef tmpDatafile, FileRef newDatafile, FileRef mergeFile, boolean hasQueueTime, long queued, CommitSession commitSession, long flushId, MinorCompactionReason mincReason) {
        boolean failed = false;
        long start = System.currentTimeMillis();
        this.timer.incrementStatusMinor();
        long count = 0L;
        String oldName = Thread.currentThread().getName();
        try {
            CompactionStats stats;
            Thread.currentThread().setName("Minor compacting " + this.extent);
            Span span = Trace.start((String)"write");
            try {
                count = memTable.getNumEntries();
                DataFileValue dfv = null;
                if (mergeFile != null) {
                    dfv = (DataFileValue)this.getDatafileManager().getDatafileSizes().get(mergeFile);
                }
                MinorCompactor compactor = new MinorCompactor(this.tabletServer, this, memTable, mergeFile, dfv, tmpDatafile, mincReason, this.tableConfiguration);
                stats = compactor.call();
            }
            finally {
                span.stop();
            }
            span = Trace.start((String)"bringOnline");
            try {
                this.getDatafileManager().bringMinorCompactionOnline(tmpDatafile, newDatafile, mergeFile, new DataFileValue(stats.getFileSize(), stats.getEntriesWritten()), commitSession, flushId);
            }
            finally {
                span.stop();
            }
            DataFileValue dataFileValue = new DataFileValue(stats.getFileSize(), stats.getEntriesWritten());
            return dataFileValue;
        }
        catch (Exception e) {
            failed = true;
            throw new RuntimeException(e);
        }
        catch (Error e) {
            failed = true;
            throw new RuntimeException(e);
        }
        finally {
            Metrics minCMetrics;
            Thread.currentThread().setName(oldName);
            try {
                this.getTabletMemory().finalizeMinC();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to free tablet memory", t);
            }
            if (!failed) {
                this.lastMinorCompactionFinishTime = System.currentTimeMillis();
            }
            if ((minCMetrics = this.getTabletServer().getMinCMetrics()).isEnabled()) {
                minCMetrics.add("minc", this.lastMinorCompactionFinishTime - start);
            }
            if (hasQueueTime) {
                this.timer.updateTime(TabletStatsKeeper.Operation.MINOR, queued, start, count, failed);
                if (minCMetrics.isEnabled()) {
                    minCMetrics.add("queue", start - queued);
                }
            } else {
                this.timer.updateTime(TabletStatsKeeper.Operation.MINOR, start, count, failed);
            }
        }
    }

    private synchronized MinorCompactionTask prepareForMinC(long flushId, MinorCompactionReason mincReason) {
        Preconditions.checkState((boolean)this.otherLogs.isEmpty());
        Preconditions.checkState((boolean)this.referencedLogs.equals(this.currentLogs));
        CommitSession oldCommitSession = this.getTabletMemory().prepareForMinC();
        this.otherLogs = this.currentLogs;
        this.currentLogs = new HashSet<DfsLogger>();
        FileRef mergeFile = null;
        if (mincReason != MinorCompactionReason.RECOVERY) {
            mergeFile = this.getDatafileManager().reserveMergingMinorCompactionFile();
        }
        double tracePercent = this.tabletServer.getConfiguration().getFraction(Property.TSERV_MINC_TRACE_PERCENT);
        return new MinorCompactionTask(this, mergeFile, oldCommitSession, flushId, mincReason, tracePercent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void flush(long tableFlushID) {
        Tablet tablet;
        boolean initiateMinor;
        boolean updateMetadata;
        block25: {
            updateMetadata = false;
            initiateMinor = false;
            tablet = this;
            // MONITORENTER : tablet
            if (!this.updatingFlushID) break block25;
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet2 = this;
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet2
            return;
        }
        if (this.lastFlushID >= tableFlushID) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet3 = this;
            // MONITORENTER : tablet3
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet3
            return;
        }
        if (this.isClosing() || this.isClosed() || this.getTabletMemory().memoryReservedForMinC()) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet4 = this;
            // MONITORENTER : tablet4
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet4
            return;
        }
        try {
            if (this.getTabletMemory().getMemTable().getNumEntries() == 0L) {
                this.lastFlushID = tableFlushID;
                this.updatingFlushID = true;
                updateMetadata = true;
            } else {
                initiateMinor = true;
            }
            // MONITOREXIT : tablet
            if (updateMetadata) {
                MetadataTableUtil.updateTabletFlushID((KeyExtent)this.extent, (long)tableFlushID, (ClientContext)this.tabletServer, (ZooLock)this.getTabletServer().getLock());
                return;
            }
            if (!initiateMinor) return;
            this.initiateMinorCompaction(tableFlushID, MinorCompactionReason.USER);
            return;
        }
        finally {
            if (updateMetadata) {
                tablet = this;
            }
        }
    }

    public boolean initiateMinorCompaction(MinorCompactionReason mincReason) {
        long flushId;
        if (this.isClosed()) {
            return false;
        }
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info((Object)("Asked to initiate MinC when there was no flush id " + this.getExtent() + " " + e.getMessage()));
            return false;
        }
        return this.initiateMinorCompaction(flushId, mincReason);
    }

    public boolean minorCompactNow(MinorCompactionReason mincReason) {
        long flushId;
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info((Object)("Asked to initiate MinC when there was no flush id " + this.getExtent() + " " + e.getMessage()));
            return false;
        }
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        mct.run();
        return true;
    }

    boolean initiateMinorCompaction(long flushId, MinorCompactionReason mincReason) {
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        this.getTabletResources().executeMinorCompaction(mct);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MinorCompactionTask createMinorCompactionTask(long flushId, MinorCompactionReason mincReason) {
        long t1;
        StringBuilder logMessage;
        block9: {
            MinorCompactionTask minorCompactionTask;
            logMessage = null;
            try {
                Tablet tablet = this;
                // MONITORENTER : tablet
                t1 = System.currentTimeMillis();
                if (!this.isClosing() && !this.isClosed() && this.majorCompactionState != CompactionState.WAITING_TO_START && !this.getTabletMemory().memoryReservedForMinC() && this.getTabletMemory().getMemTable().getNumEntries() != 0L && !this.updatingFlushID) break block9;
                logMessage = new StringBuilder();
                logMessage.append(this.extent.toString());
                logMessage.append(" closeState " + (Object)((Object)this.closeState));
                logMessage.append(" majorCompactionState " + (Object)((Object)this.majorCompactionState));
                if (this.getTabletMemory() != null) {
                    logMessage.append(" tabletMemory.memoryReservedForMinC() " + this.getTabletMemory().memoryReservedForMinC());
                }
                if (this.getTabletMemory() != null && this.getTabletMemory().getMemTable() != null) {
                    logMessage.append(" tabletMemory.getMemTable().getNumEntries() " + this.getTabletMemory().getMemTable().getNumEntries());
                }
                logMessage.append(" updatingFlushID " + this.updatingFlushID);
                minorCompactionTask = null;
                // MONITOREXIT : tablet
                if (logMessage == null) return minorCompactionTask;
            }
            catch (Throwable throwable) {
                if (logMessage == null) throw throwable;
                if (!log.isDebugEnabled()) throw throwable;
                log.debug(logMessage);
                throw throwable;
            }
            if (!log.isDebugEnabled()) return minorCompactionTask;
            log.debug((Object)logMessage);
            return minorCompactionTask;
        }
        MinorCompactionTask mct = this.prepareForMinC(flushId, mincReason);
        long t2 = System.currentTimeMillis();
        // MONITOREXIT : tablet
        if (logMessage != null && log.isDebugEnabled()) {
            log.debug((Object)logMessage);
        }
        log.debug((Object)String.format("MinC initiate lock %.2f secs", (double)(t2 - t1) / 1000.0));
        return mct;
    }

    public long getFlushID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + this.tabletServer.getInstance().getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/flush-id";
            return Long.parseLong(new String(ZooReaderWriter.getInstance().getData(zTablePath, null), StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException(ke);
        }
    }

    long getCompactionCancelID() {
        String zTablePath = "/accumulo/" + this.tabletServer.getInstance().getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/compact-cancel-id";
        try {
            return Long.parseLong(new String(ZooReaderWriter.getInstance().getData(zTablePath, null), StandardCharsets.UTF_8));
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Pair<Long, UserCompactionConfig> getCompactionID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + this.tabletServer.getInstance().getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/compact-id";
            String[] tokens = new String(ZooReaderWriter.getInstance().getData(zTablePath, null), StandardCharsets.UTF_8).split(",");
            long compactID = Long.parseLong(tokens[0]);
            UserCompactionConfig compactionConfig = new UserCompactionConfig();
            if (tokens.length > 1) {
                Hex hex = new Hex();
                ByteArrayInputStream bais = new ByteArrayInputStream(hex.decode(tokens[1].split("=")[1].getBytes(StandardCharsets.UTF_8)));
                DataInputStream dis = new DataInputStream(bais);
                try {
                    compactionConfig.readFields((DataInput)dis);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                KeyExtent ke = new KeyExtent(this.extent.getTableId(), compactionConfig.getEndRow(), compactionConfig.getStartRow());
                if (!ke.overlaps(this.extent)) {
                    compactionConfig = new UserCompactionConfig();
                }
            }
            return new Pair((Object)compactID, (Object)compactionConfig);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException(ke);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized CommitSession finishPreparingMutations(long time) {
        if (this.writesInProgress < 0) {
            throw new IllegalStateException("waitingForLogs < 0 " + this.writesInProgress);
        }
        if (this.isClosed() || this.getTabletMemory() == null) {
            return null;
        }
        ++this.writesInProgress;
        CommitSession commitSession = this.getTabletMemory().getCommitSession();
        commitSession.incrementCommitsInProgress();
        commitSession.updateMaxCommittedTime(time);
        return commitSession;
    }

    public void checkConstraints() {
        ConstraintChecker cc = this.constraintChecker.get();
        if (cc.classLoaderChanged()) {
            ConstraintChecker ncc = new ConstraintChecker(this.tableConfiguration);
            this.constraintChecker.compareAndSet(cc, ncc);
        }
    }

    public CommitSession prepareMutationsForCommit(TservConstraintEnv cenv, List<Mutation> mutations) throws TConstraintViolationException {
        ConstraintChecker cc = this.constraintChecker.get();
        ArrayList<Mutation> violators = null;
        Violations violations = new Violations();
        cenv.setExtent(this.extent);
        for (Mutation mutation : mutations) {
            Violations more = cc.check(cenv, mutation);
            if (more == null) continue;
            violations.add(more);
            if (violators == null) {
                violators = new ArrayList<Mutation>();
            }
            violators.add(mutation);
        }
        long time = this.tabletTime.setUpdateTimes(mutations);
        if (!violations.isEmpty()) {
            HashSet violatorsSet = new HashSet(violators);
            ArrayList<Mutation> nonViolators = new ArrayList<Mutation>();
            for (Mutation mutation : mutations) {
                if (violatorsSet.contains(mutation)) continue;
                nonViolators.add(mutation);
            }
            CommitSession commitSession = null;
            if (nonViolators.size() > 0 && (commitSession = this.finishPreparingMutations(time)) == null) {
                return null;
            }
            throw new TConstraintViolationException(violations, violators, nonViolators, commitSession);
        }
        return this.finishPreparingMutations(time);
    }

    @Override
    public synchronized void abortCommit(CommitSession commitSession, List<Mutation> value) {
        if (this.writesInProgress <= 0) {
            throw new IllegalStateException("waitingForLogs <= 0 " + this.writesInProgress);
        }
        if (this.isCloseComplete() || this.getTabletMemory() == null) {
            throw new IllegalStateException("aborting commit when tablet is closed");
        }
        commitSession.decrementCommitsInProgress();
        --this.writesInProgress;
        if (this.writesInProgress == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(CommitSession commitSession, List<Mutation> mutations) {
        int totalCount = 0;
        long totalBytes = 0L;
        for (Mutation mutation : mutations) {
            totalCount += mutation.size();
            totalBytes += mutation.numBytes();
        }
        this.getTabletMemory().mutate(commitSession, mutations);
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.writesInProgress < 1) {
                throw new IllegalStateException("commiting mutations after logging, but not waiting for any log messages");
            }
            if (this.isCloseComplete()) {
                throw new IllegalStateException("tablet closed with outstanding messages to the logger");
            }
            this.getTabletMemory().updateMemoryUsageStats();
            --this.writesInProgress;
            if (this.writesInProgress == 0) {
                this.notifyAll();
            }
            commitSession.decrementCommitsInProgress();
            this.numEntries += (long)totalCount;
            this.numEntriesInMemory += (long)totalCount;
            this.ingestCount += (long)totalCount;
            this.ingestBytes += totalBytes;
        }
    }

    public void close(boolean saveState) throws IOException {
        this.initiateClose(saveState, false, false);
        this.completeClose(saveState, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateClose(boolean saveState, boolean queueMinC, boolean disableWrites) {
        if (!saveState && queueMinC) {
            throw new IllegalArgumentException("Not saving state on close and requesting minor compactions queue does not make sense");
        }
        log.debug((Object)("initiateClose(saveState=" + saveState + " queueMinC=" + queueMinC + " disableWrites=" + disableWrites + ") " + this.getExtent()));
        MinorCompactionTask mct = null;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isClosed() || this.isClosing()) {
                String msg = "Tablet " + this.getExtent() + " already " + (Object)((Object)this.closeState);
                throw new IllegalStateException(msg);
            }
            this.closeState = CloseState.CLOSING;
            this.notifyAll();
            if (disableWrites) {
                this.closeState = CloseState.CLOSED;
            }
            while (this.isMajorCompactionRunning()) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.toString());
                }
            }
            while (this.updatingFlushID) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.toString());
                }
            }
            if (!saveState || this.getTabletMemory().getMemTable().getNumEntries() == 0L) {
                return;
            }
            this.getTabletMemory().waitForMinC();
            try {
                mct = this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE);
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException(e);
            }
            if (queueMinC) {
                this.getTabletResources().executeMinorCompaction(mct);
                return;
            }
        }
        mct.run();
    }

    synchronized void completeClose(boolean saveState, boolean completeClose) throws IOException {
        if (!this.isClosing() || this.isCloseComplete() || this.closeCompleting) {
            throw new IllegalStateException("closeState = " + (Object)((Object)this.closeState));
        }
        log.debug((Object)("completeClose(saveState=" + saveState + " completeClose=" + completeClose + ") " + this.getExtent()));
        this.closeCompleting = true;
        this.closeState = CloseState.CLOSED;
        this.dataSourceDeletions.incrementAndGet();
        for (ScanDataSource activeScan : this.activeScans) {
            activeScan.interrupt();
        }
        while (this.writesInProgress > 0 || this.activeScans.size() > 0) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                log.error((Object)e.toString());
            }
        }
        this.getTabletMemory().waitForMinC();
        if (saveState && this.getTabletMemory().getMemTable().getNumEntries() > 0L) {
            try {
                this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE).run();
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException(e);
            }
        }
        if (saveState) {
            RuntimeException err = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    this.closeConsistencyCheck();
                    err = null;
                    continue;
                }
                catch (RuntimeException t) {
                    err = t;
                    log.error((Object)("Consistency check fails, retrying " + t));
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            if (err != null) {
                ProblemReports.getInstance((AccumuloServerContext)this.tabletServer).report(new ProblemReport(this.extent.getTableId(), ProblemType.TABLET_LOAD, this.extent.toString(), (Throwable)err));
                log.error((Object)("Tablet closed consistency check has failed for " + this.extent + " giving up and closing"));
            }
        }
        try {
            this.getTabletMemory().getMemTable().delete(0L);
        }
        catch (Throwable t) {
            log.error((Object)("Failed to delete mem table : " + t.getMessage()), t);
        }
        this.getTabletMemory().close();
        this.getTabletResources().close();
        log.log((Priority)TLevel.TABLET_HIST, (Object)(this.extent + " closed"));
        this.tableConfiguration.getNamespaceConfiguration().removeObserver(this.configObserver);
        this.tableConfiguration.removeObserver(this.configObserver);
        if (completeClose) {
            this.closeState = CloseState.COMPLETE;
        }
    }

    private void closeConsistencyCheck() {
        if (this.getTabletMemory().getMemTable().getNumEntries() != 0L) {
            String msg = "Closed tablet " + this.extent + " has " + this.getTabletMemory().getMemTable().getNumEntries() + " entries in memory";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (this.getTabletMemory().memoryReservedForMinC()) {
            String msg = "Closed tablet " + this.extent + " has minor compacting memory";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            Pair fileLog = MetadataTableUtil.getFileAndLogEntries((ClientContext)this.tabletServer, (KeyExtent)this.extent);
            if (((List)fileLog.getFirst()).size() != 0) {
                String msg = "Closed tablet " + this.extent + " has walog entries in " + "accumulo.metadata" + " " + fileLog.getFirst();
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            if (this.extent.isRootTablet()) {
                if (!((SortedMap)fileLog.getSecond()).keySet().equals(this.getDatafileManager().getDatafileSizes().keySet())) {
                    String msg = "Data file in accumulo.root differ from in memory data " + this.extent + "  " + ((SortedMap)fileLog.getSecond()).keySet() + "  " + this.getDatafileManager().getDatafileSizes().keySet();
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
            } else if (!((SortedMap)fileLog.getSecond()).equals(this.getDatafileManager().getDatafileSizes())) {
                String msg = "Data file in accumulo.metadata differ from in memory data " + this.extent + "  " + fileLog.getSecond() + "  " + this.getDatafileManager().getDatafileSizes();
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
        }
        catch (Exception e) {
            String msg = "Failed to do close consistency check for tablet " + this.extent;
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (this.otherLogs.size() != 0 || this.currentLogs.size() != 0 || this.referencedLogs.size() != 0) {
            String msg = "Closed tablet " + this.extent + " has walog entries in memory currentLogs = " + this.currentLogs + "  otherLogs = " + this.otherLogs + " refererncedLogs = " + this.referencedLogs;
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    public Path getLocation() {
        return this.location;
    }

    public synchronized boolean initiateMajorCompaction(MajorCompactionReason reason) {
        if (this.isClosing() || this.isClosed() || !this.needsMajorCompaction(reason) || this.isMajorCompactionRunning() || this.majorCompactionQueued.contains((Object)reason)) {
            return false;
        }
        this.majorCompactionQueued.add(reason);
        this.getTabletResources().executeMajorCompaction(this.getExtent(), new CompactionRunner(this, reason));
        return false;
    }

    public boolean needsMajorCompaction(MajorCompactionReason reason) {
        if (this.isMajorCompactionRunning()) {
            return false;
        }
        if (reason == MajorCompactionReason.CHOP || reason == MajorCompactionReason.USER) {
            return true;
        }
        return this.getTabletResources().needsMajorCompaction(this.getDatafileManager().getDatafileSizes(), reason);
    }

    public long estimateTabletSize() {
        long size = 0L;
        for (DataFileValue sz : this.getDatafileManager().getDatafileSizes().values()) {
            size += sz.getSize();
        }
        return size;
    }

    private SplitRowSpec findSplitRow(Collection<FileRef> files) {
        long splitThreshold = this.tableConfiguration.getMemoryInBytes(Property.TABLE_SPLIT_THRESHOLD);
        long maxEndRow = this.tableConfiguration.getMemoryInBytes(Property.TABLE_MAX_END_ROW_SIZE);
        if (this.extent.isRootTablet() || this.estimateTabletSize() <= splitThreshold) {
            return null;
        }
        if (this.sawBigRow) {
            if (this.timeOfLastMinCWhenBigFreakinRowWasSeen != this.lastMinorCompactionFinishTime || this.timeOfLastImportWhenBigFreakinRowWasSeen != this.lastMapFileImportTime) {
                this.sawBigRow = false;
            } else {
                return null;
            }
        }
        SortedMap keys = null;
        try {
            keys = FileUtil.findMidPoint((VolumeManager)this.getTabletServer().getFileSystem(), (AccumuloConfiguration)this.getTabletServer().getConfiguration(), (Text)this.extent.getPrevEndRow(), (Text)this.extent.getEndRow(), (Collection)FileUtil.toPathStrings(files), (double)0.25);
        }
        catch (IOException e) {
            log.error((Object)("Failed to find midpoint " + e.getMessage()));
            return null;
        }
        try {
            Text lastRow;
            if (this.extent.getEndRow() == null) {
                Key lastKey = (Key)FileUtil.findLastKey((VolumeManager)this.getTabletServer().getFileSystem(), (AccumuloConfiguration)this.getTabletServer().getConfiguration(), files);
                lastRow = lastKey.getRow();
            } else {
                lastRow = this.extent.getEndRow();
            }
            Key mid = (Key)keys.get(0.5);
            if (null == mid) {
                throw new IllegalStateException("Could not determine midpoint for files");
            }
            if (mid.compareRow(lastRow) == 0) {
                if ((Double)keys.firstKey() < 0.5) {
                    Key candidate = (Key)keys.get(keys.firstKey());
                    if ((long)candidate.getLength() > maxEndRow) {
                        log.warn((Object)("Cannot split tablet " + this.extent + ", selected split point too long.  Length :  " + candidate.getLength()));
                        this.sawBigRow = true;
                        this.timeOfLastMinCWhenBigFreakinRowWasSeen = this.lastMinorCompactionFinishTime;
                        this.timeOfLastImportWhenBigFreakinRowWasSeen = this.lastMapFileImportTime;
                        return null;
                    }
                    if (candidate.compareRow(lastRow) != 0) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("Splitting at %6.2f instead of .5, row at .5 is same as end row%n", keys.firstKey()));
                        }
                        return new SplitRowSpec((Double)keys.firstKey(), candidate.getRow());
                    }
                }
                log.warn((Object)("Cannot split tablet " + this.extent + " it contains a big row : " + lastRow));
                this.sawBigRow = true;
                this.timeOfLastMinCWhenBigFreakinRowWasSeen = this.lastMinorCompactionFinishTime;
                this.timeOfLastImportWhenBigFreakinRowWasSeen = this.lastMapFileImportTime;
                return null;
            }
            Text text = mid.getRow();
            SortedMap firstHalf = keys.headMap(0.5);
            if (firstHalf.size() > 0) {
                Text beforeMid = ((Key)firstHalf.get(firstHalf.lastKey())).getRow();
                Text shorter = new Text();
                int trunc = Tablet.longestCommonLength(text, beforeMid);
                shorter.set(text.getBytes(), 0, Math.min(text.getLength(), trunc + 1));
                text = shorter;
            }
            if ((long)text.getLength() > maxEndRow) {
                log.warn((Object)("Cannot split tablet " + this.extent + ", selected split point too long.  Length :  " + text.getLength()));
                this.sawBigRow = true;
                this.timeOfLastMinCWhenBigFreakinRowWasSeen = this.lastMinorCompactionFinishTime;
                this.timeOfLastImportWhenBigFreakinRowWasSeen = this.lastMapFileImportTime;
                return null;
            }
            return new SplitRowSpec(0.5, text);
        }
        catch (IOException e) {
            log.error((Object)("Failed to find lastkey " + e.getMessage()));
            return null;
        }
    }

    private static int longestCommonLength(Text text, Text beforeMid) {
        int common;
        for (common = 0; common < text.getLength() && common < beforeMid.getLength() && text.getBytes()[common] == beforeMid.getBytes()[common]; ++common) {
        }
        return common;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FileRef, Pair<Key, Key>> getFirstAndLastKeys(SortedMap<FileRef, DataFileValue> allFiles) throws IOException {
        HashMap<FileRef, Pair<Key, Key>> result = new HashMap<FileRef, Pair<Key, Key>>();
        FileOperations fileFactory = FileOperations.getInstance();
        VolumeManager fs = this.getTabletServer().getFileSystem();
        for (Map.Entry<FileRef, DataFileValue> entry : allFiles.entrySet()) {
            FileRef file = entry.getKey();
            FileSystem ns = fs.getVolumeByPath(file.path()).getFileSystem();
            try (FileSKVIterator openReader = ((FileOperations.OpenReaderOperationBuilder)fileFactory.newReaderBuilder().forFile(file.path().toString(), ns, ns.getConf()).withTableConfiguration((AccumuloConfiguration)this.getTableConfiguration())).seekToBeginning().build();){
                Key first = openReader.getFirstKey();
                Key last = openReader.getLastKey();
                result.put(file, (Pair<Key, Key>)new Pair((Object)first, (Object)last));
            }
        }
        return result;
    }

    List<FileRef> findChopFiles(KeyExtent extent, Map<FileRef, Pair<Key, Key>> firstAndLastKeys, Collection<FileRef> allFiles) throws IOException {
        ArrayList<FileRef> result = new ArrayList<FileRef>();
        if (firstAndLastKeys == null) {
            result.addAll(allFiles);
            return result;
        }
        for (FileRef file : allFiles) {
            Pair<Key, Key> pair = firstAndLastKeys.get(file);
            if (pair == null) {
                result.add(file);
                continue;
            }
            Key first = (Key)pair.getFirst();
            Key last = (Key)pair.getSecond();
            if (!(first == null && last == null || first != null && !extent.contains((BinaryComparable)first.getRow())) && (last == null || extent.contains((BinaryComparable)last.getRow()))) continue;
            result.add(file);
        }
        return result;
    }

    public synchronized boolean needsSplit() {
        if (this.isClosing() || this.isClosed()) {
            return false;
        }
        return this.findSplitRow(this.getDatafileManager().getFiles()) != null;
    }

    private boolean isCompactionEnabled() {
        return !this.isClosing() && !this.getTabletServer().isMajorCompactionDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private CompactionStats _majorCompact(MajorCompactionReason reason) throws IOException, Compactor.CompactionCanceledException {
        compactionId = null;
        strategy = null;
        firstAndLastKeys = null;
        if (reason == MajorCompactionReason.USER) {
            try {
                compactionId = this.getCompactionID();
                strategy = this.createCompactionStrategy(((UserCompactionConfig)compactionId.getSecond()).getCompactionStrategy());
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException(e);
            }
        } else if (reason == MajorCompactionReason.NORMAL || reason == MajorCompactionReason.IDLE) {
            strategy = (CompactionStrategy)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)this.tableConfiguration, (Property)Property.TABLE_COMPACTION_STRATEGY, CompactionStrategy.class, (Object)new DefaultCompactionStrategy());
            strategy.init(Property.getCompactionStrategyOptions((AccumuloConfiguration)this.tableConfiguration));
        } else if (reason == MajorCompactionReason.CHOP) {
            firstAndLastKeys = this.getFirstAndLastKeys(this.getDatafileManager().getDatafileSizes());
        } else {
            throw new IllegalArgumentException("Unknown compaction reason " + (Object)reason);
        }
        if (strategy != null) {
            request = new MajorCompactionRequest(this.extent, reason, this.getTabletServer().getFileSystem(), (AccumuloConfiguration)this.tableConfiguration);
            request.setFiles(this.getDatafileManager().getDatafileSizes());
            strategy.gatherInformation(request);
        }
        filesToCompact = null;
        maxFilesToCompact = this.tableConfiguration.getCount(Property.TSERV_MAJC_THREAD_MAXOPEN);
        majCStats = new CompactionStats();
        plan = null;
        propogateDeletes = false;
        updateCompactionID = false;
        var17_12 = this;
        synchronized (var17_12) {
            t1 = System.currentTimeMillis();
            this.majorCompactionState = CompactionState.WAITING_TO_START;
            this.getTabletMemory().waitForMinC();
            t2 = System.currentTimeMillis();
            this.majorCompactionState = CompactionState.IN_PROGRESS;
            this.notifyAll();
            fs /* !! */  = this.getTabletServer().getFileSystem();
            if (this.extent.isRootTablet()) {
                RootFiles.cleanupReplacement(fs /* !! */ , fs /* !! */ .listStatus(this.location), false);
            }
            allFiles = this.getDatafileManager().getDatafileSizes();
            inputFiles = new ArrayList<FileRef>();
            if (reason == MajorCompactionReason.CHOP) {
                inputFiles.addAll(this.findChopFiles(this.extent, firstAndLastKeys, allFiles.keySet()));
            } else {
                request = new MajorCompactionRequest(this.extent, reason, fs /* !! */ , (AccumuloConfiguration)this.tableConfiguration);
                request.setFiles((Map<FileRef, DataFileValue>)allFiles);
                plan = strategy.getCompactionPlan(request);
                if (plan != null) {
                    plan.validate(allFiles.keySet());
                    inputFiles.addAll(plan.inputFiles);
                }
            }
            if (!inputFiles.isEmpty()) ** GOTO lbl66
            if (reason == MajorCompactionReason.USER) {
                if (((UserCompactionConfig)compactionId.getSecond()).getIterators().isEmpty()) {
                    Tablet.log.debug((Object)"No-op major compaction by USER on 0 input files because no iterators present.");
                    this.lastCompactID = (Long)compactionId.getFirst();
                    updateCompactionID = true;
                } else {
                    Tablet.log.debug((Object)"Major compaction by USER on 0 input files with iterators.");
                    filesToCompact = new HashMap<K, V>();
                }
            } else {
                return majCStats;
lbl66:
                // 1 sources

                droppedFiles = new HashSet<FileRef>();
                droppedFiles.addAll(inputFiles);
                if (plan != null) {
                    droppedFiles.addAll(plan.deleteFiles);
                }
                propogateDeletes = droppedFiles.equals(allFiles.keySet()) == false;
                Tablet.log.debug((Object)("Major compaction plan: " + plan + " propogate deletes : " + propogateDeletes));
                filesToCompact = new HashMap<FileRef, DataFileValue>((Map<FileRef, DataFileValue>)allFiles);
                filesToCompact.keySet().retainAll(inputFiles);
                this.getDatafileManager().reserveMajorCompactingFiles(filesToCompact.keySet());
            }
            t3 = System.currentTimeMillis();
        }
        try {
            Tablet.log.debug((Object)String.format("MajC initiate lock %.2f secs, wait %.2f secs", new Object[]{(double)(t3 - t2) / 1000.0, (double)(t2 - t1) / 1000.0}));
            if (updateCompactionID) {
                MetadataTableUtil.updateTabletCompactID((KeyExtent)this.extent, (long)((Long)compactionId.getFirst()), (ClientContext)this.tabletServer, (ZooLock)this.getTabletServer().getLock());
                var17_12 = majCStats;
                return var17_12;
            }
            if (!propogateDeletes && compactionId == null) {
                try {
                    compactionId = this.getCompactionID();
                    if (((UserCompactionConfig)compactionId.getSecond()).getCompactionStrategy() != null) {
                        compactionId = null;
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    throw new RuntimeException(e);
                }
            }
            compactionIterators = new ArrayList<E>();
            if (compactionId != null && reason == MajorCompactionReason.USER) {
                if (this.getCompactionCancelID() >= (Long)compactionId.getFirst()) {
                    fs /* !! */  = majCStats;
                    return fs /* !! */ ;
                }
                compactionIterators = ((UserCompactionConfig)compactionId.getSecond()).getIterators();
                fs /* !! */  = this;
                synchronized (fs /* !! */ ) {
                    block60: {
                        if (this.lastCompactID < (Long)compactionId.getFirst()) break block60;
                        allFiles = majCStats;
                        return allFiles;
                    }
                    ** try [egrp 11[TRYBLOCK] [12 : 995->1001)] { 
                    {
                    }
                }
            }
lbl113:
            // 3 sources

            do {
                numToCompact = maxFilesToCompact;
                if (filesToCompact.size() > maxFilesToCompact && filesToCompact.size() < 2 * maxFilesToCompact) {
                    numToCompact = filesToCompact.size() - maxFilesToCompact + 1;
                }
                smallestFiles = this.removeSmallest(filesToCompact, numToCompact);
                fileName = this.getNextMapFilename(filesToCompact.size() == 0 && propogateDeletes == false ? "A" : "C");
                compactTmpName = new FileRef(fileName.path().toString() + "_tmp");
                tableConf = this.createTableConfiguration(this.tableConfiguration, plan);
                span = Trace.start((String)"compactFiles");
                try {
                    cenv = new Compactor.CompactionEnv(){

                        @Override
                        public boolean isCompactionEnabled() {
                            return Tablet.this.isCompactionEnabled();
                        }

                        @Override
                        public IteratorUtil.IteratorScope getIteratorScope() {
                            return IteratorUtil.IteratorScope.majc;
                        }

                        @Override
                        public RateLimiter getReadLimiter() {
                            return Tablet.this.getTabletServer().getMajorCompactionReadLimiter();
                        }

                        @Override
                        public RateLimiter getWriteLimiter() {
                            return Tablet.this.getTabletServer().getMajorCompactionWriteLimiter();
                        }
                    };
                    copy = new HashMap<FileRef, DataFileValue>(this.getDatafileManager().getDatafileSizes());
                    if (!copy.keySet().containsAll(smallestFiles)) {
                        throw new IllegalStateException("Cannot find data file values for " + smallestFiles);
                    }
                    copy.keySet().retainAll(smallestFiles);
                    Tablet.log.debug((Object)("Starting MajC " + this.extent + " (" + (Object)reason + ") " + copy.keySet() + " --> " + compactTmpName + "  " + compactionIterators));
                    lastBatch = filesToCompact.isEmpty();
                    compactor = new Compactor(this.tabletServer, this, copy, null, compactTmpName, lastBatch != false ? propogateDeletes : true, cenv, compactionIterators, reason.ordinal(), tableConf);
                    mcs = compactor.call();
                    span.data("files", "" + smallestFiles.size());
                    span.data("read", "" + mcs.getEntriesRead());
                    span.data("written", "" + mcs.getEntriesWritten());
                    majCStats.add(mcs);
                    if (lastBatch && plan != null && plan.deleteFiles != null) {
                        smallestFiles.addAll(plan.deleteFiles);
                    }
                    this.getDatafileManager().bringMajorCompactionOnline(smallestFiles, compactTmpName, fileName, filesToCompact.size() == 0 && compactionId != null ? (Long)compactionId.getFirst() : null, new DataFileValue(mcs.getFileSize(), mcs.getEntriesWritten()));
                    if (filesToCompact.size() <= 0 || mcs.getEntriesWritten() <= 0L) continue;
                    filesToCompact.put(fileName, new DataFileValue(mcs.getFileSize(), mcs.getEntriesWritten()));
                }
                finally {
                    span.stop();
                }
            } while (filesToCompact.size() > 0);
            var18_18 = majCStats;
            return var18_18;
        }
        finally {
            fs /* !! */  = this;
            synchronized (fs /* !! */ ) {
                this.getDatafileManager().clearMajorCompactingFile();
            }
        }
    }

    protected AccumuloConfiguration createTableConfiguration(TableConfiguration base, CompactionPlan plan) {
        if (plan == null || plan.writeParameters == null) {
            return base;
        }
        WriteParameters p = plan.writeParameters;
        ConfigurationCopy result = new ConfigurationCopy((Iterable)base);
        if (p.getHdfsBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_BLOCK_SIZE, "" + p.getHdfsBlockSize());
        }
        if (p.getBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, "" + p.getBlockSize());
        }
        if (p.getIndexBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, "" + p.getIndexBlockSize());
        }
        if (p.getCompressType() != null) {
            result.set(Property.TABLE_FILE_COMPRESSION_TYPE, p.getCompressType());
        }
        if (p.getReplication() != 0) {
            result.set(Property.TABLE_FILE_REPLICATION, "" + p.getReplication());
        }
        return result;
    }

    private Set<FileRef> removeSmallest(Map<FileRef, DataFileValue> filesToCompact, int maxFilesToCompact) {
        if (filesToCompact.size() <= maxFilesToCompact) {
            HashSet<FileRef> smallestFiles = new HashSet<FileRef>(filesToCompact.keySet());
            filesToCompact.clear();
            return smallestFiles;
        }
        PriorityQueue<Pair<FileRef, Long>> fileHeap = new PriorityQueue<Pair<FileRef, Long>>(filesToCompact.size(), new Comparator<Pair<FileRef, Long>>(){

            @Override
            public int compare(Pair<FileRef, Long> o1, Pair<FileRef, Long> o2) {
                if (o1.getSecond() == o2.getSecond()) {
                    return ((FileRef)o1.getFirst()).compareTo((FileRef)o2.getFirst());
                }
                if ((Long)o1.getSecond() < (Long)o2.getSecond()) {
                    return -1;
                }
                return 1;
            }
        });
        for (Map.Entry<FileRef, DataFileValue> entry : filesToCompact.entrySet()) {
            fileHeap.add((Pair<FileRef, Long>)new Pair((Object)entry.getKey(), (Object)entry.getValue().getSize()));
        }
        HashSet<FileRef> smallestFiles = new HashSet<FileRef>();
        while (smallestFiles.size() < maxFilesToCompact && fileHeap.size() > 0) {
            Pair pair = (Pair)fileHeap.remove();
            filesToCompact.remove(pair.getFirst());
            smallestFiles.add((FileRef)pair.getFirst());
        }
        return smallestFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompactionStats majorCompact(MajorCompactionReason reason, long queued) {
        CompactionStats majCStats = null;
        boolean success = false;
        long start = System.currentTimeMillis();
        this.timer.incrementStatusMajor();
        Tablet tablet = this;
        synchronized (tablet) {
            this.majorCompactionQueued.remove((Object)reason);
            if (this.isClosing() || this.isClosed() || !this.needsMajorCompaction(reason) || this.isMajorCompactionRunning() || this.needsSplit()) {
                return null;
            }
            this.majorCompactionState = CompactionState.WAITING_TO_START;
        }
        Span span = null;
        try {
            double tracePercent = this.tabletServer.getConfiguration().getFraction(Property.TSERV_MAJC_TRACE_PERCENT);
            ProbabilitySampler sampler = new ProbabilitySampler(tracePercent);
            span = Trace.on((String)"majorCompaction", (Sampler)sampler);
            majCStats = this._majorCompact(reason);
            if (reason == MajorCompactionReason.CHOP) {
                MetadataTableUtil.chopped((AccumuloServerContext)this.getTabletServer(), (KeyExtent)this.getExtent(), (ZooLock)this.getTabletServer().getLock());
                this.getTabletServer().enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.CHOPPED, this.extent));
            }
            success = true;
        }
        catch (Compactor.CompactionCanceledException cce) {
            log.debug((Object)("Major compaction canceled, extent = " + this.getExtent()));
        }
        catch (IOException ioe) {
            log.error((Object)("MajC Failed, extent = " + this.getExtent()), (Throwable)ioe);
        }
        catch (RuntimeException e) {
            log.error((Object)("MajC Unexpected exception, extent = " + this.getExtent()), (Throwable)e);
        }
        finally {
            Tablet cce = this;
            synchronized (cce) {
                this.majorCompactionState = null;
                this.notifyAll();
            }
            if (span != null) {
                span.data("extent", "" + this.getExtent());
                if (majCStats != null) {
                    span.data("read", "" + majCStats.getEntriesRead());
                    span.data("written", "" + majCStats.getEntriesWritten());
                }
                span.stop();
            }
        }
        long count = 0L;
        if (majCStats != null) {
            count = majCStats.getEntriesRead();
        }
        this.timer.updateTime(TabletStatsKeeper.Operation.MAJOR, queued, start, count, !success);
        return majCStats;
    }

    @Override
    public KeyExtent getExtent() {
        return this.extent;
    }

    synchronized void computeNumEntries() {
        Collection<DataFileValue> vals = this.getDatafileManager().getDatafileSizes().values();
        long numEntries = 0L;
        for (DataFileValue tableValue : vals) {
            numEntries += tableValue.getNumEntries();
        }
        this.numEntriesInMemory = this.getTabletMemory().getNumEntries();
        this.numEntries = numEntries += this.getTabletMemory().getNumEntries();
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public long getNumEntriesInMemory() {
        return this.numEntriesInMemory;
    }

    public synchronized boolean isClosing() {
        return this.closeState == CloseState.CLOSING;
    }

    public synchronized boolean isClosed() {
        return this.closeState == CloseState.CLOSED || this.closeState == CloseState.COMPLETE;
    }

    public synchronized boolean isCloseComplete() {
        return this.closeState == CloseState.COMPLETE;
    }

    public boolean isMajorCompactionRunning() {
        return this.majorCompactionState != null;
    }

    public boolean isMinorCompactionQueued() {
        return this.minorCompactionState == CompactionState.WAITING_TO_START;
    }

    public boolean isMinorCompactionRunning() {
        return this.minorCompactionState == CompactionState.IN_PROGRESS;
    }

    public boolean isMajorCompactionQueued() {
        return this.majorCompactionQueued.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<KeyExtent, TabletData> split(byte[] sp) throws IOException {
        if (sp != null && this.extent.getEndRow() != null && this.extent.getEndRow().equals((Object)new Text(sp))) {
            throw new IllegalArgumentException();
        }
        if (sp != null && (long)sp.length > this.tableConfiguration.getMemoryInBytes(Property.TABLE_MAX_END_ROW_SIZE)) {
            String msg = "Cannot split tablet " + this.extent + ", selected split point too long.  Length :  " + sp.length;
            log.warn((Object)msg);
            throw new IOException(msg);
        }
        if (this.extent.isRootTablet()) {
            String msg = "Cannot split root tablet";
            log.warn((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            this.initiateClose(true, false, false);
        }
        catch (IllegalStateException ise) {
            log.debug((Object)("File " + this.extent + " not splitting : " + ise.getMessage()));
            return null;
        }
        Map firstAndLastRows = FileUtil.tryToGetFirstAndLastRows((VolumeManager)this.getTabletServer().getFileSystem(), (AccumuloConfiguration)this.getTabletServer().getConfiguration(), this.getDatafileManager().getFiles());
        Tablet tablet = this;
        synchronized (tablet) {
            SplitRowSpec splitPoint;
            TreeMap<KeyExtent, TabletData> newTablets = new TreeMap<KeyExtent, TabletData>();
            long t1 = System.currentTimeMillis();
            if (sp == null) {
                splitPoint = this.findSplitRow(this.getDatafileManager().getFiles());
            } else {
                Text tsp = new Text(sp);
                splitPoint = new SplitRowSpec(FileUtil.estimatePercentageLTE((VolumeManager)this.getTabletServer().getFileSystem(), (AccumuloConfiguration)this.getTabletServer().getConfiguration(), (Text)this.extent.getPrevEndRow(), (Text)this.extent.getEndRow(), (Collection)FileUtil.toPathStrings(this.getDatafileManager().getFiles()), (Text)tsp), tsp);
            }
            if (splitPoint == null || splitPoint.row == null) {
                log.info((Object)"had to abort split because splitRow was null");
                this.closeState = CloseState.OPEN;
                return null;
            }
            this.closeState = CloseState.CLOSING;
            this.completeClose(true, false);
            Text midRow = splitPoint.row;
            double splitRatio = splitPoint.splitRatio;
            KeyExtent low = new KeyExtent(this.extent.getTableId(), midRow, this.extent.getPrevEndRow());
            KeyExtent high = new KeyExtent(this.extent.getTableId(), this.extent.getEndRow(), midRow);
            String lowDirectory = Tablet.createTabletDirectory(this.getTabletServer().getFileSystem(), this.extent.getTableId(), midRow);
            TreeMap<FileRef, DataFileValue> lowDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            TreeMap<FileRef, DataFileValue> highDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            ArrayList highDatafilesToRemove = new ArrayList();
            MetadataTableUtil.splitDatafiles((String)this.extent.getTableId(), (Text)midRow, (double)splitRatio, (Map)firstAndLastRows, this.getDatafileManager().getDatafileSizes(), lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
            log.debug((Object)("Files for low split " + low + "  " + lowDatafileSizes.keySet()));
            log.debug((Object)("Files for high split " + high + "  " + highDatafileSizes.keySet()));
            String time = this.tabletTime.getMetadataValue();
            MetadataTableUtil.splitTablet((KeyExtent)high, (Text)this.extent.getPrevEndRow(), (double)splitRatio, (ClientContext)this.getTabletServer(), (ZooLock)this.getTabletServer().getLock());
            MasterMetadataUtil.addNewTablet((ClientContext)this.getTabletServer(), (KeyExtent)low, (String)lowDirectory, (TServerInstance)this.getTabletServer().getTabletSession(), lowDatafileSizes, this.getBulkIngestedFiles(), (String)time, (long)this.lastFlushID, (long)this.lastCompactID, (ZooLock)this.getTabletServer().getLock());
            MetadataTableUtil.finishSplit((KeyExtent)high, highDatafileSizes, highDatafilesToRemove, (ClientContext)this.getTabletServer(), (ZooLock)this.getTabletServer().getLock());
            log.log((Priority)TLevel.TABLET_HIST, (Object)(this.extent + " split " + low + " " + high));
            newTablets.put(high, new TabletData(this.tabletDirectory, highDatafileSizes, time, this.lastFlushID, this.lastCompactID, this.lastLocation, this.getBulkIngestedFiles()));
            newTablets.put(low, new TabletData(lowDirectory, lowDatafileSizes, time, this.lastFlushID, this.lastCompactID, this.lastLocation, this.getBulkIngestedFiles()));
            long t2 = System.currentTimeMillis();
            log.debug((Object)String.format("offline split time : %6.2f secs", (double)(t2 - t1) / 1000.0));
            this.closeState = CloseState.COMPLETE;
            return newTablets;
        }
    }

    public SortedMap<FileRef, DataFileValue> getDatafiles() {
        return this.getDatafileManager().getDatafileSizes();
    }

    public double queryRate() {
        return this.queryRate.rate();
    }

    public double queryByteRate() {
        return this.queryByteRate.rate();
    }

    public double ingestRate() {
        return this.ingestRate.rate();
    }

    public double ingestByteRate() {
        return this.ingestByteRate.rate();
    }

    public double scanRate() {
        return this.scannedRate.rate();
    }

    public long totalQueries() {
        return this.queryCount;
    }

    public void updateRates(long now) {
        this.queryRate.update(now, this.queryCount);
        this.queryByteRate.update(now, this.queryBytes);
        this.ingestRate.update(now, this.ingestCount);
        this.ingestByteRate.update(now, this.ingestBytes);
        this.scannedRate.update(now, this.scannedCount.get());
    }

    public long getSplitCreationTime() {
        return this.splitCreationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMapFiles(long tid, Map<FileRef, MapFileInfo> fileMap, boolean setTime) throws IOException {
        HashMap<FileRef, DataFileValue> entries = new HashMap<FileRef, DataFileValue>(fileMap.size());
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry<FileRef, MapFileInfo> entry : fileMap.entrySet()) {
            entries.put(entry.getKey(), new DataFileValue(entry.getValue().estimatedSize, 0L));
            files.add(entry.getKey().path().toString());
        }
        long now = System.currentTimeMillis();
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isClosed()) {
                throw new IOException("tablet " + this.extent + " is closed");
            }
            long lockWait = System.currentTimeMillis() - now;
            if (lockWait > this.getTabletServer().getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT)) {
                throw new IOException("Timeout waiting " + (double)lockWait / 1000.0 + " seconds to get tablet lock");
            }
            List alreadyImported = (List)this.bulkImported.getIfPresent((Object)tid);
            if (alreadyImported != null) {
                for (FileRef entry : alreadyImported) {
                    if (fileMap.remove(entry) == null) continue;
                    log.info((Object)("Ignoring import of bulk file already imported: " + entry));
                }
            }
            if (fileMap.isEmpty()) {
                return;
            }
            if (this.writesInProgress < 0) {
                throw new IllegalStateException("writesInProgress < 0 " + this.writesInProgress);
            }
            ++this.writesInProgress;
        }
        this.tabletServer.updateBulkImportState(files, BulkImportState.LOADING);
        try {
            this.getDatafileManager().importMapFiles(tid, entries, setTime);
            this.lastMapFileImportTime = System.currentTimeMillis();
            if (this.needsSplit()) {
                this.getTabletServer().executeSplit(this);
            } else {
                this.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
            tablet = this;
        }
        catch (Throwable throwable) {
            Tablet tablet2 = this;
            synchronized (tablet2) {
                if (this.writesInProgress < 1) {
                    throw new IllegalStateException("writesInProgress < 1 " + this.writesInProgress);
                }
                --this.writesInProgress;
                if (this.writesInProgress == 0) {
                    this.notifyAll();
                }
                try {
                    ((List)this.bulkImported.get((Object)tid, (Callable)new Callable<List<FileRef>>(){

                        @Override
                        public List<FileRef> call() throws Exception {
                            return new ArrayList<FileRef>();
                        }
                    })).addAll(fileMap.keySet());
                }
                catch (Exception ex) {
                    log.info((Object)ex.toString(), (Throwable)ex);
                }
                this.tabletServer.removeBulkImportState(files);
            }
            throw throwable;
        }
        synchronized (tablet) {
            if (this.writesInProgress < 1) {
                throw new IllegalStateException("writesInProgress < 1 " + this.writesInProgress);
            }
            --this.writesInProgress;
            if (this.writesInProgress == 0) {
                this.notifyAll();
            }
            try {
                ((List)this.bulkImported.get((Object)tid, (Callable)new /* invalid duplicate definition of identical inner class */)).addAll(fileMap.keySet());
            }
            catch (Exception ex) {
                log.info((Object)ex.toString(), (Throwable)ex);
            }
            this.tabletServer.removeBulkImportState(files);
        }
    }

    private synchronized void rebuildReferencedLogs() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.currentLogs);
        builder.addAll(this.otherLogs);
        this.referencedLogs = builder.build();
    }

    public void removeInUseLogs(Set<DfsLogger> candidates) {
        candidates.removeAll(this.referencedLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> beginClearingUnusedLogs() {
        HashSet<String> unusedLogs = new HashSet<String>();
        ArrayList<String> otherLogsCopy = new ArrayList<String>();
        ArrayList<String> currentLogsCopy = new ArrayList<String>();
        this.logLock.lock();
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.removingLogs) {
                throw new IllegalStateException("Attempted to clear logs when removal of logs in progress");
            }
            for (DfsLogger logger : this.otherLogs) {
                otherLogsCopy.add(logger.toString());
                unusedLogs.add(logger.getMeta());
            }
            for (DfsLogger logger : this.currentLogs) {
                currentLogsCopy.add(logger.toString());
                unusedLogs.remove(logger.getMeta());
            }
            this.otherLogs = Collections.emptySet();
            if (unusedLogs.size() > 0) {
                this.removingLogs = true;
            }
        }
        for (String logger : otherLogsCopy) {
            log.debug((Object)("Logs for memory compacted: " + this.getExtent() + " " + logger));
        }
        for (String logger : currentLogsCopy) {
            log.debug((Object)("Logs for current memory: " + this.getExtent() + " " + logger));
        }
        for (String logger : unusedLogs) {
            log.debug((Object)("Logs to be destroyed: " + this.getExtent() + " " + logger));
        }
        return unusedLogs;
    }

    synchronized void finishClearingUnusedLogs() {
        this.removingLogs = false;
        this.rebuildReferencedLogs();
        this.logLock.unlock();
    }

    public synchronized int getLogCount() {
        return this.currentLogs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean beginUpdatingLogsUsed(InMemoryMap memTable, DfsLogger more, boolean mincFinish) {
        boolean bl;
        int numContained;
        int numAdded;
        boolean releaseLock = true;
        this.logLock.lock();
        try {
            Tablet tablet = this;
            synchronized (tablet) {
                boolean addToOther;
                if (this.isCloseComplete()) {
                    throw new IllegalStateException("Can not update logs of closed tablet " + this.extent);
                }
                if (memTable == this.getTabletMemory().getMinCMemTable()) {
                    addToOther = true;
                } else {
                    if (memTable != this.getTabletMemory().getMemTable()) {
                        throw new IllegalArgumentException("passed in memtable that is not in use");
                    }
                    addToOther = false;
                }
                if (mincFinish) {
                    if (addToOther) {
                        throw new IllegalStateException("Adding to other logs for mincFinish");
                    }
                    if (this.otherLogs.size() != 0) {
                        throw new IllegalStateException("Expect other logs to be 0 when min finish, but its " + this.otherLogs);
                    }
                    if (this.currentLogs.size() == 0) {
                        boolean bl2 = !releaseLock;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 12, 15] lbl21 : MonitorExitStatement: MONITOREXIT : var5_5
                        if (!releaseLock) return bl2;
                        this.logLock.unlock();
                        return bl2;
                    }
                }
                numAdded = 0;
                numContained = 0;
                if (addToOther) {
                    if (this.otherLogs.add(more)) {
                        ++numAdded;
                    }
                    if (this.currentLogs.contains(more)) {
                        ++numContained;
                    }
                } else {
                    if (this.currentLogs.add(more)) {
                        ++numAdded;
                    }
                    if (this.otherLogs.contains(more)) {
                        ++numContained;
                    }
                }
                if (numAdded > 0) {
                    this.rebuildReferencedLogs();
                }
                if (numAdded <= 0 || numAdded == 1) break block23;
            }
        }
        catch (Throwable throwable) {
            if (!releaseLock) throw throwable;
            this.logLock.unlock();
            throw throwable;
        }
        {
            block23: {
                throw new IllegalArgumentException("Added subset of logs " + this.extent + " " + more + " " + this.currentLogs);
            }
            if (numContained > 0 && numContained != 1) {
                throw new IllegalArgumentException("Other logs contained subset of logs " + this.extent + " " + more + " " + this.otherLogs);
            }
            if (numAdded > 0 && numContained == 0) {
                return true;
            }
            bl = !releaseLock;
        }
        if (!releaseLock) return bl;
        this.logLock.unlock();
        return bl;
    }

    @Override
    public void finishUpdatingLogsUsed() {
        this.logLock.unlock();
    }

    public synchronized void chopFiles() {
        this.initiateMajorCompaction(MajorCompactionReason.CHOP);
    }

    private CompactionStrategy createCompactionStrategy(CompactionStrategyConfig strategyConfig) {
        String context = this.tableConfiguration.get(Property.TABLE_CLASSPATH);
        String clazzName = strategyConfig.getClassName();
        try {
            Class clazz = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().loadClass(context, clazzName, CompactionStrategy.class) : AccumuloVFSClassLoader.loadClass((String)clazzName, CompactionStrategy.class);
            CompactionStrategy strategy = (CompactionStrategy)clazz.newInstance();
            strategy.init(strategyConfig.getOptions());
            return strategy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactAll(long compactionId, UserCompactionConfig compactionConfig) {
        boolean updateMetadata = false;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.lastCompactID >= compactionId) {
                return;
            }
            if (this.isMinorCompactionRunning()) {
                if (this.compactionWaitInfo.compactionID == compactionId) {
                    if (this.lastFlushID == this.compactionWaitInfo.flushID) {
                        return;
                    }
                } else {
                    this.compactionWaitInfo.compactionID = compactionId;
                    this.compactionWaitInfo.flushID = this.lastFlushID;
                    return;
                }
            }
            if (this.isClosing() || this.isClosed() || this.majorCompactionQueued.contains((Object)MajorCompactionReason.USER) || this.isMajorCompactionRunning()) {
                return;
            }
            CompactionStrategyConfig strategyConfig = compactionConfig.getCompactionStrategy();
            CompactionStrategy strategy = this.createCompactionStrategy(strategyConfig);
            MajorCompactionRequest request = new MajorCompactionRequest(this.extent, MajorCompactionReason.USER, this.getTabletServer().getFileSystem(), (AccumuloConfiguration)this.tableConfiguration);
            request.setFiles(this.getDatafileManager().getDatafileSizes());
            try {
                if (strategy.shouldCompact(request)) {
                    this.initiateMajorCompaction(MajorCompactionReason.USER);
                } else {
                    this.majorCompactionState = CompactionState.IN_PROGRESS;
                    updateMetadata = true;
                    this.lastCompactID = compactionId;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (updateMetadata) {
            try {
                MetadataTableUtil.updateTabletCompactID((KeyExtent)this.extent, (long)compactionId, (ClientContext)this.getTabletServer(), (ZooLock)this.getTabletServer().getLock());
            }
            finally {
                tablet = this;
                synchronized (tablet) {
                    this.majorCompactionState = null;
                    this.notifyAll();
                }
            }
        }
    }

    @Override
    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    @Override
    public Durability getDurability() {
        return DurabilityImpl.fromString((String)this.getTableConfiguration().get(Property.TABLE_DURABILITY));
    }

    @Override
    public void updateMemoryUsageStats(long size, long mincSize) {
        this.getTabletResources().updateMemoryUsageStats(this, size, mincSize);
    }

    public long incrementDataSourceDeletions() {
        return this.dataSourceDeletions.incrementAndGet();
    }

    public synchronized void updateQueryStats(int size, long numBytes) {
        this.queryCount += (long)size;
        this.queryBytes += numBytes;
    }

    TabletServer getTabletServer() {
        return this.tabletServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePersistedTime(long bulkTime, Map<FileRef, DataFileValue> paths, long tid) {
        Object object = this.timeLock;
        synchronized (object) {
            if (bulkTime > this.persistedTime) {
                this.persistedTime = bulkTime;
            }
            MetadataTableUtil.updateTabletDataFile((long)tid, (KeyExtent)this.extent, paths, (String)this.tabletTime.getMetadataValue(this.persistedTime), (ClientContext)this.getTabletServer(), (ZooLock)this.getTabletServer().getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTabletDataFile(long maxCommittedTime, FileRef newDatafile, FileRef absMergeFile, DataFileValue dfv, Set<String> unusedWalLogs, Set<FileRef> filesInUseByScans, long flushId) {
        Object object = this.timeLock;
        synchronized (object) {
            if (maxCommittedTime > this.persistedTime) {
                this.persistedTime = maxCommittedTime;
            }
            String time = this.tabletTime.getMetadataValue(this.persistedTime);
            MasterMetadataUtil.updateTabletDataFile((ClientContext)this.getTabletServer(), (KeyExtent)this.extent, (FileRef)newDatafile, (FileRef)absMergeFile, (DataFileValue)dfv, (String)time, filesInUseByScans, (String)this.tabletServer.getClientAddressString(), (ZooLock)this.tabletServer.getLock(), unusedWalLogs, (TServerInstance)this.lastLocation, (long)flushId);
        }
    }

    TabletServerResourceManager.TabletResourceManager getTabletResources() {
        return this.tabletResources;
    }

    DatafileManager getDatafileManager() {
        return this.datafileManager;
    }

    TabletMemory getTabletMemory() {
        return this.tabletMemory;
    }

    public long getAndUpdateTime() {
        return this.tabletTime.getAndUpdateTime();
    }

    public void flushComplete(long flushId) {
        this.lastLocation = null;
        this.dataSourceDeletions.incrementAndGet();
        this.tabletMemory.finishedMinC();
        this.lastFlushID = flushId;
        this.computeNumEntries();
    }

    public TServerInstance resetLastLocation() {
        TServerInstance result = this.lastLocation;
        this.lastLocation = null;
        return result;
    }

    public synchronized void addActiveScans(ScanDataSource scanDataSource) {
        this.activeScans.add(scanDataSource);
    }

    public int removeScan(ScanDataSource scanDataSource) {
        this.activeScans.remove(scanDataSource);
        return this.activeScans.size();
    }

    public synchronized void setLastCompactionID(Long compactionId) {
        if (compactionId != null) {
            this.lastCompactID = compactionId;
        }
    }

    public void removeMajorCompactionQueuedReason(MajorCompactionReason reason) {
        this.majorCompactionQueued.remove((Object)reason);
    }

    public void minorCompactionWaitingToStart() {
        this.minorCompactionState = CompactionState.WAITING_TO_START;
    }

    public void minorCompactionStarted() {
        this.minorCompactionState = CompactionState.IN_PROGRESS;
    }

    public void minorCompactionComplete() {
        this.minorCompactionState = null;
    }

    public TabletStats getTabletStats() {
        return this.timer.getTabletStats();
    }

    public AtomicLong getScannedCounter() {
        return this.scannedCount;
    }

    private static String createTabletDirectory(VolumeManager fs, String tableId, Text endRow) {
        UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
        String volume = fs.choose(Optional.of((Object)tableId), ServerConstants.getBaseUris()) + "/tables" + "/";
        while (true) {
            try {
                Path lowDirectoryPath;
                String lowDirectory;
                if (endRow == null) {
                    lowDirectory = "/default_tablet";
                    lowDirectoryPath = new Path(volume + "/" + tableId + "/" + lowDirectory);
                    if (fs.exists(lowDirectoryPath) || fs.mkdirs(lowDirectoryPath)) {
                        FileSystem pathFs = fs.getVolumeByPath(lowDirectoryPath).getFileSystem();
                        return lowDirectoryPath.makeQualified(pathFs.getUri(), pathFs.getWorkingDirectory()).toString();
                    }
                    log.warn((Object)("Failed to create " + lowDirectoryPath + " for unknown reason"));
                } else {
                    lowDirectory = "/t-" + namer.getNextName();
                    lowDirectoryPath = new Path(volume + "/" + tableId + "/" + lowDirectory);
                    if (fs.exists(lowDirectoryPath)) {
                        throw new IllegalStateException("Dir exist when it should not " + lowDirectoryPath);
                    }
                    if (fs.mkdirs(lowDirectoryPath)) {
                        FileSystem lowDirectoryFs = fs.getVolumeByPath(lowDirectoryPath).getFileSystem();
                        return lowDirectoryPath.makeQualified(lowDirectoryFs.getUri(), lowDirectoryFs.getWorkingDirectory()).toString();
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
            log.warn((Object)("Failed to create dir for tablet in table " + tableId + " in volume " + volume + " + will retry ..."));
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public Map<Long, List<FileRef>> getBulkIngestedFiles() {
        return new HashMap<Long, List<FileRef>>(this.bulkImported.asMap());
    }

    public void cleanupBulkLoadedFiles(Set<Long> tids) {
        for (Long tid : tids) {
            this.bulkImported.invalidate((Object)tid);
        }
    }

    public static class LookupResult {
        public List<Range> unfinishedRanges = new ArrayList<Range>();
        public long bytesAdded = 0L;
        public long dataSize = 0L;
        public boolean closed = false;
    }

    static enum CompactionState {
        WAITING_TO_START,
        IN_PROGRESS;

    }

    private static class CompactionWaitInfo {
        long flushID = -1L;
        long compactionID = -1L;

        private CompactionWaitInfo() {
        }
    }

    private static enum CloseState {
        OPEN,
        CLOSING,
        CLOSED,
        COMPLETE;

    }
}

